/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.BillPoolFactory;
import com.kingdee.eas.cp.cpmm.BillPoolInfo;
import com.kingdee.eas.cp.cpmm.BillTypeEnum;
import com.kingdee.eas.cp.cpmm.CPMMBillBaseInfo;
import com.kingdee.eas.cp.cpmm.IBillPool;
import com.kingdee.eas.cp.cpmm.MMBillStateEnum;
import com.kingdee.eas.cp.cpmm.OutboundBillInfo;
import com.kingdee.eas.cp.cpmm.WarehousingBillInfo;

public class BillPoolHelper {
    public static void addNew(Context ctx, IObjectValue model, int type) throws BOSException, EASBizException {
        IBillPool iBillPool = BillPoolFactory.getLocalInstance(ctx);
        BillPoolInfo info = null;
        switch (type) {
            case 0: {
                info = BillPoolHelper.getBillPoolInfoByWarehousringBill(model);
                break;
            }
            case 1: {
                info = BillPoolHelper.getBillPoolInfoByOutboundBill(model);
            }
        }
        iBillPool.addnew(info);
    }

    public static void update(Context ctx, IObjectValue model, int type) throws BOSException, EASBizException {
        IBillPool iBillPool = BillPoolFactory.getLocalInstance(ctx);
        String sourceBillId = ((CPMMBillBaseInfo)model).getId().toString();
        BillPoolInfo info = iBillPool.getBillPoolInfo("where sourceBillId = '" + sourceBillId + "'");
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        switch (type) {
            case 0: {
                info = BillPoolHelper.getBillPoolInfoByWarehousringBill(model);
                break;
            }
            case 1: {
                info = BillPoolHelper.getBillPoolInfoByOutboundBill(model);
            }
        }
        info.setId(BOSUuid.read((String)pk.toString()));
        iBillPool.update((IObjectPK)pk, info);
    }

    public static BillPoolInfo getBillPoolInfoByWarehousringBill(IObjectValue model) {
        BillPoolInfo info = new BillPoolInfo();
        WarehousingBillInfo wbInfo = (WarehousingBillInfo)model;
        info.setNumber(wbInfo.getNumber());
        info.setAppDate(wbInfo.getAppDate());
        info.setState(wbInfo.getState());
        info.setSourceBillId(wbInfo.getId().toString());
        info.setBillType(BillTypeEnum.WAREHOUSINGBILL);
        info.setPerson(wbInfo.getAppPerson());
        info.setWarehouse(wbInfo.getWarehouse());
        return info;
    }

    public static BillPoolInfo getBillPoolInfoByOutboundBill(IObjectValue model) {
        BillPoolInfo info = new BillPoolInfo();
        OutboundBillInfo obInfo = (OutboundBillInfo)model;
        info.setNumber(obInfo.getNumber());
        info.setAppDate(obInfo.getAppDate());
        info.setState(obInfo.getState());
        info.setSourceBillId(obInfo.getId().toString());
        info.setBillType(BillTypeEnum.OUTBOUND);
        info.setPerson(obInfo.getApplicant());
        info.setWarehouse(obInfo.getWarehouse());
        return info;
    }

    public static void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sourceBillId = pk.toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId, CompareType.EQUALS));
        IBillPool iBillPool = BillPoolFactory.getLocalInstance(ctx);
        iBillPool.delete(filter);
    }

    public static void updateState(Context ctx, BOSUuid billID, MMBillStateEnum state) throws BOSException, EASBizException {
        String sourceBillId = billID.toString();
        IBillPool iBillPool = BillPoolFactory.getLocalInstance(ctx);
        BillPoolInfo info = iBillPool.getBillPoolInfo("where sourceBillId = '" + sourceBillId + "'");
        info.setState(state);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        iBillPool.update((IObjectPK)pk, info);
    }
}

