/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.IInventoryBill;
import com.kingdee.eas.cp.cpmm.InventoryBillFactory;
import com.kingdee.eas.cp.cpmm.InventoryBillInfo;
import com.kingdee.eas.cp.cpmm.app.AbstractInventoryBillControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class InventoryBillControllerBean
extends AbstractInventoryBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.InventoryBillControllerBean");
    IInventoryBill service = null;

    protected void _setIsChange(Context ctx, BOSUuid billID) throws BOSException {
        this.service = InventoryBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        try {
            InventoryBillInfo model = this.service.getInventoryBillInfo((IObjectPK)pk);
            model.setIsChange(true);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)model);
        }
        catch (EASBizException e) {
            logger.error((Object)"setIsChange error!", (Throwable)e);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.isEixtRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
        }
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isEixtRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
        }
        return super._addnew(ctx, model);
    }

    protected void setNumberFromCodingRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InventoryBillInfo inventoryInfo = (InventoryBillInfo)model;
        if (inventoryInfo.getNumber() == null || "".equals(inventoryInfo.getNumber())) {
            String orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)inventoryInfo, orgId);
            if (number != null) {
                inventoryInfo.setNumber(number);
            }
        }
    }

    protected boolean isEixtRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean flag = false;
        InventoryBillInfo inventoryInfo = (InventoryBillInfo)model;
        String orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)inventoryInfo, orgId)) {
            flag = true;
        }
        return flag;
    }
}

