/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.CPMMBillBaseInfo;
import com.kingdee.eas.cp.cpmm.CharacterEnum;
import com.kingdee.eas.cp.cpmm.IInventoryChangeBill;
import com.kingdee.eas.cp.cpmm.IItemDetail;
import com.kingdee.eas.cp.cpmm.IMaterialsRecord;
import com.kingdee.eas.cp.cpmm.IOutboundBill;
import com.kingdee.eas.cp.cpmm.InOutTypeInfo;
import com.kingdee.eas.cp.cpmm.InventoryChangeBillFactory;
import com.kingdee.eas.cp.cpmm.ItemDetailFactory;
import com.kingdee.eas.cp.cpmm.ItemDetailInfo;
import com.kingdee.eas.cp.cpmm.ItemStateEnum;
import com.kingdee.eas.cp.cpmm.MMBillStateEnum;
import com.kingdee.eas.cp.cpmm.MaterialsRecordFactory;
import com.kingdee.eas.cp.cpmm.MaterialsRecordInfo;
import com.kingdee.eas.cp.cpmm.OutboundBillEntryCollection;
import com.kingdee.eas.cp.cpmm.OutboundBillEntryInfo;
import com.kingdee.eas.cp.cpmm.OutboundBillFactory;
import com.kingdee.eas.cp.cpmm.OutboundBillInfo;
import com.kingdee.eas.cp.cpmm.app.AbstractOutboundBillControllerBean;
import com.kingdee.eas.cp.cpmm.app.ArticlePoolHelper;
import com.kingdee.eas.cp.cpmm.app.BillPoolHelper;
import com.kingdee.eas.cp.cpmm.app.WarnningSettingUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.msg.MobileConnectException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class OutboundBillControllerBean
extends AbstractOutboundBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.OutboundBillControllerBean");
    IOutboundBill service = null;
    IMaterialsRecord mService = null;
    IItemDetail itemService = null;
    IInventoryChangeBill changeService = null;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.changeService = InventoryChangeBillFactory.getLocalInstance(ctx);
        OutboundBillInfo info = this.initNewModel(ctx, model);
        if (this.isExistRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        BillPoolHelper.addNew(ctx, (IObjectValue)info, 1);
        this.writeBackSourceBill((IObjectValue)info, 7);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.changeService = InventoryChangeBillFactory.getLocalInstance(ctx);
        OutboundBillInfo info = this.initNewModel(ctx, model);
        if (this.isExistRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
        }
        super._addnew(ctx, pk, (IObjectValue)info);
        this.writeBackSourceBill((IObjectValue)info, 7);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OutboundBillInfo value = (OutboundBillInfo)model;
        MMBillStateEnum state = value.getState();
        logger.info((Object)("in OutboundBillControllerBean before submit state" + (Object)((Object)value.getState())));
        IObjectPK pk = super._submit(ctx, model);
        logger.info((Object)("in OutboundBillControllerBean after submit state" + (Object)((Object)((CPMMBillBaseInfo)model).getState())));
        if (state.equals((Object)MMBillStateEnum.TEMPORARY) || state.equals((Object)MMBillStateEnum.UNAUDITED)) {
            this.changeService = InventoryChangeBillFactory.getLocalInstance(ctx);
            if (value.getSourceBillId() != null && !value.getSourceBillId().equals("")) {
                BOSUuid sourcebillID = BOSUuid.read((String)value.getSourceBillId());
                this.changeService.setChangeState(sourcebillID, "OUTBOUNDBILL", 8);
            }
        }
        return pk;
    }

    private OutboundBillInfo initNewModel(Context ctx, IObjectValue model) {
        OutboundBillInfo info = (OutboundBillInfo)model;
        if (info.getApplicant() == null) {
            PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            info.setApplicant(person);
        }
        if (info.getAppDepartment() == null) {
            AdminOrgUnitInfo adminOrgUnitInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
            info.setAppDepartment(adminOrgUnitInfo);
        }
        if (info.getAppParty() == null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            info.setAppParty(companyOrgUnitInfo);
        }
        if (info.getAppDate() == null) {
            info.setAppDate(DateTimeUtils.truncateDate((Date)new Date()));
        }
        if (info.getState() == null) {
            info.setState(MMBillStateEnum.TEMPORARY);
        }
        if (info.getSourceBillId() != null && !info.getSourceBillId().equals("")) {
            info.put("entry", (Object)this.createEntries(info.getEntry()));
        }
        return info;
    }

    private OutboundBillEntryCollection createEntries(OutboundBillEntryCollection entry) {
        OutboundBillEntryCollection entries = new OutboundBillEntryCollection();
        for (int i = 0; i < entry.size(); ++i) {
            OutboundBillEntryInfo entryInfo = entry.get(i);
            MaterialsRecordInfo material = entryInfo.getMaterial();
            String modelType = material.getModelType().getValue();
            if (modelType.equals("device") || modelType.equals("books")) {
                int amount = entryInfo.getAmount();
                if (amount > 1) {
                    entryInfo.setAmount(1);
                    for (int j = 0; j < amount; ++j) {
                        OutboundBillEntryInfo temp = new OutboundBillEntryInfo();
                        temp = (OutboundBillEntryInfo)entryInfo.clone();
                        temp.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                        entries.add(temp);
                    }
                    continue;
                }
                entries.add(entryInfo);
                continue;
            }
            entries.add(entryInfo);
        }
        return entries;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BillPoolHelper.delete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        BillPoolHelper.update(ctx, model, 1);
    }

    protected void _confirm(Context ctx, BOSUuid billID) throws BOSException {
        try {
            this._setFinished(ctx, billID);
        }
        catch (EASBizException e) {
            logger.error((Object)("error occur in the function \"_confirm\" Of the class \"OutboundBillControllerBean\" : \n " + e.getCause()));
        }
    }

    protected void _setFinished(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.service = OutboundBillFactory.getLocalInstance(ctx);
        this.changeService = InventoryChangeBillFactory.getLocalInstance(ctx);
        this.itemService = ItemDetailFactory.getLocalInstance(ctx);
        this.mService = MaterialsRecordFactory.getLocalInstance(ctx);
        String senderName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
        this.updateInvenTories(billID);
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.FINISHED);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("outDate"));
        sic.add(new SelectorItemInfo("outPerson"));
        OutboundBillInfo bill = this.service.getOutboundBillInfo((IObjectPK)new ObjectUuidPK(billID), sic);
        if (bill != null && (bill.getOutPerson() == null || bill.getOutDate() == null)) {
            bill.setOutDate(new Date());
            bill.setOutPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            this.service.updatePartial(bill, sic);
        }
        ArticlePoolHelper.addNew(ctx, billID);
        super._setFinished(ctx, billID);
        try {
            WarnningSettingUtils.warnningNotcieByBill(ctx, billID.toString(), senderName);
        }
        catch (SQLException e) {
            logger.error((Object)("error occur in the function \"_setFinished\" Of the class \"OutboundBillControllerBean\" : \n " + e.getCause()));
        }
        catch (MobileConnectException mce) {
            logger.error((Object)("error occur in the function \"_setFinished\" Of the class \"OutboundBillControllerBean\" : \n " + mce.getCause()));
        }
        catch (MobileException me) {
            logger.error((Object)("error occur in the function \"_setFinished\" Of the class \"OutboundBillControllerBean\" : \n " + me.getCause()));
        }
    }

    protected void _setAbandoned(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.ABANDONED);
        super._setAbandoned(ctx, billID);
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.AUDITED);
        super._setAudited(ctx, billID);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.UNAUDITED);
        super._setAuditEnd(ctx, billID);
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        logger.info((Object)("set bill state to auditing!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
        BillPoolHelper.updateState(ctx, billID, MMBillStateEnum.AUDITING);
        logger.info((Object)("set bill state to auditing action success!!!!!!!!!!!!!!!!!!!!!!!!,billID:" + billID));
        super._setAuditing(ctx, billID);
    }

    private void updateInvenTories(BOSUuid billID) throws BOSException, EASBizException {
        OutboundBillInfo model = this.service.getOutboundBillInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelector());
        OutboundBillEntryCollection entries = model.getEntry();
        CoreBaseCollection itemCol = new CoreBaseCollection();
        CoreBaseCollection materialCol = new CoreBaseCollection();
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                ItemDetailInfo itemInfo;
                if (entries.get(i).getIsOutbound() == null || !entries.get(i).getIsOutbound().getValue().equals("1")) continue;
                OutboundBillEntryInfo entryInfo = entries.get(i);
                MaterialsRecordInfo material = entryInfo.getMaterial();
                String modelType = material.getModelType().getValue();
                InOutTypeInfo inOutType = entryInfo.getInOutType();
                CharacterEnum character = inOutType.getCharacter();
                int oldAvailableAmount = material.getAvailableAmount();
                int num = entryInfo.getAmount();
                int newAvailableAmount = oldAvailableAmount - num;
                material.setAvailableAmount(newAvailableAmount);
                if (character.equals((Object)CharacterEnum.REDUCE)) {
                    int oldAmount = material.getAmount();
                    int newAmount = oldAmount - num;
                    material.setAmount(newAmount);
                }
                if ((modelType.equals("device") || modelType.equals("books")) && (itemInfo = entryInfo.getItemDetail()) != null) {
                    itemInfo.setState(ItemStateEnum.OUTBOUND);
                    itemCol.add((CoreBaseInfo)itemInfo);
                }
                materialCol.add((CoreBaseInfo)material);
            }
        }
        this.itemService.update(itemCol);
        this.mService.update(materialCol);
        this.writeBackSourceBill((IObjectValue)model, 5);
    }

    private void writeBackSourceBill(IObjectValue value, int changeState) throws EASBizException, BOSException {
        OutboundBillInfo model = (OutboundBillInfo)value;
        if (model.getSourceBillId() != null && !model.getSourceBillId().equals("")) {
            BOSUuid sourcebillID = BOSUuid.read((String)model.getSourceBillId());
            this.changeService.setChangeState(sourcebillID, "OUTBOUNDBILL", changeState);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.material.*"));
        sic.add(new SelectorItemInfo("entry.inOutType.*"));
        sic.add(new SelectorItemInfo("entry.itemDetail.*"));
        return sic;
    }

    protected void setNumberFromCodingRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OutboundBillInfo outInfo = (OutboundBillInfo)model;
        if (outInfo.getNumber() == null || "".equals(outInfo.getNumber())) {
            String orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)outInfo, orgId);
            if (number != null) {
                outInfo.setNumber(number);
            }
        }
    }

    protected boolean isExistRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean flag = false;
        String orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        OutboundBillInfo outInfo = (OutboundBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)outInfo, orgId)) {
            flag = true;
        }
        return flag;
    }
}

