/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.mrm.MRMRegularInteval;
import com.kingdee.eas.cp.mrm.MRRegularInfo;
import com.kingdee.eas.cp.mrm.MRSummaryInfo;
import com.kingdee.eas.cp.mrm.MRSummaryMRApplyCCCollection;
import com.kingdee.eas.cp.mrm.MRSummaryMRAttendantCollection;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MRMRSummary
extends MRMRegularInteval {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mrm.app.MRMRSummary");
    private static String EAS = "com.kingdee.eas.cp.mrm.MailResource";
    static Locale local;
    static String jiyaoTheme;
    static String writeTime;
    static String writer;
    static String guanli;

    public MRMRSummary(MRRegularInfo regular, Date curDate) {
        super(regular, curDate);
    }

    public static void sendInform(Context ctx, MRSummaryInfo summaryInfo, int type) throws Exception {
        local = ctx.getLocale();
        MRMRSummary.SetMailHead();
        HashMap map = null;
        map = null != summaryInfo && null != summaryInfo.getCU() && null != summaryInfo.getCU().getId() ? MRMRSummary.getInformType(ctx, summaryInfo.getCU().getId().toString()) : MRMRSummary.getInformType(ctx, null);
        boolean isSMS = false;
        boolean isMessage = false;
        boolean isEmail = false;
        if (map.get("isSMS") != null) {
            isSMS = (Boolean)map.get("isSMS");
            logger.error((Object)("isSMS:" + isSMS));
        }
        if (map.get("isMessage") != null) {
            isMessage = (Boolean)map.get("isMessage");
        }
        if (map.get("isEmail") != null) {
            isEmail = (Boolean)map.get("isEmail");
        }
        if (isSMS) {
            try {
                MRMRSummary.sendSMS(ctx, summaryInfo, type);
            }
            catch (Exception e) {
                logger.error((Object)("send sms error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        if (isMessage) {
            try {
                MRMRSummary.sendMessage(ctx, summaryInfo, type);
            }
            catch (Exception e) {
                logger.error((Object)("send message error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        if (isEmail) {
            try {
                MRMRSummary.sendMail(ctx, summaryInfo, type);
            }
            catch (Exception e) {
                logger.error((Object)("send mail error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
    }

    public static void sendMessage(Context ctx, MRSummaryInfo summaryInfo, int type) throws EASBizException, BOSException {
        String[] ids = MRMRSummary.getUserId(ctx, summaryInfo);
        String messageStr = MRMRSummary.getMsgTitle(summaryInfo, type, ctx);
        String senderStr = summaryInfo.getRecorder().getName();
        String bodyStr = MRMRSummary.getMsgBody(summaryInfo);
        MRMRSummary.sendMessage(ctx, ids, messageStr, senderStr, bodyStr, summaryInfo.getId().toString(), 1);
    }

    public static void sendMail(Context ctx, MRSummaryInfo apply, int type) throws Exception {
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        MRSummaryMRAttendantCollection attC = apply.getMRAttendant();
        if (attC != null) {
            int size = attC.size();
            for (int i = 0; i < size; ++i) {
                list.add(attC.get(i).getAttendant());
            }
        }
        if (apply.getCompere() != null) {
            list.add(apply.getCompere());
        }
        if (apply.getCaller() != null) {
            list.add(apply.getCaller());
        }
        if (apply.getRecorder() != null) {
            list.add(apply.getRecorder());
        }
        String to = MRMRSummary.getMailPersonStr(ctx, list);
        list = new ArrayList();
        MRSummaryMRApplyCCCollection ccC = apply.getMRApplyCC();
        if (ccC != null) {
            int size = ccC.size();
            for (int i = 0; i < size; ++i) {
                list.add(ccC.get(i).getCc());
            }
        }
        String cc = MRMRSummary.getMailPersonStr(ctx, list);
        String subject = MRMRSummary.getMsgTitle(apply, type, ctx);
        String body = MRMRSummary.getMsgBody(apply, true);
        if (!(to != null && to.length() != 0 || cc != null && cc.length() != 0)) {
            return;
        }
        MsgUtil.msgMailDerect((Context)ctx, (String)subject, (String)body, (String)to, null, (String)cc, null);
    }

    public static void sendSMS(Context ctx, MRSummaryInfo apply, int type) throws EASBizException, BOSException {
        String receiver;
        MRSummaryMRApplyCCCollection ccC;
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        MRSummaryMRAttendantCollection attC = apply.getMRAttendant();
        if (attC != null) {
            int size = attC.size();
            for (int i = 0; i < size; ++i) {
                list.add(attC.get(i).getAttendant());
            }
        }
        if ((ccC = apply.getMRApplyCC()) != null) {
            int size = ccC.size();
            for (int i = 0; i < size; ++i) {
                list.add(ccC.get(i).getCc());
            }
        }
        if (apply.getCompere() != null) {
            list.add(apply.getCompere());
        }
        if (apply.getCaller() != null) {
            list.add(apply.getCaller());
        }
        if (apply.getRecorder() != null) {
            list.add(apply.getRecorder());
        }
        if ((receiver = MRMRSummary.getCellNumberStr(ctx, list)) == null || "".equals(receiver)) {
            return;
        }
        String content = MRMRSummary.getMsgTitle(apply, type, ctx);
        SendMessageParamInfo paramInfo = new SendMessageParamInfo();
        paramInfo.setAppendCompanyName(false);
        paramInfo.setAppendNumber(false);
        paramInfo.setAppendPersonName(false);
        paramInfo.setAppendRevert(false);
        paramInfo.setAppendUserName(false);
        paramInfo.setContent(content);
        paramInfo.setReceiver(receiver);
        paramInfo.setCanback(false);
        logger.error((Object)"MsgFacadeFactory.getLocalInstance(ctx)>>iMsgFacade.sendMsg(paramInfo)");
        IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance((Context)ctx);
        iMsgFacade.sendMsg(paramInfo);
    }

    public static String[] getUserId(Context ctx, MRSummaryInfo summaryInfo) throws BOSException, EASBizException {
        MRSummaryMRApplyCCCollection ccC;
        HashSet<String> set = new HashSet<String>();
        MRSummaryMRAttendantCollection attC = summaryInfo.getMRAttendant();
        if (attC != null) {
            int size = attC.size();
            for (int i = 0; i < size; ++i) {
                set.add(attC.get(i).getAttendant().getId().toString());
            }
        }
        if ((ccC = summaryInfo.getMRApplyCC()) != null) {
            int size = ccC.size();
            for (int i = 0; i < size; ++i) {
                set.add(ccC.get(i).getCc().getId().toString());
            }
        }
        if (summaryInfo.getCompere() != null) {
            set.add(summaryInfo.getCompere().getId().toString());
        }
        if (summaryInfo.getCaller() != null) {
            set.add(summaryInfo.getCaller().getId().toString());
        }
        if (summaryInfo.getRecorder() != null) {
            set.add(summaryInfo.getRecorder().getId().toString());
        }
        if (set.size() == 0) {
            return new String[0];
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() == 0) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        int size = userIds.length;
        for (int i = 0; i < size; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    public static void SetMailHead() {
        guanli = ResourceBase.getString((String)EAS, (String)"guanli", (Locale)local);
        writeTime = ResourceBase.getString((String)EAS, (String)"writeTime", (Locale)local);
        writer = ResourceBase.getString((String)EAS, (String)"writer", (Locale)local);
        jiyaoTheme = ResourceBase.getString((String)EAS, (String)"jiyaoTheme", (Locale)local);
    }

    public static String getMsgTitle(MRSummaryInfo summaryInfo, int type, Context ctx) {
        String looktheme = ResourceBase.getString((String)EAS, (String)"looktheme", (Locale)local);
        String huiJiyao = ResourceBase.getString((String)EAS, (String)"huiJiyao", (Locale)local);
        String huiYiJiYaoYou = ResourceBase.getString((String)EAS, (String)"huiYiJiYaoYou", (Locale)local);
        String xiuGai = ResourceBase.getString((String)EAS, (String)"xiuGai", (Locale)local);
        String genzong = ResourceBase.getString((String)EAS, (String)"genzong", (Locale)local);
        StringBuffer sb = new StringBuffer();
        if (type == 1) {
            sb.append(summaryInfo.getName());
            sb.append(huiYiJiYaoYou);
            sb.append(summaryInfo.getRecorder().getName());
            sb.append(xiuGai);
        } else if (type == 0) {
            sb.append(looktheme);
            sb.append(summaryInfo.getName());
            sb.append(huiJiyao);
        } else if (type == 2) {
            sb.append(summaryInfo.getName());
            sb.append(huiYiJiYaoYou);
            sb.append(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            sb.append(genzong);
        }
        return sb.toString();
    }

    public static String getMsgBody(MRSummaryInfo summaryInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append(jiyaoTheme);
        sb.append(summaryInfo.getName());
        sb.append("\n");
        if (summaryInfo.getMrApply() != null) {
            sb.append(guanli);
            sb.append(summaryInfo.getMrApply().getName());
            sb.append("\n");
        }
        if (summaryInfo.getRecorder() != null) {
            sb.append(writer);
            sb.append(summaryInfo.getRecorder().getName());
            sb.append("\n");
        }
        sb.append(writeTime);
        sb.append(MRMRSummary.getTimeStr(summaryInfo.getCreateTime()));
        return sb.toString();
    }

    public static String getMsgBody(MRSummaryInfo summaryInfo, boolean isEmail) {
        StringBuffer sb = new StringBuffer();
        sb.append(jiyaoTheme);
        sb.append(summaryInfo.getName());
        sb.append("\n");
        if (summaryInfo.getMrApply() != null) {
            sb.append(guanli);
            sb.append(summaryInfo.getMrApply().getName());
            sb.append("\n");
        }
        if (summaryInfo.getRecorder() != null) {
            sb.append(writer);
            sb.append(summaryInfo.getRecorder().getName());
            sb.append("\n");
        }
        sb.append(writeTime);
        sb.append(MRMRSummary.getTimeStr(summaryInfo.getCreateTime()));
        return sb.toString();
    }

    static {
        jiyaoTheme = "";
        writeTime = "";
        writer = "";
        guanli = "";
    }
}

