/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.mrm.ApplyStateEnum;
import com.kingdee.eas.cp.mrm.IMRApply;
import com.kingdee.eas.cp.mrm.IMeetingSetting;
import com.kingdee.eas.cp.mrm.ImpDegreeEnum;
import com.kingdee.eas.cp.mrm.MRAppChangeEnum;
import com.kingdee.eas.cp.mrm.MRApplyCollection;
import com.kingdee.eas.cp.mrm.MRApplyFactory;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRApplyCCCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRChangeCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRChangeInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRTraceCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRTraceInfo;
import com.kingdee.eas.cp.mrm.MRApplyUtil;
import com.kingdee.eas.cp.mrm.MRMBaseException;
import com.kingdee.eas.cp.mrm.MRMRApply;
import com.kingdee.eas.cp.mrm.MRMRRegular;
import com.kingdee.eas.cp.mrm.MRMRegularInteval;
import com.kingdee.eas.cp.mrm.MeetingMessageManager;
import com.kingdee.eas.cp.mrm.MeetingRoomInfo;
import com.kingdee.eas.cp.mrm.MeetingSettingCollection;
import com.kingdee.eas.cp.mrm.MeetingSettingFactory;
import com.kingdee.eas.cp.mrm.app.AbstractMRApplyControllerBean;
import com.kingdee.eas.cp.sm.ISchedulePlanFacade;
import com.kingdee.eas.cp.sm.IScheduleType;
import com.kingdee.eas.cp.sm.PriorityLevelEnum;
import com.kingdee.eas.cp.sm.SchedulePlanFacadeFactory;
import com.kingdee.eas.cp.sm.SchedulePlanInfo;
import com.kingdee.eas.cp.sm.ScheduleTypeCollection;
import com.kingdee.eas.cp.sm.ScheduleTypeFactory;
import com.kingdee.eas.cp.sm.ScheduleTypeInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MRApplyControllerBean
extends AbstractMRApplyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mrm.app.MRApplyControllerBean");

    protected ApplyStateEnum _getState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        MRApplyInfo info = (MRApplyInfo)this._getValue(ctx, "select state where id = '" + id.toString() + "'");
        return info.getState();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkForDelete(ctx, (IObjectValue)this.getMRApplyInfo(ctx, pk));
        super._delete(ctx, pk);
    }

    private void checkForDelete(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MRApplyInfo info = (MRApplyInfo)model;
        if (1 != info.getState().getValue()) {
            return;
        }
        Time startTime = info.getStartTime();
        if (MRApplyUtil.compareDateMinute(startTime, new Date()) < 0) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_MATUREAPPLY_CANTNOT_DELETE);
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String personID = user.getPerson().getId().toString();
        String applierID = info.getApplier().getId().toString();
        if (!applierID.equals(personID)) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_USERNOT_APPLIER);
        }
    }

    @Override
    protected boolean _cancel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        logger.info((Object)"into MRApplyControllerBean._cancel ");
        MRApplyInfo info = (MRApplyInfo)this._getValue(ctx, "select id, state, startTime, MRChange.id, MRChange.traceDate, MRChange.desc, MRChange.parent.id, MRChange.changer.id where id = '" + ((MRApplyInfo)model).getId().toString() + "'");
        if (info.getState().getValue() != 1) {
            throw new MRMBaseException(MRMBaseException.UNSUBMITAPPLY_CANNOT_CANCEL);
        }
        long startTime = info.getStartTime().getTime();
        if (startTime <= new Date().getTime()) {
            throw new MRMBaseException(MRMBaseException.MATUREAPPLY_CANNOT_CANCEL);
        }
        MRApplyMRChangeCollection mrc = info.getMRChange();
        MRApplyMRChangeInfo changeInfo = new MRApplyMRChangeInfo();
        changeInfo.setParent(info);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user.getPerson() == null) {
            throw new MRMBaseException(MRMBaseException.USER_NO_MATCH_PERSON);
        }
        changeInfo.setChanger(user.getPerson());
        changeInfo.setIsSendMsg(true);
        changeInfo.setChangeDate(new Date());
        changeInfo.setChangeType(MRAppChangeEnum.CANCELED);
        mrc.add(changeInfo);
        info.setState(ApplyStateEnum.CANCEL);
        super._save(ctx, (IObjectValue)info);
        if (info != null && info.getId() != null) {
            HashSet<BOSUuid> billIdSet = new HashSet<BOSUuid>();
            billIdSet.add(info.getId());
            ISchedulePlanFacade iSchedulePlanFacade = SchedulePlanFacadeFactory.getLocalInstance((Context)ctx);
            iSchedulePlanFacade.cancelSchedulePlans(billIdSet);
        }
        try {
            logger.info((Object)"_cancel MRMRApply.sendInform(...)");
            MRMRApply.sendInform(ctx, (MRApplyInfo)model, changeInfo, null);
        }
        catch (Exception e) {
            logger.error((Object)("send information error:" + e.getMessage() + e.getStackTrace().toString()));
        }
        return true;
    }

    @Override
    protected void _alter(Context ctx, IObjectValue model, String reason) throws BOSException, EASBizException {
        logger.info((Object)"into MRApplyControllerBean._alter");
        MRApplyInfo info = (MRApplyInfo)model;
        this.checkForSubmit(ctx, info);
        if (info.getState().getValue() != 1 && info.getState().getValue() != 3) {
            throw new MRMBaseException(MRMBaseException.UNSUBMITAPPLY_CANNOT_ALTER);
        }
        if (MRApplyUtil.compareDateMinute(info.getStartTime(), new Date()) <= 0) {
            throw new MRMBaseException(MRMBaseException.MATUREAPPLY_CANNOT_ALTER);
        }
        this._checkTime(ctx, info.getStartTime(), info.getEndTime(), info.getId().toString(), info.getAddress().getId().toString());
        info.setState(ApplyStateEnum.END);
        IObjectPK pk = this._save(ctx, (IObjectValue)info);
        MRApplyInfo info2 = (MRApplyInfo)this._getValue(ctx, " select id, address.id, MRChange.id, MRChange.traceDate, MRChange.desc, MRChange.parent.id, MRChange.changer.id,  MRChange.isSendMsg where id = '" + info.getId().toString() + "'");
        MRApplyMRChangeCollection mrc = info2.getMRChange();
        MRApplyMRChangeInfo changeInfo = new MRApplyMRChangeInfo();
        changeInfo.setParent(info2);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user.getPerson() == null) {
            throw new MRMBaseException(MRMBaseException.USER_NO_MATCH_PERSON);
        }
        changeInfo.setChanger(user.getPerson());
        changeInfo.setIsSendMsg(true);
        changeInfo.setChangeDate(new Date());
        changeInfo.setReason(reason);
        changeInfo.setChangeType(MRAppChangeEnum.CHANGED);
        mrc.add(changeInfo);
        super._save(ctx, (IObjectValue)info2);
        this._addNewOrUpdateSchedulePlan(ctx, info);
        try {
            logger.info((Object)"_alter MRMRApply.sendInform(...)");
            MRMRApply.sendInform(ctx, info, changeInfo, reason);
        }
        catch (Exception e) {
            logger.error((Object)("send information error:" + e.getMessage() + e.getStackTrace().toString()));
        }
    }

    @Override
    protected void _adjust(Context ctx, IObjectValue model, String reason) throws BOSException, EASBizException {
        logger.info((Object)"into MRApplyControllerBean._adjust");
        MRApplyInfo info = (MRApplyInfo)model;
        this.checkForSubmit(ctx, info);
        if (info.getState().getValue() != 1 && info.getState().getValue() != 3) {
            throw new MRMBaseException(MRMBaseException.UNSUBMITAPPLY_CANNOT_ADJUST);
        }
        if (MRApplyUtil.compareDateMinute(info.getStartTime(), new Date()) <= 0) {
            throw new MRMBaseException(MRMBaseException.MATUREAPPLY_CANNOT_ADJUST);
        }
        this._checkTime(ctx, info.getStartTime(), info.getEndTime(), info.getId().toString(), info.getAddress().getId().toString());
        info.setState(ApplyStateEnum.END);
        this._save(ctx, (IObjectValue)info);
        MRApplyInfo info2 = (MRApplyInfo)this._getValue(ctx, "select id, address.id, MRChange.id, MRChange.traceDate, MRChange.desc, MRChange.parent.id, MRChange.changer.id, MRChange.isSendMsg where id = '" + info.getId().toString() + "'");
        MRApplyMRChangeCollection mrc = info2.getMRChange();
        MRApplyMRChangeInfo changeInfo = new MRApplyMRChangeInfo();
        changeInfo.setParent(info2);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user.getPerson() == null) {
            throw new MRMBaseException(MRMBaseException.USER_NO_MATCH_PERSON);
        }
        changeInfo.setChanger(user.getPerson());
        changeInfo.setIsSendMsg(true);
        changeInfo.setChangeDate(new Date());
        changeInfo.setReason(reason);
        changeInfo.setChangeType(MRAppChangeEnum.DISPATCHED);
        mrc.add(changeInfo);
        super._save(ctx, (IObjectValue)info2);
        this._addNewOrUpdateSchedulePlan(ctx, info);
        try {
            logger.info((Object)"_adjust MRMRApply.sendInform(...)");
            MRMRApply.sendInform(ctx, info, changeInfo, reason);
        }
        catch (Exception e) {
            logger.error((Object)("send information error:" + e.getMessage() + e.getStackTrace().toString()));
        }
    }

    @Override
    protected void _checkTime(Context ctx, Time startTime, Time endTime, String id, String roomId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(4)));
        filter.getFilterItems().add(new FilterItemInfo("address", (Object)roomId));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)startTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)startTime, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)startTime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)endTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)endTime, CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)endTime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)startTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)endTime, CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and (#1 or #2) and #3 and ((#4 and #5) or (#6 and #7) or (#8 and #9) or (#10 and #11))");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("startTime"));
        evi.getSelector().add(new SelectorItemInfo("endTime"));
        evi.getSelector().add(new SelectorItemInfo("address.id"));
        evi.getSelector().add(new SelectorItemInfo("address.name"));
        evi.getSelector().add(new SelectorItemInfo("id"));
        MRApplyCollection c = this.getMRApplyCollection(ctx, evi);
        int size = c.size();
        if (size > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    sb.append("<br>");
                }
                sb.append(c.get(i).getNumber() == null ? "" : c.get(i).getNumber());
                sb.append("(");
                sb.append(c.get(i).getAddress().getName());
                sb.append(" : ");
                sb.append(this.formatDate(c.get(i).getStartTime(), "yyyy-MM-dd HH:mm"));
                sb.append(" -- ");
                sb.append(this.formatDate(c.get(i).getEndTime(), "yyyy-MM-dd HH:mm"));
                sb.append(")");
            }
            throw new MRMBaseException(MRMBaseException.APPLYTIME_CONFLICT, new Object[]{sb.toString()});
        }
    }

    public String formatDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    @Override
    protected void _trace(Context ctx, IObjectValue model, String desc) throws BOSException, EASBizException {
        MRApplyInfo info = (MRApplyInfo)model;
        if (info.getState().getValue() != 1) {
            throw new MRMBaseException(MRMBaseException.UNSUBMITAPPLY_CANNOT_TRACE);
        }
        if (MRApplyUtil.compareDateMinute(new Date(), info.getStartTime()) <= 0) {
            throw new MRMBaseException(MRMBaseException.UNMATUREAPPLY_CANNOT_TRACE);
        }
        info = (MRApplyInfo)this._getValue(ctx, "select id, address.id, MRTrace.id, MRTrace.traceDate,  MRTrace.desc, MRTrace.parent.id, MRTrace.tracer.id  where id = '" + info.getId().toString() + "'");
        MRApplyMRTraceCollection mrc = info.getMRTrace();
        MRApplyMRTraceInfo traceInfo = new MRApplyMRTraceInfo();
        traceInfo.setParent(info);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user.getPerson() == null) {
            throw new MRMBaseException(MRMBaseException.USER_NO_MATCH_PERSON);
        }
        traceInfo.setTracer(user.getPerson());
        traceInfo.setDesc(desc);
        traceInfo.setTraceDate(new Date());
        mrc.add(traceInfo);
        super._save(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        logger.info((Object)"into MRApplyControllerBean._submit");
        MRApplyInfo info = (MRApplyInfo)model;
        this.checkForSubmit(ctx, info);
        this._checkTime(ctx, info.getStartTime(), info.getEndTime(), info.getId() == null ? null : info.getId().toString(), info.getAddress().getId().toString());
        IObjectPK pk = null;
        String pubProcess = null;
        pubProcess = info.getApplyProcess();
        if (pubProcess != null && !"".equals(pubProcess)) {
            ((MRApplyInfo)model).setState(ApplyStateEnum.AUD);
            pk = super._submit(ctx, model);
            this.saveFile(ctx, model, pk);
        } else {
            Long t1 = System.currentTimeMillis();
            ((MRApplyInfo)model).setState(ApplyStateEnum.END);
            pk = super._save(ctx, model);
            model.setExtendedProperty("ignoreWorkflow", "true");
            MeetingMessageManager messageManager = new MeetingMessageManager(ctx, (MRApplyInfo)model);
            Thread messageThread = new Thread(messageManager);
            messageThread.start();
            Long t2 = System.currentTimeMillis();
            logger.error((Object)("-----------------------------------------------------" + (t2 - t1)));
        }
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        logger.info((Object)"into MRApplyControllerBean._save");
        IObjectPK pk = super._save(ctx, model);
        this.saveFile(ctx, model, pk);
        if (ApplyStateEnum.CONFLICT.getValue() == ((MRApplyInfo)model).getState().getValue()) {
            try {
                logger.info((Object)"_save MRMRRegular.sendInform(...)");
                MRMRRegular.sendInform(ctx, (MRApplyInfo)model);
            }
            catch (Exception e) {
                logger.error((Object)("send inform error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        return pk;
    }

    private void saveFile(Context ctx, IObjectValue model, IObjectPK pk) {
        String sql = "select FEntity from T_CP_DocExchange where fid = ? ";
        Object[] obj = new Object[1];
        Blob blob = null;
        InputStream in = null;
        try {
            obj[0] = model.getString("fileName");
            if (obj[0] == null) {
                return;
            }
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])obj);
            if (rows.next() && null != (blob = rows.getBlob(1))) {
                in = blob.getBinaryStream();
            }
            sql = "update T_MRM_MRAPPLY SET FDocEntity = ? WHERE FID = ?";
            PreparedStatement ps = this.getConnection(ctx).prepareStatement(sql);
            logger.info((Object)("Remove DocEntity Size is:" + in.available()));
            ps.setBinaryStream(1, in, in.available());
            ps.setString(2, pk.toString());
            ps.execute();
            in.close();
            sql = "delete T_CP_DocExchange where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getGenAheadParam(Context ctx, String cuIdStr) throws BOSException, EASBizException {
        IMeetingSetting ims = MeetingSettingFactory.getLocalInstance(ctx);
        MeetingSettingCollection mc = ims.getMeetingSettingCollection("select key, value,  type where CU.id = '" + cuIdStr + "' and key = 'aheadDays' ");
        if (mc.size() > 0 && mc.get(0).getValue() != null) {
            return Integer.valueOf(mc.get(0).getValue().toString());
        }
        return 0;
    }

    private void checkState(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MRApplyCollection c;
        MRApplyInfo info = (MRApplyInfo)model;
        if (info.getId() != null && (c = this.getMRApplyCollection(ctx, "select state where id = '" + info.getId().toString() + "'")).size() > 0 && (info = c.get(0)).getState().getValue() == 1) {
            throw new MRMBaseException(MRMBaseException.SUMMITEDAPPLY_CANNOT_CHANGE);
        }
    }

    private void checkForSubmit(Context ctx, MRApplyInfo info) throws BOSException, EASBizException {
        if (info.getName() == null || info.getName().trim().length() == 0) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_NAME_NULL);
        }
        if (info.getAddress() == null) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_ADDRESS_NULL);
        }
        if (info.getStartTime() == null) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_BEGINTIME_NULL);
        }
        if (info.getEndTime() == null) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_ENDTIME_NULL);
        }
        if (info.getApplier() == null) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_APPLIER_NULL);
        }
        if (info.getStartTime().compareTo(info.getEndTime()) >= 0) {
            throw new MRMBaseException(MRMBaseException.BEGINTIME_GREATER_ENDTIME);
        }
        Date now = new Date();
        if (info.getStartTime().compareTo(new Time(now.getTime())) < 0) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_BEFORE_NOW);
        }
        Date startDate = new Date(info.getStartTime().getTime());
        int ahead = this.getGenAheadParam(ctx, info.getCU().getId().toString());
        if (info.getRegular() != null) {
            ++ahead;
        }
        if (DateTimeUtils.dateDiff((String)"d", (Date)(now = DateTimeUtils.truncateDate((Date)now)), (Date)(startDate = DateTimeUtils.truncateDate((Date)startDate))) > (long)ahead) {
            throw new MRMBaseException(MRMBaseException.MRAPPLY_AFTER_MEETSET_AHEAD);
        }
    }

    @Override
    protected void _applyWorkFlow(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _shenpi(Context ctx, IObjectValue model) throws BOSException {
        logger.info((Object)"into MRApplyControllerBean._shenpi");
        IMRApply MRApply2 = MRApplyFactory.getLocalInstance(ctx);
        try {
            MRApplyInfo MRApplyModel = MRApply2.getMRApplyInfo((IObjectPK)new ObjectUuidPK(((MRApplyInfo)model).getId()), this.getSelectors());
            MRApplyModel.setState(ApplyStateEnum.END);
            MRApplyModel.remove("docEntity");
            super._save(ctx, (IObjectValue)MRApplyModel);
            this._addNewOrUpdateSchedulePlan(ctx, MRApplyModel);
            try {
                logger.info((Object)"_shenpi MRMRegularInteval.sendInform(...)");
                MRMRegularInteval.sendInform(ctx, MRApplyModel);
            }
            catch (Exception e) {
                logger.error((Object)("send inform error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("fileName"));
        sic.add(new SelectorItemInfo("contactPhone"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("mrType.id"));
        sic.add(new SelectorItemInfo("mrType.number"));
        sic.add(new SelectorItemInfo("mrType.name"));
        sic.add(new SelectorItemInfo("impDegree"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applyUnit.id"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("applyUnit.number"));
        sic.add(new SelectorItemInfo("address.*"));
        sic.add(new SelectorItemInfo("address.id"));
        sic.add(new SelectorItemInfo("address.number"));
        sic.add(new SelectorItemInfo("address.name"));
        sic.add(new SelectorItemInfo("address.contact.*"));
        sic.add(new SelectorItemInfo("address.contactTwo.*"));
        sic.add(new SelectorItemInfo("startTime"));
        sic.add(new SelectorItemInfo("endTime"));
        sic.add(new SelectorItemInfo("caller.id"));
        sic.add(new SelectorItemInfo("caller.number"));
        sic.add(new SelectorItemInfo("caller.name"));
        sic.add(new SelectorItemInfo("compere.id"));
        sic.add(new SelectorItemInfo("compere.number"));
        sic.add(new SelectorItemInfo("compere.name"));
        sic.add(new SelectorItemInfo("MRApplyCC.id"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.id"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.name"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.number"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.seq"));
        sic.add(new SelectorItemInfo("MRAttendant.id"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.id"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.name"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.number"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.seq"));
        sic.add(new SelectorItemInfo("recorder.id"));
        sic.add(new SelectorItemInfo("recorder.number"));
        sic.add(new SelectorItemInfo("recorder.name"));
        sic.add(new SelectorItemInfo("MRChange.*"));
        sic.add(new SelectorItemInfo("MRChange.changer.*"));
        sic.add(new SelectorItemInfo("MRTrace.*"));
        sic.add(new SelectorItemInfo("MRTrace.tracer.*"));
        sic.add(new SelectorItemInfo("regular.*"));
        return sic;
    }

    @Override
    protected void _shenpifiled(Context ctx, IObjectValue model) throws BOSException {
        IMRApply MRApply2 = MRApplyFactory.getLocalInstance(ctx);
        try {
            MRApplyInfo MRApplyModel = MRApply2.getMRApplyInfo((IObjectPK)new ObjectUuidPK(((MRApplyInfo)model).getId()));
            MRApplyModel.setState(ApplyStateEnum.SAVE);
            MRApplyModel.remove("docEntity");
            super._save(ctx, (IObjectValue)MRApplyModel);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    protected void _quxiao(Context ctx, IObjectValue model) throws BOSException {
        IMRApply MRApply2 = MRApplyFactory.getLocalInstance(ctx);
        try {
            MRApplyInfo MRApplyModel = MRApply2.getMRApplyInfo((IObjectPK)new ObjectUuidPK(((MRApplyInfo)model).getId()));
            MRApplyModel.setState(ApplyStateEnum.CANCEL);
            MRApplyModel.remove("docEntity");
            super._save(ctx, (IObjectValue)MRApplyModel);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    protected void _addNewOrUpdateSchedulePlan(Context ctx, MRApplyInfo applyInfo) throws BOSException, EASBizException {
        int i;
        int length;
        if (applyInfo == null) {
            return;
        }
        HashSet<BOSUuid> personIdsSet = new HashSet<BOSUuid>();
        HashMap map = MRMRegularInteval.getInformType(ctx, applyInfo.getCU().getId().toString());
        boolean isSMS = false;
        boolean isMessage = false;
        boolean isEmail = false;
        if (map.get("isSMS") != null) {
            isSMS = (Boolean)map.get("isSMS");
        }
        if (map.get("isMessage") != null) {
            isMessage = (Boolean)map.get("isMessage");
        }
        if (map.get("isEmail") != null) {
            isEmail = (Boolean)map.get("isEmail");
        }
        ISchedulePlanFacade iSchedulePlanFacade = SchedulePlanFacadeFactory.getLocalInstance((Context)ctx);
        IScheduleType iScheduleType = ScheduleTypeFactory.getLocalInstance((Context)ctx);
        ScheduleTypeCollection collType = iScheduleType.getScheduleTypeCollection(" WHERE srcObjType='1C10C0FA'");
        ScheduleTypeInfo typeInfo = null;
        if (collType != null && collType.size() > 0) {
            typeInfo = collType.get(0);
        }
        SchedulePlanInfo schedulePlan = new SchedulePlanInfo();
        schedulePlan.setTitle(applyInfo.getName());
        schedulePlan.setEventDate((Date)applyInfo.getStartTime());
        schedulePlan.setEventEndDate((Date)applyInfo.getEndTime());
        schedulePlan.setScheduleType(typeInfo);
        schedulePlan.setScheduleAddress(applyInfo.getAddress().getName());
        schedulePlan.setIsMobile(isSMS);
        schedulePlan.setIsMessage(isMessage);
        schedulePlan.setIsMail(isEmail);
        if (ImpDegreeEnum.IMPORTANT.equals((Object)applyInfo.getImpDegree())) {
            schedulePlan.setLevel(PriorityLevelEnum.HIGH);
        } else {
            schedulePlan.setLevel(PriorityLevelEnum.MIDDLE);
        }
        if (applyInfo.getApplier() != null) {
            personIdsSet.add(applyInfo.getApplier().getId());
        }
        if (applyInfo.getCompere() != null) {
            personIdsSet.add(applyInfo.getCompere().getId());
        }
        if (applyInfo.getCaller() != null) {
            personIdsSet.add(applyInfo.getCaller().getId());
        }
        if (applyInfo.getRecorder() != null) {
            personIdsSet.add(applyInfo.getRecorder().getId());
        }
        if (applyInfo.getMRApplyCC() != null && applyInfo.getMRApplyCC().size() > 0) {
            MRApplyMRApplyCCCollection userCCColl = applyInfo.getMRApplyCC();
            length = userCCColl.size();
            for (i = 0; i < length; ++i) {
                personIdsSet.add(userCCColl.get(i).getCc().getId());
            }
        }
        if (applyInfo.getMRAttendant() != null && applyInfo.getMRAttendant().size() > 0) {
            MRApplyMRAttendantCollection userMRAttendantColl = applyInfo.getMRAttendant();
            length = userMRAttendantColl.size();
            for (i = 0; i < length; ++i) {
                personIdsSet.add(userMRAttendantColl.get(i).getAttendant().getId());
            }
        }
        iSchedulePlanFacade.addNewOrUpdateSchedulePlan(schedulePlan, personIdsSet, applyInfo.getId());
    }

    @Override
    protected void _postMessage(Context ctx) throws BOSException {
        Date curDate = new Date();
        Date fifteenMLater = new Date(curDate.getTime() + 900000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            fifteenMLater = sdf.parse(sdf.format(fifteenMLater));
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRApplyQuery");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("startTime"));
            sic.add(new SelectorItemInfo("endTime"));
            sic.add(new SelectorItemInfo("applier.id"));
            sic.add(new SelectorItemInfo("applier.name"));
            sic.add(new SelectorItemInfo("compere.id"));
            sic.add(new SelectorItemInfo("compere.name"));
            sic.add(new SelectorItemInfo("address.id"));
            sic.add(new SelectorItemInfo("address.name"));
            sic.add(new SelectorItemInfo("contactPhone"));
            sic.add(new SelectorItemInfo("laterEmail"));
            sic.add(new SelectorItemInfo("laterSMS"));
            sic.add(new SelectorItemInfo("laterMessage"));
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)fifteenMLater, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            evi.setFilter(filter);
            evi.setSelector(sic);
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
            exec.setObjectView(evi);
            exec.option().isAutoIgnoreZero = true;
            exec.option().isAutoTranslateEnum = true;
            IRowSet rowSet = exec.executeQuery();
            if (rowSet != null) {
                while (rowSet.next()) {
                    MRApplyInfo info = new MRApplyInfo();
                    info.setId(BOSUuid.read((String)rowSet.getString("id")));
                    info.setName(rowSet.getString("name"));
                    info.setStartTime(rowSet.getTime("startTime"));
                    info.setEndTime(rowSet.getTime("endTime"));
                    MeetingRoomInfo meetingRoomInfo = new MeetingRoomInfo();
                    meetingRoomInfo.setName(rowSet.getString("address.name"));
                    meetingRoomInfo.setId(BOSUuid.read((String)rowSet.getString("address.id")));
                    info.setAddress(meetingRoomInfo);
                    PersonInfo applier = new PersonInfo();
                    applier.setId(BOSUuid.read((String)rowSet.getString("applier.id")));
                    applier.setName(rowSet.getString("applier.name"));
                    info.setApplier(applier);
                    PersonInfo compere = new PersonInfo();
                    compere.setId(BOSUuid.read((String)rowSet.getString("compere.id")));
                    compere.setName(rowSet.getString("compere.name"));
                    info.setCompere(compere);
                    info.setLaterEmail(rowSet.getBoolean("laterEmail"));
                    info.setLaterMessage(rowSet.getBoolean("laterMessage"));
                    info.setLaterSMS(rowSet.getBoolean("laterSMS"));
                    MRApplyMRAttendantCollection attendantCollection = info.getMRAttendant();
                    attendantCollection.clear();
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select t.FID id,t.FAttendantID attendantId,p.FName_L1 name from T_MRM_MRApplyMRAttendant t, T_BD_Person p where t.FAttendantID = p.FID and t.FParentID = '" + rowSet.getString("id") + "'"));
                    if (rs != null) {
                        while (rs.next()) {
                            PersonInfo person = new PersonInfo();
                            person.setId(BOSUuid.read((String)rs.getString("attendantId")));
                            person.setName(rs.getString("name"));
                            MRApplyMRAttendantInfo attendantInfo = new MRApplyMRAttendantInfo();
                            attendantInfo.setAttendant(person);
                            attendantInfo.setParent(info);
                            attendantCollection.add(attendantInfo);
                        }
                    }
                    MRMRegularInteval.sendInfoLater(ctx, info);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("send inform error:" + e.getMessage() + e.getStackTrace().toString()));
        }
    }
}

