/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.mrm.ApplyStateEnum;
import com.kingdee.eas.cp.mrm.IMRApply;
import com.kingdee.eas.cp.mrm.IMeetingSetting;
import com.kingdee.eas.cp.mrm.MRApplyCollection;
import com.kingdee.eas.cp.mrm.MRApplyFactory;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRApplyCCInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantInfo;
import com.kingdee.eas.cp.mrm.MRApplyUtil;
import com.kingdee.eas.cp.mrm.MRMBaseException;
import com.kingdee.eas.cp.mrm.MRMRegularInteval;
import com.kingdee.eas.cp.mrm.MRRegularInfo;
import com.kingdee.eas.cp.mrm.MRRegularIntevalCenter;
import com.kingdee.eas.cp.mrm.MRRegularMRApplyCCCollection;
import com.kingdee.eas.cp.mrm.MRRegularMRAttendantCollection;
import com.kingdee.eas.cp.mrm.MRRegularStateEnum;
import com.kingdee.eas.cp.mrm.MeetingSettingCollection;
import com.kingdee.eas.cp.mrm.MeetingSettingFactory;
import com.kingdee.eas.cp.mrm.app.AbstractMRRegularControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MRRegularControllerBean
extends AbstractMRRegularControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mrm.app.MRRegularControllerBean");

    @Override
    protected void _genMRApply(Context ctx, String regularId, Date curDate) throws BOSException, EASBizException {
        this._genMRApply(ctx, (IObjectValue)this.getRegularInfoById(ctx, regularId), curDate);
    }

    @Override
    protected boolean _genMRApply(Context ctx, IObjectValue regular, Date curDate) throws BOSException, EASBizException {
        MRRegularInfo reguInfo = (MRRegularInfo)regular;
        MRMRegularInteval inteval = MRRegularIntevalCenter.getCurInteval(reguInfo, curDate);
        if (null != inteval) {
            IMRApply mRApply = MRApplyFactory.getLocalInstance(ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("regular.id", (Object)reguInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("startTime", (Object)MRApplyUtil.getBeginDate(inteval.getMeetBeginDate()), CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("endTime", (Object)MRApplyUtil.getEndDate(inteval.getMeetBeginDate()), CompareType.LESS_EQUALS));
            entityViewInfo.setFilter(filterInfo);
            MRApplyCollection mRCollection = mRApply.getMRApplyCollection(entityViewInfo);
            if (mRCollection != null && mRCollection.size() > 0) {
                throw new MRMBaseException(MRMBaseException.MRREGULAR_ALREADY_GEN, new String[]{MRApplyUtil.formatDate(curDate, "yyyy-MM-dd")});
            }
            if (MRApplyUtil.compareDate(inteval.getGenBeginDate(), curDate) > 0) {
                throw new MRMBaseException(MRMBaseException.MRREGULAR_CURRENTDATE_LESSTHAN_AHEAD, new String[]{MRApplyUtil.formatDate(inteval.getGenBeginDate(), "yyyy-MM-dd"), MRApplyUtil.formatDate(inteval.getGenEndDate(), "yyyy-MM-dd")});
            }
            logger.debug((Object)"\u4f8b\u4f1a\u89c4\u5219ControlBean: \u624b\u52a8\u89e6\u53d1\u751f\u6210\u7684\u4f1a\u8bae\u89c4\u5219");
            return this.gen_MRApply(ctx, inteval);
        }
        logger.debug((Object)("\u4f8b\u4f1a\u89c4\u5219ControlBean: \u624b\u52a8\u89e6\u53d1\u751f\u6210\u7684\u4f1a\u8bae\u89c4\u5219\u4e3a\u7a7a " + curDate));
        throw new MRMBaseException(MRMBaseException.MRREGULAR_CAN_NOT_GEN);
    }

    @Override
    protected void _autoGenMRApply(Context ctx, String regularId, Date curDate) throws BOSException, EASBizException {
        MRRegularInfo reguInfo = this.getRegularInfoById(ctx, regularId);
        if (curDate == null) {
            curDate = new Date();
        }
        Date dt = DateTimeUtils.addDay((Date)curDate, (long)reguInfo.getMrGenAhead());
        MRMRegularInteval inteval = MRRegularIntevalCenter.getCurInteval(reguInfo, dt);
        this._autoGenMRApply(ctx, reguInfo, dt, inteval);
    }

    protected void _autoGenMRApply(Context ctx, MRRegularInfo reguInfo, Date curDate, MRMRegularInteval regularInteval) throws BOSException, EASBizException {
        MRMRegularInteval inteval = null;
        inteval = null == regularInteval ? MRRegularIntevalCenter.getCurInteval(reguInfo, curDate) : regularInteval;
        if (null == inteval) {
            logger.debug((Object)"\u4f8b\u4f1a\u81ea\u52a8\u751f\u6210\uff1a\u4f8b\u4f1a\u89c4\u5219\u5df2\u8fc7\u671f\uff0c\u4e0d\u80fd\u751f\u6210\u4f8b\u4f1a");
            return;
        }
        if (MRApplyUtil.compareDate(inteval.getGenBeginDate(), curDate) <= 0 && MRApplyUtil.compareDate(inteval.getGenEndDate(), curDate) >= 0) {
            logger.debug((Object)"\u4f8b\u4f1a\u81ea\u52a8\u751f\u6210\uff1a\u89c4\u5219\u662f\u5728\u63d0\u524d\u671f\u5185");
            this.gen_MRApply(ctx, inteval);
            MRMRegularInteval next = MRRegularIntevalCenter.getNextInteval(inteval);
            while (null == regularInteval && null != next && MRApplyUtil.compareDate(next.getGenBeginDate(), curDate) <= 0 && MRApplyUtil.compareDate(next.getGenEndDate(), curDate) >= 0) {
                logger.debug((Object)"\u4f8b\u4f1a\u81ea\u52a8\u751f\u6210\uff1a\u5faa\u73af\u751f\u6210\u89c4\u5219\u5728\u63d0\u524d\u671f\u5185\u7684\u4f1a\u8bae");
                this.gen_MRApply(ctx, next);
                next = MRRegularIntevalCenter.getNextInteval(next);
            }
            if (null != next && MRApplyUtil.compareDate(next.getMeetEndDate(), reguInfo.getRepEndDate()) <= 0) {
                logger.debug((Object)"\u4f8b\u4f1a\u81ea\u52a8\u751f\u6210\uff1a\u751f\u6210\u4e0b\u6b21\u4efb\u52a1JOB");
                this.createBackGroundJob(ctx, reguInfo.getId().toString(), reguInfo.getRegularName(), next.getGenBeginDate());
            }
        } else {
            logger.debug((Object)"\u4f8b\u4f1a\u81ea\u52a8\u751f\u6210\uff1a\u4e0d\u5728\u63d0\u524d\u671f\u5185\uff0c\u751f\u6210\u4f1a\u8baeJOB");
            this.createBackGroundJob(ctx, reguInfo.getId().toString(), reguInfo.getRegularName(), inteval.getGenBeginDate());
        }
    }

    private boolean gen_MRApply(Context ctx, MRMRegularInteval inteval) throws BOSException, EASBizException {
        MRRegularInfo reguInfo = inteval.getRegular();
        boolean isConfict = false;
        IMRApply iapply = MRApplyFactory.getLocalInstance(ctx);
        Time beginTime = new Time(inteval.getMeetBeginDate().getTime());
        Time endTime = new Time(inteval.getMeetEndDate().getTime());
        try {
            MRMRegularInteval.checkTime(ctx, beginTime, endTime, reguInfo.getId().toString(), reguInfo.getAddress().getId().toString());
        }
        catch (Exception e) {
            if (e instanceof MRMBaseException) {
                isConfict = true;
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        MRApplyInfo apply = new MRApplyInfo();
        apply.setId(BOSUuid.create((BOSObjectType)apply.getBOSType()));
        apply.setName(reguInfo.getName());
        apply.setMrType(reguInfo.getMrType());
        apply.setApplier(reguInfo.getApplier());
        apply.setApplyUnit(reguInfo.getApplyUnit());
        apply.setAddress(reguInfo.getAddress());
        apply.setContactPhone(reguInfo.getContactPhone());
        apply.setStartTime(beginTime);
        apply.setEndTime(endTime);
        apply.setCompere(reguInfo.getCompere());
        apply.setCaller(reguInfo.getCaller());
        apply.setRecorder(reguInfo.getRecorder());
        apply.setRegular(reguInfo);
        apply.setImpDegree(reguInfo.getImpDegree());
        apply.setNumber(this.getNumber(ctx, apply, reguInfo));
        apply.setContent(reguInfo.getContent());
        apply.setFileName(reguInfo.getFileName());
        apply.setCreator(reguInfo.getCreator());
        apply.setCU(reguInfo.getCU());
        MRApplyMRAttendantInfo attendant = null;
        MRRegularMRAttendantCollection _attC = reguInfo.getMRAttendant();
        if (_attC != null && _attC.size() > 0) {
            int size = _attC.size();
            for (int i = 0; i < size; ++i) {
                attendant = new MRApplyMRAttendantInfo();
                attendant.setSeq(_attC.get(i).getSeq());
                attendant.setAttendant(_attC.get(i).getAttendant());
                apply.getMRAttendant().add(attendant);
            }
        }
        MRApplyMRApplyCCInfo cc = null;
        MRRegularMRApplyCCCollection _ccC = reguInfo.getMRApplyCC();
        if (_ccC != null && _ccC.size() > 0) {
            int size = _ccC.size();
            for (int i = 0; i < size; ++i) {
                cc = new MRApplyMRApplyCCInfo();
                cc.setSeq(_ccC.get(i).getSeq());
                cc.setCc(_ccC.get(i).getCc());
                apply.getMRApplyCC().add(cc);
            }
        }
        String id = null;
        if (isConfict) {
            logger.debug((Object)"\u4f8b\u4f1aControlBean: \u751f\u6210\u7684\u4f1a\u8bae\u89c4\u5219\u51b2\u7a81");
            id = iapply.save((CoreBaseInfo)apply).toString();
            this._copyRTFToApply(ctx, id, reguInfo.getId().toString());
            apply.setState(ApplyStateEnum.CONFLICT);
            iapply.save((CoreBaseInfo)apply).toString();
        } else {
            logger.debug((Object)"\u4f8b\u4f1aControlBean: \u751f\u6210\u4f1a\u8bae\u89c4\u5219");
            id = iapply.save((CoreBaseInfo)apply).toString();
            this._copyRTFToApply(ctx, id, reguInfo.getId().toString());
            apply.setState(ApplyStateEnum.END);
            iapply.submit((CoreBaseInfo)apply).toString();
        }
        return true;
    }

    private boolean _copyRTFToApply(Context ctx, String applyId, String regularId) throws BOSException {
        String sql = "SELECT FDocEntity FROM T_MRM_MRRegular WHERE FID = ?";
        Object[] obj = new Object[1];
        Blob blob = null;
        InputStream in = null;
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{regularId});
            if (rows.next()) {
                blob = rows.getBlob(1);
                if (blob == null) {
                    return false;
                }
                in = blob.getBinaryStream();
                sql = "update T_MRM_MRApply SET FDocEntity = ? WHERE FID = ?";
                PreparedStatement ps = this.getConnection(ctx).prepareStatement(sql);
                ps.setBinaryStream(1, in, in.available());
                ps.setString(2, applyId);
                ps.execute();
                in.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private String getNumber(Context ctx, MRApplyInfo info, MRRegularInfo regular) throws BOSException, EASBizException {
        String number = null;
        String cuID = "";
        cuID = regular != null && regular.getApplyUnit() != null && regular.getApplyUnit().getId() != null ? regular.getApplyUnit().getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        number = iCodingRuleManager.isExist((IObjectValue)info, cuID) ? iCodingRuleManager.getNumber((IObjectValue)info, cuID) : regular.getNumber();
        return number;
    }

    private MRRegularInfo getRegularInfoById(Context ctx, String regularId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select name, regularName, number, mrType, impDegree, applier.id, applyUnit.id, address.id, ");
        sb.append(" contactPhone, caller.id, compere.id, recorder.id, endTime, startTime, mrAppGenType,");
        sb.append(" mrGenAhead, repeatType, week_weekType, week_weekNum, monthSetting, monWeek_monType, ");
        sb.append(" monWeek_weekDay, monDay_day, repStartDate, repEndDate, monWeek_weekNum, monDay_monType, ");
        sb.append(" MRAttendant.id, MRAttendant.attendant.id, MRApplyCC.id, MRApplyCC.cc.id, creator.id, CU.id, mrType.applyProcess ");
        sb.append(" where id = '");
        sb.append(regularId);
        sb.append("'");
        MRRegularInfo reguInfo = this.getMRRegularInfo(ctx, sb.toString());
        return reguInfo;
    }

    public String getSchedule(Date date) {
        Date dt = DateTimeUtils.addMinute((Date)date, (long)5L);
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setDefine(this.getDateStr(dt));
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    public String getDateStr(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        int hour = date.getHours();
        int minute = date.getMinutes();
        int second = date.getSeconds();
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }

    private void changeJobTriggerStatus(Context ctx, String regularID, String status) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String procName = this.getProcessNamePrefix(regularID) + "%";
        sb.append("update t_job_trigger set fisvalid='").append(status).append("' \n where fjobdefid in ").append("(select fjobdefid from t_job_def \n where ftitle like '").append(procName).append("')");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void deleteRetireJob(Context ctx, String regularID) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String local = "_" + ctx.getLocale().toString();
        String procName = this.getProcessNamePrefix(regularID) + "%";
        sb.append("delete from t_wfr_procdef  \n");
        sb.append("\twhere fprocdeftype = 'BACKGROUNDJOB'  \n");
        sb.append("\tand fname");
        sb.append(local);
        sb.append(" like '");
        sb.append(procName);
        sb.append("'  \n");
        sb.append("\tand fprocdefid not in (  \n");
        sb.append("\tselect fprocdefid from t_wfr_procinst where fprocdefid in (  \n");
        sb.append("\tselect fprocdefid from t_wfr_procdef   \n");
        sb.append("\twhere fprocdeftype='BACKGROUNDJOB'   \n");
        sb.append("\tand fname");
        sb.append(local);
        sb.append(" like '");
        sb.append(procName);
        sb.append("')  \n");
        sb.append("\t\t)  \n");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    public String createBackGroundJob(Context ctx, String regularID, String regularName, Date curDate) throws EASBizException, BOSException {
        this.deleteRetireJob(ctx, regularID);
        this.changeJobTriggerStatus(ctx, regularID, "X");
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRRegularBizFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        OperationInfo operation = function.getOperation().get(0);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("regularId", regularID);
        jobContext.put("curDate", MRApplyUtil.formatDate(curDate, "yyyy-MM-dd"));
        String jobProcessDefID = service.createJobProcessDef(this.getProcessName(ctx, regularID, regularName, curDate), function, operation, jobContext, this.getSchedule(curDate), ctx.getLocale());
        return jobProcessDefID;
    }

    private String getProcessName(Context ctx, String regularID, String regularName, Date curDate) {
        return this.getProcessNamePrefix(regularID) + "_" + regularName + "_" + MRMRegularInteval.getTimeStr(curDate);
    }

    private String getProcessNamePrefix(String regularID) {
        return "MRM_" + regularID;
    }

    private int getGenAheadParam(Context ctx) throws BOSException, EASBizException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        IMeetingSetting ims = MeetingSettingFactory.getLocalInstance(ctx);
        MeetingSettingCollection mc = ims.getMeetingSettingCollection("select key, value, type where CU.id = '" + cuId + "' and key = 'aheadDays' ");
        if (mc.size() > 0 && mc.get(0).getValue() != null) {
            return Integer.valueOf(mc.get(0).getValue().toString());
        }
        return 0;
    }

    private void updateModel(Context ctx, MRRegularInfo model) throws BOSException, EASBizException {
        if ("0".equals(model.getRepeatType().getValue())) {
            model.setMonthSetting(null);
            model.setMonWeek_monType(null);
            model.setMonWeek_weekNum(null);
            model.setMonWeek_weekDay(null);
            model.setMonDay_monType(null);
            model.setMonDay_day(null);
        } else if ("0".equals(model.getMonthSetting().getValue())) {
            model.setWeek_weekType(null);
            model.setWeek_weekNum(null);
            model.setMonDay_monType(null);
            model.setMonDay_day(null);
        } else {
            model.setWeek_weekType(null);
            model.setWeek_weekNum(null);
            model.setMonWeek_monType(null);
            model.setMonWeek_weekNum(null);
            model.setMonWeek_weekDay(null);
        }
    }

    private void checkRepeatRule(Context ctx, MRRegularInfo model) throws BOSException, EASBizException {
        if (model.getRepeatType() == null) {
            throw new MRMBaseException(MRMBaseException.MRREGULAR_REPEAT_RULE_NOT_COMPLETE);
        }
        if (model.getRepeatType().getValue().equals("0")) {
            if (model.getWeek_weekType() == null || model.getWeek_weekNum() == null) {
                throw new MRMBaseException(MRMBaseException.MRREGULAR_REPEAT_RULE_NOT_COMPLETE);
            }
        } else {
            if (model.getMonthSetting() == null) {
                throw new MRMBaseException(MRMBaseException.MRREGULAR_REPEAT_RULE_NOT_COMPLETE);
            }
            if (model.getMonthSetting().getValue().equals("0")) {
                if (model.getMonWeek_monType() == null || model.getMonWeek_weekNum() == null || model.getMonWeek_weekDay() == null) {
                    throw new MRMBaseException(MRMBaseException.MRREGULAR_REPEAT_RULE_NOT_COMPLETE);
                }
            } else {
                if (model.getMonDay_monType() == null || model.getMonDay_day() == null) {
                    throw new MRMBaseException(MRMBaseException.MRREGULAR_REPEAT_RULE_NOT_COMPLETE);
                }
                MRMRegularInteval inteval = MRRegularIntevalCenter.getCurInteval(model, new Date());
                if (null == inteval) {
                    throw new MRMBaseException(MRMBaseException.MRREGULAR_REPEAT_RULE_NOT_VALID);
                }
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MRRegularInfo reguInfo = (MRRegularInfo)model;
        this.updateModel(ctx, reguInfo);
        this.checkRepeatRule(ctx, reguInfo);
        if (reguInfo.getMrGenAhead() > this.getGenAheadParam(ctx) + 1) {
            throw new MRMBaseException(MRMBaseException.GENAPP_AHEADTIME_CANNOT_GREATER_PARAM);
        }
        reguInfo.setState(MRRegularStateEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, (IObjectValue)reguInfo);
        this.saveFile(ctx, model, pk);
        if (reguInfo.getMrAppGenType().getValue().equals("0")) {
            this._autoGenMRApply(ctx, reguInfo, new Date(), null);
        }
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        this.saveFile(ctx, model, pk);
        return pk;
    }

    private void saveFile(Context ctx, IObjectValue model, IObjectPK pk) {
        String sql = "select FEntity from T_CP_DocExchange where fid = ? ";
        Object[] obj = new Object[1];
        Blob blob = null;
        InputStream in = null;
        try {
            obj[0] = model.getString("fileName");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])obj);
            if (rows.next() && null != (blob = rows.getBlob(1))) {
                in = blob.getBinaryStream();
            }
            sql = "update T_MRM_MRREGULAR SET FDocEntity = ? WHERE FID = ?";
            PreparedStatement ps = this.getConnection(ctx).prepareStatement(sql);
            logger.info((Object)("Remove DocEntity Size is:" + in.available()));
            ps.setBinaryStream(1, in, in.available());
            ps.setString(2, pk.toString());
            ps.execute();
            in.close();
            sql = "delete T_CP_DocExchange where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _autoGenMRApplyEx(Context ctx, String regularId, String strDate) throws BOSException, EASBizException {
        Date curDate = MRApplyUtil.getDay(MRApplyUtil.parse2Date(strDate, "yyyy-MM-dd"));
        MRRegularInfo reguInfo = this.getRegularInfoById(ctx, regularId);
        if (curDate == null) {
            curDate = new Date();
        }
        Date dt = DateTimeUtils.addDay((Date)curDate, (long)reguInfo.getMrGenAhead());
        MRMRegularInteval inteval = MRRegularIntevalCenter.getCurInteval(reguInfo, dt);
        this._autoGenMRApply(ctx, reguInfo, dt, inteval);
    }
}

