/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRApplyCCCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantCollection;
import com.kingdee.eas.cp.mrm.tools.MsgConstants;
import com.kingdee.eas.cp.mrm.utils.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashSet;
import java.util.Locale;

public class MrmMsgUtil {
    public static String[] getCompereUserId(Context ctx, MRApplyInfo apply) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (apply.getCompere() != null) {
            set.add(apply.getCompere().getId().toString());
        }
        return MrmMsgUtil.getUserIdByPersons(ctx, set);
    }

    public static String[] getRecorderUserId(Context ctx, MRApplyInfo apply) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (apply.getRecorder() != null) {
            set.add(apply.getRecorder().getId().toString());
        }
        return MrmMsgUtil.getUserIdByPersons(ctx, set);
    }

    public static String[] getCommonUserId(Context ctx, MRApplyInfo apply) throws BOSException, EASBizException {
        MRApplyMRApplyCCCollection ccC;
        HashSet<String> set = new HashSet<String>();
        MRApplyMRAttendantCollection attC = apply.getMRAttendant();
        if (attC != null) {
            int size = attC.size();
            for (int i = 0; i < size; ++i) {
                set.add(attC.get(i).getAttendant().getId().toString());
            }
        }
        if ((ccC = apply.getMRApplyCC()) != null) {
            int size = ccC.size();
            for (int i = 0; i < size; ++i) {
                set.add(ccC.get(i).getCc().getId().toString());
            }
        }
        if (apply.getCaller() != null) {
            set.add(apply.getCaller().getId().toString());
        }
        if (apply.getApplier() != null) {
            set.add(apply.getApplier().getId().toString());
        }
        return MrmMsgUtil.getUserIdByPersons(ctx, set);
    }

    public static String[] getUserIdByPersons(Context ctx, HashSet set) throws BOSException, EASBizException {
        if (set.size() == 0) {
            return new String[0];
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() == 0) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        int size = userIds.length;
        for (int i = 0; i < size; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    public static String getCommonMessageTitle(Context ctx, MRApplyInfo apply) {
        String messageStr = ResourceBase.getString((String)MsgConstants.EAS, (String)"common_pass_msg", (Locale)ctx.getLocale());
        messageStr = MrmMsgUtil.doMessageReplace(messageStr, apply);
        return messageStr;
    }

    public static String getCompereMessageTitle(Context ctx, MRApplyInfo apply) {
        String messageStr = ResourceBase.getString((String)MsgConstants.EAS, (String)"compere_pass_msg", (Locale)ctx.getLocale());
        messageStr = MrmMsgUtil.doMessageReplace(messageStr, apply);
        return messageStr;
    }

    public static String getRecordMessageTitle(Context ctx, MRApplyInfo apply) {
        String messageStr = ResourceBase.getString((String)MsgConstants.EAS, (String)"recorder_pass_msg", (Locale)ctx.getLocale());
        messageStr = MrmMsgUtil.doMessageReplace(messageStr, apply);
        return messageStr;
    }

    private static String doMessageReplace(String messageStr, MRApplyInfo apply) {
        String startTime = StringUtil.getTimeStr(apply.getStartTime());
        String address = apply.getAddress().getName();
        String title = apply.getName();
        messageStr = messageStr.replaceFirst("\\{0\\}", startTime);
        messageStr = messageStr.replaceFirst("\\{1\\}", address);
        messageStr = messageStr.replaceFirst("\\{2\\}", title);
        return messageStr;
    }
}

