/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.web.MenuBaseAction;
import com.kingdee.eas.cp.mrm.IMRApply;
import com.kingdee.eas.cp.mrm.IMRSummary;
import com.kingdee.eas.cp.mrm.IMrmSetRowNumber;
import com.kingdee.eas.cp.mrm.MRApplyCollection;
import com.kingdee.eas.cp.mrm.MRApplyFactory;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRSummaryCollection;
import com.kingdee.eas.cp.mrm.MRSummaryFactory;
import com.kingdee.eas.cp.mrm.MRSummaryInfo;
import com.kingdee.eas.cp.mrm.MrmSetRowNumberCollection;
import com.kingdee.eas.cp.mrm.MrmSetRowNumberFactory;
import com.kingdee.eas.cp.mrm.MrmSetRowNumberInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MrmWebUtil {
    public static final int Default_NUM = 8;
    public static final String FID = "sVJWOoKcSs2xi8UwUkefzli0dho=";
    public static final String MRMAPPLY_PERMISSION = "cp_mrm_MRApply_AddNew";
    public static final String MRSUMMARY_PERMISSION = "cp_mrm_MRSummary_AddNew";
    public static final String MRREGULAR_PERMISSION = "cp_mrm_MRRegular_AddNew";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mrm.web.MrmWebUtil");

    public static IRowSet getApplyIRowSet(Context ctx, int count, boolean flag) {
        try {
            EntityViewInfo tempEVI = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            Timestamp currTime = new Timestamp(System.currentTimeMillis());
            filterInfo.getFilterItems().add(new FilterItemInfo("APPLIER.ID", (Object)personInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("caller.id", (Object)personInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("compere.id", (Object)personInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("MRApplyCC.cc.id", (Object)personInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("recorder.id", (Object)personInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("MRAttendant.attendant.id", (Object)personInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(1), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("startTime", (Object)currTime, CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("endTime", (Object)currTime, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("endTime", (Object)currTime, CompareType.GREATER_EQUALS));
            filterInfo.setMaskString("(#0 or #1 or #2 or #3 or #4 or #5) and #6 and ((#7 and #8) or #9 )");
            tempEVI.setFilter(filterInfo);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app", "MRApplyInfoPortalQuery");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            exec.setObjectView(tempEVI);
            IRowSet rowSet = null;
            rowSet = flag ? exec.executeQuery() : exec.executeQuery(0, count);
            return rowSet;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static IRowSet getMrSummary(Context ctx, int count, boolean falg) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        filterInfo.getFilterItems().add(new FilterItemInfo("recorder.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("caller.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("compere.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("MRApplyCC.cc.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("MRAttendant.attendant.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(0), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("recorder.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("caller.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("compere.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("MRApplyCC.cc.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("MRAttendant.attendant.id", (Object)personInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(0), CompareType.NOTEQUALS));
        filterInfo.setMaskString("((#0 or ((#1 or #2 or #3 or #4) and #5)) and #6) or (#7 or ((#8 or #9 or #10 or #11) and #12)) ");
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app", "MRSummaryQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = null;
        rowSet = falg ? exec.executeQuery() : exec.executeQuery(0, count);
        return rowSet;
    }

    public static HashMap getAttendantName(Context ctx, Set ids) throws BOSException {
        if (ids == null || ids.size() < 1) {
            return null;
        }
        HashMap<String, String> hs = new HashMap<String, String>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        IMRApply iMRApply = MRApplyFactory.getLocalInstance(ctx);
        MRApplyCollection mRApplyCollection = iMRApply.getMRApplyCollection(entityViewInfo);
        if (mRApplyCollection != null && mRApplyCollection.size() > 0) {
            for (int i = 0; i < mRApplyCollection.size(); ++i) {
                MRApplyInfo info = mRApplyCollection.get(i);
                if (info == null || info.getMRAttendant() == null || info.getMRAttendant().size() <= 0) continue;
                HashSet<BOSUuid> personSet = new HashSet<BOSUuid>();
                int size = info.getMRAttendant().size();
                for (int k = 0; k < size; ++k) {
                    personSet.add(info.getMRAttendant().get(k).getAttendant().getId());
                }
                if (personSet.size() > 0) {
                    hs.put(info.getId().toString(), MrmWebUtil.getPersonNameByids(ctx, personSet));
                    continue;
                }
                hs.put(info.getId().toString(), "");
            }
        }
        return hs;
    }

    public static HashMap getSummaryAttendantName(Context ctx, Set ids) throws BOSException {
        if (ids == null || ids.size() < 1) {
            return null;
        }
        HashMap<String, String> hs = new HashMap<String, String>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        IMRSummary iMRSummary = MRSummaryFactory.getLocalInstance(ctx);
        MRSummaryCollection mRSummaryCollection = iMRSummary.getMRSummaryCollection(entityViewInfo);
        if (mRSummaryCollection != null && mRSummaryCollection.size() > 0) {
            for (int i = 0; i < mRSummaryCollection.size(); ++i) {
                MRSummaryInfo info = mRSummaryCollection.get(i);
                if (info == null || info.getMRAttendant() == null || info.getMRAttendant().size() <= 0) continue;
                HashSet<BOSUuid> personSet = new HashSet<BOSUuid>();
                int size = info.getMRAttendant().size();
                for (int k = 0; k < size; ++k) {
                    if (info.getMRAttendant().get(k).getAttendant() == null) continue;
                    personSet.add(info.getMRAttendant().get(k).getAttendant().getId());
                }
                if (personSet.size() > 0) {
                    hs.put(info.getId().toString(), MrmWebUtil.getPersonNameByids(ctx, personSet));
                    continue;
                }
                hs.put(info.getId().toString(), "");
            }
        }
        return hs;
    }

    public static String getPersonNameByids(Context ctx, Set set) {
        StringBuffer str = new StringBuffer("");
        String name = "";
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection coll = iperson.getPersonCollection(entityViewInfo);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    PersonInfo info = coll.get(i);
                    str.append(info.getName() + "\uff0c");
                }
                name = str.toString();
                if (name.length() > 1) {
                    name = name.substring(0, name.length() - 1);
                }
            }
        }
        catch (BOSException e) {
            logger.debug((Object)("getPersonNameByids is error: " + e.getMessage()));
        }
        return name;
    }

    public static String forMatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String str = df.format(date);
        return str;
    }

    public static String forMatDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String str = df.format(date);
        return str;
    }

    public static String forMatHoursAndMinutes(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        String str = df.format(date);
        return str;
    }

    public static String getHoursOrMinutes(Time time, int type) {
        if (time == null) {
            return "";
        }
        String str = "";
        if (type == 1) {
            String hours = String.valueOf(time.getHours());
            str = time.getHours() < 10 ? "0" + hours : hours;
        } else {
            String times = String.valueOf(time.getMinutes());
            str = time.getMinutes() < 10 ? "0" + times : times;
        }
        return str;
    }

    public static int[] getRowsNumber(Context ctx) {
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        int[] rows = new int[]{8, 8};
        String sql = " where usePerson.id='" + personInfo.getId().toString() + "'";
        if (MenuBaseAction.isCMAdmin((Context)ctx)) {
            sql = " where id='sVJWOoKcSs2xi8UwUkefzli0dho='";
        }
        MrmSetRowNumberInfo info = null;
        IMrmSetRowNumber imrm = null;
        try {
            imrm = MrmSetRowNumberFactory.getLocalInstance(ctx);
            MrmSetRowNumberCollection coll = imrm.getMrmSetRowNumberCollection(sql);
            if (coll != null && coll.size() > 0) {
                info = coll.get(0);
                rows[0] = info.getMrmRows();
                rows[1] = info.getSummaryRow();
            } else {
                rows = MrmWebUtil.getDefalutRowsNumber(ctx);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rows;
    }

    public static int[] getDefalutRowsNumber(Context ctx) {
        int[] rows = new int[]{8, 8};
        MrmSetRowNumberInfo info = null;
        IMrmSetRowNumber imrm = null;
        try {
            imrm = MrmSetRowNumberFactory.getLocalInstance(ctx);
            MrmSetRowNumberCollection coll = imrm.getMrmSetRowNumberCollection(" where id='sVJWOoKcSs2xi8UwUkefzli0dho='");
            if (coll != null && coll.size() > 0) {
                info = coll.get(0);
                rows[0] = info.getMrmRows();
                rows[1] = info.getSummaryRow();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rows;
    }

    public static int setWordsLen(int divWidth) {
        int wordsLen = 6;
        if (divWidth - 110 - 80 - 80 - 60 > 0) {
            wordsLen = (divWidth - 110 - 80 - 80 - 60) / 20;
        }
        return wordsLen;
    }

    public static void checkPermission(Context ctx, String permissionItem) throws BOSException, EASBizException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (cuId == null || StringUtils.isEmpty((String)permissionItem)) {
            return;
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(cuId);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, (IObjectPK)orgPK, permissionItem);
    }

    public static boolean isHasPermission(Context ctx, String permissionItem) {
        try {
            MrmWebUtil.checkPermission(ctx, permissionItem);
        }
        catch (PermissionServiceException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.mrm.webMrmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (PermItemException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.mrm.webMrmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (PermissionException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.mrm.webMrmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.mrm.webMrmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.debug((Object)("com.kingdee.eas.cp.mrm.webMrmWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public static String trim(String str, int specialCharsLength) {
        if (str == null || "".equals(str) || specialCharsLength < 1) {
            return "";
        }
        char[] chars = str.toCharArray();
        int charsLength = MrmWebUtil.getCharsLength(chars, specialCharsLength);
        return new String(chars, 0, charsLength);
    }

    public static int getCharsLength(char[] chars, int specialCharsLength) {
        int specialCharLength;
        int count = 0;
        int normalCharsLength = 0;
        for (int i = 0; i < chars.length && count <= specialCharsLength - (specialCharLength = MrmWebUtil.getSpecialCharLength(chars[i])); ++i) {
            count += specialCharLength;
            ++normalCharsLength;
        }
        return normalCharsLength;
    }

    private static int getSpecialCharLength(char c) {
        if (MrmWebUtil.isLetter(c)) {
            return 1;
        }
        return 2;
    }

    public static int getCharLength(char[] chars) {
        int length = 0;
        if (chars == null) {
            return length;
        }
        for (int i = 0; i < chars.length; ++i) {
            length += MrmWebUtil.getSpecialCharLength(chars[i]);
        }
        return length;
    }

    private static boolean isLetter(char c) {
        int k = 128;
        return c / k == 0;
    }
}

