/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.odm.CodingHistoryCollection;
import com.kingdee.eas.cp.odm.CodingHistoryFactory;
import com.kingdee.eas.cp.odm.CodingHistoryInfo;
import com.kingdee.eas.cp.odm.FileWordsInfo;
import com.kingdee.eas.cp.odm.ICodingHistory;
import com.kingdee.eas.cp.odm.IReservedNo;
import com.kingdee.eas.cp.odm.ODMNumberStatusEnum;
import com.kingdee.eas.cp.odm.OfficialDocumentNoCollection;
import com.kingdee.eas.cp.odm.OfficialDocumentNoFactory;
import com.kingdee.eas.cp.odm.OfficialDocumentNoInfo;
import com.kingdee.eas.cp.odm.ReservedNoCollection;
import com.kingdee.eas.cp.odm.ReservedNoEntryCollection;
import com.kingdee.eas.cp.odm.ReservedNoEntryInfo;
import com.kingdee.eas.cp.odm.ReservedNoFactory;
import com.kingdee.eas.cp.odm.ReservedNoInfo;
import com.kingdee.eas.cp.odm.app.AbstractCodingHistoryControllerBean;
import com.kingdee.eas.cp.odm.util.OdmUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class CodingHistoryControllerBean
extends AbstractCodingHistoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.odm.app.CodingHistoryControllerBean");

    @Override
    protected IObjectPK _addCodingHistoryBook(Context ctx, String odmTemplateID, String odmID, String odmNumber, String odmSubject, String formId) throws BOSException {
        CodingHistoryInfo codingHistoryInfo = new CodingHistoryInfo();
        codingHistoryInfo.setOdmTemplateID(odmTemplateID);
        codingHistoryInfo.setOdmID(odmID);
        codingHistoryInfo.setOdmNumber(odmNumber);
        codingHistoryInfo.setOdmSubject(odmSubject);
        codingHistoryInfo.setCodingDate(new Date());
        codingHistoryInfo.setFormid(formId);
        codingHistoryInfo.setOdmNumberStatus(ODMNumberStatusEnum.Book);
        IObjectPK pk = null;
        try {
            pk = this._save(ctx, (IObjectValue)codingHistoryInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return pk;
    }

    @Override
    protected void _setCodingHistoryUsed(Context ctx, String odmTemplateID, String odmID) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo item = null;
        item = new FilterItemInfo("odmTemplateID", (Object)odmTemplateID, CompareType.EQUALS);
        itemCollection.add(item);
        item = new FilterItemInfo("odmID", (Object)odmID, CompareType.EQUALS);
        itemCollection.add(item);
        entityViewInfo.setFilter(filterInfo);
        CodingHistoryCollection codingHistoryCollection = this.getCodingHistoryCollection(ctx, entityViewInfo);
        if (codingHistoryCollection != null && codingHistoryCollection.size() > 0) {
            for (int i = 0; i < codingHistoryCollection.size(); ++i) {
                CodingHistoryInfo codingHistoryInfo = codingHistoryCollection.get(i);
                if (codingHistoryInfo == null || codingHistoryInfo.getId() == null) continue;
                ObjectUuidPK pk = new ObjectUuidPK(codingHistoryInfo.getId().toString());
                codingHistoryInfo.setOdmNumberStatus(ODMNumberStatusEnum.Used);
                try {
                    this._update(ctx, (IObjectPK)pk, (IObjectValue)codingHistoryInfo);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected boolean _existsCodingHistory(Context ctx, String docNum, String createrCUID) throws BOSException {
        try {
            boolean flag = false;
            Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            ICodingHistory iCodingHistory = CodingHistoryFactory.getLocalInstance(ctx);
            flag = iCodingHistory.exists(" where odmNumber='" + docNum + "' and cu.id='" + createrCUID + "'");
            ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
            logger.info((Object)("CodingHistoryControllerBean _existsCodingHistory cuId = '" + createrCUID + "'"));
            return flag;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void recoverCodingHistory(Context ctx, String odmId) throws BOSException {
        this._recoverCodingHistory(ctx, odmId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _recoverCodingHistory(Context ctx, String odmId) throws BOSException {
        ICodingHistory iCodingHistory = CodingHistoryFactory.getLocalInstance(ctx);
        CodingHistoryCollection coll = iCodingHistory.getCodingHistoryCollection(" where odmID='" + odmId + "'");
        if (coll != null && coll.size() > 0) {
            CodingHistoryInfo info = coll.get(0);
            if (info.getFileWordsID() == null || info.getFileWordsID().getId() == null || info.getOfficialID() == null || info.getOfficialID().getId() == null) {
                return;
            }
            Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            try {
                this.recoverNum(ctx, info.getFileWordsID().getId().toString(), info.getOfficialID().getId().toString(), info.getOfficialNo());
                this._delete(ctx, " where odmID='" + odmId + "'");
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            finally {
                ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
            }
        }
    }

    private void recoverNum(Context ctx, String fileWordsId, String officicalNoId, String no) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fileWordsId) || StringUtils.isEmpty((String)officicalNoId)) {
            return;
        }
        StringBuffer whereSql = new StringBuffer(" where fileWords.id='" + fileWordsId + "' ");
        whereSql.append(" and officialDocumentNo.id='" + officicalNoId + "'");
        IReservedNo iReservedNo = ReservedNoFactory.getLocalInstance(ctx);
        ReservedNoCollection coll = iReservedNo.getReservedNoCollection(whereSql.toString());
        if (coll != null && coll.size() > 0) {
            ReservedNoInfo info = coll.get(0);
            ReservedNoEntryCollection entryColl = info.getEntrys();
            boolean isExist = false;
            if (entryColl != null && entryColl.size() > 0) {
                StringBuffer str = new StringBuffer("");
                for (int i = 0; i < entryColl.size(); ++i) {
                    ReservedNoEntryInfo info2 = entryColl.get(i);
                    if (info2.getReservedNumber().equals(no)) {
                        info2.setIsUsed(ODMNumberStatusEnum.NoUsed);
                        isExist = true;
                    }
                    str.append(info2.getReservedNumber() + ";");
                    info.getEntrys().add(info2);
                }
                String[] str2 = str.toString().split(";");
                info.setReservedNumberStr(OdmUtil.strArrayToLenStr(str2, 255));
            }
            if (!isExist) {
                ReservedNoEntryInfo entryInfo = new ReservedNoEntryInfo();
                entryInfo.setParent(info);
                entryInfo.setReservedNumber(no);
                entryInfo.setIsUsed(ODMNumberStatusEnum.NoUsed);
                String str = info.getReservedNumberStr() + ";" + no;
                String[] str2 = str.toString().split(";");
                info.setReservedNumberStr(OdmUtil.strArrayToLenStr(str2, 255));
                info.getEntrys().add(entryInfo);
            }
            iReservedNo.save((CoreBaseInfo)info);
        } else {
            ReservedNoInfo info = new ReservedNoInfo();
            FileWordsInfo fileWordsInfo = new FileWordsInfo();
            fileWordsInfo.setId(BOSUuid.read((String)fileWordsId));
            OfficialDocumentNoInfo officialDocumentNoInfo = new OfficialDocumentNoInfo();
            officialDocumentNoInfo.setId(BOSUuid.read((String)officicalNoId));
            info.setId(BOSUuid.create((String)"F00B3588"));
            info.setFileWords(fileWordsInfo);
            info.setOfficialDocumentNo(officialDocumentNoInfo);
            info.setRulesName(this.getRulesName(ctx, officicalNoId));
            info.setReservedNumberStr(no);
            ReservedNoEntryInfo entryInfo = new ReservedNoEntryInfo();
            entryInfo.setParent(info);
            entryInfo.setReservedNumber(no);
            entryInfo.setIsUsed(ODMNumberStatusEnum.NoUsed);
            info.getEntrys().add(entryInfo);
            iReservedNo.addnew((CoreBaseInfo)info);
        }
    }

    private String getRulesName(Context ctx, String officicalNoId) throws BOSException {
        String rulesName = "";
        OfficialDocumentNoCollection coll = OfficialDocumentNoFactory.getLocalInstance(ctx).getOfficialDocumentNoCollection(" where id='" + officicalNoId + "'");
        rulesName = coll != null && coll.size() > 0 ? coll.get(0).getOdNOName() : CodingHistoryControllerBean.covertToSimpleDate(new Date());
        return rulesName;
    }

    private static String covertToSimpleDate(Date date) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        return f.format(date);
    }
}

