/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.odm.CollectionDocumentCollection;
import com.kingdee.eas.cp.odm.CollectionDocumentFactory;
import com.kingdee.eas.cp.odm.CollectionDocumentInfo;
import com.kingdee.eas.cp.odm.ICollectionDocument;
import com.kingdee.eas.cp.odm.app.AbstractCollectionDocumentControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class CollectionDocumentControllerBean
extends AbstractCollectionDocumentControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.odm.app.CollectionDocumentControllerBean");

    @Override
    protected boolean _saveCollectonDocument(Context ctx, String sourcePK, String parentFormId) throws BOSException {
        boolean flag = false;
        if (StringUtils.isEmpty((String)sourcePK) || StringUtils.isEmpty((String)parentFormId)) {
            return flag;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String personId = userInfo.getPerson() != null && userInfo.getPerson().getId() != null ? userInfo.getPerson().getId().toString() : null;
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("soucePK", (Object)sourcePK, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("favoritesPerson.id", (Object)personId, CompareType.EQUALS));
            evi.setFilter(filter);
            ICollectionDocument iCollectionDocument = CollectionDocumentFactory.getLocalInstance(ctx);
            CollectionDocumentCollection coll = iCollectionDocument.getCollectionDocumentCollection(evi);
            if (StringUtils.isEmpty((String)personId) || coll == null || coll.size() < 1) {
                SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHHmmss");
                CollectionDocumentInfo info = new CollectionDocumentInfo();
                info.setNumber(f.format(new Date()));
                info.setSoucePK(sourcePK);
                info.setFavoritesTime(new Timestamp(new Date().getTime()));
                info.setFavoritesPerson(userInfo.getPerson());
                info.setParentFormId(parentFormId);
                this._save(ctx, (IObjectValue)info);
            } else {
                CollectionDocumentInfo collInfo = coll.get(0);
                collInfo.setFavoritesTime(new Timestamp(new Date().getTime()));
                this._save(ctx, (IObjectValue)collInfo);
            }
            flag = true;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return flag;
    }
}

