/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;

public class RedHeadEditPlugin
extends AbstractBillPlugin {
    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if ("Save".equalsIgnoreCase(operation.getOperation())) {
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()).getId());
            this.application.setValue("FLoginCU", (Object)cu, 0);
        }
        return super.beforeOperation(operation);
    }

    public void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
        this.setOfficeDoc();
    }

    private void setOfficeDoc() {
        try {
            if (this.isAddNew()) {
                JSONObject jsOffice = new JSONObject();
                jsOffice.put("noTemplate", (Object)Boolean.TRUE);
                this.application.setControlProperty("FredHeadOffice", "templateAttachment", (Object)jsOffice);
            }
            if (this.isAddNew() || this.isEdit()) {
                JSONObject officeSetting = new JSONObject();
                officeSetting.put("docEditable", (Object)new Boolean(true));
                officeSetting.put("noCopy", (Object)new Boolean(false));
                this.application.setControlProperty("FredHeadOffice", "officeSetting", (Object)officeSetting);
            }
            JSONArray disabledButtons = new JSONArray();
            disabledButtons.put((Object)"mnuSave").put((Object)"ShowTrace").put((Object)"AcceptRevision").put((Object)"ViewHistory").put((Object)"RedHead").put((Object)"SignByHand").put((Object)"ElectroSignBill");
            this.application.setControlProperty("FredHeadOffice", "disabledButtons", (Object)disabledButtons);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private boolean isAddNew() {
        return OperationStatus.ADDNEW.equals(this.application.getBillView().getOperationStatus());
    }

    private boolean isEdit() {
        return OperationStatus.EDIT.equals(this.application.getBillView().getOperationStatus());
    }
}

