/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.service;

import com.kingdee.bos.spi.SPInfo;
import com.kingdee.util.ConfigurationException;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PublishObserverManager {
    public static final String PROPERTIES_DIR_ENV_NAME = "eas.properties.dir";
    public static final String CLIENTROOT_DIR_ENV_NAME = "easclient.root";
    public static final String CONFIG_FILE_NAME = "ServiceProviderImpl.xml";
    private static final Logger logger = Logger.getLogger(PublishObserverManager.class);
    protected static PublishObserverManager instance = new PublishObserverManager();
    private XMLConfiguration config;
    private boolean configError;

    protected PublishObserverManager() {
    }

    public static PublishObserverManager getInstance() {
        return instance;
    }

    public static String getConfigFilePath() {
        String configPath = PublishObserverManager.runtimeIsClient() ? System.getProperty(CLIENTROOT_DIR_ENV_NAME) : System.getProperty(PROPERTIES_DIR_ENV_NAME);
        File configFile = new File(configPath, CONFIG_FILE_NAME);
        return configFile.getAbsolutePath();
    }

    public List<SPInfo> getSeviceProvider() {
        this.lazyInit();
        if (this.configError) {
            return null;
        }
        List list = this.config.getConfigItem("SPImplList").getChild("OdmContentPublishObserver").getAllChildren();
        if (list == null) {
            return null;
        }
        return this.loadSPinfo(list);
    }

    public static boolean isSPInstalled() {
        List<SPInfo> list = PublishObserverManager.getInstance().getSeviceProvider();
        return list != null;
    }

    private synchronized void lazyInit() {
        if (this.config != null) {
            return;
        }
        boolean loadSuccess = false;
        try {
            loadSuccess = this.loadConfig();
        }
        catch (ConfigurationException e) {
            logger.error((Object)"cannot load ServiceProviderImpl.xml", (Throwable)e);
        }
        if (!loadSuccess) {
            logger.error((Object)("ServiceProviderConfig init error, " + PublishObserverManager.getConfigFilePath() + " cannot found"));
            this.configError = true;
        }
    }

    protected void reload() {
        this.config = null;
        this.lazyInit();
    }

    protected boolean loadConfig() throws ConfigurationException {
        String configPath = PublishObserverManager.runtimeIsClient() ? System.getProperty(CLIENTROOT_DIR_ENV_NAME) : System.getProperty(PROPERTIES_DIR_ENV_NAME);
        File configFile = new File(configPath, CONFIG_FILE_NAME);
        if (configFile.isFile() && configFile.canWrite()) {
            this.config = XMLConfiguration.getInstance((File)configFile);
            return true;
        }
        return false;
    }

    private List<SPInfo> loadSPinfo(List<?> listConfig) {
        ArrayList<SPInfo> list = null;
        for (ConfigurationItem item : listConfig) {
            String serviceName = item.getName();
            Map attributes = item.getProperties();
            SPInfo spinfo = new SPInfo(serviceName, attributes);
            this.LoadProviderClass(spinfo);
            if (spinfo.getProviderClass() == null) continue;
            if (list == null) {
                list = new ArrayList<SPInfo>();
            }
            list.add(spinfo);
        }
        return list;
    }

    private void LoadProviderClass(SPInfo spinfo) {
        String className = spinfo.getProviderClassName();
        Class<?> clazz = null;
        if (className != null) {
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                logger.error((Object)("cannot load serviceProvider Class " + className), (Throwable)e);
                e.printStackTrace();
            }
        }
        if (clazz != null) {
            spinfo.setProviderClass(clazz);
        } else {
            logger.error((Object)("cannot load serviceProvider Class for service " + spinfo.getServiceName()));
        }
    }

    private static boolean runtimeIsClient() {
        return System.getProperty(CLIENTROOT_DIR_ENV_NAME) != null;
    }
}

