/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.extend.attachment.AttachmentCollection;
import com.kingdee.eas.base.form.extend.attachment.AttachmentFactory;
import com.kingdee.eas.base.form.extend.attachment.AttachmentInfo;
import com.kingdee.eas.base.form.extend.attachment.AttachmentTypeEnum;
import com.kingdee.eas.base.form.extend.attachment.IAttachment;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoCollection;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoInfo;
import com.kingdee.eas.base.form.extend.flow.IDocumentInfo;
import com.kingdee.eas.base.form.extend.flow.ITemplate;
import com.kingdee.eas.base.form.extend.flow.TemplateCollection;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.extend.flow.TemplateWorkFlowCollection;
import com.kingdee.eas.base.form.extend.flow.WorkflowStatus;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.mc.web.WfWafUtil;
import com.kingdee.eas.cp.odm.BillStatusEnum;
import com.kingdee.eas.cp.odm.FileCenterRecordFactory;
import com.kingdee.eas.cp.odm.FileCenterRecordInfo;
import com.kingdee.eas.cp.odm.FileWordsInfo;
import com.kingdee.eas.cp.odm.IFileCenterRecord;
import com.kingdee.eas.cp.odm.IReceiveAdmin;
import com.kingdee.eas.cp.odm.IReceivePerson;
import com.kingdee.eas.cp.odm.IReceiveRole;
import com.kingdee.eas.cp.odm.IReleasePortlet;
import com.kingdee.eas.cp.odm.IsDownLoadEnum;
import com.kingdee.eas.cp.odm.IsReadEnum;
import com.kingdee.eas.cp.odm.LatestPRSFactory;
import com.kingdee.eas.cp.odm.LatestPRSInfo;
import com.kingdee.eas.cp.odm.OfficialDocumentNoInfo;
import com.kingdee.eas.cp.odm.ReceiveAdminFactory;
import com.kingdee.eas.cp.odm.ReceiveAdminInfo;
import com.kingdee.eas.cp.odm.ReceivePersonFactory;
import com.kingdee.eas.cp.odm.ReceivePersonInfo;
import com.kingdee.eas.cp.odm.ReceiveRoleFactory;
import com.kingdee.eas.cp.odm.ReceiveRoleInfo;
import com.kingdee.eas.cp.odm.ReleasePortletFactory;
import com.kingdee.eas.cp.odm.ReleasePortletInfo;
import com.kingdee.eas.cp.odm.ReservedNoCollection;
import com.kingdee.eas.cp.odm.ReservedNoEntryFactory;
import com.kingdee.eas.cp.odm.ReservedNoEntryInfo;
import com.kingdee.eas.cp.odm.ReservedNoFactory;
import com.kingdee.eas.cp.odm.ReservedNoInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.log4j.Logger;

public class OdmUtil {
    public static final String DOCRECEIVE_TEMPLATEID = "tqAoxLV0TguihBZ6eqU8bZp+rpI=";
    public static final String DOCDISPATCH_TEMPLATEID = "C/T4g3UCStmKrMRuH4ErO5p+rpI=";
    public static final String ODMFILECENTER_TEMPLATEID = "qL9kls2EQg+JsjtX1FYbKZp+rpI=";
    public static final String ATTACHMENT_FORMID = "5QaE3qg8RO2/SIe+AB/IaJp+rpI=";
    public static final String POSITION_NAME = "\u673a\u8981\u5458";
    public static final String HUI_QIAN = "\u4f1a\u7b7e";
    public static final String QIAN_FA = "\u7b7e\u53d1";
    public static final String ODM_RESOURCE = "com.kingdee.eas.cp.odm.OdmResource";
    public static final String MULTIAPPROVE_QUERY = "com.kingdee.eas.base.multiapprove.app.MultiApproveQuery";
    public static final String PORTLET_MSG_QUERY = "com.kingdee.eas.cp.odm.app.PortletReceiveMsgQuery";
    public static final String PORTLET_MSG2_QUERY = "com.kingdee.eas.cp.odm.app.PortletReceiveMsg2Query";
    public static final String PERSONANDPOSITIONMEMBER_Query = "com.kingdee.eas.cp.odm.app.PerosnAndPositionMemberQuery";
    public static final String NOT_SAVED_ATTACHEMNT_CTRL_KEY = "NOT_SAVED_ATTACHEMNT_CTRL_KEY";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.odm.util.OdmUtil");

    public static AttachmentInfo getAttachmentById(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        AttachmentInfo attachment = null;
        String oql = "select id,controlKey,hasAcceptRevision where id='" + id + "'";
        AttachmentCollection coll = iAttachment.getAttachmentCollection(oql);
        if (coll != null && coll.size() > 0) {
            attachment = coll.get(0);
        }
        return attachment;
    }

    public static AttachmentInfo newAttachment(Context ctx, String contentId, String billId, String billName) throws EASBizException, BOSException {
        return OdmUtil.newAttachment(ctx, contentId, billId, billName, null);
    }

    public static AttachmentInfo newAttachment(Context ctx, String contentId, String billId, String billName, String flowTempId) throws EASBizException, BOSException {
        int dotIndex;
        AttachmentInfo attachment = null;
        attachment = new AttachmentInfo();
        if (!StringUtil.isEmpty((String)billId) && !"null".equals(billId)) {
            attachment.setBillId(BOSUuid.read((String)billId));
        } else {
            attachment.setBillId(BOSUuid.create((String)"40E7BFAC"));
        }
        if (!StringUtil.isEmpty((String)contentId)) {
            attachment.setId(BOSUuid.read((String)contentId));
        }
        if ((dotIndex = (billName = StringUtil.isEmpty((String)billName) ? "\u516c\u6587\u6b63\u6587" : billName).lastIndexOf(46)) < 0) {
            attachment.setName(billName);
        } else {
            attachment.setName(billName.substring(0, dotIndex));
            attachment.setExtName(billName.substring(dotIndex + 1));
        }
        attachment.setNumber(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
        attachment.setControlKey("Foffice".toUpperCase());
        attachment.setAttachmentType(AttachmentTypeEnum.office);
        attachment.setControlKey(NOT_SAVED_ATTACHEMNT_CTRL_KEY + attachment.getControlKey());
        byte[] fileData = OdmUtil.getDefaultWordDoc(ctx, flowTempId);
        attachment.setFileData(fileData);
        attachment.setSizeInByte(fileData.length);
        attachment.setSize(StringUtil4File.getFileSizeRepresentation((long)fileData.length, (Context)ctx));
        attachment.setExtName("doc");
        attachment.setDescription("\u7535\u5b50\u516c\u6587\u6b63\u6587\u5185\u5bb9");
        AttachmentFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)attachment);
        return attachment;
    }

    private static byte[] getDefaultWordDoc(Context ctx, String flowTempId) {
        if (StringUtils.isEmpty((String)flowTempId)) {
            return OdmUtil.getEmptyWordDoc();
        }
        AttachmentInfo ai = null;
        try {
            ai = OdmUtil.getOfficeDocTemplate(ctx, flowTempId);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return ai == null ? OdmUtil.getEmptyWordDoc() : ai.getFileData();
    }

    private static AttachmentInfo getOfficeDocTemplate(Context ctx, String flowTempId) throws BOSException {
        IAttachment facade = AttachmentFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)flowTempId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlKey", (Object)"FOFFICETEMPLATE", CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("creator.id"));
        evi.setSelector(selector);
        AttachmentCollection attachs = facade.getAttachmentCollection(evi);
        AttachmentInfo attachment = null;
        if (attachs != null && attachs.size() > 0) {
            attachment = attachs.get(0);
        }
        return attachment;
    }

    public static void deleteNotSavedAttachment(Context ctx) throws BOSException, EASBizException {
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("controlKey", (Object)"NOT_SAVED_ATTACHEMNT_CTRL_KEY%", CompareType.LIKE);
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        Date d = c.getTime();
        FilterItemInfo filterItem2 = new FilterItemInfo("createTime", (Object)d, CompareType.LESS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem2);
        iAttachment.delete(filter);
    }

    public static byte[] getEmptyWordDoc() {
        byte[] bytes = new byte[]{0, 1, 127};
        String emptyDocPath = "/server/deploy/easweb.ear/eas_web.war/cp/odm/emptyDoc.doc";
        String eas_home = System.getProperty("EAS_HOME");
        emptyDocPath = eas_home + emptyDocPath;
        System.out.println("************************* cp.odm.util.OdmUtil SystemPath:" + emptyDocPath + "********************************");
        File wordDoc = new File(emptyDocPath);
        if (wordDoc.exists()) {
            try {
                FileInputStream fis = new FileInputStream(wordDoc);
                bytes = new byte[fis.available()];
                fis.read(bytes);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    public static String[] getUserIds(Context ctx, String personid) throws BOSException, EASBizException {
        UserCollection uc = OdmUtil.getUserCollection(ctx, personid);
        if (uc == null) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    public static Set getUserIdsSet(Context ctx, String personid) throws BOSException, EASBizException {
        UserCollection uc = OdmUtil.getUserCollection(ctx, personid);
        HashSet<String> set = new HashSet<String>();
        if (uc == null) {
            return set;
        }
        for (int i = 0; i < uc.size(); ++i) {
            set.add(uc.get(i).getId().toString());
        }
        return set;
    }

    private static UserCollection getUserCollection(Context ctx, String personid) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personid)) {
            return null;
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personid, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        return uc;
    }

    public static void setWorkflowStatusFinished(String billId) throws BOSException {
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
        service2.abortProcessByHoldedObjectId(billId);
    }

    public static void setWorkflowStatusIsAbandon(Context ctx, String documentId, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)documentId)) {
            return;
        }
        String sql = "UPDATE t_bas_documentinfo SET FWorkflowStatus=6 WHERE Fid='" + documentId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        OdmUtil.updateObjectWorkStatus(ctx, billId, 6);
    }

    public static String getMultiApproveMsg(String billId, String actedfName) throws BOSException, SQLException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MultiApprove.billId", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("AssignDetail.actdefName", (Object)("%" + actedfName + "%"), CompareType.LIKE));
        evi.setFilter(filter);
        MetaDataPK query = new MetaDataPK(MULTIAPPROVE_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)query);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        StringBuffer str = new StringBuffer("");
        if (rowSet != null) {
            while (rowSet.next()) {
                String msg = rowSet.getString("MULTIAPPROVE.OPINION");
                String person = rowSet.getString("PERSONID.NAME");
                String time = rowSet.getString("MULTIAPPROVE.CREATETIME");
                if (time != null && time.length() > 10) {
                    time = time.substring(0, 10);
                }
                str.append(msg + "  " + person + "  " + time + "\uff1b");
            }
        }
        return str.toString();
    }

    public static void saveToPortlet2(Context ctx, Map hasMap) throws EASBizException, BOSException {
        if (hasMap == null || hasMap.size() < 1) {
            return;
        }
        String billId = hasMap.get("billId").toString();
        String billName = hasMap.get("billName").toString();
        String formid = hasMap.get("formid").toString();
        boolean isPushAllPerson = (Boolean)hasMap.get("isPushAllPerson");
        Date startDate = (Date)hasMap.get("startDate");
        Date endDate = (Date)hasMap.get("endDate");
        AdminOrgUnitInfo dispatchUnit = (AdminOrgUnitInfo)hasMap.get("dispatchUnit");
        boolean toDesktop = (Boolean)hasMap.get("toDesktop");
        boolean toXTtop = (Boolean)hasMap.get("toXTtop");
        PersonCollection personColl = (PersonCollection)hasMap.get("personColl");
        List roleList = (List)hasMap.get("roleList");
        List adminList = (List)hasMap.get("adminList");
        String portletBillId = OdmUtil.saveReasePortletInfo(ctx, billId, billName, formid, startDate, endDate, dispatchUnit, toDesktop, toXTtop, isPushAllPerson);
        if (!StringUtil.isEmpty((String)portletBillId)) {
            OdmUtil.saverReceiverMsg(ctx, portletBillId, personColl);
            OdmUtil.saverReceiveRole(ctx, portletBillId, roleList);
            OdmUtil.saverReceiveAdmin(ctx, portletBillId, adminList);
        }
    }

    public static void saveToPortlet(PersonCollection personColl, String billId, String billName, String formid, Date startDate, Date endDate, AdminOrgUnitInfo dispatchUnit) throws EASBizException, BOSException {
        String portletBillId = OdmUtil.saveReasePortletInfo(billId, billName, formid, startDate, endDate, dispatchUnit);
        if (!StringUtil.isEmpty((String)portletBillId)) {
            OdmUtil.saverReceiverMsg(portletBillId, personColl);
        }
    }

    private static String saveReasePortletInfo(String billId, String billName, String formid, Date startDate, Date endDate, AdminOrgUnitInfo dispatchUnit) throws BOSException, EASBizException {
        String pk = OdmUtil.saveReasePortletInfo(null, billId, billName, formid, startDate, endDate, dispatchUnit, false, false, false);
        return pk;
    }

    private static String saveReasePortletInfo(Context ctx, String billId, String billName, String formid, Date startDate, Date endDate, AdminOrgUnitInfo dispatchUnit) throws BOSException, EASBizException {
        String pk = OdmUtil.saveReasePortletInfo(ctx, billId, billName, formid, startDate, endDate, dispatchUnit, false, false, false);
        return pk;
    }

    private static String saveReasePortletInfo(Context ctx, String billId, String billName, String formid, Date startDate, Date endDate, AdminOrgUnitInfo dispatchUnit, boolean toDesktop, boolean toXTtop, boolean isPushAllPerson) throws BOSException, EASBizException {
        ReleasePortletInfo info = new ReleasePortletInfo();
        info.setBillId(billId);
        info.setBillName(billName);
        info.setFormId(formid);
        info.setStartDate(startDate);
        info.setEndDate(endDate);
        info.setDispatchUnit(dispatchUnit);
        info.setPublishToDesktop(toDesktop);
        info.setPublishToXTtop(toXTtop);
        info.setIsConvert(false);
        info.setIsPushAllPerson(isPushAllPerson);
        IReleasePortlet iReleasePortlet = null;
        iReleasePortlet = ctx == null ? ReleasePortletFactory.getRemoteInstance() : ReleasePortletFactory.getLocalInstance(ctx);
        IObjectPK pk = iReleasePortlet.save((CoreBaseInfo)info);
        return String.valueOf(pk);
    }

    private static void saverReceiveRole(Context ctx, String portletBillId, List<RoleInfo> roleList) throws BOSException, EASBizException {
        if (roleList == null || roleList.size() < 1) {
            return;
        }
        IReceiveRole ireceiveRole = ReceiveRoleFactory.getLocalInstance(ctx);
        CoreBaseCollection coll = new CoreBaseCollection();
        int count = roleList.size();
        for (int i = 0; i < count; ++i) {
            ReceiveRoleInfo receiveRoleInfo = new ReceiveRoleInfo();
            receiveRoleInfo.setPortletId(portletBillId);
            receiveRoleInfo.setRoleId(roleList.get(i).getId().toString());
            coll.add((CoreBaseInfo)receiveRoleInfo);
        }
        ireceiveRole.save(coll);
    }

    private static void saverReceiveAdmin(Context ctx, String portletBillId, List<AdminOrgUnitInfo> adminList) throws BOSException, EASBizException {
        if (adminList == null || adminList.size() < 1) {
            return;
        }
        IReceiveAdmin iReceiveAdmin = ReceiveAdminFactory.getLocalInstance(ctx);
        CoreBaseCollection coll = new CoreBaseCollection();
        int count = adminList.size();
        for (int i = 0; i < count; ++i) {
            ReceiveAdminInfo receiveAdminInfo = new ReceiveAdminInfo();
            receiveAdminInfo.setPortletId(portletBillId);
            receiveAdminInfo.setAdminOrgId(adminList.get(i));
            coll.add((CoreBaseInfo)receiveAdminInfo);
        }
        iReceiveAdmin.save(coll);
    }

    private static void saverReceiverMsg(String billId, PersonCollection personColl) throws BOSException, EASBizException {
        if (personColl == null || personColl.size() < 1) {
            return;
        }
        CoreBaseCollection coll = new CoreBaseCollection();
        IReceivePerson iReceivePerson = ReceivePersonFactory.getRemoteInstance();
        for (int i = 0; i < personColl.size(); ++i) {
            ReceivePersonInfo info = new ReceivePersonInfo();
            info.setPortletId(billId);
            info.setIsRead(IsReadEnum.UNREADED);
            info.setReceiver(personColl.get(i));
            coll.add((CoreBaseInfo)info);
        }
        iReceivePerson.save(coll);
    }

    private static void saverReceiverMsg(Context ctx, String billId, PersonCollection personColl) throws BOSException, EASBizException {
        if (personColl == null || personColl.size() < 1) {
            return;
        }
        CoreBaseCollection coll = new CoreBaseCollection();
        IReceivePerson iReceivePerson = ReceivePersonFactory.getLocalInstance(ctx);
        for (int i = 0; i < personColl.size(); ++i) {
            ReceivePersonInfo info = new ReceivePersonInfo();
            info.setPortletId(billId);
            info.setIsRead(IsReadEnum.UNREADED);
            info.setReceiver(personColl.get(i));
            coll.add((CoreBaseInfo)info);
        }
        iReceivePerson.save(coll);
    }

    public static IRowSet getPortletMsg(Context ctx) throws BOSException, SQLException {
        PersonInfo info = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Timestamp now = new Timestamp(new Date().getTime());
        filter.getFilterItems().add(new FilterItemInfo("ReleasePortlet.endDate", (Object)now, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("receiver.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("DocumentInfo.workflowStatus", (Object)new Integer(2), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("DocumentInfo.workflowStatus", (Object)new Integer(4), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        evi.setFilter(filter);
        MetaDataPK query = new MetaDataPK(PORTLET_MSG_QUERY);
        IQueryExecutor exec = null;
        exec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)query) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static IRowSet getPortletMsg2(Context ctx) throws BOSException, SQLException {
        PersonInfo info = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        AdminOrgUnitInfo adminOrgUnitInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
        if (adminOrgUnitInfo == null) {
            return null;
        }
        Timestamp now = new Timestamp(new Date().getTime());
        String roleIds = OdmUtil.getCurrentAllRoleIdsStr(ctx);
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        int showRows = 5;
        CoreBaseCollection infos = LatestPRSFactory.getLocalInstance(ctx).getCollection("select id, Rows where CU.id='" + cu.getId().toString() + "' order by createTime desc");
        if (null != infos && infos.size() > 0) {
            showRows = ((LatestPRSInfo)infos.get(0)).getRows();
        }
        ctx.put((Object)"disablePermissionForKScript", disablePermissionForKScript);
        StringBuffer sql = new StringBuffer("SELECT DISTINCT TOP " + showRows + " ALLTABLE.* FROM (");
        sql.append(" SELECT DISTINCT B.FID AS id,B.CFBillId AS billId,B.CFBillName AS billName,B.CFFormId AS formId,B.FCreateTime AS createTime,B.CFStartDate AS startDate,B.CFEndDate AS endDate,");
        sql.append(" A.FDocNumber AS docNumber,A.FTitle AS title,A.FWorkflowStatus AS workflowStatus");
        sql.append(" FROM T_BAS_DocumentInfo AS A");
        sql.append(" LEFT OUTER JOIN CT_ODM_ReleasePortlet AS B");
        sql.append(" ON B.CFBillId=A.FSourcePK");
        sql.append(" WHERE A.FWorkflowStatus IN(2,4)  AND B.CFEndDate >={" + now + "}  AND B.FIsPushAllPerson=1");
        sql.append(" UNION ALL");
        sql.append(" SELECT  DISTINCT TABLE1.* FROM (SELECT DISTINCT B.FID AS id,B.CFBillId AS billId,B.CFBillName AS billName,B.CFFormId AS formId,B.FCreateTime AS createTime,B.CFStartDate AS startDate,B.CFEndDate AS endDate,");
        sql.append(" A.FDocNumber AS docNumber,A.FTitle AS title,A.FWorkflowStatus AS workflowStatus");
        sql.append(" FROM T_BAS_DocumentInfo AS A");
        sql.append(" LEFT OUTER JOIN CT_ODM_ReleasePortlet AS B");
        sql.append(" ON B.CFBillId=A.FSourcePK");
        sql.append(" WHERE A.FWorkflowStatus IN(2,4) AND  B.CFEndDate >={" + now + "}) TABLE1,T_ODM_ReceiveAdmin  AS ReceiveAdmin");
        sql.append(" WHERE TABLE1.id=ReceiveAdmin.FPortletId AND ReceiveAdmin.FAdminOrgIdID='" + adminOrgUnitInfo.getId().toString() + "'");
        sql.append(" UNION ALL");
        sql.append(" SELECT  DISTINCT TABLE1.* FROM (SELECT DISTINCT B.FID AS id,B.CFBillId AS billId,B.CFBillName AS billName,B.CFFormId AS formId,B.FCreateTime AS createTime,B.CFStartDate AS startDate,B.CFEndDate AS endDate,");
        sql.append(" A.FDocNumber AS docNumber,A.FTitle AS title,A.FWorkflowStatus AS workflowStatus");
        sql.append(" FROM T_BAS_DocumentInfo AS A");
        sql.append(" LEFT OUTER JOIN CT_ODM_ReleasePortlet AS B");
        sql.append(" ON B.CFBillId=A.FSourcePK");
        sql.append(" WHERE A.FWorkflowStatus IN(2,4) AND  B.CFEndDate >={" + now + "}) TABLE1,T_ODM_ReceiveRole  AS ReceiveRole");
        sql.append(" WHERE TABLE1.id=ReceiveRole.FPortletId AND ReceiveRole.FRoleId IN(" + roleIds + ")");
        sql.append(" UNION ALL");
        sql.append(" SELECT  DISTINCT TABLE1.* FROM (SELECT DISTINCT B.FID AS id,B.CFBillId AS billId,B.CFBillName AS billName,B.CFFormId AS formId,B.FCreateTime AS createTime,B.CFStartDate AS startDate,B.CFEndDate AS endDate,");
        sql.append(" A.FDocNumber AS docNumber,A.FTitle AS title,A.FWorkflowStatus AS workflowStatus");
        sql.append(" FROM T_BAS_DocumentInfo AS A");
        sql.append(" LEFT OUTER JOIN CT_ODM_ReleasePortlet AS B");
        sql.append(" ON B.CFBillId=A.FSourcePK");
        sql.append(" WHERE A.FWorkflowStatus IN(2,4) AND  B.CFEndDate >={" + now + "}) TABLE1,CT_ODM_ReceivePerson  AS ReceivePerson");
        sql.append(" WHERE TABLE1.id=ReceivePerson.CFPortletId AND ReceivePerson.CFReceiverID='" + info.getId().toString() + "'");
        sql.append(") ALLTABLE  ORDER BY ALLTABLE.createTime DESC ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    public static HashMap getOdmReadRecord(Context ctxtv, IRowSet rowSet) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctxtv);
        String sqltv = "";
        IRowSet rstv = null;
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (rowSet != null && rowSet.size() > 0) {
            StringBuffer columnIdStr = new StringBuffer();
            try {
                while (rowSet.next()) {
                    columnIdStr.append("'").append(rowSet.getString("id")).append("',");
                }
                rowSet.beforeFirst();
                if (columnIdStr.length() > 0 && (rstv = DbUtil.executeQuery((Context)ctxtv, (String)(sqltv = "select CFPortletId from CT_ODM_ReceivePerson where CFIsRead='1' and CFReceiverID='" + userInfo.getPerson().getId().toString() + "'  and CFPortletId in(" + columnIdStr.substring(0, columnIdStr.length() - 1) + ")"))) != null && rstv.size() > 0) {
                    while (rstv.next()) {
                        idMap.put(rstv.getString("CFPortletId"), "true");
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return idMap;
    }

    public static boolean isExistAttachment(String billId) {
        try {
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getRemoteInstance();
            BoAttchAssoCollection coll = iBoAttchAsso.getBoAttchAssoCollection(" where boid='" + billId + "'");
            if (coll != null && coll.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void sendPersonMessage(Context ctx, PersonInfo personInfo, String billID, String messageContent, String bodyContent, boolean isSMS, boolean isMsg, boolean isMail) throws BOSException {
        if (personInfo == null || personInfo.getId() == null) {
            return;
        }
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        if (isMsg) {
            try {
                String[] userIds = OdmUtil.getUserIds(ctx, personInfo.getId().toString());
                if (userIds != null) {
                    for (int i = 0; i < userIds.length; ++i) {
                        Message message = OdmUtil.getPostMessage(ctx, billID, messageContent, messageContent);
                        if (null == message) {
                            return;
                        }
                        message.setStringHeader("receiver", userIds[i]);
                        senderAgent.sendMessage(message);
                    }
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        if (isSMS) {
            String content = bodyContent;
            SendMessageParamInfo paramInfo = new SendMessageParamInfo();
            paramInfo.setAppendCompanyName(false);
            paramInfo.setAppendNumber(false);
            paramInfo.setAppendPersonName(false);
            paramInfo.setAppendRevert(false);
            paramInfo.setAppendUserName(false);
            paramInfo.setContent(content);
            paramInfo.setReceiver(personInfo.getCell());
            paramInfo.setCanback(false);
            IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance((Context)ctx);
            try {
                if (paramInfo.getReceiver() != null) {
                    iMsgFacade.sendMsg(paramInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (isMail) {
            String subject = messageContent;
            String body = bodyContent;
            String to = personInfo.getEmail();
            try {
                MsgUtil.msgMailDerect((Context)ctx, (String)subject, (String)body, (String)to, null, null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Message getPostMessage(Context ctx, String billID, String messageContent, String bodyContent) {
        String sendName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
        String messageStr = messageContent;
        String bodyStr = bodyContent;
        String senderStr = sendName;
        Locale[] lcla = OdmUtil.getContextLocales(ctx);
        Locale locale = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (int j = 0; j < lcla.length; ++j) {
            locale = lcla[j];
            message.setLocaleStringHeader("title", messageStr, locale);
            message.setLocaleStringHeader("sender", senderStr, locale);
            if (bodyStr == null) {
                message.setLocaleStringHeader("body", messageStr, locale);
                continue;
            }
            message.setLocaleStringHeader("body", bodyStr, locale);
        }
        String sourceIDs = "||" + billID + "|";
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 40);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("bizPackage", "com.kingdee.eas.cp.odm.app");
        message.setStringHeader("realBizPackage", "com.kingdee.eas.cp.odm.app");
        message.setStringHeader("sourceID", "");
        message.setStringHeader("sourceIDs", sourceIDs);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        return message;
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static String[] getUserIds(String personid) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personid, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        IUser iuser = UserFactory.getRemoteInstance();
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() == 0) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    public static PositionCollection getPositionCollection(Context ctx, PersonInfo info) throws BOSException, EASBizException, ParserException, SQLException {
        AdminOrgUnitInfo adminInfo = OdmUtil.getAdminOrgByPerson(ctx, info);
        if (adminInfo == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminInfo.getParent().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"%\u673a\u8981\u5458%", CompareType.LIKE));
        evi.setFilter(filter);
        IPosition iPostion = PositionFactory.getRemoteInstance();
        return iPostion.getPositionCollection(evi);
    }

    public static Hashtable getParentPositionPersonIds(Context ctx, PersonInfo info) throws EASBizException, ParserException, BOSException, SQLException {
        Hashtable<String, String> hs = new Hashtable<String, String>();
        AdminOrgUnitInfo adminInfo = OdmUtil.getAdminOrgByPerson(ctx, info);
        if (adminInfo == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer("select a.fid from T_BD_Person a,T_ORG_PositionMember b where a.fid=b.FPersonID");
        sql.append(" and b.FpositionID in ( ");
        sql.append(" select fid from t_org_position where fadminorgunitid='" + adminInfo.getParent().getId().toString() + "'");
        sql.append(" and Fname_l2 like '%\u673a\u8981\u5458%')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            while (rowSet.next()) {
                hs.put(rowSet.getString("fid"), rowSet.getString("fid"));
            }
        }
        return hs;
    }

    public static AdminOrgUnitInfo getAdminOrgByPerson(Context ctx, PersonInfo person) throws ParserException, EASBizException, BOSException, SQLException {
        AdminOrgUnitInfo adminOrgUnitInfo = OdmUtil.getAdminOrgByPersonByIsPrimary(ctx, person, false);
        return adminOrgUnitInfo;
    }

    public static AdminOrgUnitInfo getAdminOrgByPersonByIsPrimary(Context ctx, PersonInfo person, boolean isPrimary) throws ParserException, EASBizException, BOSException, SQLException {
        StringBuffer str = new StringBuffer(" person.id='" + person.getString("id") + "' ");
        if (isPrimary) {
            str.append(" AND PM.isPrimary=1 ");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(str.toString());
        MetaDataPK query = new MetaDataPK("com.kingdee.eas.basedata.org.app.AdminOrgPersons");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        String adminOrgId = "";
        if (rowSet != null && rowSet.next()) {
            adminOrgId = rowSet.getString("AdminOrg.id");
        }
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (!StringUtils.isEmpty((String)adminOrgId) && !"null".equals(adminOrgId)) {
            ObjectUuidPK pk = new ObjectUuidPK(adminOrgId);
            adminOrgUnitInfo = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)pk);
        }
        return adminOrgUnitInfo;
    }

    public static Set getMyPositionIds(Context ctx, String personid) throws BOSException, SQLException {
        HashSet<String> set = new HashSet<String>();
        StringBuffer sql = new StringBuffer("select FPositionID from T_ORG_PositionMember ");
        sql.append("  where FPersonId='" + personid + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            while (rowSet.next()) {
                set.add(rowSet.getString("FPositionID"));
            }
        }
        return set;
    }

    public static Set getPositionPersonIds(Context ctx, PersonInfo info) throws SQLException, BOSException {
        HashSet<String> set = new HashSet<String>();
        StringBuffer sql = new StringBuffer("select FPersonID from T_ORG_PositionMember  where FPositionID in (");
        sql.append(" select FpositionID from T_ORG_PositionMember where FpersonID='" + info.getId().toString() + "'");
        sql.append(" and FpositionID in ( select fid from t_org_position where Fname_l2 like '%\u673a\u8981\u5458%')");
        sql.append(" )");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            while (rowSet.next()) {
                set.add(rowSet.getString("FPersonID"));
            }
        }
        return set;
    }

    public static boolean isContains(String str1, String str2, String separ) {
        if (OdmUtil.isEmpty(str1)) {
            return false;
        }
        if (OdmUtil.isEmpty(str2)) {
            return false;
        }
        if (OdmUtil.isEmpty(separ)) {
            return false;
        }
        String[] strs = str1.split(separ);
        for (int i = 0; i < strs.length; ++i) {
            if (OdmUtil.isEmpty(strs[i]) || !strs[i].equalsIgnoreCase(str2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim()) || str.trim().length() == 0;
    }

    public static String arrayContrastStr(String maxAry, String minAry, String separ) {
        String strs = "";
        if (OdmUtil.isEmpty(maxAry)) {
            return "";
        }
        if (OdmUtil.isEmpty(separ)) {
            return "";
        }
        if (OdmUtil.isEmpty(minAry)) {
            return maxAry;
        }
        String[] str1 = maxAry.split(separ);
        String[] str2 = minAry.split(separ);
        for (int i = 0; i < str1.length; ++i) {
            boolean fg = true;
            for (int j = 0; j < str2.length; ++j) {
                if (OdmUtil.isEmpty(str1[i]) || OdmUtil.isEmpty(str2[j]) || !str1[i].equalsIgnoreCase(str2[j])) continue;
                fg = false;
                break;
            }
            if (!fg || OdmUtil.isEmpty(str1[i])) continue;
            strs = OdmUtil.isEmpty(strs) ? str1[i] : "," + str1[i];
        }
        return strs;
    }

    public static ReservedNoInfo reservedNo(Context ctx, FileWordsInfo fw, OfficialDocumentNoInfo odn) {
        if (null == fw || null == fw.getId() || null == odn || null == odn.getId()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select * where fileWords.id ='");
        sb.append(fw.getId().toString()).append("'");
        sb.append(" and officialDocumentNo.id ='");
        sb.append(odn.getId().toString()).append("'");
        try {
            ReservedNoCollection fwc = ReservedNoFactory.getLocalInstance(ctx).getReservedNoCollection(sb.toString());
            if (fwc.size() <= 0) {
                return null;
            }
            return fwc.get(0);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateResverdNo(Context ctx, ReservedNoInfo rn) {
        if (null != rn) {
            try {
                if (null != rn.getId()) {
                    ReservedNoFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectStringPK(rn.getId().toString()), (CoreBaseInfo)rn);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addResverdNoEntry(Context ctx, ReservedNoEntryInfo rne) {
        try {
            ReservedNoEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)rne);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static IRowSet getPersonIdsByAdminOrgNumber(Context ctx, Set orgNumber) throws ParserException, EASBizException, BOSException, SQLException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgNumber, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        MetaDataPK query = new MetaDataPK("com.kingdee.eas.cp.odm.app.ConfidentialPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static IRowSet getPersonIdsByConfidentialPerson(Context ctx, Set num) throws ParserException, EASBizException, BOSException, SQLException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)num, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        MetaDataPK query = new MetaDataPK("com.kingdee.eas.cp.odm.app.ConfidentialPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static String[] getOrgNumberByMulBaseDate(Object mulBaseDate) throws JSONException {
        JSONArray obj;
        String numberStr;
        String[] str = null;
        if (mulBaseDate != null && !"".equals(mulBaseDate) && !"null".equals(mulBaseDate) && (numberStr = (obj = new JSONArray((String)mulBaseDate)).get(0).toString()) != null) {
            numberStr = numberStr.substring(1, numberStr.length() - 1).replaceAll("\"", "");
            str = numberStr.split(",");
        }
        return str;
    }

    public static String[] getConfidentialPersonNumByMulBaseDate(Object mulBaseDate) throws JSONException {
        String[] str = null;
        String baseDataStr = (String)mulBaseDate;
        if (baseDataStr != null && !"".equals(baseDataStr) && !"null".equals(baseDataStr)) {
            JSONArray obj = new JSONArray(baseDataStr);
            String numberStr = obj.get(0).toString();
            numberStr = numberStr.substring(1, numberStr.length() - 1).replaceAll("\"", "");
            str = numberStr.split(",");
        }
        return str;
    }

    public static Set getFormIds(Context ctx, String templateId) throws BOSException, SQLException {
        HashSet<String> set = new HashSet<String>();
        String sql = "select fid from t_bas_form where FTemplateID ='" + templateId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null) {
            while (rowSet.next()) {
                set.add(rowSet.getString("fid"));
            }
        }
        return set;
    }

    public static String getFormIdBySourcePK(Context ctx, String sourcePK) throws BOSException, SQLException {
        String formId = "";
        return formId;
    }

    public static String getTemplateIDByFormId(Context ctx, String formId) throws BOSException, SQLException {
        String templateID = "";
        String sql = "select FTemplateID from t_bas_form where fid ='" + formId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null && rowSet.next()) {
            templateID = rowSet.getString("FTemplateID");
        }
        return templateID;
    }

    public static String getFormTemplateId(Context ctx, String sourcePK) throws BOSException, EASBizException {
        String templateid = "";
        IDocumentInfo iDocumentInfo = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoCollection coll = iDocumentInfo.getDocumentInfoCollection(" where sourcePK='" + sourcePK + "'");
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getTemplateId();
        }
        return templateid;
    }

    public static void updateReservedNoUsed(Context ctx, String entryid) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)entryid) || "null".equals(entryid)) {
            return;
        }
        String sql = "UPDATE CT_ODM_ReservedNoEntry SET fisused='2' WHERE fid='" + entryid + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        StringBuffer oql = new StringBuffer();
        oql.append("select CFReservedNumber,FParentID from ct_odm_reservedNoEntry ");
        oql.append(" where FParentID in (select FParentID from ct_odm_reservedNoEntry where fid='" + entryid + "') ");
        oql.append(" and FIsUsed='0' ");
        String[] str = null;
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            str = new String[iRowSet.size()];
            int k = 0;
            while (iRowSet.next()) {
                str[k] = iRowSet.getString("CFReservedNumber");
                ++k;
            }
        }
        String sql_update = "update ct_odm_reservedNo set CFReservedNumberStr='" + OdmUtil.strArrayToLenStr(str, 255) + "' where fid in (select FParentID from ct_odm_reservedNoEntry where fid='" + entryid + "')";
        DbUtil.execute((Context)ctx, (String)sql_update);
    }

    public static boolean isReservedNoUsed(Context ctx, String entryid) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)entryid) || "null".equals(entryid)) {
            return false;
        }
        String sql = "select CFReservedNumber from CT_ODM_ReservedNoEntry  where fisused='2' and fid='" + entryid + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSet != null && rowSet.next();
    }

    public static Set getPersonSet(Context ctx, String personid) throws BOSException, SQLException {
        HashSet<String> set = new HashSet<String>();
        String sql = "select FParentID from T_ODM_CommonOpinionSharePerson where FPersonIDID='" + personid + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rows != null) {
            while (rows.next()) {
                set.add(rows.getString("FParentID"));
            }
        }
        return set;
    }

    public static String getTemplateIdByBillID(Context ctx, String billId) throws BOSException, SQLException {
        String templateid = "";
        StringBuffer sql = new StringBuffer("select FTemplateID from t_bas_form ");
        sql.append(" where fid in(select FFormID from t_bas_documentinfo where FSourcePK='" + billId + "')");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rows != null && rows.next()) {
            templateid = rows.getString("FTemplateID");
        }
        return templateid;
    }

    public static boolean isHasCode(Context ctx, String sql, String str) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)sql) || "null".equals(sql)) {
            return false;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null && rowSet.next()) {
            boolean isflag = StringUtil.isEmpty((String)rowSet.getString(str)) || "null".equals(rowSet.getString(str));
            return !isflag;
        }
        return false;
    }

    public static void updateDocumeninfoDocNum(Context ctx, String docNum, String billID) throws BOSException, EASBizException {
        IDocumentInfo iDocumentInfo = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoCollection coll = iDocumentInfo.getDocumentInfoCollection(" where SourcePK='" + billID + "'");
        if (coll != null && coll.size() > 0) {
            DocumentInfoInfo docInfo = coll.get(0);
            docInfo.setDocNumber(docNum);
            iDocumentInfo.save((CoreBaseInfo)docInfo);
        }
    }

    public static String getBosTypeByFormId(Context ctx, String formId) throws BOSException, SQLException {
        String bosType = "";
        String sql = " select FBosType from t_bas_formentity where FFormID='" + formId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null && rowSet.next()) {
            bosType = rowSet.getString("FBosType");
        }
        return bosType;
    }

    public static Hashtable getAdminOrgUtilById(Context ctx, Set number) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.INCLUDE));
        evi.setFilter(filter);
        IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection coll = adminOrgUnit.getAdminOrgUnitCollection(evi);
        Hashtable<String, AdminOrgUnitInfo> hs = new Hashtable<String, AdminOrgUnitInfo>();
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                hs.put(coll.get(i).getId().toString(), coll.get(i));
            }
        }
        return hs;
    }

    public static Set getConfidentNumSet(Object tocu, Object carboncopycu) {
        HashSet<String> set = new HashSet<String>();
        String[] str = null;
        String[] str2 = null;
        try {
            str = OdmUtil.getConfidentialPersonNumByMulBaseDate(tocu);
            str2 = OdmUtil.getConfidentialPersonNumByMulBaseDate(carboncopycu);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (str != null) {
            for (int i = 0; i < str.length; ++i) {
                if (StringUtils.isEmpty((String)str[i]) || "null".equals(str[i])) continue;
                set.add(str[i]);
            }
        }
        if (str2 != null) {
            for (int i = 0; i < str2.length; ++i) {
                if (StringUtils.isEmpty((String)str2[i]) || "null".equals(str2[i])) continue;
                set.add(str2[i]);
            }
        }
        return set;
    }

    public static void saveFileCenterRecord(Context ctx, Set set, AdminOrgUnitInfo orgUnit, String txtAttachmentId, String billId, String messageContent, String bodyContent, boolean isSMS, boolean isMsg, boolean isEmail) throws EASBizException, BOSException {
        block8: {
            IFileCenterRecord iFileCenterRecord = FileCenterRecordFactory.getLocalInstance(ctx);
            if (iFileCenterRecord.exists(" where billId='" + billId + "'")) {
                return;
            }
            messageContent = bodyContent = "\u8bf7\u67e5\u9605\u516c\u6587\uff1a" + bodyContent;
            try {
                IRowSet iRowSet = OdmUtil.getPersonIdsByConfidentialPerson(ctx, set);
                if (iRowSet == null) break block8;
                while (iRowSet.next()) {
                    PersonInfo personInfo = new PersonInfo();
                    String personId = iRowSet.getString("Person.id");
                    if (StringUtils.isEmpty((String)personId) || "null".equals(personId)) continue;
                    personInfo.setId(BOSUuid.read((String)personId));
                    personInfo.setCell(iRowSet.getString("Person.cell"));
                    personInfo.setEmail(iRowSet.getString("Person.email"));
                    FileCenterRecordInfo info = new FileCenterRecordInfo();
                    info.setBillId(billId);
                    info.setPosition("");
                    info.setType(BillStatusEnum.FILECENTER);
                    info.setIsDownLoad(IsDownLoadEnum.no);
                    info.setIsRollbackStatus(BillStatusEnum.NORMAL);
                    info.setAdminOrgUnit(orgUnit);
                    info.setTxtAttachmentId(txtAttachmentId);
                    info.setDocReceiver(personInfo);
                    if (iRowSet.getString("orgUnit.id") != null) {
                        try {
                            info.setReceiverOrg(OdmUtil.getAdminOrgByPersonByIsPrimary(ctx, personInfo, true));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    iFileCenterRecord.save((CoreBaseInfo)info);
                    OdmUtil.sendPersonMessage(ctx, personInfo, billId, messageContent, bodyContent, isSMS, isMsg, isEmail);
                }
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isFileCenterAndNoWfByFormId(Context ctx, String formId) {
        if (StringUtils.isEmpty((String)formId)) {
            return false;
        }
        boolean flag = OdmUtil.isFileCenterTemplateid(ctx, formId);
        if (flag) {
            flag = OdmUtil.isHasTemplateWorkFlow(ctx, formId);
        }
        return flag;
    }

    public static boolean isFileCenterTemplateid(Context ctx, String formId) {
        boolean flag = false;
        try {
            String sql = "select FTemplateID from t_bas_form where fid ='" + formId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet != null && rowSet.next()) {
                flag = ODMFILECENTER_TEMPLATEID.equals(rowSet.getString("FTemplateID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("isFileCenterTemplateid is SQLException error:" + e));
        }
        catch (BOSException e) {
            logger.error((Object)("isFileCenterTemplateid is BOSException error:" + (Object)((Object)e)));
        }
        return flag;
    }

    public static boolean isFileCenterTemplateidByBillId(Context ctx, String billId) {
        boolean flag = false;
        try {
            StringBuffer sql = new StringBuffer("SELECT  a.FTemplateID FROM t_bas_form AS a ,t_bas_documentInfo AS b");
            sql.append(" where a.Fid=b.Fformid and b.FsourcePK='" + billId + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet != null && rowSet.next()) {
                flag = ODMFILECENTER_TEMPLATEID.equals(rowSet.getString("FTemplateID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("isFileCenterTemplateidByBillId is SQLException error:" + e));
        }
        catch (BOSException e) {
            logger.error((Object)("isHasTemplateWorkFlow is BOSException error:" + (Object)((Object)e)));
        }
        return flag;
    }

    private static boolean isHasTemplateWorkFlow(Context ctx, String formId) {
        ITemplate templateService = null;
        TemplateInfo templateInfo = null;
        boolean flag = false;
        try {
            TemplateWorkFlowCollection collection;
            templateService = TemplateFactory.getLocalInstance((Context)ctx);
            TemplateCollection coll = templateService.getTemplateCollection(" where formId='" + formId + "'");
            if (coll != null && coll.size() > 0 && ((collection = (templateInfo = coll.get(0)).getEntries()) == null || collection.size() == 0)) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)("isHasTemplateWorkFlow is BOSException error:" + (Object)((Object)e)));
        }
        return flag;
    }

    public static void updateObjectWorkStatus(Context ctx, String billId, int workStatus) throws DataAccessException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("workflowStatus");
        IObjectValue objectValue = DAOHelper.getDAO().load(ctx, billId, sic);
        objectValue.setString("workflowStatus", String.valueOf(workStatus));
        DAOHelper.getDAO().update(ctx, objectValue);
    }

    public static void updateDocumentInfoWorkStatus(Context ctx, String fid, String sourcePK, int workStatus) throws BOSException {
        StringBuffer sql = new StringBuffer("UPDATE t_bas_documentinfo SET FWorkflowStatus=" + workStatus);
        if (!StringUtils.isEmpty((String)fid)) {
            sql.append(" WHERE Fid='" + fid + "'");
        } else {
            sql.append(" WHERE FSourcePK='" + sourcePK + "'");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void updateDocumentInfoWorkStatusDelete(Context ctx, Set sourcePKs) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("SourcePK", (Object)sourcePKs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("WorkflowStatus", (Object)WorkflowStatus.abandon, CompareType.EQUALS));
        evi.setFilter(filter);
        CoreBaseCollection coreColl = new CoreBaseCollection();
        IDocumentInfo iDocumentInfo = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoCollection coll = iDocumentInfo.getDocumentInfoCollection(evi);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                DocumentInfoInfo docInfo = coll.get(i);
                docInfo.setWorkflowStatus(WorkflowStatus.delete);
                coreColl.add((CoreBaseInfo)docInfo);
            }
        }
        iDocumentInfo.update(coreColl);
    }

    public static String covertToSimpleDate(Date date) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        return f.format(date);
    }

    public static String covertDateToStr(Date date) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return f.format(date);
    }

    public static String convert2String(String[] str) {
        if (str == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int length = str.length;
        for (int n = 0; n < length; ++n) {
            sb.append(str[n]).append(";");
        }
        String s = sb.substring(0, sb.lastIndexOf(";"));
        return s;
    }

    public static String[] sort(String[] str) {
        if (str == null) {
            return str;
        }
        String s = null;
        for (int i = 1; i < str.length; ++i) {
            for (int j = str.length - 1; j >= i; --j) {
                if (Integer.parseInt(str[j]) >= Integer.parseInt(str[j - 1])) continue;
                s = str[j - 1];
                str[j - 1] = str[j];
                str[j] = s;
            }
        }
        return str;
    }

    public static String strArrayToLenStr(String[] str, int len) {
        String numberStr = OdmUtil.convert2String(OdmUtil.sort(str));
        if (numberStr != null && numberStr.length() > len - 3) {
            numberStr = numberStr.substring(0, len - 3) + "...";
        }
        return numberStr;
    }

    public static String passAssignment(String billId, String formId, String passRecordId) {
        String url = "/easweb/cp/odm/replyList.jsf";
        StringBuffer reqParamStr = WfWafUtil.appendParam((String)"fromMesgOrCpBase", (String)"mySentPassRecordInfo.getFromMesgOrCpBase()", (boolean)true);
        WfWafUtil.appendParam((StringBuffer)reqParamStr, (String)"billPassRecordID", (String)passRecordId, (boolean)true);
        WfWafUtil.appendParam((StringBuffer)reqParamStr, (String)"billPassRecordEntryID", (String)"mySentPassRecordInfo.getBillPassRecordEntryID()", (boolean)true);
        WfWafUtil.appendParam((StringBuffer)reqParamStr, (String)"formID", (String)formId, (boolean)true);
        WfWafUtil.appendParam((StringBuffer)reqParamStr, (String)"billId", (String)billId, (boolean)true);
        WfWafUtil.appendParam((StringBuffer)reqParamStr, (String)"showReply", (String)"none", (boolean)true);
        WfWafUtil.appendParam((StringBuffer)reqParamStr, (String)"modulePackage", (String)"com.kingdee.cp.odm", (boolean)true);
        return url + reqParamStr.toString();
    }

    public static void recordRead(Context ctx, String portletId) {
        if (portletId != null && !"".equals(portletId)) {
            String currentPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            String currentAdminUnitI = "";
            if (ContextUtil.getCurrentAdminUnit((Context)ctx) != null) {
                // empty if block
            }
            currentAdminUnitI = ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString();
            String sql_read = "select fid from CT_ODM_ReceivePerson where CFPortletid='" + portletId + "' and CFReceiverID='" + currentPersonId + "'";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_read);
                IReceivePerson iDocRead = ReceivePersonFactory.getLocalInstance(ctx);
                ReceivePersonInfo docReadInfo = null;
                if (null != rowSet && rowSet.size() < 1) {
                    docReadInfo = new ReceivePersonInfo();
                    docReadInfo.setPortletId(portletId);
                    docReadInfo.setReceiver(PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(currentPersonId)));
                    docReadInfo.setReadTime(new Date());
                    docReadInfo.setIsRead(IsReadEnum.READED);
                    docReadInfo.setIsReadPerson(true);
                    docReadInfo.setReadedPersonAdminOrgId(currentAdminUnitI);
                    iDocRead.addnew((CoreBaseInfo)docReadInfo);
                } else if (rowSet.next()) {
                    docReadInfo = iDocRead.getReceivePersonInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("fid")));
                    docReadInfo.setReadTime(new Date());
                    docReadInfo.setIsRead(IsReadEnum.READED);
                    docReadInfo.setReadedPersonAdminOrgId(currentAdminUnitI);
                    iDocRead.save((CoreBaseInfo)docReadInfo);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static int recordReadCount(Context ctx, String portletId) {
        if (portletId != null && !"".equals(portletId)) {
            String currentPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            StringBuffer sql_read = new StringBuffer("select count(fid) as readCount from CT_ODM_ReceivePerson ");
            sql_read.append(" where CFPortletid='" + portletId + "' and CFReceiverID='" + currentPersonId + "'");
            sql_read.append(" and CFIsRead='1'");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_read.toString());
                if (null != rowSet) {
                    return rowSet.size();
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static Set<String> getCurrentAllRoleIds(Context ctx) {
        HashSet<String> set = new HashSet<String>();
        UserInfo UserInfo2 = ContextUtil.getCurrentUserInfo((Context)ctx);
        AdminOrgUnitInfo adminOrgUnitInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
        if (ctx != null && adminOrgUnitInfo != null && adminOrgUnitInfo.getId() != null) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FRoleID FROM T_PM_UserRoleOrg ");
                sql.append(" WHERE FUserID='" + UserInfo2.getId().toString() + "'");
                sql.append(" AND FOrgID='" + adminOrgUnitInfo.getId().toString() + "'");
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (iRowSet.next()) {
                    set.add(iRowSet.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (set.size() == 0) {
            set.add("noRoles");
        }
        return set;
    }

    public static String getCurrentAllRoleIdsStr(Context ctx) {
        UserInfo UserInfo2 = ContextUtil.getCurrentUserInfo((Context)ctx);
        AdminOrgUnitInfo adminOrgUnitInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
        if (ctx != null && adminOrgUnitInfo != null && adminOrgUnitInfo.getId() != null) {
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FRoleID FROM T_PM_UserRoleOrg ");
                sql.append(" WHERE FUserID='" + UserInfo2.getId().toString() + "'");
                sql.append(" AND FOrgID='" + adminOrgUnitInfo.getId().toString() + "'");
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                StringBuffer columnIdStr = new StringBuffer("");
                while (iRowSet.next()) {
                    columnIdStr.append("'").append(iRowSet.getString(1)).append("',");
                }
                if (columnIdStr.toString().length() > 0) {
                    return columnIdStr.substring(0, columnIdStr.length() - 1);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return "'noRoles'";
    }

    public static String hashSetToStr(Set<String> set, String split) {
        StringBuffer ids = new StringBuffer();
        if (StringUtils.isEmpty((String)split)) {
            split = ",";
        }
        if (set != null && set.size() > 0) {
            for (String id : set) {
                ids.append("'" + id + "',");
            }
            ids = new StringBuffer(ids.toString().substring(0, ids.length() - 1));
        }
        return ids.toString();
    }
}

