/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class OdmXtUtil {
    public static Set<String> getPersons(Context ctx, String billId, boolean isAll) {
        Set<String> peronIds = new HashSet<String>();
        if (isAll) {
            IRowSet person_iRowSet = OdmXtUtil.getAllPerson(ctx, billId);
            peronIds = OdmXtUtil.rowSetToSet(peronIds, person_iRowSet);
        } else {
            IRowSet iRowSet = OdmXtUtil.getRolePersons(ctx, billId);
            peronIds = OdmXtUtil.rowSetToSet(peronIds, iRowSet);
            IRowSet role_iRowSet = OdmXtUtil.getRoleRolePersons(ctx, billId);
            peronIds = OdmXtUtil.rowSetToSet(peronIds, role_iRowSet);
            IRowSet adminPersons1 = OdmXtUtil.getRoleAdminPersons(ctx, billId);
            peronIds = OdmXtUtil.rowSetToSet(peronIds, adminPersons1);
        }
        return peronIds;
    }

    private static IRowSet getAllPerson(Context ctx, String billId) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT DISTINCT PERSON.FID FROM T_BD_Person PERSON ");
        selectSql.append(" INNER JOIN T_ORG_PositionMember POSITIONMEMBER ON PERSON.FID = POSITIONMEMBER.FPersonID");
        selectSql.append(" INNER JOIN T_ORG_Position POSITION ON POSITIONMEMBER.FPositionID = POSITION.FID");
        selectSql.append(" INNER JOIN T_ORG_Admin ADMINORGUNIT ON POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        selectSql.append(" INNER JOIN T_ORG_CtrlUnit CU2 ON ADMINORGUNIT.FControlUnitID = CU2.FID");
        selectSql.append(" WHERE PERSON.FDeletedStatus =1");
        return OdmXtUtil.getRowSetBySql(ctx, selectSql.toString());
    }

    private static IRowSet getRolePersons(Context ctx, String billId) {
        StringBuffer personSql = new StringBuffer();
        personSql.append(" SELECT DISTINCT a.CFReceiverID FROM CT_ODM_ReceivePerson a,CT_ODM_ReleasePortlet b ");
        personSql.append(" WHERE a.CFPortletId=b.FID AND b.CFBillId='" + billId + "' ");
        return OdmXtUtil.getRowSetBySql(ctx, personSql.toString());
    }

    private static IRowSet getRoleRolePersons(Context ctx, String billId) {
        StringBuffer roleSql = new StringBuffer();
        roleSql.append(" SELECT DISTINCT c.FID FROM T_PM_UserRoleOrg a ");
        roleSql.append(" INNER JOIN T_PM_User b ON b.FID = a.FUserID ");
        roleSql.append(" INNER JOIN T_BD_Person c ON c.FID = b.FPersonId ");
        roleSql.append(" INNER JOIN T_ODM_ReceiveRole d ON d.FRoleId=a.FRoleID ");
        roleSql.append(" INNER JOIN CT_ODM_ReleasePortlet e ON e.FID= d.FPortletId ");
        roleSql.append(" WHERE e.CFBillId='" + billId + "' ");
        return OdmXtUtil.getRowSetBySql(ctx, roleSql.toString());
    }

    private static IRowSet getRoleAdminPersons(Context ctx, String billId) {
        StringBuffer adminSql1 = new StringBuffer();
        adminSql1.append(" SELECT DISTINCT a.FID FROM T_BD_Person a ");
        adminSql1.append(" INNER JOIN T_ORG_PositionMember b ON a.FID = b.FPersonID ");
        adminSql1.append(" INNER JOIN T_ORG_Position c ON b.FPositionID = c.FID ");
        adminSql1.append(" INNER JOIN T_ORG_Admin d ON c.FAdminOrgUnitID = d.FID ");
        adminSql1.append(" INNER JOIN T_ODM_ReceiveAdmin e ON  d.FID = e.FAdminOrgIdID ");
        adminSql1.append(" INNER JOIN CT_ODM_ReleasePortlet f ON e.FPortletId = f.FID ");
        adminSql1.append(" INNER JOIN T_ORG_CtrlUnit cu ON d.FControlUnitID = cu.FID ");
        adminSql1.append(" WHERE a.FDeletedStatus =1 AND f.CFBillId='" + billId + "'");
        return OdmXtUtil.getRowSetBySql(ctx, adminSql1.toString());
    }

    private static IRowSet getRowSetBySql(Context ctx, String sql) {
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    private static Set<String> rowSetToSet(Set<String> set, IRowSet iRowSet) {
        if (iRowSet != null) {
            try {
                if (set == null) {
                    set = new HashSet<String>();
                }
                while (iRowSet.next()) {
                    set.add(iRowSet.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return set;
    }
}

