/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ov;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.cp.ov.OVSqlUtil;
import com.kingdee.eas.cp.ov.OnlineSurveyBaseInfo;
import com.kingdee.eas.cp.ov.SurveyEmpPermCollection;
import com.kingdee.eas.cp.ov.SurveyOrgPermCollection;
import com.kingdee.eas.cp.ov.SurveyPermRangeEnum;
import com.kingdee.eas.cp.ov.SurveyPermissionInfo;
import com.kingdee.eas.cp.ov.SurveyRolePermCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PermissionHandler {
    public static boolean havePermission(Context ctx, Map ctxMap, OnlineSurveyBaseInfo info, SurveyPermissionInfo permInfo) {
        HashSet roleIDSet = (HashSet)ctxMap.get("role");
        String currentOrgID = ((AdminOrgUnitInfo)ctxMap.get("org")).getId().toString();
        String currentPersonID = (String)ctxMap.get("emp");
        UserInfo creator = info.getCreator();
        if (permInfo.getRangeType().equals((Object)SurveyPermRangeEnum.ALLCU)) {
            return true;
        }
        if (permInfo.getRangeType().equals((Object)SurveyPermRangeEnum.ALLEMPINCU)) {
            boolean flag = false;
            return flag;
        }
        if (permInfo.getRangeType().equals((Object)SurveyPermRangeEnum.SPECIFICRANGE)) {
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            flag1 = PermissionHandler.haveRolePerm(roleIDSet, permInfo);
            flag2 = PermissionHandler.haveOrgPerm(currentOrgID, permInfo);
            flag3 = PermissionHandler.haveEmpPerm(currentPersonID, permInfo);
            return flag1 || flag2 || flag3;
        }
        return false;
    }

    private static boolean haveRolePerm(HashSet roleIDSet, SurveyPermissionInfo permInfo) {
        boolean flag = false;
        SurveyRolePermCollection col = new SurveyRolePermCollection();
        if (permInfo != null) {
            col = permInfo.getRolePerms();
        }
        if (col.size() < 1) {
            return false;
        }
        String roleID = "";
        String roleID2 = "";
        int n = col.size();
        block0: for (int i = 0; i < n; ++i) {
            if (col.get(i).getRole() != null && col.get(i).getRole().getId() != null) {
                roleID = col.get(i).getRole().getId().toString();
            }
            while (roleIDSet.iterator().hasNext() && !flag) {
                String currentRoleID = (String)roleIDSet.iterator().next();
                if (!roleID.equals(currentRoleID)) continue;
                flag = true;
                continue block0;
            }
        }
        return flag;
    }

    private static boolean haveOrgPerm(String currentOrgID, SurveyPermissionInfo permInfo) {
        boolean flag = false;
        SurveyOrgPermCollection col = new SurveyOrgPermCollection();
        if (permInfo != null) {
            col = permInfo.getOrgPerms();
        }
        if (col.size() < 1) {
            return false;
        }
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            if (col.get(i).getOrg() == null || col.get(i).getOrg().getId() == null || !col.get(i).getOrg().getId().toString().equals(currentOrgID)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean haveEmpPerm(String currentPersonID, SurveyPermissionInfo permInfo) {
        boolean flag = false;
        SurveyEmpPermCollection col = new SurveyEmpPermCollection();
        if (permInfo != null) {
            col = permInfo.getEmpPerms();
        }
        if (col.size() < 1) {
            return false;
        }
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            if (col.get(i).getPerson() == null || col.get(i).getPerson().getId() == null || !col.get(i).getPerson().getId().toString().equals(currentPersonID)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static RoleCollection getRoleCol(SurveyPermissionInfo permInfo) {
        SurveyRolePermCollection col = new SurveyRolePermCollection();
        RoleCollection roleCol = new RoleCollection();
        if (permInfo != null) {
            col = permInfo.getRolePerms();
        }
        if (col.size() < 1) {
            return roleCol;
        }
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            if (col.get(i) == null) continue;
            roleCol.add(col.get(i).getRole());
        }
        return roleCol;
    }

    public static AdminOrgUnitCollection getOrgCol(SurveyPermissionInfo permInfo) {
        SurveyOrgPermCollection col = new SurveyOrgPermCollection();
        AdminOrgUnitCollection orgCol = new AdminOrgUnitCollection();
        if (permInfo != null) {
            col = permInfo.getOrgPerms();
        }
        if (col.size() < 1) {
            return orgCol;
        }
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            if (col.get(i) == null) continue;
            orgCol.add(col.get(i).getOrg());
        }
        return orgCol;
    }

    public static PersonCollection getEmpCol(SurveyPermissionInfo permInfo) {
        SurveyEmpPermCollection col = new SurveyEmpPermCollection();
        PersonCollection perCol = new PersonCollection();
        if (permInfo != null) {
            col = permInfo.getEmpPerms();
        }
        if (col.size() < 1) {
            return perCol;
        }
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            if (col.get(i) == null) continue;
            perCol.add(col.get(i).getPerson());
        }
        return perCol;
    }

    public static HashSet getIDSet(IRowSet row, String key) {
        HashSet<String> set = new HashSet<String>();
        try {
            if (row != null) {
                while (row.next()) {
                    if (row.getString(key) == null) continue;
                    set.add(row.getString(key));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    private static SelectorItemCollection getUserSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("pp.id"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("role.id"));
        sic.add(new SelectorItemInfo("ctrlUnit.id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("role.name"));
        sic.add(new SelectorItemInfo("ctrlUnit.name"));
        return sic;
    }

    public static HashSet getRoleID(Context ctx, UserInfo currentUser) {
        HashSet<String> set = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IRowSet row = null;
        filter.getFilterItems().add(new FilterItemInfo("userId.id", (Object)currentUser.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        try {
            row = OVSqlUtil.query(ctx, view, "com.kingdee.eas.base.permission.app", "UserRoleOrgQuery");
            if (row != null) {
                while (row.next()) {
                    if (row.getString("roleId.id") == null) continue;
                    set.add(row.getString("roleId.id"));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static IRowSet getRowSet(Context ctx, UserInfo currentUser) {
        IRowSet row = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currentUser.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(PermissionHandler.getUserSelector());
        try {
            row = OVSqlUtil.query(ctx, view, "com.kingdee.eas.cp.ov.app", "UserByPermQuery");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return row;
    }

    public static EntityViewInfo getEntityView(String content, Map ctxMap) {
        HashSet roleIdSet = (HashSet)ctxMap.get("role");
        HashSet orgIdSet = (HashSet)ctxMap.get("org");
        HashSet CUIdSet = (HashSet)ctxMap.get("CU");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String empId = (String)ctxMap.get("emp");
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(new Integer(2));
        stateSet.add(new Integer(3));
        filter.getFilterItems().add(new FilterItemInfo("state", stateSet, CompareType.INCLUDE));
        if (roleIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("role.id", (Object)roleIdSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("org.id", (Object)orgIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)empId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("permission.rangeType", (Object)new Integer(2), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("org.id", (Object)CUIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("permission.rangeType", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("permission.rangeType", (Object)new Integer(1), CompareType.EQUALS));
        if (content.equals("JOIN")) {
            filter.getFilterItems().add(new FilterItemInfo("permission.contentType", (Object)"0", CompareType.EQUALS));
        }
        if (content.equals("VIEW")) {
            filter.getFilterItems().add(new FilterItemInfo("permission.contentType", (Object)"1", CompareType.EQUALS));
        }
        filter.setMaskString(PermissionHandler.getMaskString(content, roleIdSet));
        view.setFilter(filter);
        return view;
    }

    private static String getMaskString(String content, HashSet roleIdSet) {
        if (content.equals("JOIN") || content.equals("VIEW")) {
            if (roleIdSet.size() > 0) {
                return "#0 and (((#1 or #2 or #3) and #4) or (#5 and #6) or #7) and #8";
            }
            return "#0 and (((#1 or #2) and #3) or (#4 and #5) or #6) and #7";
        }
        if (roleIdSet.size() > 0) {
            return "#0 and (((#1 or #2 or #3) and #4) or (#5 and #6) or #7)";
        }
        return "#0 and (((#1 or #2) and #3) or (#4 and #5) or #6)";
    }

    public static Map getCtxMap(Context ctx) {
        HashMap<String, Object> ctxMap = new HashMap<String, Object>();
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashSet roleIdSet = PermissionHandler.getRoleID(ctx, currentUser);
        IRowSet row = PermissionHandler.getRowSet(ctx, currentUser);
        HashSet orgIdSet = new HashSet();
        HashSet CUIdSet = new HashSet();
        String personId = "";
        if (currentUser.getPerson() != null) {
            personId = currentUser.getPerson().getId().toString();
        }
        try {
            orgIdSet = PermissionHandler.getIDSet(row.createCopy(), "adminOrg.id");
            CUIdSet = PermissionHandler.getIDSet(row.createCopy(), "ctrlUnit.id");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ctxMap.put("role", roleIdSet);
        ctxMap.put("org", orgIdSet);
        ctxMap.put("CU", CUIdSet);
        ctxMap.put("emp", personId);
        return ctxMap;
    }

    public static IRowSet getOvSet(Context ctx, String content) {
        IRowSet row = null;
        try {
            row = OVSqlUtil.query(ctx, PermissionHandler.getEntityView(content, PermissionHandler.getCtxMap(ctx)), "com.kingdee.eas.cp.ov.app", "MyOnlineSurveyQuery");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return row;
    }

    public static Map getMapBySet(IRowSet set, String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (set != null) {
            try {
                while (set.next()) {
                    if (set.getString("id") == null) continue;
                    map.put(set.getString("id"), set.getObject(key));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

