/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ov.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUserRolePerm;
import com.kingdee.eas.base.permission.UserRolePermFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.ov.OnlineSurveyBaseCollection;
import com.kingdee.eas.cp.ov.OnlineSurveyBaseFactory;
import com.kingdee.eas.cp.ov.OnlineSurveyBaseInfo;
import com.kingdee.eas.cp.ov.SurveyEmpPermCollection;
import com.kingdee.eas.cp.ov.SurveyOrgPermCollection;
import com.kingdee.eas.cp.ov.SurveyPermContentEnum;
import com.kingdee.eas.cp.ov.SurveyPermRangeEnum;
import com.kingdee.eas.cp.ov.SurveyPermissionCollection;
import com.kingdee.eas.cp.ov.SurveyPermissionInfo;
import com.kingdee.eas.cp.ov.SurveyRolePermCollection;
import com.kingdee.eas.cp.ov.SurveyStateEnum;
import com.kingdee.eas.cp.ov.app.AbstractOnlineSurveyBaseControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OnlineSurveyBaseControllerBean
extends AbstractOnlineSurveyBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.ov.app.OnlineSurveyBaseControllerBean");

    @Override
    protected void _setDraft(Context ctx, BOSUuid ovID) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(ovID);
        try {
            OnlineSurveyBaseInfo info = OnlineSurveyBaseFactory.getLocalInstance(ctx).getOnlineSurveyBaseInfo((IObjectPK)pk);
            info.setState(SurveyStateEnum.draft);
            OnlineSurveyBaseFactory.getLocalInstance(ctx).update((IObjectPK)pk, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _setAuditing(Context ctx, IObjectValue model) throws BOSException {
        OnlineSurveyBaseInfo info = (OnlineSurveyBaseInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        try {
            info.setState(SurveyStateEnum.audit);
            OnlineSurveyBaseFactory.getLocalInstance(ctx).update((IObjectPK)pk, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _setStarted(Context ctx, BOSUuid ovID) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(ovID);
        OnlineSurveyBaseInfo info = new OnlineSurveyBaseInfo();
        try {
            OnlineSurveyBaseInfo model;
            info = model = OnlineSurveyBaseFactory.getLocalInstance(ctx).getOnlineSurveyBaseInfo((IObjectPK)pk, this.getSelector());
            info.setState(SurveyStateEnum.proceed);
            OnlineSurveyBaseFactory.getLocalInstance(ctx).update((IObjectPK)pk, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (info.isMessageNotice()) {
            String title = "\u8bf7\u53c2\u52a0\u300a" + info.getName() + "\u300b\u7f51\u7edc\u8c03\u67e5\u7684\u6295\u7968";
            String sender = info.getCreator().getName();
            String body = "\u8bf7\u53c2\u52a0\u300a" + info.getName() + "\u300b\u7f51\u7edc\u8c03\u67e5\u7684\u6295\u7968";
            List ids = new ArrayList();
            HashMap<String, String> messageMap = new HashMap<String, String>();
            messageMap.put("title", title);
            messageMap.put("sourceID", ovID.toString());
            messageMap.put("sourceIDs", ovID.toString());
            messageMap.put("sender", sender);
            messageMap.put("body", body);
            try {
                ids = this.getJoinUserIDList(ctx, info);
                this._sendMessage(ctx, ids, messageMap);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void _setEndedByDate(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Date nowDate = new Date();
        nowDate = DateTimeUtils.truncateDate((Date)nowDate);
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)nowDate, CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2), CompareType.EQUALS));
        view.setFilter(filter);
        OnlineSurveyBaseCollection ovCol = OnlineSurveyBaseFactory.getLocalInstance(ctx).getOnlineSurveyBaseCollection(view);
        if (ovCol != null) {
            int n = ovCol.size();
            for (int i = 0; i < n; ++i) {
                OnlineSurveyBaseInfo ovInfo = ovCol.get(i);
                ObjectUuidPK pk = new ObjectUuidPK(ovInfo.getId().toString());
                try {
                    ovInfo.setState(SurveyStateEnum.end);
                    OnlineSurveyBaseFactory.getLocalInstance(ctx).update((IObjectPK)pk, ovInfo);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List getJoinUserIDList(Context ctx, OnlineSurveyBaseInfo info) throws EASBizException, BOSException, SQLException {
        List ids = new ArrayList();
        SurveyPermissionCollection permCol = info.getPermission();
        SurveyPermissionInfo permInfo = new SurveyPermissionInfo();
        int n = permCol.size();
        for (int i = 0; i < n; ++i) {
            if (permCol.get(i).getContentType() == null || !permCol.get(i).getContentType().equals((Object)SurveyPermContentEnum.JOIN)) continue;
            permInfo = permCol.get(i);
        }
        ids = this.getUserIdSet(ctx, permInfo);
        return ids;
    }

    @Override
    protected void _setEnded(Context ctx, BOSUuid ovID) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(ovID);
        try {
            OnlineSurveyBaseInfo info = OnlineSurveyBaseFactory.getLocalInstance(ctx).getOnlineSurveyBaseInfo((IObjectPK)pk);
            info.setState(SurveyStateEnum.end);
            OnlineSurveyBaseFactory.getLocalInstance(ctx).update((IObjectPK)pk, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected void _sendMessage(Context ctx, List idList, Map messageMap) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = OnlineSurveyBaseControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        String userId = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("bizPackage", "com.kingdee.eas.cp.ov.app");
        message.setStringHeader("realBizPackage", "com.kingdee.eas.cp.ov.app");
        String billId = (String)messageMap.get("sourceID");
        String billURL = "/easweb/cp/ov/surveyResultEdit.jsf?billId=" + billId;
        message.setStringHeader("sourceID", "");
        StringBuffer sourceIdsSB = new StringBuffer("CPOVMSG::billPassURL:null;billURL:");
        sourceIdsSB.append(billURL);
        sourceIdsSB.append(";billID:");
        sourceIdsSB.append(billId);
        message.setStringHeader("sourceIDs", sourceIdsSB.toString());
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", (String)messageMap.get("title"), locale2);
            message.setLocaleStringHeader("sender", (String)messageMap.get("sender"), locale2);
            message.setLocaleStringHeader("body", (String)messageMap.get("body"), locale2);
        }
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            userId = (String)idList.get(i);
            message.setStringHeader("receiver", userId);
            senderAgent.sendMessage(message);
        }
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public List getUserIdSet(Context ctx, SurveyPermissionInfo permInfo) throws BOSException, EASBizException, SQLException {
        ArrayList<String> idSet = new ArrayList<String>();
        IUserRolePerm iUserRolePerm = UserRolePermFactory.getLocalInstance((Context)ctx);
        SurveyEmpPermCollection empCol = new SurveyEmpPermCollection();
        SurveyOrgPermCollection orgCol = new SurveyOrgPermCollection();
        SurveyRolePermCollection roleCol = new SurveyRolePermCollection();
        HashSet<String> empSet = new HashSet<String>();
        HashSet<String> orgSet = new HashSet<String>();
        HashSet<String> roleSet = new HashSet<String>();
        if (permInfo == null) {
            return idSet;
        }
        empCol = permInfo.getEmpPerms();
        orgCol = permInfo.getOrgPerms();
        roleCol = permInfo.getRolePerms();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IRowSet dataRows = null;
        if (permInfo.getRangeType().equals((Object)SurveyPermRangeEnum.SPECIFICRANGE)) {
            int i;
            int n = orgCol.size();
            for (i = 0; i < n; ++i) {
                if (orgCol.get(i).getOrg() == null) continue;
                orgSet.add(orgCol.get(i).getOrg().getId().toString());
            }
            n = empCol.size();
            for (i = 0; i < n; ++i) {
                if (empCol.get(i).getPerson() == null) continue;
                empSet.add(empCol.get(i).getPerson().getId().toString());
            }
            n = roleCol.size();
            for (i = 0; i < n; ++i) {
                if (roleCol.get(i).getRole() == null) continue;
                roleSet.add(roleCol.get(i).getRole().getId().toString());
            }
            int item = 0;
            if (empSet.size() > 0) {
                ++item;
                filter.getFilterItems().add(new FilterItemInfo("person.id", empSet, CompareType.INCLUDE));
            }
            if (orgSet.size() > 0) {
                ++item;
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", orgSet, CompareType.INCLUDE));
            }
            if (roleSet.size() > 0) {
                ++item;
                filter.getFilterItems().add(new FilterItemInfo("role.id", roleSet, CompareType.INCLUDE));
            }
            if (item != 1 && item != 0) {
                if (item == 2) {
                    filter.setMaskString("#0 or #1");
                }
                if (item == 3) {
                    filter.setMaskString("#0 or #1 or #2");
                }
            }
            view.setFilter(filter);
        }
        if (permInfo.getRangeType().equals((Object)SurveyPermRangeEnum.ALLCU)) {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", null, CompareType.NOTEQUALS));
            view.setFilter(filter);
        }
        if (permInfo.getRangeType().equals((Object)SurveyPermRangeEnum.ALLEMPINCU)) {
            HashSet<String> ctrlUnitIDSet = new HashSet<String>();
            if (orgCol != null) {
                int n = orgCol.size();
                for (int i = 0; i < n; ++i) {
                    ctrlUnitIDSet.add(orgCol.get(i).getOrg().getId().toString());
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("ctrlUnit.id", ctrlUnitIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
        }
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.ov.app", "UserByPermQuery"));
        iqec.setObjectView(view);
        dataRows = iqec.executeQuery();
        while (dataRows.next()) {
            if (dataRows.getString("id") == null) continue;
            idSet.add(dataRows.getString("id"));
        }
        return idSet;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isAnonymous"));
        sic.add(new SelectorItemInfo("windowNotice"));
        sic.add(new SelectorItemInfo("messageNotice"));
        sic.add(new SelectorItemInfo("isShowResult"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("procDef"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.CU.id"));
        sic.add(new SelectorItemInfo("creator.CU.name"));
        sic.add(new SelectorItemInfo("creator.CU.number"));
        sic.add(new SelectorItemInfo("createDate"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("permission.id"));
        sic.add(new SelectorItemInfo("permission.rangeType"));
        sic.add(new SelectorItemInfo("permission.contentType"));
        sic.add(new SelectorItemInfo("permission.empPerms.id"));
        sic.add(new SelectorItemInfo("permission.orgPerms.id"));
        sic.add(new SelectorItemInfo("permission.rolePerms.id"));
        sic.add(new SelectorItemInfo("permission.empPerms.person.id"));
        sic.add(new SelectorItemInfo("permission.empPerms.person.name"));
        sic.add(new SelectorItemInfo("permission.empPerms.person.number"));
        sic.add(new SelectorItemInfo("permission.orgPerms.org.id"));
        sic.add(new SelectorItemInfo("permission.orgPerms.org.name"));
        sic.add(new SelectorItemInfo("permission.orgPerms.org.number"));
        sic.add(new SelectorItemInfo("permission.orgPerms.org.longNumber"));
        sic.add(new SelectorItemInfo("permission.orgPerms.org.isCU"));
        sic.add(new SelectorItemInfo("permission.rolePerms.role.id"));
        sic.add(new SelectorItemInfo("permission.rolePerms.role.name"));
        sic.add(new SelectorItemInfo("permission.rolePerms.role.number"));
        sic.add(new SelectorItemInfo("topic.id"));
        sic.add(new SelectorItemInfo("topic.name"));
        sic.add(new SelectorItemInfo("topic.isMultiSelection"));
        sic.add(new SelectorItemInfo("topic.optionCount"));
        sic.add(new SelectorItemInfo("topic.isNecessary"));
        sic.add(new SelectorItemInfo("topic.options.id"));
        sic.add(new SelectorItemInfo("topic.options.name"));
        sic.add(new SelectorItemInfo("topic.options.url"));
        return sic;
    }
}

