/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.BillWebUtil;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.web.WebMessageUtils;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.biz.AbstractBaseBizFunction;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BIZMessageHandler
extends AbstractBaseBizFunction {
    private static final Logger logger = Logger.getLogger(BIZMessageHandler.class);
    private static final String RESOURCE = "com.kingdee.eas.cp.eip.pc.processresource";
    private static String COMMNAD_STR = "myinprocess";
    private static String PAGENUMBER = "pageNum=";
    private static String ASSIGN_ID = "assignID";
    private static int STEP = 3;
    private static String SLIP = "#";
    private static String DECISION = "decision=";

    public boolean afterExecReplyAction(BizFuncParamObj paramObj, BizReturnObj bizReturnObj) {
        return super.afterExecReplyAction(paramObj, bizReturnObj);
    }

    public boolean afterExecSendAction(BizFuncParamObj paramObj, BizReturnObj bizReturnObj) {
        return super.afterExecSendAction(paramObj, bizReturnObj);
    }

    public boolean beforeExecReplyAction(BizFuncParamObj paramObj) {
        return super.beforeExecReplyAction(paramObj);
    }

    public boolean beforeExecSendAction(BizFuncParamObj paramObj) {
        return super.beforeExecSendAction(paramObj);
    }

    public BizReturnObj executeReplyAction(BizFuncParamObj paramObj) {
        BizReturnObj returnObj = null;
        String command = paramObj.getCommand().toLowerCase();
        SendMobileMessageInfo coreSendMessageInfo = null;
        if (paramObj.getReceiveMsg() instanceof ReceiveMobileMessageInfo) {
            coreSendMessageInfo = ((ReceiveMobileMessageInfo)paramObj.getReceiveMsg()).getParentMsg();
        } else if (paramObj.getReceiveMsg() instanceof EmailReceiveMessageInfo) {
            coreSendMessageInfo = ((EmailReceiveMessageInfo)paramObj.getReceiveMsg()).getParentMsg();
        }
        char numKey = command.toLowerCase().charAt(0);
        switch (numKey) {
            case '0': {
                returnObj = this.execQuery(paramObj, (CoreSendMessageInfo)coreSendMessageInfo);
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int recordNum = Integer.parseInt(numKey + "");
                if (recordNum < 0 || recordNum > STEP) {
                    return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_number", (Locale)paramObj.getCtx().getLocale()));
                }
                returnObj = this.execQueryDetail(paramObj, (CoreSendMessageInfo)coreSendMessageInfo, recordNum);
                break;
            }
            case 'n': 
            case 'y': {
                if (paramObj.getCommandParams().length < 1) {
                    return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_command", (Locale)paramObj.getCtx().getLocale()));
                }
                if (numKey == 'y') {
                    returnObj = this.execProcess(paramObj, (CoreSendMessageInfo)coreSendMessageInfo, "true");
                    break;
                }
                returnObj = this.execProcess(paramObj, (CoreSendMessageInfo)coreSendMessageInfo, "false");
                break;
            }
            default: {
                return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_command", (Locale)paramObj.getCtx().getLocale()));
            }
        }
        return returnObj;
    }

    private BizReturnObj execQuery(BizFuncParamObj paramObj, CoreSendMessageInfo coreSendMessageInfo) {
        IRowSet rowset;
        BizReturnObj returnObj = null;
        int lastPageNum = -1;
        String lastPageNumStr = null;
        if (coreSendMessageInfo != null) {
            lastPageNumStr = this.getPropertyFromCustomStr(coreSendMessageInfo.getCustomStr(), PAGENUMBER);
            try {
                if (StringUtils.isEmpty((String)lastPageNumStr)) {
                    return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_command", (Locale)paramObj.getCtx().getLocale()));
                }
                lastPageNum = Integer.parseInt(lastPageNumStr);
            }
            catch (NumberFormatException err) {
                lastPageNum = -1;
            }
        }
        lastPageNum = lastPageNum > -1 ? lastPageNum : 0;
        try {
            rowset = this.getMyInProccess(paramObj.getCtx(), paramObj.getUserID());
        }
        catch (BOSException e) {
            logger.error((Object)("Has some error when getInProccess \uff08" + paramObj.getReceiveMsg().getContent() + "); " + e.toString()));
            return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"hasserror_inprocess", (Locale)paramObj.getCtx().getLocale()));
        }
        if (rowset == null || rowset.size() == 0) {
            returnObj = new BizReturnObj();
            returnObj.setReturnText(ResourceBase.getString((String)RESOURCE, (String)"hasNoneInprocess", (Locale)paramObj.getCtx().getLocale()));
            returnObj.setErrorText("");
            returnObj.setCustomStr("");
            returnObj.setSucceed(true);
            returnObj.setMustReply(true);
        } else {
            returnObj = this.makeQueryReplyObj(paramObj, rowset, lastPageNum + 1);
        }
        return returnObj;
    }

    private BizReturnObj createReturnObjForError(BizFuncParamObj paramObj, String errorTxt) {
        BizReturnObj returnObj = new BizReturnObj();
        returnObj.setReturnText("");
        returnObj.setErrorText(errorTxt);
        returnObj.setCustomStr("");
        returnObj.setSucceed(false);
        returnObj.setMustReply(true);
        return returnObj;
    }

    private String getPropertyFromCustomStr(String lastCustomStr, String PropertyName) {
        String num = null;
        int lastPageNumber = -1;
        int i = lastCustomStr.indexOf(PropertyName);
        if (i > -1) {
            int j = lastCustomStr.indexOf(SLIP, i + PropertyName.length());
            num = j > -1 ? lastCustomStr.substring(i + PropertyName.length(), j) : lastCustomStr.substring(i + PropertyName.length());
        }
        return num;
    }

    public BizReturnObj executeSendAction(BizFuncParamObj paramObj) {
        BizReturnObj bizReturnObj = this.execQuery(paramObj, null);
        return bizReturnObj;
    }

    public boolean validate(BizFuncParamObj paramObj) {
        String command = paramObj.getCommand().toLowerCase();
        SendMobileMessageInfo coreSendMessageInfo = null;
        if (paramObj.getReceiveMsg() instanceof ReceiveMobileMessageInfo) {
            coreSendMessageInfo = ((ReceiveMobileMessageInfo)paramObj.getReceiveMsg()).getParentMsg();
        } else if (paramObj.getReceiveMsg() instanceof EmailReceiveMessageInfo) {
            coreSendMessageInfo = ((EmailReceiveMessageInfo)paramObj.getReceiveMsg()).getParentMsg();
        }
        if (coreSendMessageInfo == null) {
            if (COMMNAD_STR.equals(command)) {
                return true;
            }
        } else {
            char numKey = command.toLowerCase().charAt(0);
            switch (numKey) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'n': 
                case 'y': {
                    return true;
                }
            }
        }
        return false;
    }

    private IRowSet getMyInProccess(Context ctx, String userId) throws BOSException {
        IMessageCenter iMessageCenter = MessageCenterFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iMessageCenter.getAcceptedTask(userId);
        return rowset;
    }

    private BizReturnObj makeQueryReplyObj(BizFuncParamObj paramObj, IRowSet rowset, int pageNumber) {
        StringBuffer assignIdSB = new StringBuffer();
        StringBuffer replySB = new StringBuffer();
        int msgNum = 0;
        int pageNumCounter = 0;
        int lineNum = 0;
        boolean isEnd = true;
        boolean isEnough = false;
        try {
            if (pageNumber == 1) {
                replySB.append(ResourceBase.getString((String)RESOURCE, (String)"total1", (Locale)paramObj.getCtx().getLocale()) + rowset.size() + ResourceBase.getString((String)RESOURCE, (String)"total2", (Locale)paramObj.getCtx().getLocale()) + " ");
            }
            rowset.beforeFirst();
            while (rowset.next()) {
                if (isEnough) {
                    isEnd = false;
                    break;
                }
                if ((++msgNum - 1) % STEP == 0 && msgNum != 1) {
                    ++pageNumCounter;
                }
                if (pageNumCounter == pageNumber - 1) {
                    System.out.println("hello");
                    replySB.append(++lineNum + ". " + rowset.getString("sender") + "," + rowset.getString("title") + "," + rowset.getTimestamp("receiveTime").toString() + ".  ");
                    assignIdSB.append(ASSIGN_ID + lineNum + "=").append(rowset.getString("AssignRead.assignID") + SLIP);
                }
                if (lineNum != STEP) continue;
                isEnough = true;
            }
        }
        catch (SQLException err) {
            logger.error((Object)("Has some error when makeReplyObj\uff08" + paramObj.getReceiveMsg().getContent() + "); " + err.toString()));
            return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"hasserror_inprocess", (Locale)paramObj.getCtx().getLocale()));
        }
        replySB.append("  " + ResourceBase.getString((String)RESOURCE, (String)"tip10", (Locale)paramObj.getCtx().getLocale()));
        if (!isEnd) {
            replySB.append(ResourceBase.getString((String)RESOURCE, (String)"tip11", (Locale)paramObj.getCtx().getLocale()));
        }
        BizReturnObj returnObj = new BizReturnObj();
        returnObj.setReturnText(replySB.toString());
        returnObj.setErrorText("");
        returnObj.setCustomStr(PAGENUMBER + pageNumber + SLIP + assignIdSB.toString());
        returnObj.setSucceed(true);
        returnObj.setMustReply(true);
        return returnObj;
    }

    private BizReturnObj execQueryDetail(BizFuncParamObj paramObj, CoreSendMessageInfo coreSendMessageInfo, int recordNum) {
        BizReturnObj returnObj = null;
        String assignID = this.getPropertyFromCustomStr(coreSendMessageInfo.getCustomStr(), ASSIGN_ID + recordNum + "=");
        if (!StringUtils.isEmpty((String)assignID)) {
            String decision = "";
            try {
                EnactmentServiceProxy service = new EnactmentServiceProxy(paramObj.getCtx());
                decision = service.getMultiApproveDecision(assignID);
            }
            catch (WfException err1) {
                logger.error((Object)("Has WfException when execQueryDetail!\uff08" + paramObj.getReceiveMsg().getContent() + "): " + err1.toString()));
                return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"cannot_process", (Locale)paramObj.getCtx().getLocale()));
            }
            catch (BOSException err1) {
                return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_process", (Locale)paramObj.getCtx().getLocale()));
            }
            returnObj = new BizReturnObj();
            if (!StringUtils.isEmpty((String)decision)) {
                decision = decision.replaceAll(":", ".  ");
                returnObj.setReturnText(decision + "   " + ResourceBase.getString((String)RESOURCE, (String)"tip2", (Locale)paramObj.getCtx().getLocale()));
            } else {
                decision = ResourceBase.getString((String)RESOURCE, (String)"none_decision", (Locale)paramObj.getCtx().getLocale());
                returnObj.setReturnText(decision + "   " + ResourceBase.getString((String)RESOURCE, (String)"tip3", (Locale)paramObj.getCtx().getLocale()));
            }
            returnObj.setErrorText("");
            returnObj.setCustomStr(ASSIGN_ID + "=" + assignID + SLIP + DECISION + decision);
            returnObj.setSucceed(true);
            returnObj.setMustReply(true);
        } else {
            logger.error((Object)("Has none assignID! : " + paramObj.getReceiveMsg().getContent()));
            returnObj = this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_process", (Locale)paramObj.getCtx().getLocale()));
        }
        return returnObj;
    }

    private BizReturnObj execProcess(BizFuncParamObj paramObj, CoreSendMessageInfo coreSendMessageInfo, String isPass) {
        String assignID;
        int num;
        boolean hasNum;
        String decision;
        BizReturnObj returnObj;
        block19: {
            block18: {
                returnObj = null;
                decision = this.getPropertyFromCustomStr(coreSendMessageInfo.getCustomStr(), DECISION);
                int maxNum = 0;
                hasNum = false;
                char numKey = paramObj.getCommandParams()[0].charAt(0);
                if (!StringUtils.isEmpty((String)decision)) {
                    for (int i = 0; i < 100; ++i) {
                        if (decision.indexOf(i + "") == -1) {
                            maxNum = i > 0 ? i - 1 : 0;
                            break;
                        }
                        hasNum = true;
                    }
                }
                num = -1;
                if (!hasNum) break block18;
                switch (numKey) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        num = Integer.parseInt(numKey + "");
                        if (num > maxNum) {
                            return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_command", (Locale)paramObj.getCtx().getLocale()));
                        }
                        break block19;
                    }
                    default: {
                        return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_command", (Locale)paramObj.getCtx().getLocale()));
                    }
                }
            }
            num = 0;
        }
        if (!StringUtils.isEmpty((String)(assignID = this.getPropertyFromCustomStr(coreSendMessageInfo.getCustomStr(), ASSIGN_ID + "=")))) {
            Context ctx = paramObj.getCtx();
            if (!WebMessageUtils.canHandleAssignment((Context)ctx, (String)assignID)) {
                return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"cannot_process", (Locale)paramObj.getCtx().getLocale()));
            }
            if (!StringUtils.isEmpty((String)decision)) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)assignID));
                String billID = "";
                try {
                    AssignInfo assignInfo = BillWebUtil.getAssignInfo((Context)ctx, (IObjectPK)pk);
                    billID = assignInfo.getBizObjID();
                    if (StringUtils.isEmpty((String)billID)) {
                        return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"cannot_process", (Locale)paramObj.getCtx().getLocale()));
                    }
                    billID = billID.replaceAll(" ", "+");
                    EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
                    String actInstId = "";
                    AssignmentInfo wholeInfo = service.getAssignmentById(assignID);
                    actInstId = wholeInfo.getActInstId();
                    IEnactmentService wfservice = EnactmentServiceProxy.getEnacementService((Context)ctx);
                    String sendMail = wfservice.isSendMail(wholeInfo.getProcInstId(), actInstId, wholeInfo.getProcDefHashValue()) ? "true" : "false";
                    String sendSMS = wfservice.isSendMobelMessage(wholeInfo.getProcInstId(), actInstId, wholeInfo.getProcDefHashValue()) ? "true" : "false";
                    String opinionDesc = null;
                    if (hasNum) {
                        if (paramObj.getCommandParams().length > 1) {
                            opinionDesc = paramObj.getCommandParams()[1];
                        }
                    } else if (paramObj.getCommandParams().length > 0) {
                        opinionDesc = paramObj.getCommandParams()[0];
                    }
                    this.submitAssign(paramObj.getCtx(), null, assignID, billID, isPass, null, num, opinionDesc, sendMail, sendSMS);
                    returnObj = new BizReturnObj();
                    returnObj.setReturnText(ResourceBase.getString((String)RESOURCE, (String)"processing", (Locale)paramObj.getCtx().getLocale()));
                    returnObj.setErrorText("");
                    returnObj.setCustomStr("");
                    returnObj.setSucceed(true);
                    returnObj.setMustReply(true);
                }
                catch (Exception ex) {
                    logger.error((Object)("Has some error when exec WF!(" + paramObj.getReceiveMsg().getContent() + "); " + ex.toString()));
                    return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_process", (Locale)paramObj.getCtx().getLocale()));
                }
            }
        } else {
            logger.error((Object)("Has none assignID! : " + paramObj.getReceiveMsg().getContent()));
            return this.createReturnObjForError(paramObj, ResourceBase.getString((String)RESOURCE, (String)"error_command", (Locale)paramObj.getCtx().getLocale()));
        }
        return returnObj;
    }

    private String submitAssign(Context ctx, String id, String assignMentID, String billID, String isPass, String opinion, int cOpinion, String opinionDesc, String sendMail, String sendMsg) throws Exception {
        IMultiApprove multiApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo mInfo = null;
        if (StringUtils.isEmpty((String)id)) {
            mInfo = new MultiApproveInfo();
            mInfo.setAssignment(assignMentID);
            if (!StringUtils.isEmpty((String)billID)) {
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setExtendedProperty("businuessObjectId", billID);
            }
            mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
            mInfo.setOpinion(opinion);
            mInfo.setHandlerOpinion(cOpinion);
            mInfo.setIsMailNotifyNext(Boolean.valueOf(sendMail).booleanValue());
            mInfo.setIsMobelNotifyNext(Boolean.valueOf(sendMsg).booleanValue());
            mInfo.setHandlerContent(opinionDesc);
            mInfo.setExtendedProperty("assignmentID", assignMentID);
            mInfo.setExtendedProperty("isAddNew", "isAddNew");
            multiApprove.submit((CoreBaseInfo)mInfo);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            mInfo = multiApprove.getMultiApproveInfo((IObjectPK)pk);
            mInfo.setAssignment(assignMentID);
            if (!StringUtils.isEmpty((String)billID)) {
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setExtendedProperty("businuessObjectId", billID);
            }
            mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
            mInfo.setOpinion(opinion);
            mInfo.setIsMailNotifyNext(Boolean.valueOf(sendMail).booleanValue());
            mInfo.setIsMobelNotifyNext(Boolean.valueOf(sendMsg).booleanValue());
            mInfo.setHandlerOpinion(cOpinion);
            mInfo.setHandlerContent(opinionDesc);
            mInfo.setExtendedProperty("assignmentID", assignMentID);
            mInfo.setExtendedProperty("isAddNew", "isAddNew");
            multiApprove.submit((CoreBaseInfo)mInfo);
        }
        return mInfo.getId().toString();
    }
}

