/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.pc.IProcCatalogSolution;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.cp.eip.pc.ProcCatalogSolutionFactory;
import com.kingdee.eas.cp.eip.pc.ProcessCenterUtil;
import com.kingdee.eas.cp.eip.pc.app.AbstractProcStatFacadeControllerBean;
import com.kingdee.eas.cp.eip.pc.web.ProcessCenterWebUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProcStatFacadeControllerBean
extends AbstractProcStatFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.pc.app.ProcStatFacadeControllerBean");
    private final String procCatalogResource = "com.kingdee.eas.cp.eip.pc.ProcCatalogResource";

    @Override
    protected ArrayList _statAllProcessByOrgUnit(Context ctx, String orgUnitID, String startTime, String endTime, int currentPage, int pageNumber, String sortFieldName, String sortType) throws BOSException, EASBizException {
        ArrayList<Object> list = null;
        if (orgUnitID == null || orgUnitID.equals("") || startTime == null || startTime.equals("") || endTime == null || endTime.equals("")) {
            return list;
        }
        StringBuffer strSql = new StringBuffer();
        StringBuffer strCountSql = new StringBuffer();
        Timestamp startimetimestamp = Timestamp.valueOf(startTime + " 00:00:00.0");
        Timestamp endtimetimestamp = Timestamp.valueOf(endTime + " 00:00:00.0");
        String strProcCatalogName = "FNAME_" + ctx.getLocale().toString();
        strCountSql.append(" select count(*) NUM ");
        strCountSql.append(" from ( select C.FPROCLNUMBER NUMBER, COUNT(*) FPROCCOUNT, ");
        strCountSql.append(" ( sum( case when C.FWORKINGTIME <= 0 then 0 when  C.FOVERTIME > 0  then 1 end)) FEXPIREDPROCCOUNT, ");
        strCountSql.append(" avg(C.FPROCTIMECONSUMING) FAVGPROCTIMECONSUMING ");
        strCountSql.append(" from (select left(FPROCLNUMBER,35) FPROCLNUMBER,FWORKINGTIME,FOVERTIME,FPROCTIMECONSUMING  FROM V_PC_AllPROCSTATDETAIL");
        strCountSql.append(" where FLONGNUMBER like ? and ");
        strCountSql.append(" datediff(day,FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0 ");
        strCountSql.append(") C");
        strCountSql.append(" where  len(C.FPROCLNUMBER) = 35");
        strCountSql.append(" group by FPROCLNUMBER ) B right outer join ");
        strCountSql.append(" (select flongnumber,fsolutionid from t_pc_proccatalog ");
        strCountSql.append("where len(flongnumber) = 35) A ON A.FLONGNUMBER = B.NUMBER ");
        strCountSql.append(" WHERE  (A.FSOLUTIONID = ? )");
        strSql.append(" select A.FLONGNUMBER, A.").append(strProcCatalogName).append(", isnull( B.FPROCCOUNT, 0) FPROCCOUNT, ");
        strSql.append(" isnull( B.FEXPIREDPROCCOUNT, 0) FEXPIREDPROCCOUNT, ");
        strSql.append(" isnull( B.FAVGPROCTIMECONSUMING, 0) FAVGPROCTIMECONSUMING ");
        strSql.append(" from ( select C.FPROCLNUMBER NUMBER, COUNT(*) FPROCCOUNT, ");
        strSql.append(" ( sum( case when C.FWORKINGTIME <= 0 then 0 when  C.FOVERTIME > 0  then 1 end)) FEXPIREDPROCCOUNT, ");
        strSql.append(" avg(C.FPROCTIMECONSUMING) FAVGPROCTIMECONSUMING ");
        strSql.append(" from (select left(FPROCLNUMBER,35) FPROCLNUMBER,FWORKINGTIME,FOVERTIME,FPROCTIMECONSUMING  FROM V_PC_AllPROCSTATDETAIL");
        strSql.append(" where FLONGNUMBER like ? and ");
        strSql.append(" datediff(day,FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0 ");
        strSql.append(") C");
        strSql.append(" where  len(C.FPROCLNUMBER) = 35");
        strSql.append(" group by FPROCLNUMBER ) B right outer join ");
        strSql.append(" (select flongnumber,").append(strProcCatalogName).append(",fsolutionid from t_pc_proccatalog ");
        strSql.append("where len(flongnumber) = 35) A ON A.FLONGNUMBER = B.NUMBER ");
        strSql.append(" WHERE (A.FSOLUTIONID = ? )");
        Object[] param = new Object[]{orgUnitID, this.getSolution(ctx)};
        if (sortFieldName == null || sortFieldName.length() == 0) {
            sortFieldName = "A." + strProcCatalogName;
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortFieldName).append(" ").append(sortType);
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (pageNumber < 1) {
            pageNumber = 20;
        }
        logger.debug((Object)("===countSql===_statAllProcessByOrgUnit====" + strCountSql.toString()));
        logger.debug((Object)("===strSql===_statAllProcessByOrgUnit====" + strSql.toString()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strCountSql.toString(), (Object[])param);
        try {
            if (rowSet != null) {
                list = new ArrayList<Object>();
                if (rowSet.next()) {
                    int n = rowSet.getInt("NUM");
                    list.add("" + n);
                }
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param)) != null) {
                int nSize = (currentPage - 1) * pageNumber;
                for (int i = 0; i < nSize; ++i) {
                    if (rowSet.next()) continue;
                    return null;
                }
                String[] strProcId = null;
                for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                    strProcId = new String[]{rowSet.getString("FLONGNUMBER"), rowSet.getString(strProcCatalogName), rowSet.getString("FPROCCOUNT"), rowSet.getString("FEXPIREDPROCCOUNT"), ProcessCenterUtil.getDateHour(rowSet.getInt("FAVGPROCTIMECONSUMING"))};
                    for (int j = 0; j < 5; ++j) {
                        if (strProcId[j] != null) continue;
                        strProcId[j] = "";
                    }
                    list.add(strProcId);
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, sqlException);
        }
        return list;
    }

    private String getAdminOrgName(Context ctx, String longnumber) {
        String name = "";
        Locale locale = ctx != null ? ctx.getLocale() : null;
        int n = longnumber.indexOf("%");
        if (n > 0) {
            longnumber = longnumber.substring(0, n);
        }
        String name_label = "FName_" + locale;
        String sql = "select " + name_label + " from T_ORG_ADMIN where FLONGNUMBER ='" + longnumber + "'";
        IRowSet adminNameRow = null;
        try {
            adminNameRow = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (adminNameRow.next()) {
                name = adminNameRow.getString(name_label);
                if (n > 0) {
                    name = name + ResourceBase.getString((String)"com.kingdee.eas.cp.eip.pc.processresource", (String)"jiQiXiaJiZuZhi", (Locale)locale);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    private String getSolution(Context ctx) throws BOSException, EASBizException {
        IProcCatalogSolution solution = ProcCatalogSolutionFactory.getLocalInstance(ctx);
        String strCUID = ProcessCenterUtil.getCurrentCU(ctx);
        String strSolutionId = "";
        FilterItemInfo filterItem = new FilterItemInfo("CU", (Object)strCUID);
        FilterItemInfo filterItem1 = new FilterItemInfo("isDefault", (Object)"0");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(filterItem);
        filterInfo.getFilterItems().add(filterItem1);
        filterInfo.setMaskString(" #0 AND #1 ");
        if (solution.exists(filterInfo)) {
            strSolutionId = solution.getValue("select id where CU = '" + strCUID + "' and isDefault = 0 ").getId().toString();
        } else {
            filterInfo.getFilterItems().remove(filterItem1);
            FilterItemInfo filterItem2 = new FilterItemInfo("isDefault", (Object)"1");
            filterInfo.getFilterItems().add(filterItem2);
            if (solution.exists(filterInfo)) {
                strSolutionId = solution.getValue("select id where CU = '" + strCUID + "' and isDefault = 1 ").getId().toString();
            }
        }
        return strSolutionId;
    }

    @Override
    protected ArrayList _statAllProcDetailByOrgAndCatalog(Context ctx, String orgUnitID, String catalogLongnumber, String startTime, String endTime, int currentPage, int pageNumber, String sortFieldName, String sortType) throws BOSException, EASBizException {
        Locale locale;
        ArrayList<Object> list = null;
        Locale locale2 = locale = ctx != null ? ctx.getLocale() : null;
        if (orgUnitID == null || orgUnitID.equals("") || startTime == null || startTime.equals("") || endTime == null || endTime.equals("") || catalogLongnumber == null || catalogLongnumber.equals("")) {
            return list;
        }
        Timestamp startimetimestamp = Timestamp.valueOf(startTime + " 00:00:00.0");
        Timestamp endtimetimestamp = Timestamp.valueOf(endTime + " 00:00:00.0");
        StringBuffer strSql = new StringBuffer();
        StringBuffer strCountSql = new StringBuffer();
        String strProcessName = "FPROCDEFNAME_" + ctx.getLocale().toString();
        String strInitiatorName = "FINITIATORNAME_" + ctx.getLocale().toString();
        strCountSql.append(" select count(*) NUM from V_PC_AllPROCSTATDETAIL ");
        strCountSql.append(" where FLONGNUMBER like ? and ");
        strCountSql.append(" datediff(day,FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0 ");
        strCountSql.append(" and FPROCLNUMBER like ? ");
        strSql.append(" select FPROCDEFID,FLONGNUMBER,").append(strProcessName).append(",").append(strInitiatorName);
        strSql.append(" ,FPROCTIMECONSUMING").append(",case when FWORKINGTIME <= 0 then 0 when  FOVERTIME > 0  then 1 end FOVERTIME ,FSTATE");
        strSql.append(" from V_PC_AllPROCSTATDETAIL ");
        strSql.append(" where FLONGNUMBER like ? and ");
        strSql.append(" datediff(day,FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0 ");
        strSql.append(" and FPROCLNUMBER like ? ");
        Object[] param = new Object[]{orgUnitID, catalogLongnumber + "%"};
        if (sortFieldName == null || sortFieldName.length() == 0) {
            sortFieldName = strProcessName;
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortFieldName).append(" ").append(sortType);
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (pageNumber < 1) {
            pageNumber = 20;
        }
        logger.debug((Object)("==org==" + orgUnitID + "==startTime===" + startTime + "===endTime===" + endTime + "===catalogID==" + catalogLongnumber));
        logger.debug((Object)("===countSql===_statAllProcDetailByOrgAndCatalog====" + strCountSql.toString()));
        logger.debug((Object)("===strSql===_statAllProcDetailByOrgAndCatalog====" + strSql.toString()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strCountSql.toString(), (Object[])param);
        try {
            if (rowSet != null) {
                list = new ArrayList<Object>();
                if (rowSet.next()) {
                    int n = rowSet.getInt("NUM");
                    list.add("" + n);
                }
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param)) != null) {
                int nSize = (currentPage - 1) * pageNumber;
                for (int i = 0; i < nSize; ++i) {
                    if (rowSet.next()) continue;
                    return null;
                }
                String[] strProcId = null;
                for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                    strProcId = new String[]{rowSet.getString("FPROCDEFID"), rowSet.getString(strProcessName), rowSet.getString(strInitiatorName), ProcessCenterUtil.getDateHour(rowSet.getInt("FPROCTIMECONSUMING")), rowSet.getInt("FOVERTIME") > 0 ? EASCommonResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"yes", (Locale)locale) : EASCommonResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"no", (Locale)locale), WfState.getEnum((String)rowSet.getString("FSTATE")).getAlias()};
                    for (int j = 0; j < 6; ++j) {
                        if (strProcId[j] != null) continue;
                        strProcId[j] = "";
                    }
                    list.add(strProcId);
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, sqlException);
        }
        return list;
    }

    @Override
    protected ArrayList _statActEfficency(Context ctx, String orgUnitID, String procDefID, String startDate, String endDate, int currentPage, int pageNumber, String sortFieldName, String sortType) throws BOSException, EASBizException {
        ArrayList<Object> list = null;
        logger.info((Object)("begin to _statActEfficency time :" + System.currentTimeMillis()));
        if (orgUnitID == null || orgUnitID.equals("") || procDefID == null || procDefID.equals("") || startDate == null || startDate.equals("") || endDate == null || endDate.equals("")) {
            return list;
        }
        ArrayList childProcessID = new ArrayList();
        this.getChildProcessId(ctx, procDefID, childProcessID);
        Timestamp startime = Timestamp.valueOf(startDate + " 00:00:00.0");
        Timestamp endtime = Timestamp.valueOf(endDate + " 00:00:00.0");
        StringBuffer strSql = new StringBuffer();
        StringBuffer strCountSql = new StringBuffer();
        String strActdefName = "FACTDEFNAME_" + ctx.getLocale().toString();
        String strPersonName = "FPERSONNAME_" + ctx.getLocale().toString();
        String strProcessName = "FPROCDEFNAME_" + ctx.getLocale().toString();
        strCountSql.append(" select count(*) NUM from (select B.FACTDEFID from V_PC_ACTEFFICENCYDETAILSTAT B");
        strCountSql.append(" where B.FLONGNUMBER like ? and (B.FPROCDEFID = ? ");
        int childCount = childProcessID.size();
        Object[] paramCount = new Object[childCount + 2];
        paramCount[0] = orgUnitID;
        paramCount[1] = procDefID;
        Iterator iteratorChild = childProcessID.iterator();
        int xunHuanBianLiang = 2;
        while (iteratorChild.hasNext()) {
            strCountSql.append(" or B.FPROCDEFID = ? ");
            paramCount[xunHuanBianLiang++] = iteratorChild.next();
        }
        strCountSql.append(") and datediff(day,B.FCREATEDTIME,TO_DATE('" + startime + "') )<=0 and datediff(day,B.FCREATEDTIME,TO_DATE('" + endtime + "') )>=0 ");
        strCountSql.append(" group by B.FACTDEFID, B.FWORKINGTIME ) A ");
        strSql.append(" select B.FPROCDEFID,B.FACTDEFID, (Select TOP 1 A.").append(strActdefName).append(" from V_PC_ACTEFFICENCYDETAILSTAT A ");
        strSql.append(" where A.FACTDEFID = B.FACTDEFID and A.FLONGNUMBER like ? and (A.FPROCDEFID = ? ");
        iteratorChild = childProcessID.iterator();
        Object[] param = new Object[3 * (childCount + 2)];
        param[0] = orgUnitID;
        param[1] = procDefID;
        xunHuanBianLiang = 2;
        while (iteratorChild.hasNext()) {
            strSql.append(" or A.FPROCDEFID = ? ");
            param[xunHuanBianLiang++] = iteratorChild.next();
        }
        strSql.append(") and datediff(day,A.FCREATEDTIME,TO_DATE('" + startime + "') )<=0 and datediff(day,A.FCREATEDTIME,TO_DATE('" + endtime + "') )>=0) AS ");
        strSql.append(strActdefName).append(",(Select TOP 1 A.").append(strProcessName).append(" from V_PC_ACTEFFICENCYDETAILSTAT A ");
        strSql.append(" where A.FACTDEFID = B.FACTDEFID and A.FLONGNUMBER like ? and (A.FPROCDEFID = ? ");
        param[xunHuanBianLiang++] = orgUnitID;
        param[xunHuanBianLiang++] = procDefID;
        iteratorChild = childProcessID.iterator();
        while (iteratorChild.hasNext()) {
            strSql.append(" or A.FPROCDEFID = ? ");
            param[xunHuanBianLiang++] = iteratorChild.next();
        }
        strSql.append(") and datediff(day,A.FCREATEDTIME,TO_DATE('" + startime + "') )<=0 and datediff(day,A.FCREATEDTIME,TO_DATE('" + endtime + "') )>=0) AS ");
        strSql.append(strProcessName).append(", B.FWORKINGTIME,");
        strSql.append(" avg(B.FACTTIMECONSUMING) AS FAVGACTTIMECONSUMING, ");
        strSql.append(" max(B.FACTTIMECONSUMING) AS FMAXACTTIMECONSUMING, ");
        strSql.append(" min(B.FACTTIMECONSUMING) AS FMINACTTIMECONSUMING ");
        strSql.append(" from V_PC_ACTEFFICENCYDETAILSTAT B ");
        strSql.append(" where B.FLONGNUMBER like ? and (B.FPROCDEFID = ? ");
        iteratorChild = childProcessID.iterator();
        param[xunHuanBianLiang++] = orgUnitID;
        param[xunHuanBianLiang++] = procDefID;
        while (iteratorChild.hasNext()) {
            strSql.append(" or B.FPROCDEFID = ? ");
            param[xunHuanBianLiang++] = iteratorChild.next();
        }
        strSql.append(") and datediff(day,B.FCREATEDTIME,TO_DATE('" + startime + "') )<=0 and datediff(day,B.FCREATEDTIME,TO_DATE('" + endtime + "') )>=0 ");
        strSql.append(" group by B.FPROCDEFID,B.FACTDEFID, B.FWORKINGTIME ");
        if (sortFieldName == null || sortFieldName.length() == 0) {
            sortFieldName = "B.FACTDEFID";
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortFieldName).append(" ").append(sortType);
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (pageNumber < 1) {
            pageNumber = 20;
        }
        logger.debug((Object)("===countSql===_statActEfficency====" + strCountSql.toString()));
        logger.debug((Object)("===strSql===_statActEfficency====" + strSql.toString()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strCountSql.toString(), (Object[])paramCount);
        try {
            if (rowSet != null) {
                list = new ArrayList<Object>();
                if (rowSet.next()) {
                    int n = rowSet.getInt("NUM");
                    list.add("" + n);
                }
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param)) != null) {
                int nSize = (currentPage - 1) * pageNumber;
                for (int i = 0; i < nSize; ++i) {
                    if (rowSet.next()) continue;
                    return null;
                }
                String[] strActId = null;
                for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                    strActId = new String[10];
                    strActId[9] = rowSet.getString("FPROCDEFID");
                    strActId[1] = rowSet.getString(strProcessName);
                    strActId[0] = rowSet.getString("FACTDEFID");
                    strActId[2] = rowSet.getString(strActdefName);
                    strActId[3] = rowSet.getString("FWORKINGTIME");
                    strActId[4] = ProcessCenterUtil.getDateHour(rowSet.getInt("FAVGACTTIMECONSUMING"));
                    int maxTimeParm = rowSet.getInt("FMAXACTTIMECONSUMING");
                    int minTimeParm = rowSet.getInt("FMINACTTIMECONSUMING");
                    strActId[7] = ProcessCenterUtil.getDateHour(maxTimeParm);
                    strActId[5] = ProcessCenterUtil.getDateHour(minTimeParm);
                    StringBuffer sqlForMaxOrMinPerson = new StringBuffer();
                    sqlForMaxOrMinPerson.append(" select ").append(strPersonName).append(" from V_PC_ACTEFFICENCYDETAILSTAT ");
                    sqlForMaxOrMinPerson.append(" where FACTTIMECONSUMING = ? and  FACTDEFID = ? and ");
                    sqlForMaxOrMinPerson.append(" FLONGNUMBER like ? and FPROCDEFID = ? ");
                    sqlForMaxOrMinPerson.append(" and datediff(day,FCREATEDTIME,TO_DATE('" + startime + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtime + "') )>=0");
                    Object[] paramMax = new Object[]{new Integer(maxTimeParm), strActId[0], orgUnitID, strActId[9]};
                    IRowSet rowSetMax = DbUtil.executeQuery((Context)ctx, (String)sqlForMaxOrMinPerson.toString(), (Object[])paramMax);
                    strActId[8] = "";
                    if (rowSetMax != null) {
                        while (rowSetMax.next()) {
                            if (strActId[8] == "") {
                                strActId[8] = rowSetMax.getString(1);
                                continue;
                            }
                            strActId[8] = strActId[8] + "," + rowSetMax.getString(1);
                        }
                    }
                    Object[] paramMin = new Object[]{new Integer(minTimeParm), strActId[0], orgUnitID, strActId[9]};
                    IRowSet rowSetMin = DbUtil.executeQuery((Context)ctx, (String)sqlForMaxOrMinPerson.toString(), (Object[])paramMin);
                    strActId[6] = "";
                    if (rowSetMin != null) {
                        while (rowSetMin.next()) {
                            if (strActId[6] == "") {
                                strActId[6] = rowSetMin.getString(1);
                                continue;
                            }
                            strActId[6] = strActId[6] + "," + rowSetMin.getString(1);
                        }
                    }
                    for (int j = 0; j < 10; ++j) {
                        if (strActId[j] != null) continue;
                        strActId[j] = "";
                    }
                    list.add(strActId);
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, sqlException);
        }
        return list;
    }

    private String getProcdefName(Context ctx, String procDefID) {
        String name = "";
        Locale locale = ctx != null ? ctx.getLocale() : null;
        String name_label = "FName_" + locale;
        String sql = "select " + name_label + " from T_WFR_PROCDEF where FPROCDEFID = '" + procDefID + "'";
        IRowSet processNameRow = null;
        try {
            processNameRow = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (processNameRow.next()) {
                name = processNameRow.getString(name_label);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    private void getChildProcessId(Context ctx, String procDefID, List list) throws BOSException {
        IEnactmentService service = (IEnactmentService)BOSObjectFactory.createBOSObject((Context)ctx, (String)"com.kingdee.bos.workflow.service.EnactmentServiceProxy");
        logger.debug((Object)("-----------------procdefid------------------:" + procDefID));
        ProcessDefInfo info = service.getProcessDefInfo(procDefID);
        if (info == null) {
            return;
        }
        if (info.getMd5HashValue() == null) {
            return;
        }
        logger.debug((Object)("-----------------info.getMd5HashValue()------------------:" + info.getMd5HashValue()));
        ProcessDef procDef = service.getProcessDefByDefineHashValue(info.getMd5HashValue());
        ActivityCollection subCol = procDef.getActivitys(ActivityType.SUBFLOW);
        int size = subCol.size();
        for (int i = 0; i < size; ++i) {
            SubflowActivityDef subAci = (SubflowActivityDef)subCol.get(i);
            String childProcID = subAci.getSubflowId();
            list.add(childProcID);
            this.getChildProcessId(ctx, childProcID, list);
        }
    }

    @Override
    protected ArrayList _statActEfficencyDetail(Context ctx, String orgUnitID, String procDefID, String actDefID, String startDate, String endDate, int currentPage, int pageNumber, String sortFieldName, String sortType) throws BOSException, EASBizException {
        ArrayList<Object> list = null;
        if (orgUnitID == null || orgUnitID.equals("") || procDefID == null || procDefID.equals("") || startDate == null || startDate.equals("") || endDate == null || endDate.equals("")) {
            return list;
        }
        StringBuffer strSql = new StringBuffer();
        StringBuffer strCountSql = new StringBuffer();
        Timestamp startime = Timestamp.valueOf(startDate + " 00:00:00.0");
        Timestamp endtime = Timestamp.valueOf(endDate + " 00:00:00.0");
        String strPersonName = "FNAME_" + ctx.getLocale().toString();
        strCountSql.append(" select count(*) NUM from (select A.FPERSONID from V_PC_ACTEFFICENCYDETAILSTAT A");
        strCountSql.append(" where A.FLONGNUMBER like ? and A.FPROCDEFID = ? and A.FACTDEFID = ? ");
        strCountSql.append(" and datediff(day,A.FCREATEDTIME,TO_DATE('" + startime + "') )<=0 and datediff(day,A.FCREATEDTIME,TO_DATE('" + endtime + "') )>=0 ");
        strCountSql.append(" group by A.FPERSONID ) B ");
        strSql.append(" select (Select TOP 1 A.").append(strPersonName).append(" from T_BD_PERSON A ");
        strSql.append(" where A.FID = B.FPERSONID ) AS ").append(strPersonName);
        strSql.append(" ,avg(B.FACTTIMECONSUMING) AS FAVGACTTIMECONSUMING, ");
        strSql.append(" max(B.FACTTIMECONSUMING) AS FMAXACTTIMECONSUMING, ");
        strSql.append(" min(B.FACTTIMECONSUMING) AS FMINACTTIMECONSUMING ");
        strSql.append(" from V_PC_ACTEFFICENCYDETAILSTAT B ");
        strSql.append(" where B.FLONGNUMBER like ? and B.FPROCDEFID = ? and B.FACTDEFID = ? ");
        strSql.append(" and datediff(day,B.FCREATEDTIME,TO_DATE('" + startime + "') )<=0 and datediff(day,B.FCREATEDTIME,TO_DATE('" + endtime + "') )>=0 ");
        strSql.append(" group by B.FPERSONID ");
        Object[] param = new Object[]{orgUnitID, procDefID, actDefID};
        if (sortFieldName == null || sortFieldName.length() == 0) {
            sortFieldName = strPersonName;
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortFieldName).append(" ").append(sortType);
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (pageNumber < 1) {
            pageNumber = 20;
        }
        logger.debug((Object)("===countSql===_statActEfficencyDetail====" + strCountSql.toString()));
        logger.debug((Object)("===strSql===_statActEfficencyDetail====" + strSql.toString()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strCountSql.toString(), (Object[])param);
        try {
            if (rowSet != null) {
                list = new ArrayList<Object>();
                if (rowSet.next()) {
                    int n = rowSet.getInt("NUM");
                    list.add("" + n);
                }
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param)) != null) {
                int nSize = (currentPage - 1) * pageNumber;
                for (int i = 0; i < nSize; ++i) {
                    if (rowSet.next()) continue;
                    return null;
                }
                String[] strActId = null;
                for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                    strActId = new String[8];
                    strActId[0] = rowSet.getString(strPersonName);
                    strActId[1] = ProcessCenterUtil.getDateHour(rowSet.getInt("FAVGACTTIMECONSUMING"));
                    strActId[2] = ProcessCenterUtil.getDateHour(rowSet.getInt("FMAXACTTIMECONSUMING"));
                    strActId[3] = ProcessCenterUtil.getDateHour(rowSet.getInt("FMINACTTIMECONSUMING"));
                    for (int j = 0; j < 4; ++j) {
                        if (strActId[j] != null) continue;
                        strActId[j] = "";
                    }
                    list.add(strActId);
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, sqlException);
        }
        return list;
    }

    @Override
    protected boolean _isProcessAdmin(Context ctx, String orgid) throws BOSException, EASBizException {
        boolean isAdmin = false;
        if (orgid == null) {
            orgid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        isAdmin = ProcessCenterWebUtil.isProcessAdmin(ctx, orgid);
        return isAdmin;
    }

    @Override
    protected ArrayList _statAllProcessByOrgUnitForChart(Context ctx, String orgUnit, String startTime, String endTime, String sortFiled, String sortType) throws BOSException, EASBizException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (orgUnit == null || orgUnit.equals("") || startTime == null || startTime.equals("") || endTime == null || endTime.equals("")) {
            return list;
        }
        String adminOrgName = this.getAdminOrgName(ctx, orgUnit);
        Timestamp startimetimestamp = Timestamp.valueOf(startTime + " 00:00:00.0");
        Timestamp endtimetimestamp = Timestamp.valueOf(endTime + " 00:00:00.0");
        StringBuffer strSql = new StringBuffer();
        String strProcCatalogName = "FNAME_" + ctx.getLocale().toString();
        strSql.append(" select A.FLONGNUMBER, A.").append(strProcCatalogName).append(", isnull( B.FPROCCOUNT, 0) FPROCCOUNT, ");
        strSql.append(" isnull( B.FEXPIREDPROCCOUNT, 0) FEXPIREDPROCCOUNT, ");
        strSql.append(" isnull( B.FAVGPROCTIMECONSUMING, 0) FAVGPROCTIMECONSUMING ");
        strSql.append(" from ( select C.FPROCLNUMBER NUMBER, COUNT(*) FPROCCOUNT, ");
        strSql.append(" ( sum( case when C.FWORKINGTIME <= 0 then 0 when  C.FOVERTIME > 0  then 1 end)) FEXPIREDPROCCOUNT, ");
        strSql.append(" avg(C.FPROCTIMECONSUMING) FAVGPROCTIMECONSUMING ");
        strSql.append(" from (select left(FPROCLNUMBER,35) FPROCLNUMBER,FWORKINGTIME,FOVERTIME,FPROCTIMECONSUMING  FROM V_PC_AllPROCSTATDETAIL");
        strSql.append(" where FLONGNUMBER like ? and ");
        strSql.append(" datediff(day,FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0 ");
        strSql.append(") C");
        strSql.append(" where  len(C.FPROCLNUMBER) = 35");
        strSql.append(" group by FPROCLNUMBER ) B right outer join ");
        strSql.append(" (select flongnumber,").append(strProcCatalogName).append(",fsolutionid from t_pc_proccatalog ");
        strSql.append("where len(flongnumber) = 35) A ON A.FLONGNUMBER = B.NUMBER ");
        strSql.append(" WHERE (A.FSOLUTIONID = ? )");
        Object[] param = new Object[]{orgUnit, this.getSolution(ctx)};
        if (sortFiled == null || sortFiled.length() == 0) {
            sortFiled = "A." + strProcCatalogName;
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortFiled).append(" ").append(sortType);
        logger.debug((Object)("_statAllProcessByOrgUnitForChart strSql = " + strSql.toString()));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param);
            if (rowSet != null) {
                String[] strProcId = null;
                while (rowSet.next()) {
                    strProcId = new String[]{rowSet.getString("FLONGNUMBER"), rowSet.getString(strProcCatalogName), rowSet.getString("FPROCCOUNT"), rowSet.getString("FEXPIREDPROCCOUNT"), String.valueOf(rowSet.getInt("FAVGPROCTIMECONSUMING"))};
                    for (int j = 0; j < 5; ++j) {
                        if (strProcId[j] != null) continue;
                        strProcId[j] = "";
                    }
                    list.add(strProcId);
                }
            }
            if (adminOrgName == null) {
                adminOrgName = "";
            }
            list.add(adminOrgName);
        }
        catch (SQLException sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, sqlException);
        }
        return list;
    }

    @Override
    protected ArrayList _statActEfficencyForChart(Context ctx, String orgUnit, String proDef, String startTime, String endTime, String sortField, String sortTyep) throws BOSException, EASBizException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (orgUnit == null || orgUnit.equals("") || proDef == null || proDef.equals("") || startTime == null || startTime.equals("") || endTime == null || endTime.equals("")) {
            return list;
        }
        ArrayList childProcessID = new ArrayList();
        this.getChildProcessId(ctx, proDef, childProcessID);
        String processName = this.getProcdefName(ctx, proDef);
        StringBuffer strSql = new StringBuffer();
        Timestamp startimetimestamp = Timestamp.valueOf(startTime + " 00:00:00.0");
        Timestamp endtimetimestamp = Timestamp.valueOf(endTime + " 00:00:00.0");
        String strActdefName = "FACTDEFNAME_" + ctx.getLocale().toString();
        String strProcessName = "FPROCDEFNAME_" + ctx.getLocale().toString();
        strSql.append(" select B.FACTDEFID, (Select TOP 1 A.").append(strActdefName).append(" from V_PC_ACTEFFICENCYDETAILSTAT A ");
        strSql.append(" where A.FACTDEFID = B.FACTDEFID and A.FLONGNUMBER like ? and (A.FPROCDEFID = ? ");
        int childCount = childProcessID.size();
        Iterator iteratorChild = childProcessID.iterator();
        Object[] param = new Object[3 * (childCount + 2)];
        param[0] = orgUnit;
        param[1] = proDef;
        int xunHuanBianLiang = 2;
        while (iteratorChild.hasNext()) {
            strSql.append(" or A.FPROCDEFID = ? ");
            param[xunHuanBianLiang++] = iteratorChild.next();
        }
        strSql.append(") and datediff(day,A.FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,A.FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0) AS ");
        strSql.append(strActdefName).append(", (Select TOP 1 A.").append(strProcessName).append(" from V_PC_ACTEFFICENCYDETAILSTAT A ");
        strSql.append(" where A.FACTDEFID = B.FACTDEFID and A.FLONGNUMBER like ? and (A.FPROCDEFID = ? ");
        iteratorChild = childProcessID.iterator();
        param[xunHuanBianLiang++] = orgUnit;
        param[xunHuanBianLiang++] = proDef;
        while (iteratorChild.hasNext()) {
            strSql.append(" or A.FPROCDEFID = ? ");
            param[xunHuanBianLiang++] = iteratorChild.next();
        }
        strSql.append(") and datediff(day,A.FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,A.FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0) AS ");
        strSql.append(strProcessName).append(", B.FWORKINGTIME,");
        strSql.append(" avg(B.FACTTIMECONSUMING) AS FAVGACTTIMECONSUMING, ");
        strSql.append(" max(B.FACTTIMECONSUMING) AS FMAXACTTIMECONSUMING, ");
        strSql.append(" min(B.FACTTIMECONSUMING) AS FMINACTTIMECONSUMING ");
        strSql.append(" from V_PC_ACTEFFICENCYDETAILSTAT B ");
        strSql.append(" where B.FLONGNUMBER like ? and (B.FPROCDEFID = ? ");
        iteratorChild = childProcessID.iterator();
        param[xunHuanBianLiang++] = orgUnit;
        param[xunHuanBianLiang++] = proDef;
        while (iteratorChild.hasNext()) {
            strSql.append(" or B.FPROCDEFID = ? ");
            param[xunHuanBianLiang++] = iteratorChild.next();
        }
        strSql.append(") and datediff(day,B.FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,B.FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0 ");
        strSql.append(" group by B.FACTDEFID, B.FWORKINGTIME ");
        if (sortField == null || sortField.length() == 0) {
            sortField = "B.FACTDEFID";
        }
        if (sortTyep == null || sortTyep.length() == 0) {
            sortTyep = "desc";
        }
        strSql.append(" order by ").append(sortField).append(" ").append(sortTyep);
        logger.debug((Object)("_statAllProcessByOrgUnitForChart strSql = " + strSql.toString()));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param);
            if (rowSet != null) {
                while (rowSet.next()) {
                    String[] strActId = new String[]{childProcessID.size() > 0 ? rowSet.getString(strProcessName) + ":" + rowSet.getString(strActdefName) : rowSet.getString(strActdefName), String.valueOf(rowSet.getInt("FAVGACTTIMECONSUMING"))};
                    for (int j = 0; j < 2; ++j) {
                        if (strActId[j] != null) continue;
                        strActId[j] = "";
                    }
                    list.add(strActId);
                }
            }
            if (processName == null) {
                processName = "";
            }
            list.add(processName);
        }
        catch (SQLException sqlException) {
            logger.error((Object)"sqlexception:", (Throwable)sqlException);
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, sqlException);
        }
        return list;
    }

    @Override
    protected void _statAllProcess(Context ctx, String orgID) throws BOSException, EASBizException {
    }

    @Override
    protected ArrayList _statPersonProcess(Context ctx, String userId, String startTime, String endTime, int currentPage, int pageNumber, String sortFieldName, String sortType, String processArea) throws BOSException, EASBizException {
        ArrayList<Object> list = null;
        if (userId == null || userId.equals("") || startTime == null || startTime.equals("") || endTime == null || endTime.equals("")) {
            return list;
        }
        StringBuffer strSql = new StringBuffer();
        StringBuffer strCountSql = new StringBuffer();
        Timestamp startimetimestamp = Timestamp.valueOf(startTime + " 00:00:00.0");
        Timestamp endtimetimestamp = Timestamp.valueOf(endTime + " 00:00:00.0");
        String strProcName = "FNAME_" + ctx.getLocale().toString();
        strCountSql.append(" select count(*) NUM ");
        strCountSql.append(" from (");
        strCountSql.append(" select DISTINCT sum(CASE WHEN FOVERTIME <= 0 THEN 1 ELSE 0 END) AS FNOEXPIRED, ");
        strCountSql.append(" SUM(CASE WHEN FOVERTIME > 0 THEN 1 ELSE 0 END) AS FEXPIRED, ");
        strCountSql.append(" avg(FPROCTIMECONSUMING) AS FAVGPROCTIMECONSUMING, ");
        strCountSql.append(" max(FPROCTIMECONSUMING) AS FMAXPROCTIMECONSUMING, ");
        strCountSql.append(" min(FPROCTIMECONSUMING) AS FMINPROCTIMECONSUMING, ");
        strCountSql.append(" FPROCDEFID ");
        strCountSql.append(" from V_PC_PERSONPROCSTATDETAIL ");
        strCountSql.append(" where FPARTICIPATORID = ? and ");
        strCountSql.append(" datediff(day,FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0 ");
        strCountSql.append(" GROUP BY FPROCDEFID) B INNER JOIN (select DISTINCT bb.FPROCDEFID from T_WFR_ProcDef bb join ( select FPROCDEFID,");
        strCountSql.append(" max(FINNERVERSION ) v from T_WFR_ProcDef  where fenable=1 ");
        if (processArea != null && processArea.length() > 0) {
            processArea = processArea.replaceAll(",", "','");
            processArea = "'" + processArea + "'";
            strCountSql.append(" and FPROCDEFID in (" + processArea + ")");
        }
        strCountSql.append("group by FPROCDEFID ) cc on bb.FPROCDEFID=cc.FPROCDEFID) A ");
        strCountSql.append(" ON A.FPROCDEFID = B.FPROCDEFID ");
        strSql.append(" select DISTINCT A.FPROCDEFID, A.").append(strProcName).append(",B.FNOEXPIRED,B.FEXPIRED,");
        strSql.append(" B.FAVGPROCTIMECONSUMING,B.FMAXPROCTIMECONSUMING,B.FMINPROCTIMECONSUMING ");
        strSql.append(" from (");
        strSql.append(" select DISTINCT sum(CASE WHEN FOVERTIME <= 0 THEN 1 ELSE 0 END) AS FNOEXPIRED, ");
        strSql.append(" SUM(CASE WHEN FOVERTIME > 0 THEN 1 ELSE 0 END) AS FEXPIRED, ");
        strSql.append(" avg(FPROCTIMECONSUMING) AS FAVGPROCTIMECONSUMING, ");
        strSql.append(" max(FPROCTIMECONSUMING) AS FMAXPROCTIMECONSUMING, ");
        strSql.append(" min(FPROCTIMECONSUMING) AS FMINPROCTIMECONSUMING, ");
        strSql.append(" FPROCDEFID ");
        strSql.append(" from V_PC_PERSONPROCSTATDETAIL ");
        strSql.append(" where FPARTICIPATORID = ? and ");
        strSql.append(" datediff(day,FCREATEDTIME,TO_DATE('" + startimetimestamp + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtimetimestamp + "') )>=0 ");
        strSql.append(" GROUP BY FPROCDEFID) B INNER JOIN (select bb.FPROCDEFID,bb." + strProcName + " from T_WFR_ProcDef bb join ( select FPROCDEFID,");
        strSql.append(" max(FINNERVERSION ) v from T_WFR_ProcDef  where fenable=1 ");
        if (processArea != null && processArea.length() > 0) {
            strSql.append(" and FPROCDEFID in (" + processArea + ")");
        }
        strSql.append("group by FPROCDEFID ) cc on bb.FPROCDEFID=cc.FPROCDEFID) A ");
        strSql.append(" ON A.FPROCDEFID = B.FPROCDEFID ");
        Object[] param = null;
        param = new Object[]{userId};
        if (sortFieldName == null || sortFieldName.length() == 0) {
            sortFieldName = "A." + strProcName;
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortFieldName).append(" ").append(sortType);
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (pageNumber < 1) {
            pageNumber = 20;
        }
        logger.debug((Object)("==startTime===" + startTime + "===endTime===" + endTime + "===userid==" + userId));
        logger.debug((Object)("===countSql===_statPersonProcess====" + strCountSql.toString()));
        logger.debug((Object)("===strSql===_statPersonProcess====" + strSql.toString()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strCountSql.toString(), (Object[])param);
        try {
            if (rowSet != null) {
                list = new ArrayList<Object>();
                if (rowSet.next()) {
                    int n = rowSet.getInt("NUM");
                    list.add("" + n);
                }
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])param)) != null) {
                int nSize = (currentPage - 1) * pageNumber;
                for (int i = 0; i < nSize; ++i) {
                    if (rowSet.next()) continue;
                    return null;
                }
                String[] strProcId = null;
                for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                    strProcId = new String[]{rowSet.getString("FPROCDEFID"), rowSet.getString(strProcName), rowSet.getString("FNOEXPIRED"), rowSet.getString("FEXPIRED"), ProcessCenterUtil.getDateHour(rowSet.getInt("FAVGPROCTIMECONSUMING")), ProcessCenterUtil.getDateHour(rowSet.getInt("FMAXPROCTIMECONSUMING")), ProcessCenterUtil.getDateHour(rowSet.getInt("FMINPROCTIMECONSUMING"))};
                    for (int j = 0; j < 7; ++j) {
                        if (strProcId[j] != null) continue;
                        strProcId[j] = "";
                    }
                    list.add(strProcId);
                }
            }
        }
        catch (SQLException sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, sqlException);
        }
        return list;
    }

    protected List _statOrgEfficencyDetail(Context ctx, String adminLongnumber, String procDefID) throws BOSException, EASBizException {
        return null;
    }

    private void getActdefByProc(Context ctx, String procDefID, List list) throws BOSException {
        IEnactmentService service = (IEnactmentService)BOSObjectFactory.createBOSObject((Context)ctx, (String)"com.kingdee.bos.workflow.service.EnactmentServiceProxy");
        logger.debug((Object)("-----------------procdefid------------------:" + procDefID));
        ProcessDefInfo info = service.getProcessDefInfo(procDefID);
        if (info == null) {
            return;
        }
        ProcessDef procDef = service.getProcessDefByDefineHashValue(info.getMd5HashValue());
        ActivityCollection activityCol = procDef.getActivitys();
        int size = activityCol.size();
        for (int i = 0; i < size; ++i) {
            ActivityDef activity = activityCol.get(i);
            if (activity instanceof SubflowActivityDef) {
                SubflowActivityDef subAci = (SubflowActivityDef)activity;
                String childProcID = subAci.getSubflowId();
                this.getActdefByProc(ctx, childProcID, list);
            }
            String actdefid = activity.getID();
            list.add(actdefid);
        }
    }

    @Override
    protected ArrayList _statOrgEfficency(Context ctx, List adminLongNumberList, List adminNameList, String procdefID, String startTime, String endTime, int currentPage, int pageNumber, String sortField, String sortType) throws BOSException, EASBizException {
        Timestamp startime = Timestamp.valueOf(startTime + " 00:00:00.0");
        Timestamp endtime = Timestamp.valueOf(endTime + " 00:00:00.0");
        HashMap<String, Integer[]> valueMap = new HashMap<String, Integer[]>();
        ArrayList actdefList = new ArrayList();
        ArrayList actdefNameList = new ArrayList();
        if (procdefID == null || procdefID.trim().length() < 1) {
            return null;
        }
        ArrayList childProcessID = new ArrayList();
        this.getChildProcessId(ctx, procdefID, childProcessID);
        ProcessCenterWebUtil.getActdefByProc(ctx, procdefID, actdefList, actdefNameList, true, true);
        for (String adminlongnumber : adminLongNumberList) {
            for (String actdefID : actdefList) {
                Integer[] value = new Integer[]{new Integer(0), new Integer(0)};
                valueMap.put(adminlongnumber + "," + actdefID, value);
            }
        }
        String orgName = "FADMINORGNAME_" + ctx.getLocale();
        String procDefName = "FACTDEFNAME_" + ctx.getLocale();
        StringBuffer sql = new StringBuffer("SELECT FADMINORGID, ");
        sql.append(orgName).append(", FLongNumber, FACTDEFID, FACTTIMECONSUMING,").append(procDefName).append(" FROM V_PC_ActEfficencyDetailStat where (");
        Iterator longnumberItertator = adminLongNumberList.iterator();
        Object[] param = new Object[adminLongNumberList.size() + childProcessID.size() + 1];
        int paramIndex = 0;
        while (longnumberItertator.hasNext()) {
            String tempLongnumber = (String)longnumberItertator.next() + "%";
            if (paramIndex == 0) {
                sql.append(" FLongNumber like ?");
            } else {
                sql.append(" or FLongNumber like ?");
            }
            param[paramIndex++] = tempLongnumber;
        }
        sql.append(") and ( FPROCDEFID = ?");
        param[paramIndex++] = procdefID;
        Iterator procDefIdIterator = childProcessID.iterator();
        int startIndex = paramIndex;
        while (procDefIdIterator.hasNext()) {
            String tempprocdef = (String)procDefIdIterator.next();
            sql.append(" or FPROCDEFID = ?");
            param[paramIndex++] = tempprocdef;
        }
        sql.append(") and datediff(day,FCREATEDTIME,TO_DATE('" + startime + "') )<=0 and datediff(day,FCREATEDTIME,TO_DATE('" + endtime + "') )>=0");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (row.next()) {
                String orgLongnumber = row.getString("FLongNumber");
                String actdefid = row.getString("FACTDEFID");
                int acttimeconfuming = row.getInt("FACTTIMECONSUMING");
                for (String adminlongnumber : adminLongNumberList) {
                    Integer[] value;
                    if (!orgLongnumber.startsWith(adminlongnumber)) continue;
                    String key = orgLongnumber + "," + actdefid;
                    if (valueMap.containsKey(key)) {
                        value = (Integer[])valueMap.get(key);
                        value[0] = new Integer(value[0] + 1);
                        value[1] = new Integer(value[1] + acttimeconfuming);
                        valueMap.put(key, value);
                        continue;
                    }
                    value = new Integer[]{new Integer(0), new Integer(0)};
                    valueMap.put(key, value);
                }
            }
        }
        catch (SQLException SQLE) {
            logger.error((Object)"\u6d41\u7a0b\u90e8\u95e8\u7edf\u8ba1\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519", (Throwable)SQLE);
            throw new ProcCatalogException(ProcCatalogException.GETDATA_FORLEDGER_ERROR);
        }
        int startPageRow = pageNumber * (currentPage - 1);
        int actdefSize = actdefList.size() + 2;
        ArrayList<Object> returnList = new ArrayList<Object>();
        String[] rowValue = null;
        Iterator adminNameIterator = adminNameList.iterator();
        returnList.add(new Integer(adminNameList.size()));
        Iterator adminIterator = adminLongNumberList.iterator();
        while (adminIterator.hasNext()) {
            if (startPageRow <= 0) {
                String adminlongnumber = (String)adminIterator.next();
                String adminName = (String)adminNameIterator.next();
                rowValue = new String[actdefSize * 3 + 1];
                int j = 0;
                rowValue[j++] = adminName;
                for (String actdefID : actdefList) {
                    String key = adminlongnumber + "," + actdefID;
                    int avgWorkingTime = 0;
                    Integer[] value = (Integer[])valueMap.get(key);
                    if (value[0] != 0) {
                        avgWorkingTime = value[1] / value[0];
                        rowValue[j++] = ProcessCenterUtil.getDateHour(avgWorkingTime);
                        rowValue[j++] = ProcessCenterUtil.getDateHour(value[1]);
                        rowValue[j++] = String.valueOf(value[0]);
                        continue;
                    }
                    rowValue[j++] = "";
                    rowValue[j++] = "";
                    rowValue[j++] = "0";
                }
                rowValue[j++] = procdefID;
                returnList.add(rowValue);
                continue;
            }
            --startPageRow;
            adminIterator.next();
            adminNameIterator.next();
        }
        return returnList;
    }

    @Override
    protected ArrayList _statOrgEfficencyDetail(Context ctx, String adminLongnumber, String procDefID, String startTime, String endtime, int currentPage, int pageCount, String sortField, String sortType) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected ArrayList _statOrgEfficencyForChart(Context ctx, List adminLongnumberList, List adminNameList, String startTime, String endtime, int currencyNumber, int pageCount, String sortField, String sortType) throws BOSException, EASBizException {
        return null;
    }
}

