/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.SubSystemCollection;
import com.kingdee.eas.cp.base.SubSystemFactory;
import com.kingdee.eas.cp.sm.CurrentStateEnum;
import com.kingdee.eas.cp.sm.PriorityLevelEnum;
import com.kingdee.eas.cp.sm.SMBizException;
import com.kingdee.eas.cp.sm.SchedulePlanCollection;
import com.kingdee.eas.cp.sm.SchedulePlanFactory;
import com.kingdee.eas.cp.sm.SchedulePlanInfo;
import com.kingdee.eas.cp.sm.app.AbstractSchedulePlanFacadeControllerBean;
import com.kingdee.eas.cp.sm.util.ScheduleMessageHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class SchedulePlanFacadeControllerBean
extends AbstractSchedulePlanFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.sm.app.SchedulePlanFacadeControllerBean");

    protected boolean _addNewSchedulePlan(Context ctx, SchedulePlanInfo schedulePlan, Set personIds, BOSUuid billId) throws BOSException, EASBizException {
        boolean isSucceed = false;
        if (this.checkSMModuleEnable(ctx) && billId != null && personIds != null && schedulePlan != null) {
            this.validate(ctx, schedulePlan);
            SchedulePlanInfo tempSchedulePlan = (SchedulePlanInfo)schedulePlan.clone();
            this.initSchedulePlan(ctx, tempSchedulePlan, billId);
            for (BOSUuid personid : personIds) {
                PersonInfo person = new PersonInfo();
                SchedulePlanInfo tempSp = (SchedulePlanInfo)tempSchedulePlan.clone();
                person.setId(personid);
                tempSp.setPersonCreator(person);
                tempSp.setId(BOSUuid.create((BOSObjectType)new SchedulePlanInfo().getBOSType()));
                SchedulePlanFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)tempSp);
                ScheduleMessageHelper.sendMessageForAddNew(ctx, tempSp);
                ScheduleMessageHelper.createMessageBackgroundJob(ctx, tempSp);
            }
            isSucceed = true;
        }
        return isSucceed;
    }

    protected boolean[] _addNewSchedulePlans(Context ctx, SchedulePlanInfo[] schedulePlans, Set[] personIds, BOSUuid[] billIds) throws BOSException, EASBizException {
        boolean[] isSucceed = null;
        if (this.checkSMModuleEnable(ctx) && schedulePlans.length == personIds.length && personIds.length == billIds.length) {
            int i;
            for (i = 0; i < schedulePlans.length; ++i) {
                this.validate(ctx, schedulePlans[i]);
            }
            isSucceed = new boolean[schedulePlans.length];
            for (i = 0; i < schedulePlans.length; ++i) {
                isSucceed[i] = this._addNewSchedulePlan(ctx, schedulePlans[i], personIds[i], billIds[i]);
            }
        }
        return isSucceed;
    }

    protected boolean _updateSchedulePlan(Context ctx, SchedulePlanInfo schedulePlan, Set personIds, BOSUuid billId) throws BOSException, EASBizException {
        boolean isSucceed = false;
        if (this.checkSMModuleEnable(ctx) && billId != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billId.toString(), CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            SchedulePlanCollection spColl = SchedulePlanFactory.getLocalInstance(ctx).getSchedulePlanCollection(viewInfo);
            if (personIds == null) {
                this._deleteSchedulePlan(ctx, billId);
            } else {
                this.validate(ctx, schedulePlan);
                SchedulePlanInfo tempSchedulePlan = (SchedulePlanInfo)schedulePlan.clone();
                this.initSchedulePlan(ctx, tempSchedulePlan, billId);
                HashSet<BOSUuid> addPersonIdSet = new HashSet<BOSUuid>();
                HashSet<String> deletedIdSet = new HashSet<String>();
                HashSet<BOSUuid> reservedIdSet = new HashSet<BOSUuid>();
                HashSet<BOSUuid> oldPersonIdSet = new HashSet<BOSUuid>();
                int length = spColl.size();
                for (int i = 0; i < length; ++i) {
                    if (!personIds.contains(spColl.get(i).getPersonCreator().getId())) {
                        deletedIdSet.add(spColl.get(i).getId().toString());
                    } else {
                        reservedIdSet.add(spColl.get(i).getId());
                    }
                    oldPersonIdSet.add(spColl.get(i).getPersonCreator().getId());
                }
                for (BOSUuid tempPersonId : personIds) {
                    if (oldPersonIdSet.contains(tempPersonId)) continue;
                    addPersonIdSet.add(tempPersonId);
                }
                int length2 = spColl.size();
                for (int i = 0; i < length2; ++i) {
                    if (!reservedIdSet.contains(spColl.get(i).getId())) continue;
                    SchedulePlanInfo tempSP = (SchedulePlanInfo)tempSchedulePlan.clone();
                    tempSP.setId(spColl.get(i).getId());
                    tempSP.setPersonCreator(spColl.get(i).getPersonCreator());
                    SchedulePlanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(spColl.get(i).getId().toString()), (CoreBaseInfo)tempSP);
                    boolean isTimeChange = ScheduleMessageHelper.isEventDateChanged(spColl.get(i), tempSP);
                    if (!isTimeChange) continue;
                    ScheduleMessageHelper.createMessageBackgroundJob(ctx, tempSP);
                }
                if (deletedIdSet.size() != 0) {
                    FilterInfo filter1 = new FilterInfo();
                    filter1.getFilterItems().add(new FilterItemInfo("id", deletedIdSet, CompareType.INCLUDE));
                    EntityViewInfo viewInfo1 = new EntityViewInfo();
                    viewInfo1.setFilter(filter1);
                    SchedulePlanCollection spColl1 = SchedulePlanFactory.getLocalInstance(ctx).getSchedulePlanCollection(viewInfo1);
                    FilterInfo tempFilter = new FilterInfo();
                    tempFilter.getFilterItems().add(new FilterItemInfo("id", deletedIdSet, CompareType.INCLUDE));
                    SchedulePlanFactory.getLocalInstance(ctx).delete(tempFilter);
                    int length3 = spColl1.size();
                    for (int i = 0; i < length3; ++i) {
                        ScheduleMessageHelper.sendMessageForDelete(ctx, spColl1.get(i));
                    }
                }
                if (addPersonIdSet.size() > 0) {
                    this._addNewSchedulePlan(ctx, tempSchedulePlan, addPersonIdSet, billId);
                }
            }
            isSucceed = true;
        }
        return isSucceed;
    }

    protected boolean _deleteSchedulePlan(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isSucceed = false;
        if (billId != null) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billId.toString(), CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter1);
            SchedulePlanCollection spColl = SchedulePlanFactory.getLocalInstance(ctx).getSchedulePlanCollection(viewInfo);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billId.toString(), CompareType.EQUALS));
            IObjectPK[] pk = SchedulePlanFactory.getLocalInstance(ctx).delete(filter);
            int length = spColl.size();
            for (int i = 0; i < length; ++i) {
                ScheduleMessageHelper.sendMessageForDelete(ctx, spColl.get(i));
                ScheduleMessageHelper.changeJobTriggerStatus(ctx, spColl.get(i).getId().toString(), "X");
            }
            isSucceed = true;
        }
        return isSucceed;
    }

    protected boolean _deleteSchedulePlans(Context ctx, Set billIds) throws BOSException, EASBizException {
        boolean isSucceed = false;
        if (billIds != null && billIds.size() > 0) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billIds, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter1);
            SchedulePlanCollection spColl = SchedulePlanFactory.getLocalInstance(ctx).getSchedulePlanCollection(viewInfo);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billIds, CompareType.INCLUDE));
            IObjectPK[] pk = SchedulePlanFactory.getLocalInstance(ctx).delete(filter);
            int length = spColl.size();
            for (int i = 0; i < length; ++i) {
                ScheduleMessageHelper.sendMessageForDelete(ctx, spColl.get(i));
                ScheduleMessageHelper.changeJobTriggerStatus(ctx, spColl.get(i).getId().toString(), "X");
            }
            isSucceed = true;
        }
        return isSucceed;
    }

    protected boolean _cancelSchedulePlans(Context ctx, Set billIds) throws BOSException, EASBizException {
        boolean isSucceed = false;
        if (billIds != null && billIds.size() > 0) {
            StringBuffer sql = new StringBuffer();
            StringBuffer sqlFilter = new StringBuffer();
            sql.append(" UPDATE T_SM_SchedulePlan SET FState = 'CANCEL' WHERE ");
            Iterator iterator = billIds.iterator();
            while (iterator.hasNext()) {
                sqlFilter.append("FSourceBillId = '").append(iterator.next().toString()).append("' or ");
            }
            int lastIndex = sqlFilter.lastIndexOf("or");
            sql.append("( ").append(sqlFilter.subSequence(0, lastIndex)).append(" )");
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql.toString());
                stmt.executeUpdate();
                isSucceed = true;
                FilterInfo filter1 = new FilterInfo();
                filter1.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billIds, CompareType.INCLUDE));
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter1);
                SchedulePlanCollection spColl = SchedulePlanFactory.getLocalInstance(ctx).getSchedulePlanCollection(viewInfo);
                int length = spColl.size();
                for (int i = 0; i < length; ++i) {
                    ScheduleMessageHelper.sendMessageForCancel(ctx, spColl.get(i));
                    ScheduleMessageHelper.changeJobTriggerStatus(ctx, spColl.get(i).getId().toString(), "X");
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        return isSucceed;
    }

    protected boolean _isExistedSchedulePlan(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isExisted = false;
        if (billId != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)billId.toString(), CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            SchedulePlanCollection spColl = SchedulePlanFactory.getLocalInstance(ctx).getSchedulePlanCollection(viewInfo);
            if (spColl.size() > 0) {
                isExisted = true;
            }
        }
        return isExisted;
    }

    protected boolean _addNewOrUpdateSchedulePlan(Context ctx, SchedulePlanInfo schedulePlan, Set personIds, BOSUuid billId) throws BOSException, EASBizException {
        boolean isSucceed = false;
        if (this.checkSMModuleEnable(ctx) && billId != null && schedulePlan != null) {
            isSucceed = this._isExistedSchedulePlan(ctx, billId) ? this._updateSchedulePlan(ctx, schedulePlan, personIds, billId) : this._addNewSchedulePlan(ctx, schedulePlan, personIds, billId);
        }
        return isSucceed;
    }

    protected boolean[] _addNewOrUpdateSchedulePlans(Context ctx, SchedulePlanInfo[] schedulePlans, Set[] personIds, BOSUuid[] billIds) throws BOSException, EASBizException {
        boolean[] isSucceed = null;
        if (this.checkSMModuleEnable(ctx) && schedulePlans.length == personIds.length && personIds.length == billIds.length) {
            int i;
            for (i = 0; i < schedulePlans.length; ++i) {
                this.validate(ctx, schedulePlans[i]);
            }
            isSucceed = new boolean[schedulePlans.length];
            for (i = 0; i < schedulePlans.length; ++i) {
                isSucceed[i] = this._addNewOrUpdateSchedulePlan(ctx, schedulePlans[i], personIds[i], billIds[i]);
            }
        }
        return isSucceed;
    }

    private void validate(Context ctx, SchedulePlanInfo schedulePlan) throws SMBizException, NullPointerException {
        if (schedulePlan == null || ctx == null) {
            throw new NullPointerException();
        }
        if (schedulePlan.getTitle() == null || "".equals(schedulePlan.getTitle())) {
            throw new SMBizException(SMBizException.PROPERTY_NOT_NULL, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.cp.sm.BizCollResource", (String)"title", (Locale)ctx.getLocale())});
        }
        if (schedulePlan.getEventDate() == null) {
            throw new SMBizException(SMBizException.PROPERTY_NOT_NULL, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.cp.sm.BizCollResource", (String)"eventDate", (Locale)ctx.getLocale())});
        }
        if (schedulePlan.getEventDate() == null) {
            throw new SMBizException(SMBizException.PROPERTY_NOT_NULL, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.cp.sm.BizCollResource", (String)"eventEndDate", (Locale)ctx.getLocale())});
        }
        if (schedulePlan.getScheduleType() == null) {
            throw new SMBizException(SMBizException.PROPERTY_NOT_NULL, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.cp.sm.BizCollResource", (String)"scheduleType", (Locale)ctx.getLocale())});
        }
    }

    private void initSchedulePlan(Context ctx, SchedulePlanInfo schedulePlan, BOSUuid billId) throws BOSException, EASBizException {
        schedulePlan.setSourceBillId(billId.toString());
        if (schedulePlan.getNotifyTime() == 0) {
            schedulePlan.setNotifyTime(15);
        }
        if (schedulePlan.getLevel() == null) {
            schedulePlan.setLevel(PriorityLevelEnum.MIDDLE);
        }
        if (schedulePlan.getState() == null) {
            schedulePlan.setState(CurrentStateEnum.UNDO);
        }
    }

    private boolean checkSMModuleEnable(Context ctx) throws BOSException, EASBizException {
        boolean isEnabled = true;
        SubSystemCollection subSystemcoll = SubSystemFactory.getLocalInstance((Context)ctx).getSubSystemCollection("select * where number = 'sm'");
        if (subSystemcoll == null || subSystemcoll.size() == 0 || !subSystemcoll.get(0).isVisible()) {
            isEnabled = false;
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.cp.sm.BizCollResource", (String)"moduleIsDisabled", (Locale)ctx.getLocale()));
        }
        return isEnabled;
    }
}

