/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.sm.IInvitedPerson2Person;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonCollection;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonFactory;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonInfo;
import com.kingdee.eas.cp.sm.MessageCenterUtil;
import com.kingdee.eas.cp.sm.ScheduleEditConfigInfo;
import com.kingdee.eas.cp.sm.SchedulePlanInfo;
import com.kingdee.eas.cp.sm.util.CommonDataUtil;
import com.kingdee.eas.cp.sm.util.DateUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class ScheduleMessageHelper {
    private static final String RES = "com.kingdee.eas.cp.sm.BizCollResource";

    public static boolean sendMessageForAddNew(Context ctx, SchedulePlanInfo planInfo) {
        boolean isSucc = false;
        String title = null;
        String sender = null;
        String body = null;
        HashSet<PersonInfo> receiver = null;
        String scheduleId = planInfo.getId().toString();
        String content = null != planInfo.getContent() && !"".equals(planInfo.getContent()) ? planInfo.getContent() : planInfo.getTitle();
        InvitedPerson2PersonCollection collection = planInfo.getInvitedPerson();
        if (collection == null || collection.isEmpty() || planInfo.getId() == null) {
            isSucc = true;
        } else {
            sender = planInfo.getPersonCreator().getName();
            title = sender + ResourceBase.getString((String)RES, (String)"schedule_message_for_addnew", (Locale)ctx.getLocale()) + planInfo.getTitle();
            body = ResourceBase.getString((String)RES, (String)"schedule_message_for_multi_body", (Locale)ctx.getLocale()) + planInfo.getTitle() + ResourceBase.getString((String)RES, (String)"schedule_message_for_multi_content", (Locale)ctx.getLocale()) + content;
            receiver = new HashSet<PersonInfo>();
            Iterator ite = collection.iterator();
            while (ite.hasNext()) {
                InvitedPerson2PersonInfo info = (InvitedPerson2PersonInfo)ite.next();
                receiver.add(info.getPerson());
            }
            try {
                MessageCenterUtil.sendMessage(ctx, receiver, title, sender, body, scheduleId);
                isSucc = true;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return isSucc;
    }

    public static boolean sendMessageForCancel(Context ctx, SchedulePlanInfo planInfo) {
        boolean isSucc = false;
        String title = planInfo.getPersonCreator().getName() + ResourceBase.getString((String)RES, (String)"schedule_message_for_cancel", (Locale)ctx.getLocale()) + planInfo.getTitle();
        isSucc = ScheduleMessageHelper.sendMessageForCancelAndDelete(ctx, planInfo, title);
        return isSucc;
    }

    public static boolean sendMessageForDelete(Context ctx, SchedulePlanInfo planInfo) {
        boolean isSucc = false;
        String title = planInfo.getPersonCreator().getName() + ResourceBase.getString((String)RES, (String)"schedule_message_for_delete", (Locale)ctx.getLocale()) + planInfo.getTitle();
        isSucc = ScheduleMessageHelper.sendMessageForCancelAndDelete(ctx, planInfo, title);
        return isSucc;
    }

    private static boolean sendMessageForCancelAndDelete(Context ctx, SchedulePlanInfo planInfo, String title) {
        boolean isSucc = false;
        String sender = null;
        String body = null;
        HashSet<PersonInfo> receiver = null;
        String scheduleId = planInfo.getId().toString();
        String content = null != planInfo.getContent() && !"".equals(planInfo.getContent()) ? planInfo.getContent() : planInfo.getTitle();
        InvitedPerson2PersonCollection collection = ScheduleMessageHelper.getMessagePersonCollection(scheduleId, ctx);
        if (collection == null || collection.isEmpty() || planInfo.getId() == null) {
            isSucc = true;
        } else {
            sender = planInfo.getPersonCreator().getName();
            receiver = new HashSet<PersonInfo>();
            Iterator ite = collection.iterator();
            while (ite.hasNext()) {
                InvitedPerson2PersonInfo info = (InvitedPerson2PersonInfo)ite.next();
                receiver.add(info.getPerson());
            }
            try {
                body = ResourceBase.getString((String)RES, (String)"schedule_message_for_multi_body", (Locale)ctx.getLocale()) + planInfo.getTitle() + ResourceBase.getString((String)RES, (String)"schedule_message_for_multi_content", (Locale)ctx.getLocale()) + content;
                MessageCenterUtil.sendMessage(ctx, receiver, title, sender, body, scheduleId);
                isSucc = true;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return isSucc;
    }

    private static InvitedPerson2PersonCollection getMessagePersonCollection(String scheduleId, Context ctx) {
        PersonInfo curPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        InvitedPerson2PersonCollection invitedPersonColl = new InvitedPerson2PersonCollection();
        EntityViewInfo invitedPersonView = new EntityViewInfo();
        invitedPersonView.getSelector().add(new SelectorItemInfo("person.id"));
        invitedPersonView.getSelector().add(new SelectorItemInfo("person.name"));
        FilterInfo invitedPersonFilter = new FilterInfo();
        invitedPersonFilter.getFilterItems().add(new FilterItemInfo("schedule", (Object)scheduleId));
        invitedPersonFilter.getFilterItems().add(new FilterItemInfo("inviteBillState", (Object)new Integer(2), CompareType.NOTEQUALS));
        invitedPersonFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)curPerson.getId().toString(), CompareType.NOTEQUALS));
        invitedPersonView.setFilter(invitedPersonFilter);
        IInvitedPerson2Person iinvitedPerson = null;
        try {
            iinvitedPerson = InvitedPerson2PersonFactory.getLocalInstance(ctx);
            invitedPersonColl = iinvitedPerson.getInvitedPerson2PersonCollection(invitedPersonView);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return invitedPersonColl;
    }

    public static void createMessageBackgroundJob(Context ctx, SchedulePlanInfo info) {
        try {
            ScheduleEditConfigInfo editConfigInfo;
            String scheduleId = info.getId().toString();
            ScheduleMessageHelper._deleteMessageRetireJob(ctx, scheduleId);
            ScheduleMessageHelper.changeJobTriggerStatus(ctx, scheduleId, "X");
            Date notifyStartDate = null;
            Date notifyFinishDate = null;
            if ((info.isIsMail() || info.isIsMessage() || info.isIsMobile()) && (notifyStartDate = DateUtil.addMinute(info.getEventDate(), -1 * info.getNotifyTime())).compareTo(new Date()) <= 0) {
                notifyStartDate = null;
            }
            if (((editConfigInfo = CommonDataUtil.getEditConfig(ctx)).isIsMail() || editConfigInfo.isIsMessage() || editConfigInfo.isIsSms()) && (notifyFinishDate = CommonDataUtil.getNotifyFinishDate(info.getEventEndDate(), editConfigInfo)).compareTo(new Date()) <= 0) {
                notifyFinishDate = null;
            }
            ScheduleMessageHelper._createMessageBackGroundJob(ctx, scheduleId, notifyStartDate, notifyFinishDate);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isEventDateChanged(SchedulePlanInfo oldInfo, SchedulePlanInfo newInfo) {
        boolean isChanged = true;
        if (oldInfo == null || newInfo == null) {
            return false;
        }
        if (DateUtil.isSameDateOfMinute(oldInfo.getEventDate(), newInfo.getEventDate()) && DateUtil.isSameDateOfMinute(oldInfo.getEventEndDate(), newInfo.getEventEndDate())) {
            isChanged = false;
        }
        return isChanged;
    }

    public static void changeJobTriggerStatus(Context ctx, String regularID, String status) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String procName = ScheduleMessageHelper.getProcessNamePrefix(regularID) + "%";
        sb.append("update t_job_trigger set fisvalid='").append(status).append("' \n where fjobdefid in ").append("(select fjobdefid from t_job_def \n where ftitle like '").append(procName).append("')");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    public static void _deleteMessageRetireJob(Context ctx, String scheduleID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String local = "_" + ctx.getLocale().toString();
        String procName = ScheduleMessageHelper.getProcessNamePrefix(scheduleID) + "%";
        sb.append("delete from t_wfr_procdef  \n");
        sb.append("\twhere fprocdeftype = 'BACKGROUNDJOB'  \n");
        sb.append("\tand fname");
        sb.append(local);
        sb.append(" like '");
        sb.append(procName);
        sb.append("'  \n");
        sb.append("\tand fprocdefid not in (  \n");
        sb.append("\tselect fprocdefid from t_wfr_procinst where fprocdefid in (  \n");
        sb.append("\tselect fprocdefid from t_wfr_procdef   \n");
        sb.append("\twhere fprocdeftype='BACKGROUNDJOB'   \n");
        sb.append("\tand fname");
        sb.append(local);
        sb.append(" like '");
        sb.append(procName);
        sb.append("')  \n");
        sb.append("\t\t)  \n");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private static String getProcessNamePrefix(String regularID) {
        return "CP_SM_" + regularID;
    }

    private static void _createMessageBackGroundJob(Context ctx, String scheduleID, Date notifyStartDate, Date notifyFinishDate) throws BOSException, EASBizException {
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.cp.sm.app.MessageCenterFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("scheduleId", scheduleID);
        if (notifyStartDate != null) {
            try {
                OperationInfo notifyStartDateOperation = function.getOperation().get(0);
                service.createJobProcessDef(ScheduleMessageHelper.getProcessName(ctx, scheduleID, notifyStartDate), function, notifyStartDateOperation, jobContext, ScheduleMessageHelper.getScheduleXML(notifyStartDate), ctx.getLocale());
            }
            catch (BOSException ex) {
                ex.getStackTrace();
            }
        }
        if (notifyFinishDate != null) {
            try {
                OperationInfo notifyFinishDateOperation = function.getOperation().get(1);
                service.createJobProcessDef(ScheduleMessageHelper.getProcessName(ctx, scheduleID, notifyFinishDate), function, notifyFinishDateOperation, jobContext, ScheduleMessageHelper.getScheduleXML(notifyFinishDate), ctx.getLocale());
            }
            catch (BOSException ex) {
                ex.getStackTrace();
            }
        }
    }

    private static String getScheduleXML(Date date) {
        Date dt = DateTimeUtils.addMinute((Date)date, (long)1L);
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setDefine(ScheduleMessageHelper.getScheduleDateDesc(dt));
        define.setRetryTime(0);
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    private static String getProcessName(Context ctx, String scheduleID, Date jobDate) {
        return ScheduleMessageHelper.getProcessNamePrefix(scheduleID) + "_" + ScheduleMessageHelper.getDateStr(jobDate);
    }

    private static String getScheduleDateDesc(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        int hour = date.getHours();
        int minute = date.getMinutes();
        int second = date.getSeconds();
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }

    private static String getDateStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        return format.format(date);
    }
}

