/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.tfv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.tfv.app.AbstractDocumentViewReceiversControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DocumentViewReceiversControllerBean
extends AbstractDocumentViewReceiversControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.tfv.app.DocumentViewReceiversControllerBean");
    private static DocumentViewReceiversControllerBean documentViewReceiversControllerBean;

    @Override
    public int _getReceiversCount(Context ctx) throws BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo == null || userInfo.getPerson() == null || userInfo.getPerson().getId() == null) {
            return 0;
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.tfv.app.DocViewReceiversQuery"));
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("DOCUMENTVIEWRECEIVERS.person.id", (Object)userInfo.getPerson().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("viewStatus", (Object)"unview", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"availability", CompareType.EQUALS));
        StringBuffer sb = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("docView.status", (Object)"availability", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("docView.status", (Object)"deleted", CompareType.EQUALS));
        sb.append(" #0 and #1 and #2 and ( #3 or #4 ) ");
        filter.setMaskString(sb.toString());
        ev.setFilter(filter);
        if (ev != null) {
            exec.setObjectView(ev);
        }
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        IRowSet set = exec.executeQuery();
        int receiversCount = set.size();
        return receiversCount;
    }

    private IRowSet executeQuery(Context ctx, String sql) {
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return rs;
    }

    public String getDocMyReceivedListSql(String perId, int start, int pageSize, String sortType, String viewState) {
        int currentPage = start / pageSize + 1;
        currentPage = currentPage <= 0 ? 1 : currentPage;
        sortType = null == sortType ? "DESC" : sortType;
        viewState = null == viewState ? "unview" : viewState;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT TOP " + pageSize + " ");
        sb.append("DOCUMENTVIEWRECEIVERS.FID AS ID,  ");
        sb.append("DOCVIEW.FTitle AS TITLE,  ");
        sb.append("DOCVIEW.FDisplaySize AS DISPLAYSIZE,  ");
        sb.append("DOCVIEW.FID AS DOCVIEWID,  ");
        sb.append("DOCVIEW.FSentTime AS SENTTIME,  ");
        sb.append("DOCUMENTVIEWRECEIVERS.FViewStatus AS VIEWSTATUS,  ");
        sb.append("SENDPERSON.FID AS SENDPERSONID,  ");
        sb.append("SENDPERSON.FName_l2 AS SENDPERSONNAME  ");
        sb.append("FROM T_TFV_DocViewReceivers AS DOCUMENTVIEWRECEIVERS ");
        sb.append("INNER JOIN T_TFV_DocumentView AS DOCVIEW ");
        sb.append("ON DOCUMENTVIEWRECEIVERS.FDocViewID = DOCVIEW.FID ");
        sb.append("LEFT OUTER JOIN T_BD_Person AS PERSON ");
        sb.append("ON DOCUMENTVIEWRECEIVERS.FPersonID = PERSON.FID ");
        sb.append("INNER JOIN T_BD_Person AS SENDPERSON ");
        sb.append("ON DOCVIEW.FSendPerson = SENDPERSON.FID ");
        sb.append("WHERE DOCUMENTVIEWRECEIVERS.FPersonID = '" + perId + "'  ");
        sb.append("AND DOCUMENTVIEWRECEIVERS.FStatus = 'availability'  ");
        sb.append("AND (DOCVIEW.FStatus = 'availability' OR DOCVIEW.FStatus = 'deleted') ");
        if (!"all".equals(viewState)) {
            sb.append("and DOCUMENTVIEWRECEIVERS.FViewStatus = '").append(viewState).append("' ");
        }
        if (1 < currentPage) {
            sb.append("and DOCUMENTVIEWRECEIVERS.FID not in ");
            sb.append("(SELECT TOP " + (currentPage - 1) * pageSize + " ");
            sb.append("DOCUMENTVIEWRECEIVERS.FID AS ID  ");
            sb.append("FROM T_TFV_DocViewReceivers AS DOCUMENTVIEWRECEIVERS ");
            sb.append("INNER JOIN T_TFV_DocumentView AS DOCVIEW ");
            sb.append("ON DOCUMENTVIEWRECEIVERS.FDocViewID = DOCVIEW.FID ");
            sb.append("LEFT OUTER JOIN T_BD_Person AS PERSON ");
            sb.append("ON DOCUMENTVIEWRECEIVERS.FPersonID = PERSON.FID ");
            sb.append("INNER JOIN T_BD_Person AS SENDPERSON ");
            sb.append("ON DOCVIEW.FSendPerson = SENDPERSON.FID ");
            sb.append("WHERE DOCUMENTVIEWRECEIVERS.FPersonID = '" + perId + "'  ");
            sb.append("AND DOCUMENTVIEWRECEIVERS.FStatus = 'availability'  ");
            sb.append("AND (DOCVIEW.FStatus = 'availability' OR DOCVIEW.FStatus = 'deleted') ");
            if (!"all".equals(viewState)) {
                sb.append("and DOCUMENTVIEWRECEIVERS.FViewStatus = '").append(viewState).append("' ");
            }
            sb.append("ORDER BY  ");
            sb.append("DOCVIEW.fSENTTIME ").append(sortType).append(")");
        }
        sb.append("ORDER BY  ");
        sb.append("DOCVIEW.fSENTTIME ").append(sortType);
        return sb.toString();
    }

    public JSONArray getDocMyReceivedList(String personId, Context ctx, int start, int pageSize) {
        IRowSet rs = this.executeQuery(ctx, this.getDocMyReceivedListSql(personId, start, pageSize, null, null));
        return this.getJSONArrayFromIRowSet(rs);
    }

    public JSONArray getDocMyReceivedList(String personId, Context ctx, int start, int pageSize, String sortType) {
        IRowSet rs = this.executeQuery(ctx, this.getDocMyReceivedListSql(personId, start, pageSize, sortType, null));
        return this.getJSONArrayFromIRowSet(rs);
    }

    public JSONArray getDocMyReceivedList(String personId, Context ctx, int start, int pageSize, String sortType, String viewState) {
        IRowSet rs = this.executeQuery(ctx, this.getDocMyReceivedListSql(personId, start, pageSize, sortType, viewState));
        return this.getJSONArrayFromIRowSet(rs);
    }

    private JSONArray getJSONArrayFromIRowSet(IRowSet rs) {
        JSONArray ja = new JSONArray();
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("docviewId", (Object)rs.getString("DOCVIEWID"));
                    jsonObj.put("senderPersonId", (Object)rs.getString("SENDPERSONID"));
                    jsonObj.put("senderPersonName", (Object)rs.getString("SENDPERSONNAME"));
                    jsonObj.put("title", (Object)rs.getString("TITLE"));
                    jsonObj.put("sentTime", (Object)rs.getString("SENTTIME"));
                    jsonObj.put("displaySize", (Object)rs.getString("DISPLAYSIZE"));
                    jsonObj.put("viewStatus", (Object)rs.getString("VIEWSTATUS"));
                    ja.put((Object)jsonObj);
                }
            }
            catch (NullPointerException e) {
                logger.error((Object)e.getMessage());
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return ja;
    }

    private String getDocMyReceivedCountSql(String personId, String viewState) {
        viewState = null == viewState ? "unview" : viewState;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(DOCUMENTVIEWRECEIVERS.FID)  ");
        sb.append("FROM T_TFV_DocViewReceivers AS DOCUMENTVIEWRECEIVERS ");
        sb.append("INNER JOIN T_TFV_DocumentView AS DOCVIEW ");
        sb.append("ON DOCUMENTVIEWRECEIVERS.FDocViewID = DOCVIEW.FID ");
        sb.append("LEFT OUTER JOIN T_BD_Person AS PERSON ");
        sb.append("ON DOCUMENTVIEWRECEIVERS.FPersonID = PERSON.FID ");
        sb.append("INNER JOIN T_BD_Person AS SENDPERSON ");
        sb.append("ON DOCVIEW.FSendPerson = SENDPERSON.FID ");
        sb.append("WHERE DOCUMENTVIEWRECEIVERS.FPersonID = '" + personId + "'  ");
        sb.append("AND DOCUMENTVIEWRECEIVERS.FStatus = 'availability'  ");
        sb.append("AND (DOCVIEW.FStatus = 'availability' OR DOCVIEW.FStatus = 'deleted') ");
        if (!"all".equals(viewState)) {
            sb.append("and DOCUMENTVIEWRECEIVERS.FViewStatus = '").append(viewState).append("' ");
        }
        return sb.toString();
    }

    public int getDocMyReceivedCount(Context ctx, String personId) {
        IRowSet rs = this.executeQuery(ctx, this.getDocMyReceivedCountSql(personId, null));
        int count = 0;
        try {
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return count;
    }

    public int getDocMyReceivedCount(Context ctx, String personId, String viewState) {
        IRowSet rs = this.executeQuery(ctx, this.getDocMyReceivedCountSql(personId, viewState));
        int count = 0;
        try {
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return count;
    }

    public static DocumentViewReceiversControllerBean getInstance() {
        return null == documentViewReceiversControllerBean ? new DocumentViewReceiversControllerBean() : documentViewReceiversControllerBean;
    }
}

