/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.eas.cp.wfs.StatPeriodEnum;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DateUtils {
    public static final String LABEL_START_DATE = "startDate";
    public static final String LABEL_END_DATE = "endDate";
    public static final String LABEL_DATE = "date";
    public static final String DEFAULT_FORMATE_DATE_WITHOUT_TIME = "yyyy-MM-dd";
    public static final String DEFAULT_FORMATE_DATE = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_ID_PRE = "dateGroup";
    public static final BigDecimal baseTime = new BigDecimal("60.00");

    public static List getPeriod(Date startDate, Date endDate, StatPeriodEnum period) {
        switch (period.getValue()) {
            case 4: {
                return DateUtils.getPeriodByDay(startDate, endDate);
            }
            case 3: {
                return DateUtils.getPeriodByWeek(startDate, endDate);
            }
            case 2: {
                return DateUtils.getPeriodByMonth(startDate, endDate);
            }
            case 1: {
                return DateUtils.getPeriodByQuartar(startDate, endDate);
            }
            case 0: {
                return DateUtils.getPeriodByYear(startDate, endDate);
            }
        }
        return null;
    }

    public static List getPeriodByDay(Date startDate, Date endDate) {
        ArrayList listData = new ArrayList();
        if (startDate != null && endDate != null && !DateUtils.compareDay(startDate, endDate)) {
            if (DateUtils.isInSamePeriod(startDate, endDate, StatPeriodEnum.DAY)) {
                HashMap<String, Date> data = new HashMap<String, Date>();
                data.put(LABEL_START_DATE, startDate);
                data.put(LABEL_END_DATE, startDate);
                listData.add(data);
            } else {
                Calendar c = null;
                Date date = null;
                HashMap<String, Date> data = null;
                int _startYear = DateUtils.getYear(startDate);
                int _endYear = DateUtils.getYear(endDate);
                int _startMonth = DateUtils.getMonth(startDate);
                int _endMonth = DateUtils.getMonth(endDate);
                int _startDay = DateUtils.getDay(startDate);
                int _endDay = DateUtils.getDay(endDate);
                int endYear = _endYear;
                for (int year = _startYear; year <= endYear; ++year) {
                    int endMonth;
                    int n = endMonth = year == _endYear ? _endMonth : 11;
                    for (int month = year == _startYear ? _startMonth : 0; month <= endMonth; ++month) {
                        int endDay;
                        int n2 = endDay = year == _endYear && month == _endMonth ? _endDay : DateUtils.getDayCountInMonth(month, DateUtils.isLeapYear(year));
                        for (int day = year == _startYear && month == _startMonth ? _startDay : 1; day <= endDay; ++day) {
                            c = Calendar.getInstance();
                            c.set(1, year);
                            c.set(2, month);
                            c.set(5, day);
                            date = c.getTime();
                            date = DateUtils.resetTime(date);
                            data = new HashMap<String, Date>();
                            data.put(LABEL_START_DATE, date);
                            data.put(LABEL_END_DATE, date);
                            listData.add(data);
                        }
                    }
                }
            }
        }
        return listData;
    }

    public static List getPeriodByWeek(Date startDate, Date endDate) {
        ArrayList listData = new ArrayList();
        if (startDate != null && endDate != null && !DateUtils.compareDay(startDate, endDate)) {
            if (DateUtils.isInSamePeriod(startDate, endDate, StatPeriodEnum.WEEK)) {
                HashMap<String, Date> data = new HashMap<String, Date>();
                data.put(LABEL_START_DATE, startDate);
                data.put(LABEL_END_DATE, endDate);
                listData.add(data);
            } else {
                Calendar c = null;
                Date date = null;
                HashMap<String, Date> data = null;
                Date firstWeekDate = startDate;
                Object lastWeekDate = null;
                int _startYear = DateUtils.getYear(startDate);
                int _endYear = DateUtils.getYear(endDate);
                int _startMonth = DateUtils.getMonth(startDate);
                int _endMonth = DateUtils.getMonth(endDate);
                int _startDay = DateUtils.getDay(startDate);
                int _endDay = DateUtils.getDay(endDate);
                int endYear = _endYear;
                for (int year = _startYear; year <= endYear; ++year) {
                    int endMonth;
                    int n = endMonth = year == _endYear ? _endMonth : 11;
                    for (int month = year == _startYear ? _startMonth : 0; month <= endMonth; ++month) {
                        int endDay;
                        int n2 = endDay = year == _endYear && month == _endMonth ? _endDay : DateUtils.getDayCountInMonth(month, DateUtils.isLeapYear(year));
                        for (int day = year == _startYear && month == _startMonth ? _startDay : 1; day <= endDay; ++day) {
                            c = Calendar.getInstance();
                            c.set(1, year);
                            c.set(2, month);
                            c.set(5, day);
                            date = c.getTime();
                            date = DateUtils.resetTime(date);
                            if (DateUtils.getWeekDay(date) != 1 && !DateUtils.isInSamePeriod(date, endDate, StatPeriodEnum.DAY)) continue;
                            data = new HashMap<String, Date>();
                            data.put(LABEL_START_DATE, firstWeekDate);
                            data.put(LABEL_END_DATE, date);
                            listData.add(data);
                            firstWeekDate = DateUtils.addOneDay(date);
                        }
                    }
                }
            }
        }
        return listData;
    }

    public static List getPeriodByMonth(Date startDate, Date endDate) {
        ArrayList listData = new ArrayList();
        if (startDate != null && endDate != null && !DateUtils.compareDay(startDate, endDate)) {
            if (DateUtils.isInSamePeriod(startDate, endDate, StatPeriodEnum.MONTH)) {
                HashMap<String, Date> data = new HashMap<String, Date>();
                data.put(LABEL_START_DATE, startDate);
                data.put(LABEL_END_DATE, endDate);
                listData.add(data);
            } else {
                Calendar c = null;
                Date date = null;
                HashMap<String, Date> data = null;
                int _startYear = DateUtils.getYear(startDate);
                int _endYear = DateUtils.getYear(endDate);
                int _startMonth = DateUtils.getMonth(startDate);
                int _endMonth = DateUtils.getMonth(endDate);
                int _startDay = DateUtils.getDay(startDate);
                int _endDay = DateUtils.getDay(endDate);
                int endYear = _endYear;
                for (int year = _startYear; year <= endYear; ++year) {
                    int endMonth;
                    int n = endMonth = year == _endYear ? _endMonth : 11;
                    for (int month = year == _startYear ? _startMonth : 0; month <= endMonth; ++month) {
                        if (year == _startYear && month == _startMonth) {
                            data = new HashMap<String, Date>();
                            data.put(LABEL_START_DATE, startDate);
                            c = Calendar.getInstance();
                            c.set(1, year);
                            c.set(2, month);
                            c.set(5, DateUtils.getDayCountInMonth(month, DateUtils.isLeapYear(year)));
                            date = c.getTime();
                            date = DateUtils.resetTime(date);
                            data.put(LABEL_END_DATE, date);
                            listData.add(data);
                            continue;
                        }
                        if (year == _endYear && month == _endMonth) {
                            data = new HashMap();
                            c = Calendar.getInstance();
                            c.set(1, year);
                            c.set(2, month);
                            c.set(5, 1);
                            date = c.getTime();
                            date = DateUtils.resetTime(date);
                            data.put(LABEL_START_DATE, date);
                            data.put(LABEL_END_DATE, endDate);
                            listData.add(data);
                            continue;
                        }
                        data = new HashMap();
                        c = Calendar.getInstance();
                        c.set(1, year);
                        c.set(2, month);
                        c.set(5, 1);
                        date = c.getTime();
                        date = DateUtils.resetTime(date);
                        data.put(LABEL_START_DATE, date);
                        c = Calendar.getInstance();
                        c.set(1, year);
                        c.set(2, month);
                        c.set(5, DateUtils.getDayCountInMonth(month, DateUtils.isLeapYear(year)));
                        date = c.getTime();
                        date = DateUtils.resetTime(date);
                        data.put(LABEL_END_DATE, date);
                        listData.add(data);
                    }
                }
            }
        }
        return listData;
    }

    public static List getPeriodByQuartar(Date startDate, Date endDate) {
        ArrayList listData = new ArrayList();
        if (startDate != null && endDate != null && !DateUtils.compareDay(startDate, endDate)) {
            if (DateUtils.isInSamePeriod(startDate, endDate, StatPeriodEnum.QUARTER)) {
                HashMap<String, Date> data = new HashMap<String, Date>();
                data.put(LABEL_START_DATE, startDate);
                data.put(LABEL_END_DATE, endDate);
                listData.add(data);
            } else {
                Calendar c = null;
                Date date = null;
                HashMap<String, Date> data = null;
                int _startYear = DateUtils.getYear(startDate);
                int _endYear = DateUtils.getYear(endDate);
                int _startMonth = DateUtils.getMonth(startDate);
                int _endMonth = DateUtils.getMonth(endDate);
                int endYear = _endYear;
                block0: for (int year = _startYear; year <= endYear; ++year) {
                    int endMonth;
                    int month = year == _startYear ? _startMonth : 0;
                    int n = endMonth = year == _endYear ? _endMonth : 11;
                    while (month <= endMonth) {
                        if (year == DateUtils.getYear(startDate) && month == DateUtils.getMonth(startDate)) {
                            data = new HashMap();
                            data.put(LABEL_START_DATE, startDate);
                            c = Calendar.getInstance();
                            c.set(1, year);
                            if (11 - month <= 2) {
                                c.set(2, 11);
                            } else if (8 - month <= 2) {
                                c.set(2, 8);
                            } else if (5 - month <= 2) {
                                c.set(2, 5);
                            } else {
                                c.set(2, 2);
                            }
                            c.set(5, DateUtils.getDayCountInMonth(c.get(2), DateUtils.isLeapYear(year)));
                            date = c.getTime();
                            date = DateUtils.resetTime(date);
                            data.put(LABEL_END_DATE, date);
                            listData.add(data);
                            month = c.get(2) + 1;
                            if (month <= endMonth) continue;
                            continue block0;
                        }
                        data = new HashMap<String, Date>();
                        c = Calendar.getInstance();
                        c.set(1, year);
                        c.set(2, month);
                        c.set(5, 1);
                        date = c.getTime();
                        date = DateUtils.resetTime(date);
                        data.put(LABEL_START_DATE, date);
                        c = Calendar.getInstance();
                        c.set(1, year);
                        if (11 - month <= 2) {
                            c.set(2, 11);
                        } else if (8 - month <= 2) {
                            c.set(2, 8);
                        } else if (5 - month <= 2) {
                            c.set(2, 5);
                        } else {
                            c.set(2, 2);
                        }
                        int endDayValue = DateUtils.getDayCountInMonth(c.get(2), DateUtils.isLeapYear(year));
                        if (year == endYear) {
                            int tempMonth = DateUtils.getMonth(endDate);
                            if (c.get(2) >= tempMonth) {
                                c.set(2, tempMonth);
                                int tempDay = DateUtils.getDay(endDate);
                                if (endDayValue > tempDay) {
                                    endDayValue = tempDay;
                                }
                            }
                        }
                        c.set(5, endDayValue);
                        date = c.getTime();
                        date = DateUtils.resetTime(date);
                        data.put(LABEL_END_DATE, date);
                        listData.add(data);
                        month = c.get(2) + 1;
                        if (month <= endMonth) continue;
                        continue block0;
                    }
                }
            }
        }
        return listData;
    }

    public static List getPeriodByYear(Date startDate, Date endDate) {
        ArrayList listData = new ArrayList();
        if (startDate != null && endDate != null && !DateUtils.compareDay(startDate, endDate)) {
            if (DateUtils.isInSamePeriod(startDate, endDate, StatPeriodEnum.YEAR)) {
                HashMap<String, Date> data = new HashMap<String, Date>();
                data.put(LABEL_START_DATE, startDate);
                data.put(LABEL_END_DATE, endDate);
                listData.add(data);
            } else {
                Calendar c = null;
                Date date = null;
                HashMap<String, Date> data = null;
                int endYear = DateUtils.getYear(endDate);
                for (int year = DateUtils.getYear(startDate); year <= endYear; ++year) {
                    if (year == DateUtils.getYear(startDate)) {
                        data = new HashMap<String, Date>();
                        data.put(LABEL_START_DATE, startDate);
                        c = Calendar.getInstance();
                        c.set(1, year);
                        c.set(2, 11);
                        c.set(5, DateUtils.getDayCountInMonth(11, DateUtils.isLeapYear(year)));
                        date = c.getTime();
                        date = DateUtils.resetTime(date);
                        data.put(LABEL_END_DATE, date);
                        listData.add(data);
                        continue;
                    }
                    if (year == DateUtils.getYear(endDate)) {
                        data = new HashMap();
                        c = Calendar.getInstance();
                        c.set(1, year);
                        c.set(2, 0);
                        c.set(5, 1);
                        date = c.getTime();
                        date = DateUtils.resetTime(date);
                        data.put(LABEL_START_DATE, date);
                        data.put(LABEL_END_DATE, endDate);
                        listData.add(data);
                        continue;
                    }
                    data = new HashMap();
                    c = Calendar.getInstance();
                    c.set(1, year);
                    c.set(2, 0);
                    c.set(5, 1);
                    date = c.getTime();
                    date = DateUtils.resetTime(date);
                    data.put(LABEL_START_DATE, date);
                    c = Calendar.getInstance();
                    c.set(1, year);
                    c.set(2, 11);
                    c.set(5, DateUtils.getDayCountInMonth(11, DateUtils.isLeapYear(year)));
                    date = c.getTime();
                    date = DateUtils.resetTime(date);
                    data.put(LABEL_END_DATE, date);
                    listData.add(data);
                }
            }
        }
        return listData;
    }

    public static Date resetTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static String formatDate(Date date, String formatStr) {
        return new SimpleDateFormat(formatStr == null ? DEFAULT_FORMATE_DATE : formatStr).format(date);
    }

    public static Date formatDate(String dateStr, String formatStr) throws ParseException {
        return new SimpleDateFormat(formatStr == null ? DEFAULT_FORMATE_DATE : formatStr).parse(dateStr);
    }

    public static String getPeriodText(Map periodData, String formatStr) {
        String periodTextData = null;
        if (periodData != null) {
            formatStr = formatStr == null ? DEFAULT_FORMATE_DATE_WITHOUT_TIME : formatStr;
            Date startDate = (Date)periodData.get(LABEL_START_DATE);
            Date endDate = (Date)periodData.get(LABEL_END_DATE);
            periodTextData = DateUtils.isInSamePeriod(startDate, endDate, StatPeriodEnum.DAY) ? DateUtils.formatDate(startDate, formatStr) : DateUtils.formatDate(startDate, formatStr) + " - " + DateUtils.formatDate(endDate, formatStr);
        }
        return periodTextData;
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static int getYear(String dateStr, String format) throws ParseException {
        return DateUtils.getYear(DateUtils.formatDate(dateStr, format));
    }

    public static int getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2);
    }

    public static int getMonth(String dateStr, String format) throws ParseException {
        return DateUtils.getMonth(DateUtils.formatDate(dateStr, format));
    }

    public static int getDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getDay(String dateStr, String format) throws ParseException {
        return DateUtils.getDay(DateUtils.formatDate(dateStr, format));
    }

    public static int getWeekDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(7);
    }

    public static int getWeekDay(String dateStr, String format) throws ParseException {
        return DateUtils.getWeekDay(DateUtils.formatDate(dateStr, format));
    }

    public static int getDayCountInMonth(int month, boolean isLeapYear) {
        int dayCount = 0;
        if (month >= 0 && month <= 11) {
            if (month == 0 || month == 2 || month == 4 || month == 6 || month == 7 || month == 9 || month == 11) {
                dayCount = 31;
            } else if (month == 3 || month == 5 || month == 8 || month == 10) {
                dayCount = 30;
            } else if (month == 1) {
                dayCount = isLeapYear ? 29 : 28;
            }
        }
        return dayCount;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 || year % 100 != 0 && year % 400 == 0;
    }

    public static boolean isInSamePeriod(Date startDate, Date endDate, StatPeriodEnum period) {
        boolean flag = false;
        if (startDate != null && endDate != null) {
            switch (period.getValue()) {
                case 4: {
                    flag = DateUtils.getYear(startDate) == DateUtils.getYear(endDate) && DateUtils.getMonth(startDate) == DateUtils.getMonth(endDate) && DateUtils.getDay(startDate) == DateUtils.getDay(endDate);
                    break;
                }
                case 3: {
                    long subData = DateUtils.daySub(endDate, startDate);
                    flag = subData < 7L && subData >= 0L && DateUtils.getWeekDay(startDate) > DateUtils.getWeekDay(endDate);
                    break;
                }
                case 2: {
                    flag = DateUtils.getYear(startDate) == DateUtils.getYear(endDate) && DateUtils.getMonth(startDate) == DateUtils.getMonth(endDate);
                    break;
                }
                case 1: {
                    int startMonth = DateUtils.getMonth(startDate);
                    int endMonth = DateUtils.getMonth(endDate);
                    int earlyMonth = startMonth < endMonth ? startMonth : endMonth;
                    int count = endMonth - startMonth > 0 ? endMonth - startMonth : startMonth - endMonth;
                    flag = DateUtils.getYear(startDate) == DateUtils.getYear(endDate) && count < 3 && (earlyMonth < 2 && earlyMonth + count < 2 || earlyMonth < 5 && earlyMonth + count < 5 || earlyMonth < 8 && earlyMonth + count < 8 || earlyMonth < 11 && earlyMonth + count < 11);
                    break;
                }
                case 0: {
                    flag = DateUtils.getYear(startDate) == DateUtils.getYear(endDate);
                }
            }
        }
        return flag;
    }

    public static boolean compareDay(Date d1, Date d2) {
        return DateUtils.resetTime(d1).after(DateUtils.resetTime(d2));
    }

    public static long daySub(Date startDate, Date endDate) {
        return (startDate.getTime() - endDate.getTime()) / 86400000L > 0L ? (startDate.getTime() - endDate.getTime()) / 86400000L : (startDate.getTime() - endDate.getTime()) / 86400000L;
    }

    public static Date addOneDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.get(5) + 1);
        return DateUtils.resetTime(c.getTime());
    }

    public static BigDecimal calculateWorkTime(String costWorkTime) {
        return DateUtils.calculateWorkTime(costWorkTime, 2);
    }

    public static BigDecimal calculateWorkTime(String costWorkTime, int scale) {
        BigDecimal workTime = null;
        if (costWorkTime != null) {
            BigDecimal costTime = new BigDecimal(costWorkTime);
            workTime = costTime.divide(baseTime, scale, 4);
        }
        return workTime;
    }

    public static String getFormatDate(String time) {
        if (time == null || time.trim().length() == 0) {
            return null;
        }
        return time.substring(0, 19);
    }
}

