/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfs.CollectTypeEnum;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.ResourceUtils;
import com.kingdee.eas.cp.wfs.utils.AbstractExcelReportBiz;
import com.kingdee.eas.cp.wfs.utils.DataUtil;
import com.kingdee.eas.cp.wfs.utils.DateUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.json.JSONException;

public class ExcelExportPostponeReportBiz
extends AbstractExcelReportBiz {
    private String procInstSubQueryFilterText = null;
    public static final String QUERY_REPORT_GET_BIZDATA_BY_ADMIN = "com.kingdee.eas.cp.wfs.app.GetReportDataPostponeByAdminQuery";
    public static final String QUERY_REPORT_GET_BIZDATA_BY_PROCDEF = "com.kingdee.eas.cp.wfs.app.GetReportDataPostponeByProcDefQuery";
    public static final String QUERY_REPORT_GET_BIZDATA_BY_PROCTEMPLATE = "com.kingdee.eas.cp.wfs.app.GetReportDataPostponeByProcTemplateQuery";
    public static final String QUERY_REPORT_GET_BIZDATA_BY_PROCTYPE = "com.kingdee.eas.cp.wfs.app.GetReportDataPostponeByProcTypeQuery";
    private static final String[] ITEM_LABEL = new String[]{ResourceUtils.getString("TOTAL_SUM"), ResourceUtils.getString("POSTPONE"), ResourceUtils.getString("PERCENT")};
    private Set headCalculSet;
    private static final String[] ITEM_VALUE = new String[]{"total", "postpone", "percent"};
    private String[] LATITUDE_HEADER_ITEM = new String[]{"", ResourceUtils.getString("FLOW_NAME"), ResourceUtils.getString("STEP_NAME")};

    public ExcelExportPostponeReportBiz() {
        this.headCalculSet = new HashSet();
    }

    protected void beforeBuildData(Context ctx, FormConfigInfo config) {
    }

    private EntityViewInfo createCommonView(Context ctx, FormConfigInfo config, boolean onlyDelayData) throws EASBizException, BOSException, UuidException, SQLException {
        EntityViewInfo view = this.createEmptyView();
        this.procInstSubQueryFilterText = "\"_PROCINST_\".FCreateTime >= {TS'" + DateUtils.formatDate(DateUtils.resetTime(config.getStartDate()), null) + "'}" + " AND \"_PROCINST_\".FCreateTime<{TS'" + DateUtils.formatDate(DateUtils.addOneDay(config.getEndDate()), null) + "'}" + " AND \"USER\".FID" + "='" + this.getUserId() + "' AND \"_PROCINST_\".FCuLongNumber  LIKE '" + config.getAdmin().getCU().getLongNumber() + "%'";
        this.procInstSubQueryFilterText = this.procInstSubQueryFilterText + " AND \"_PROCINST_\".FOrgLongNumber LIKE '" + config.getAdmin().getLongNumber() + (CollectTypeEnum.ADMIN.equals((Object)config.getCollectType()) ? "!%" : "%") + "'";
        if (CollectTypeEnum.PROCESSTYPE.equals((Object)config.getCollectType()) || CollectTypeEnum.PROCESSTEMPLATE.equals((Object)config.getCollectType())) {
            if (this.isNeedConfigEntryJoinQuery()) {
                view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
            } else if (CollectTypeEnum.PROCESSTYPE.equals((Object)config.getCollectType())) {
                view.getFilter().mergeFilter(this.createCollectIdView("type.id", config).getFilter(), "and");
            } else if (CollectTypeEnum.PROCESSTEMPLATE.equals((Object)config.getCollectType())) {
                view.getFilter().mergeFilter(this.createCollectIdView("template.id", config).getFilter(), "and");
            }
        } else if (CollectTypeEnum.PROCESS.equals((Object)config.getCollectType())) {
            view.getFilter().mergeFilter(this.createCollectIdView("procDef.procDefId", config).getFilter(), "and");
        }
        return view;
    }

    public void buildHeadData(Context ctx, FormConfigInfo config) throws Exception {
        HSSFCellStyle style = this.styleKit.getCommonHeadStyle();
        switch (config.getCollectType().getValue()) {
            case 0: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("ADMIN_NAME");
                break;
            }
            case 1: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("FLOW_TYPE");
                break;
            }
            case 2: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("FLOW_TEMPLATE");
                break;
            }
            case 3: {
                this.LATITUDE_HEADER_ITEM = new String[]{ResourceUtils.getString("FLOW_NAME"), ResourceUtils.getString("STEP_NAME")};
            }
        }
        int len = this.LATITUDE_HEADER_ITEM.length;
        for (int i = 0; i < len; ++i) {
            this.appendCellData(0, i, this.createCellData(2, 1, this.LATITUDE_HEADER_ITEM[i]), style);
        }
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        if (periodDatas != null) {
            int idx = 0;
            int size = periodDatas.size();
            for (int i = 0; i < size; ++i) {
                this.appendCellData(0, i * ITEM_VALUE.length + this.LATITUDE_HEADER_ITEM.length, this.createCellData(1, ITEM_VALUE.length, DateUtils.getPeriodText((Map)periodDatas.get(i), null)), style);
                int len2 = ITEM_VALUE.length;
                for (int j = 0; j < len2; ++j) {
                    this.appendCellData(1, this.LATITUDE_HEADER_ITEM.length + i * ITEM_VALUE.length + j, this.createCellData(ITEM_LABEL[j]), style);
                    idx = i * ITEM_VALUE.length + j + this.LATITUDE_HEADER_ITEM.length;
                    this.registColIdx("dateGroup" + i + "_" + ITEM_VALUE[j], idx);
                    if (!ITEM_VALUE[j].equals("percent")) continue;
                    this.headCalculSet.add(new Integer(idx));
                }
            }
        }
        this.setDataColCount(periodDatas.size() * ITEM_VALUE.length);
    }

    public void buildLatitudeByOrg(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByAdminProcStep(ctx, config, 2);
    }

    private String createRptSQLByOrg(Context ctx, FormConfigInfo config, String queryName, boolean onlyDelayData) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config, onlyDelayData);
        StringBuffer sql = new StringBuffer(this.insertProcInstSubQueryFilter(DataUtil.getSQL(ctx, queryName, view), this.procInstSubQueryFilterText));
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE1 AS \"REPLACESTATEMENT1\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".\"CREATETIME\""));
        StringBuffer adminSQL = new StringBuffer();
        String adminReplace = "(?u)NULLVALUE2 AS \"REPLACESTATEMENT2\"";
        List adminList = this.getChildAdmin(ctx, config);
        if (adminList.size() == 0) {
            adminList.add(config.getAdmin());
        }
        adminSQL.append(" \n(CASE \n");
        AdminOrgUnitInfo admin = null;
        int size = adminList.size();
        for (int i = 0; i < size; ++i) {
            admin = (AdminOrgUnitInfo)adminList.get(i);
            adminSQL.append("WHEN \"PROCINST\".\"ORGLONGNUMBER\" LIKE '" + admin.getLongNumber() + "%' THEN '" + admin.getId().toString() + "' \n");
        }
        adminSQL.append("end )");
        return sql.toString().replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE1", stateSQL.toString()).replaceAll(adminReplace, adminSQL.toString() + "as \"ADMINORG.ID\" \n").replaceAll("(?u)NULLVALUE2", adminSQL.toString());
    }

    public void buildBizGridDataByOrg(Context ctx, FormConfigInfo config) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("colids", new String[]{"PERIOD"});
        params.put("rowids", new String[]{"ADMINORG.ID", "PROCDEF.PROCDEFID", "STEPDEF.STEPDEFID"});
        params.put("value", "COUNTINST");
        params.put("formatColId", "{0}_" + ITEM_VALUE[0]);
        params.put("formatRowId", "{0}_{1}_{2}");
        this.appendBizCellData(this.query(ctx, this.createRptSQLByOrg(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_ADMIN, false)), params, null);
        params.put("formatColId", "{0}_" + ITEM_VALUE[1]);
        this.appendBizCellData(this.query(ctx, this.createRptSQLByOrg(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_ADMIN, true)), params, null);
    }

    public void buildLatitudeByProcType(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByTypeProcStep(ctx, config, 2);
    }

    private String createRptSQLByProcType(Context ctx, FormConfigInfo config, String queryName, boolean onlyDelayData) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config, onlyDelayData);
        StringBuffer sql = new StringBuffer(this.insertProcInstSubQueryFilter(DataUtil.getSQL(ctx, queryName, view), this.procInstSubQueryFilterText));
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".\"CREATETIME\""));
        String _sql = sql.toString();
        if (!this.isNeedConfigEntryJoinQuery()) {
            _sql = this.removeCollectItemSQL(_sql, CollectTypeEnum.PROCESSTYPE);
        }
        return _sql.replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString());
    }

    public void buildBizGridDataByProcType(Context ctx, FormConfigInfo config) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("colids", new String[]{"PERIOD"});
        params.put("rowids", new String[]{"TYPE.NUMBER", "PROCDEF.PROCDEFID", "STEPDEF.STEPDEFID"});
        params.put("value", "COUNTINST");
        params.put("formatColId", "{0}_" + ITEM_VALUE[0]);
        params.put("formatRowId", "{0}_{1}_{2}");
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcType(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCTYPE, false)), params, null);
        params.put("formatColId", "{0}_" + ITEM_VALUE[1]);
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcType(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCTYPE, true)), params, null);
    }

    public void buildLatitudeByProcTemplate(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByTemplateProcStep(ctx, config, 2);
    }

    private String createRptSQLByProcTemplate(Context ctx, FormConfigInfo config, String queryName, boolean onlyDelayData) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config, onlyDelayData);
        StringBuffer sql = new StringBuffer(this.insertProcInstSubQueryFilter(DataUtil.getSQL(ctx, queryName, view), this.procInstSubQueryFilterText));
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".\"CREATETIME\""));
        String _sql = sql.toString();
        if (!this.isNeedConfigEntryJoinQuery()) {
            _sql = this.removeCollectItemSQL(_sql, CollectTypeEnum.PROCESSTEMPLATE);
        }
        return _sql.toString().replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString());
    }

    public void buildBizGridDataByProcTemplate(Context ctx, FormConfigInfo config) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("colids", new String[]{"PERIOD"});
        params.put("rowids", new String[]{"TEMPLATE.NUMBER", "PROCDEF.PROCDEFID", "STEPDEF.STEPDEFID"});
        params.put("value", "COUNTINST");
        params.put("formatColId", "{0}_" + ITEM_VALUE[0]);
        params.put("formatRowId", "{0}_{1}_{2}");
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcTemplate(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCTEMPLATE, false)), params, null);
        params.put("formatColId", "{0}_" + ITEM_VALUE[1]);
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcTemplate(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCTEMPLATE, true)), params, null);
    }

    public void buildLatitudeByProc(Context ctx, FormConfigInfo config) throws BOSException, SQLException, JSONException {
        this.buildLatitudeDataByProcStep(ctx, config, 2);
    }

    private String createRptSQLByProcDef(Context ctx, FormConfigInfo config, String queryName, boolean onlyDelayData) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config, onlyDelayData);
        StringBuffer sql = new StringBuffer(this.insertProcInstSubQueryFilter(DataUtil.getSQL(ctx, queryName, view), this.procInstSubQueryFilterText));
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".\"CREATETIME\""));
        String _sql = this.removeCollectItemSQL(sql.toString(), CollectTypeEnum.PROCESS);
        return _sql.toString().replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString());
    }

    public void buildBizGridDataByProc(Context ctx, FormConfigInfo config) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("colids", new String[]{"PERIOD"});
        params.put("rowids", new String[]{"PROCDEF.PROCDEFID", "STEPDEF.STEPDEFID"});
        params.put("value", "COUNTINST");
        params.put("formatColId", "{0}_" + ITEM_VALUE[0]);
        params.put("formatRowId", "{0}_{1}");
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcDef(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCDEF, false)), params, null);
        params.put("formatColId", "{0}_" + ITEM_VALUE[1]);
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcDef(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCDEF, true)), params, null);
    }

    public void buildCalculCells() throws JSONException {
        Iterator it = this.headCalculSet.iterator();
        int idx = 0;
        while (it.hasNext()) {
            idx = (Integer)it.next();
            this.appendRateColData(idx, idx - 1, idx - 2, null);
        }
    }
}

