/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfs.CollectTypeEnum;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.ResourceUtils;
import com.kingdee.eas.cp.wfs.WfsStateEnum;
import com.kingdee.eas.cp.wfs.utils.AbstractExcelReportBiz;
import com.kingdee.eas.cp.wfs.utils.DataUtil;
import com.kingdee.eas.cp.wfs.utils.DateUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.json.JSONException;

public class ExcelExportProcInstReportBiz
extends AbstractExcelReportBiz {
    private String COMMON_FILTER = "";
    public static final String QUERY_REPORT_GET_BIZDATA_BY_ADMIN = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstByAdminQuery";
    public static final String QUERY_REPORT_GET_BIZDATA_BY_PROCDEF = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstByProcDefQuery";
    public static final String QUERY_REPORT_GET_BIZDATA_BY_PROCTEMPLATE = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstByProcTemplateQuery";
    public static final String QUERY_REPORT_GET_BIZDATA_BY_PROCTYPE = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstByProcTypeQuery";
    public static final String LABEL_PERIOD_SUM = "period_sum";
    private static final String[] STATE_ITEM = new String[]{WfsStateEnum.FINISHED.getAlias(), ResourceUtils.getString("PERCENT"), WfsStateEnum.RUNNING.getAlias(), ResourceUtils.getString("PERCENT"), WfsStateEnum.CANCELED.getAlias(), ResourceUtils.getString("PERCENT"), ResourceUtils.getString("TOTAL_COUNT")};
    private static final String[] STATE_VALUE = new String[]{"finished", "finished_percent", "running", "running_percent", "canceled", "canceled_percent", "total"};
    private String[] LATITUDE_HEADER_ITEM = new String[]{"", ResourceUtils.getString("FLOW_NAME")};
    private Map headCalculMap = new HashMap();
    private boolean isIncludAllVersionProc = true;

    protected void beforeBuildData(Context ctx, FormConfigInfo config) {
        this.COMMON_FILTER = this.COMMON_FILTER + (this.COMMON_FILTER != null && !"".equals(this.COMMON_FILTER) ? " AND " : "") + "\"USER\".FID" + "='" + this.getUserId() + "' AND (\"CU\".FID = '" + config.getAdmin().getCU().getId().toString() + "' OR " + "\"CU\".FLONGNUMBER like '" + config.getAdmin().getCU().getLongNumber() + "%')";
    }

    private EntityViewInfo createCommonView(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, UuidException, SQLException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS));
        view.getFilter().getFilterItems().add(this.getAdminOrgAndUserRangeFilterItem(ctx, "user.id"));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgLongNumber", (Object)(config.getAdmin().getLongNumber() + (CollectTypeEnum.ADMIN.equals((Object)config.getCollectType()) ? "!%" : "%")), CompareType.LIKE));
        if (CollectTypeEnum.PROCESSTYPE.equals((Object)config.getCollectType()) || CollectTypeEnum.PROCESSTEMPLATE.equals((Object)config.getCollectType())) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
        } else if (CollectTypeEnum.PROCESS.equals((Object)config.getCollectType())) {
            view.getFilter().mergeFilter(this.createCollectIdView("procDef.procDefId", config).getFilter(), "and");
        }
        return view;
    }

    public void buildHeadData(Context ctx, FormConfigInfo config) throws Exception {
        HSSFCellStyle style = this.styleKit.getCommonHeadStyle();
        switch (config.getCollectType().getValue()) {
            case 0: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("ADMIN_NAME");
                break;
            }
            case 1: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("FLOW_TYPE");
                break;
            }
            case 2: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("FLOW_TEMPLATE");
                break;
            }
            case 3: {
                this.LATITUDE_HEADER_ITEM = new String[]{ResourceUtils.getString("FLOW_NAME")};
            }
        }
        int len = this.LATITUDE_HEADER_ITEM.length;
        for (int i = 0; i < len; ++i) {
            this.appendCellData(0, i, this.createCellData(2, 1, this.LATITUDE_HEADER_ITEM[i]), style);
        }
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        if (periodDatas != null) {
            int idx = 0;
            int size = periodDatas.size();
            for (int i = 0; i < size; ++i) {
                this.appendCellData(0, i * STATE_VALUE.length + this.LATITUDE_HEADER_ITEM.length, this.createCellData(1, STATE_VALUE.length, DateUtils.getPeriodText((Map)periodDatas.get(i), null)), style);
                int len2 = STATE_VALUE.length;
                for (int j = 0; j < len2; ++j) {
                    this.appendCellData(1, this.LATITUDE_HEADER_ITEM.length + i * STATE_VALUE.length + j, this.createCellData(STATE_ITEM[j]), style);
                    idx = i * STATE_VALUE.length + j + this.LATITUDE_HEADER_ITEM.length;
                    this.registColIdx("dateGroup" + i + "_" + STATE_VALUE[j], idx);
                    if (STATE_VALUE[j].lastIndexOf("total") == -1) continue;
                    this.headCalculMap.put("dateGroup" + i, new Integer(idx));
                }
            }
        }
        HSSFCell sumHeadCell = this.appendCellData(0, periodDatas.size() * STATE_VALUE.length + this.LATITUDE_HEADER_ITEM.length, this.createCellData(2, 1, ResourceUtils.getString("PERIOD_SUM")), style);
        this.registColIdx(LABEL_PERIOD_SUM, sumHeadCell.getColumnIndex());
        this.setDataColCount(periodDatas.size() * STATE_VALUE.length + 1);
    }

    public void buildLatitudeByOrg(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByAdminProc(ctx, config, 2);
    }

    private String createRptSQLByOrg(Context ctx, FormConfigInfo config, String queryName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config);
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE1 AS \"REPLACESTATEMENT1\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        StringBuffer adminSQL = new StringBuffer();
        String adminReplace = "(?u)NULLVALUE2 AS \"REPLACESTATEMENT2\"";
        List adminList = this.getChildAdmin(ctx, config);
        if (adminList.size() == 0) {
            adminList.add(config.getAdmin());
        }
        adminSQL.append(" \n(CASE \n");
        AdminOrgUnitInfo admin = null;
        int size = adminList.size();
        for (int i = 0; i < size; ++i) {
            admin = (AdminOrgUnitInfo)adminList.get(i);
            adminSQL.append("WHEN \"PROCINST\".FORGLONGNUMBER LIKE '" + admin.getLongNumber() + "%' THEN '" + admin.getId().toString() + "' \n");
        }
        adminSQL.append("end )");
        return this.insertFilter(sql.toString().replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE1", stateSQL.toString()).replaceAll(adminReplace, adminSQL.toString() + "as \"ADMINORG.ID\" \n").replaceAll("(?u)NULLVALUE2", adminSQL.toString()) + " ORDER BY \"ADMINORG.ID\" ASC,\"PERIOD\" ASC", this.COMMON_FILTER);
    }

    public void buildBizGridDataByOrg(Context ctx, FormConfigInfo config) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("colids", new String[]{"PERIOD", "STATE"});
        params.put("rowids", new String[]{"ADMINORG.ID", "PROCDEF.PROCDEFID"});
        params.put("value", "COUNTINST");
        params.put("formatColId", "{0}_{1}");
        params.put("formatRowId", "{0}_{1}");
        this.appendBizCellData(this.query(ctx, this.createRptSQLByOrg(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_ADMIN)), params, null);
    }

    public void buildLatitudeByProcType(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByTypeProc(ctx, config, 2);
    }

    private String createRptSQLByProcType(Context ctx, FormConfigInfo config, String queryName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config);
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        String _sql = sql.toString();
        return this.insertFilter(_sql.replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString()), this.COMMON_FILTER);
    }

    public void buildBizGridDataByProcType(Context ctx, FormConfigInfo config) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("colids", new String[]{"PERIOD", "STATE"});
        params.put("rowids", new String[]{"TYPE.NUMBER", "PROCDEF.PROCDEFID"});
        params.put("value", "COUNTINST");
        params.put("formatColId", "{0}_{1}");
        params.put("formatRowId", "{0}_{1}");
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcType(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCTYPE)), params, null);
    }

    public void buildLatitudeByProcTemplate(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByTemplateProc(ctx, config, 2);
    }

    private String createRptSQLByProcTemplate(Context ctx, FormConfigInfo config, String queryName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config);
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        String _sql = sql.toString();
        return this.insertFilter(_sql.replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString()), this.COMMON_FILTER);
    }

    public void buildBizGridDataByProcTemplate(Context ctx, FormConfigInfo config) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("colids", new String[]{"PERIOD", "STATE"});
        params.put("rowids", new String[]{"TEMPLATE.NUMBER", "PROCDEF.PROCDEFID"});
        params.put("value", "COUNTINST");
        params.put("formatColId", "{0}_{1}");
        params.put("formatRowId", "{0}_{1}");
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcTemplate(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCTEMPLATE)), params, null);
    }

    public void buildLatitudeByProc(Context ctx, FormConfigInfo config) throws BOSException, SQLException, JSONException, EASBizException {
        this.buildLatitudeDataByProc(ctx, config, 2);
    }

    private String createRptSQLByProcDef(Context ctx, FormConfigInfo config, String queryName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config);
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        String _sql = this.removeCollectItemSQL(sql.toString(), CollectTypeEnum.PROCESS);
        return this.insertFilter(_sql.toString().replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString()), this.COMMON_FILTER);
    }

    public void buildBizGridDataByProc(Context ctx, FormConfigInfo config) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("colids", new String[]{"PERIOD", "STATE"});
        params.put("rowids", new String[]{"PROCDEF.PROCDEFID"});
        params.put("value", "COUNTINST");
        params.put("formatColId", "{0}_{1}");
        params.put("formatRowId", "{0}");
        this.appendBizCellData(this.query(ctx, this.createRptSQLByProcDef(ctx, config, QUERY_REPORT_GET_BIZDATA_BY_PROCDEF)), params, null);
    }

    public void buildCalculCells() throws Exception {
        Set keySet = this.headCalculMap.keySet();
        Iterator it = keySet.iterator();
        int idx = 0;
        int i = 0;
        int[] sumTargetColIdx = new int[keySet.size()];
        while (it.hasNext()) {
            idx = (Integer)this.headCalculMap.get(it.next());
            this.appendSumFormulaColData(idx, new int[]{idx - 6, idx - 4, idx - 2}, null);
            this.appendRateColData(idx - 5, idx - 6, idx, null);
            this.appendRateColData(idx - 3, idx - 4, idx, null);
            this.appendRateColData(idx - 1, idx - 2, idx, null);
            sumTargetColIdx[i++] = idx;
        }
        this.appendSumFormulaColData(this.getColumnIdx(LABEL_PERIOD_SUM), sumTargetColIdx, this.styleKit.getCommonCalculateStyle());
    }
}

