/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.json.JSONException;
import org.json.JSONObject;

public class ExcelExportUtils {
    public static final String LABEL_COLSPAN = "colspan";
    public static final String LABEL_ROWSPAN = "rowspan";
    public static final String LABEL_VALUE = "value";

    public static int getDiffLineColor(int lineNumber) {
        return lineNumber % 2 == 0 ? 9 : 44;
    }

    public static HSSFCell appendCell(HSSFSheet sheet, int rowIdx, int colIdx, HSSFCellStyle style, int cellType, JSONObject cellData) throws JSONException {
        HSSFCell cell;
        if (colIdx >= HSSFCell.LAST_COLUMN_NUMBER) {
            return null;
        }
        HSSFRow row = sheet.getRow(rowIdx);
        if (row == null) {
            row = sheet.createRow(rowIdx);
        }
        if ((cell = row.getCell(colIdx)) == null) {
            cell = row.createCell(colIdx, cellType);
        }
        if (cellData != null) {
            Object value = cellData.get(LABEL_VALUE);
            if (style != null) {
                cell.setCellStyle(style);
            }
            switch (cellType) {
                case 2: {
                    cell.setCellType(2);
                    cell.setCellFormula(value.toString());
                    break;
                }
                default: {
                    break;
                }
                case 1: {
                    if (value != null) {
                        cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
                        break;
                    }
                    cell.setCellValue((RichTextString)new HSSFRichTextString());
                    break;
                }
                case 0: {
                    cell.setCellType(0);
                    if (value != null) {
                        try {
                            cell.setCellValue(Double.valueOf(value.toString()).doubleValue());
                        }
                        catch (Exception e) {
                            cell.setCellValue((RichTextString)new HSSFRichTextString());
                        }
                        break;
                    }
                    cell.setCellValue((RichTextString)new HSSFRichTextString());
                }
            }
            int rowspan = 1;
            int colspan = 1;
            if (cellData.has(LABEL_ROWSPAN)) {
                rowspan = cellData.getInt(LABEL_ROWSPAN);
            }
            if (cellData.has(LABEL_COLSPAN)) {
                colspan = cellData.getInt(LABEL_COLSPAN);
            }
            for (int r = rowIdx; r < rowIdx + rowspan; ++r) {
                for (int c = colIdx; c < colIdx + colspan; ++c) {
                    ExcelExportUtils.appendCell(sheet, r, c, style, cellType, null);
                }
            }
            if (colIdx + colspan - 1 < HSSFCell.LAST_COLUMN_NUMBER && (rowspan != 1 || colspan != 1)) {
                org.apache.poi.hssf.util.CellRangeAddress region = new org.apache.poi.hssf.util.CellRangeAddress(rowIdx, rowIdx + rowspan - 1, colIdx, colIdx + colspan - 1);
                sheet.addMergedRegion((CellRangeAddress)region);
                ExcelExportUtils.setRegionStyle(sheet, region, style);
            }
        }
        return cell;
    }

    public static void setRegionStyle(HSSFSheet sheet, org.apache.poi.hssf.util.CellRangeAddress region, HSSFCellStyle cs) {
        for (int i = region.getFirstRow(); i <= region.getLastRow(); ++i) {
            HSSFRow row = sheet.getRow(i);
            for (int j = region.getFirstColumn(); j <= region.getLastColumn(); ++j) {
                HSSFCell cell = row.getCell(j);
                cell.setCellStyle(cs);
            }
        }
    }

    public static void appendBlockData(HSSFSheet sheet, HSSFCellStyle style, int cellType, JSONObject cellData, int leftIdx, int rightIdx, int topIdx, int bottomIdx) throws JSONException {
        HSSFRow row = null;
        for (int rowStep = topIdx; rowStep <= bottomIdx; ++rowStep) {
            row = sheet.getRow(rowStep);
            if (row == null) {
                row = sheet.createRow(rowStep);
            }
            for (int colStep = leftIdx; colStep <= rightIdx; ++colStep) {
                if (row.getCell(colStep) != null) continue;
                ExcelExportUtils.appendCell(sheet, rowStep, colStep, style, cellType, cellData);
            }
        }
    }

    public static String convertColIdx(int colIdx) {
        if (colIdx < 0) {
            return "";
        }
        String[] alphabet = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        if (colIdx < alphabet.length) {
            return alphabet[colIdx].toUpperCase();
        }
        return (ExcelExportUtils.convertColIdx(colIdx / alphabet.length - 1) + alphabet[colIdx % alphabet.length]).toUpperCase();
    }
}

