/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelStyleToolKit {
    public static final String STYLELABEL_COMMON_STYLE = "0";
    public static final String STYLELABEL_COMMON_HEAD = "1";
    public static final String STYLELABEL_COMMON_EVEN_LINENUMBERCELL = "2";
    public static final String STYLELABEL_COMMON_ODD_LINENUMBERCELL = "3";
    public static final String STYLELABEL_COMMON_CALCULATECELL = "4";
    public static final String STYLELABEL_COMMON_LATITUDECELL = "5";
    public static final String STYLELABEL_EVEN_NUMBER_LATITUDECELL = "6";
    public static final String STYLELABEL_ODD_NUMBER_LATITUDECELL = "7";
    public static final String STYLELABEL_CALCULATE_LATITUDECELL = "8";
    public static final String STYLELABEL_EVEN_LINENUMBER_DECIMAL_DATACELL = "9";
    public static final String STYLELABEL_ODD_LINENUMBER_DECIMAL_DATACELL = "10";
    public static final String STYLELABEL_CALCULATE_DECIMAL_DATACELL = "11";
    public static final String STYLELABEL_EVEN_LINENUMBER_RATING_DATACELL = "12";
    public static final String STYLELABEL_ODD_LINENUMBER_RATING_DATACELL = "13";
    public static final String STYLELABEL_CALCULATE_RATING_DATACELL = "14";
    private HashMap styles = null;
    private HSSFWorkbook book = null;

    public ExcelStyleToolKit(HSSFWorkbook book) {
        this.init(book);
    }

    public void reset() {
        this.styles = null;
        this.book = null;
    }

    public void init(HSSFWorkbook book) {
        this.reset();
        HSSFCellStyle style = null;
        this.styles = new HashMap();
        this.book = book;
        this.styles.put(STYLELABEL_COMMON_STYLE, this.createStyle());
        this.styles.put(STYLELABEL_COMMON_HEAD, this.createHeadStyle());
        HSSFCellStyle[] temps = this.createDiffLineStyle();
        this.styles.put(STYLELABEL_COMMON_EVEN_LINENUMBERCELL, temps[0]);
        this.styles.put(STYLELABEL_COMMON_ODD_LINENUMBERCELL, temps[1]);
        this.styles.put(STYLELABEL_COMMON_CALCULATECELL, this.createCalculCellStyle());
        style = this.createStyle();
        style.setAlignment((short)1);
        this.styles.put(STYLELABEL_COMMON_LATITUDECELL, style);
        temps = this.createDiffLineStyle();
        temps[0].setAlignment((short)1);
        this.styles.put(STYLELABEL_EVEN_NUMBER_LATITUDECELL, temps[0]);
        temps[1].setAlignment((short)1);
        this.styles.put(STYLELABEL_ODD_NUMBER_LATITUDECELL, temps[1]);
        style = this.createCalculCellStyle();
        style.setAlignment((short)3);
        this.styles.put(STYLELABEL_CALCULATE_LATITUDECELL, style);
        temps = this.createDiffLineStyle();
        temps[0].setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
        this.styles.put(STYLELABEL_EVEN_LINENUMBER_DECIMAL_DATACELL, temps[0]);
        temps[1].setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
        this.styles.put(STYLELABEL_ODD_LINENUMBER_DECIMAL_DATACELL, temps[1]);
        style = this.createCalculCellStyle();
        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
        this.styles.put(STYLELABEL_CALCULATE_DECIMAL_DATACELL, style);
        temps = this.createDiffLineStyle();
        temps[0].setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00%"));
        this.styles.put(STYLELABEL_EVEN_LINENUMBER_RATING_DATACELL, temps[0]);
        temps[1].setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00%"));
        this.styles.put(STYLELABEL_ODD_LINENUMBER_RATING_DATACELL, temps[1]);
        style = this.createCalculCellStyle();
        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00%"));
        this.styles.put(STYLELABEL_CALCULATE_RATING_DATACELL, style);
    }

    public HSSFCellStyle get(String lable) {
        return (HSSFCellStyle)this.styles.get(lable);
    }

    public HSSFCellStyle getCommonStyle() {
        return this.get(STYLELABEL_COMMON_STYLE);
    }

    public HSSFCellStyle getCommonHeadStyle() {
        return this.get(STYLELABEL_COMMON_HEAD);
    }

    public HSSFCellStyle getCommonCalculateStyle() {
        return this.get(STYLELABEL_COMMON_CALCULATECELL);
    }

    public HSSFCellStyle getCommonDifferStyle(int i) {
        HSSFCellStyle style = null;
        if (i >= 0) {
            style = i % 2 == 0 ? this.get(STYLELABEL_COMMON_EVEN_LINENUMBERCELL) : this.get(STYLELABEL_COMMON_ODD_LINENUMBERCELL);
        }
        return style;
    }

    public HSSFCellStyle getDifferLineDecimalStyle(int i) {
        HSSFCellStyle style = null;
        if (i >= 0) {
            style = i % 2 == 0 ? this.get(STYLELABEL_EVEN_LINENUMBER_DECIMAL_DATACELL) : this.get(STYLELABEL_ODD_LINENUMBER_DECIMAL_DATACELL);
        }
        return style;
    }

    public HSSFCellStyle getDifferLineRatingStyle(int i) {
        HSSFCellStyle style = null;
        if (i >= 0) {
            style = i % 2 == 0 ? this.get(STYLELABEL_EVEN_LINENUMBER_RATING_DATACELL) : this.get(STYLELABEL_ODD_LINENUMBER_RATING_DATACELL);
        }
        return style;
    }

    private HSSFCellStyle createStyle() {
        HSSFCellStyle style = this.book.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderTop((short)1);
        style.setBorderRight((short)1);
        return style;
    }

    private HSSFCellStyle createHeadStyle() {
        HSSFCellStyle style = this.createStyle();
        style.setFillPattern((short)1);
        style.setFillForegroundColor((short)22);
        return style;
    }

    private HSSFCellStyle[] createDiffLineStyle() {
        HSSFCellStyle[] styles = new HSSFCellStyle[2];
        int len = styles.length;
        for (int i = 0; i < len; ++i) {
            styles[i] = this.createStyle();
            styles[i].setFillPattern((short)1);
            styles[i].setAlignment((short)2);
            styles[i].setFillForegroundColor((short)this.getDiffLineColor(i));
        }
        return styles;
    }

    private HSSFCellStyle createCalculCellStyle() {
        HSSFCellStyle style = this.createStyle();
        style.setFillPattern((short)1);
        style.setFillForegroundColor((short)43);
        return style;
    }

    private int getDiffLineColor(int lineNumber) {
        return lineNumber % 2 == 0 ? 9 : 44;
    }
}

