/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public class NumericUtils {
    public static final int NUMBER_TYPE_INT = 0;
    public static final int NUMBER_TYPE_DOUBLE = 1;
    public static final String DIGITAL_REX = "[0-9]*(\\.?)[0-9]*";
    private static final DecimalFormat df = new DecimalFormat("0.00");

    public static String formatNumberText(String formatStr, Number n) {
        if (formatStr == null) {
            return df.format(n);
        }
        DecimalFormat f = new DecimalFormat(formatStr);
        return f.format(n);
    }

    public static String formatNumberText(Number n) {
        return NumericUtils.formatNumberText(null, n);
    }

    public static String formatNumberText(double n) {
        return NumericUtils.formatNumberText(new Double(n));
    }

    public static String formatNumberText(int n) {
        return NumericUtils.formatNumberText(new Integer(n));
    }

    public static boolean isDigital(String text) {
        boolean isDigital = false;
        if (text != null && text.length() > 0) {
            Pattern p = Pattern.compile(DIGITAL_REX);
            isDigital = p.matcher(text).matches();
        }
        return isDigital;
    }

    public static double roundDoubleValue(int scale, double value) {
        return NumericUtils.roundDoubleValue(scale, value, 6);
    }

    public static double roundDoubleValue(int scale, Double value) {
        return NumericUtils.roundDoubleValue(scale, (double)value);
    }

    public static double roundDoubleValue(int scale, double value, int roundingMode) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(scale, roundingMode);
        double d = bd.doubleValue();
        bd = null;
        return d;
    }

    public static Number avoidNullNumber(Number n, int type) {
        if (n == null) {
            Number zeroValue = null;
            switch (type) {
                case 1: {
                    zeroValue = new Double(0.0);
                    break;
                }
                case 0: {
                    zeroValue = new Integer(0);
                }
            }
            return zeroValue;
        }
        return n;
    }

    public static String calculIncreasePercent(Object v1, Object v2, int decimalDigits) {
        return NumericUtils.calculPercent(NumericUtils.sub(v2, v1), v2, decimalDigits);
    }

    public static String calculPercent(Object v1, Object v2, int decimalDigits) {
        String result = null;
        Double _re = NumericUtils.divide(v1, v2, decimalDigits + 2);
        if (_re != null) {
            _re = new Double(NumericUtils.roundDoubleValue(2, _re * 100.0));
            result = ((Object)_re).toString() + "%";
        }
        return result;
    }

    public static Double sub(Object v1, Object v2) {
        Double result = null;
        v1 = (Double)NumericUtils.avoidNullNumber((Number)v1, 1);
        v2 = (Double)NumericUtils.avoidNullNumber((Number)v2, 1);
        result = NumericUtils.sub(new Double(((Number)v1).doubleValue()), new Double(((Number)v2).doubleValue()));
        return (Double)NumericUtils.avoidNullNumber(result, 1);
    }

    public static Integer sub(Integer n1, Integer n2) {
        return new Integer(NumericUtils.avoidNullNumber(n1, 0).intValue() - NumericUtils.avoidNullNumber(n2, 0).intValue());
    }

    public static Integer sub(int n1, Integer n2) {
        return NumericUtils.sub(new Integer(n1), n2);
    }

    public static Integer sub(Integer n1, int n2) {
        return NumericUtils.sub(n1, new Integer(n2));
    }

    public static Double sub(Double n1, Double n2) {
        return new Double(NumericUtils.avoidNullNumber(n1, 1).doubleValue() - NumericUtils.avoidNullNumber(n2, 1).doubleValue());
    }

    public static Double sub(double n1, Double n2) {
        return new Double(n1 - NumericUtils.avoidNullNumber(n2, 1).doubleValue());
    }

    public static Double sub(Double n1, double n2) {
        return new Double(NumericUtils.avoidNullNumber(n1, 1).doubleValue() - n2);
    }

    public static Double sub(Double n1, Integer n2) {
        return new Double(NumericUtils.avoidNullNumber(n1, 1).doubleValue() - (double)NumericUtils.avoidNullNumber(n2, 0).intValue());
    }

    public static Double sub(double n1, Integer n2) {
        return new Double(n1 - (double)NumericUtils.avoidNullNumber(n2, 0).intValue());
    }

    public static Double sub(Double n1, int n2) {
        return new Double(NumericUtils.avoidNullNumber(n1, 1).doubleValue() - (double)n2);
    }

    public static Double sub(Integer n1, Double n2) {
        return new Double((double)NumericUtils.avoidNullNumber(n1, 1).intValue() - NumericUtils.avoidNullNumber(n2, 0).doubleValue());
    }

    public static Double sub(int n1, Double n2) {
        return new Double((double)n1 - NumericUtils.avoidNullNumber(n2, 0).doubleValue());
    }

    public static Double sub(Integer n1, double n2) {
        return new Double((double)NumericUtils.avoidNullNumber(n1, 1).intValue() - n2);
    }

    public static Integer add(Integer n1, Integer n2) {
        return new Integer(NumericUtils.avoidNullNumber(n1, 0).intValue() + NumericUtils.avoidNullNumber(n2, 0).intValue());
    }

    public static Integer add(int n1, Integer n2) {
        return NumericUtils.add(new Integer(n1), n2);
    }

    public static Integer add(Integer n1, int n2) {
        return NumericUtils.add(n1, new Integer(n2));
    }

    public static Double add(Double n1, Double n2) {
        return new Double(NumericUtils.avoidNullNumber(n1, 1).doubleValue() + NumericUtils.avoidNullNumber(n2, 1).doubleValue());
    }

    public static Double add(double n1, Double n2) {
        return NumericUtils.add(new Double(n1), n2);
    }

    public static Double add(Double n1, double n2) {
        return NumericUtils.add(n1, new Double(n2));
    }

    public static Double add(Double n1, Integer n2) {
        return new Double(NumericUtils.avoidNullNumber(n1, 1).doubleValue() + (double)NumericUtils.avoidNullNumber(n2, 0).intValue());
    }

    public static Double add(double n1, Integer n2) {
        return NumericUtils.add(new Double(n1), n2);
    }

    public static Double add(Double n1, int n2) {
        return NumericUtils.add(n1, new Integer(n2));
    }

    public static Double add(Integer n1, Double n2) {
        return new Double((double)NumericUtils.avoidNullNumber(n1, 1).intValue() + NumericUtils.avoidNullNumber(n2, 0).doubleValue());
    }

    public static Double add(int n1, Double n2) {
        return NumericUtils.add(new Integer(n1), n2);
    }

    public static Double add(Integer n1, double n2) {
        return NumericUtils.add(n1, new Double(n2));
    }

    public static Double divide(Object v1, Object v2, int decimalDigits) {
        Double result = null;
        if (v1 instanceof Number && v2 instanceof Number && v2 != null) {
            result = v1 != null && ((Number)v1).intValue() != 0 ? NumericUtils.divide(new Double(((Number)v1).doubleValue()), new Double(((Number)v2).doubleValue()), decimalDigits) : new Double(0.0);
        }
        return (Double)NumericUtils.avoidNullNumber(result, 1);
    }

    public static Double divide(Double n1, Double n2, int decimalDigits) {
        Double result = null;
        n1 = (Double)NumericUtils.avoidNullNumber(n1, 1);
        if (!new Double(0.0).equals(n2 = (Double)NumericUtils.avoidNullNumber(n2, 1))) {
            result = !new Double(0.0).equals(n1) ? new Double(n1 / n2) : Double.valueOf("0");
            result = new Double(NumericUtils.roundDoubleValue(decimalDigits, (double)result));
        }
        return (Double)NumericUtils.avoidNullNumber(result, 1);
    }

    public static Double divide(double n1, double n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1), new Double(n2), decimalDigits);
    }

    public static Double divide(double n1, Double n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1), n2, decimalDigits);
    }

    public static Double divide(Double n1, double n2, int decimalDigits) {
        return NumericUtils.divide(n1, new Double(n2), decimalDigits);
    }

    public static Double divide(Double n1, Integer n2, int decimalDigits) {
        return NumericUtils.divide(n1, new Double(n2.doubleValue()), decimalDigits);
    }

    public static Double divide(Double n1, int n2, int decimalDigits) {
        return NumericUtils.divide(n1, new Double(n2), decimalDigits);
    }

    public static Double divide(double n1, Integer n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1), new Double(n2.doubleValue()), decimalDigits);
    }

    public static Double divide(double n1, int n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1), new Double(n2), decimalDigits);
    }

    public static Double divide(Integer n1, Integer n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1.doubleValue()), new Double(n2.doubleValue()), decimalDigits);
    }

    public static Double divide(int n1, int n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1), new Double(n2), decimalDigits);
    }

    public static Double divide(int n1, Integer n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1), new Double(n2.doubleValue()), decimalDigits);
    }

    public static Double divide(Integer n1, int n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1.doubleValue()), new Double(n2), decimalDigits);
    }

    public static Double divide(Integer n1, Double n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1.doubleValue()), n2, decimalDigits);
    }

    public static Double divide(int n1, Double n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1), n2, decimalDigits);
    }

    public static Double divide(Integer n1, double n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1.doubleValue()), new Double(n2), decimalDigits);
    }

    public static Double divide(int n1, double n2, int decimalDigits) {
        return NumericUtils.divide(new Double(n1), new Double(n2), decimalDigits);
    }
}

