/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs;

import com.kingdee.eas.cp.wfs.AbstractQueryContextInfo;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.QueryCollectEntryCollection;
import com.kingdee.eas.cp.wfs.QueryCollectEntryInfo;
import java.io.Serializable;

public class QueryContextInfo
extends AbstractQueryContextInfo
implements Serializable {
    public QueryContextInfo() {
    }

    protected QueryContextInfo(String pkField) {
        super(pkField);
    }

    public boolean copy(FormConfigInfo config) {
        if (this.verify(config)) {
            this.setFormType(config.getFormType());
            this.setStatPeriod(config.getStatPeriod());
            this.setStartDate(config.getStartDate());
            this.setEndDate(config.getEndDate());
            this.setCollectType(config.getCollectType());
            this.setAdminID(config.getAdmin().getId().toString());
            this.setCuID(config.getAdmin().getCU().getId().toString());
            if (config.getEntry() != null) {
                QueryCollectEntryCollection coll = new QueryCollectEntryCollection();
                QueryCollectEntryInfo entryInfo = null;
                this.put("collectEntry", (Object)coll);
                int size = config.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = new QueryCollectEntryInfo();
                    entryInfo.setCollectID(config.getEntry().get(i).getCollectItemId().toString());
                    coll.add(entryInfo);
                }
                this.put("collectEntry", (Object)coll);
            }
            return true;
        }
        return false;
    }

    private boolean verify(FormConfigInfo config) {
        if (config.getFormType() == null) {
            return false;
        }
        if (config.getStatPeriod() == null) {
            return false;
        }
        if (config.getStartDate() == null) {
            return false;
        }
        if (config.getEndDate() == null) {
            return false;
        }
        if (config.getAdmin() == null && config.getAdmin().getId() == null) {
            return false;
        }
        if (config.getAdmin().getCU() == null && config.getAdmin().getCU().getId() == null) {
            return false;
        }
        if (config.getCollectType() == null) {
            return false;
        }
        return config.getCollectType().getValue() == 0 || config.getEntry() != null && config.getEntry().size() != 0;
    }
}

