/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.message.common.KDMemAttachment;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfs.BaseSettingEntryCollection;
import com.kingdee.eas.cp.wfs.BaseSettingEntryInfo;
import com.kingdee.eas.cp.wfs.BaseSettingFactory;
import com.kingdee.eas.cp.wfs.BaseSettingInfo;
import com.kingdee.eas.cp.wfs.FormConfigFactory;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.IFormConfig;
import com.kingdee.eas.cp.wfs.PortletEntryCollection;
import com.kingdee.eas.cp.wfs.PortletEntryInfo;
import com.kingdee.eas.cp.wfs.PortletFactory;
import com.kingdee.eas.cp.wfs.PortletInfo;
import com.kingdee.eas.cp.wfs.ReceiverCollection;
import com.kingdee.eas.cp.wfs.ReceiverInfo;
import com.kingdee.eas.cp.wfs.SendCycleEnum;
import com.kingdee.eas.cp.wfs.SendListCollection;
import com.kingdee.eas.cp.wfs.SendListFactory;
import com.kingdee.eas.cp.wfs.SendListInfo;
import com.kingdee.eas.cp.wfs.SendLogFactory;
import com.kingdee.eas.cp.wfs.SendLogInfo;
import com.kingdee.eas.cp.wfs.StatusEnum;
import com.kingdee.eas.cp.wfs.app.AbstractSendCenterFacadeControllerBean;
import com.kingdee.eas.cp.wfs.utils.ExcelExportHandler;
import com.kingdee.eas.cp.wfs.utils.FtpUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class SendCenterFacadeControllerBean
extends AbstractSendCenterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.wfs.app.SendCenterFacadeControllerBean");
    private static int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    protected void _deleteMessageRetireJob(Context ctx, String baseID) throws BOSException, EASBizException {
        this._changeJobTriggerStatus(ctx, baseID, "X");
    }

    private void _changeJobTriggerStatus(Context ctx, String baseID, String status) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String procName = SendCenterFacadeControllerBean.getProcessNamePrefix(baseID) + "%";
        sb.append("update t_job_trigger set fisvalid='").append(status).append("' \n where fjobdefid in ").append("(select fjobdefid from t_job_def \n where ftitle like '").append(procName).append("')");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private static String getProcessNamePrefix(String regularID) {
        return "CP_WFS_" + regularID;
    }

    protected void _createMessageBackGroundJob(Context ctx, BaseSettingInfo baseSettingInfo) throws BOSException, EASBizException {
        String baseId = baseSettingInfo.getId().toString();
        BaseSettingEntryCollection entryCol = baseSettingInfo.getEntry();
        BaseSettingEntryInfo entryInfo = null;
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.cp.wfs.app.SendCenterFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("baseID", baseId);
        if (entryCol != null && entryCol.size() > 0) {
            int size = entryCol.size();
            block7: for (int i = 0; i < size; ++i) {
                entryInfo = entryCol.get(i);
                String entryId = entryInfo.getId().toString();
                OperationInfo notifyOperation = null;
                switch (entryInfo.getSendCycle().getValue()) {
                    case 0: {
                        notifyOperation = function.getOperation().get(0);
                        service.createJobProcessDef(this.getProcessName(ctx, entryId, new Date()), function, notifyOperation, jobContext, SendCenterFacadeControllerBean.getScheduleXML(new Date(), ScheduleType.EVERYDAY, entryInfo, -1), ctx.getLocale());
                        continue block7;
                    }
                    case 1: {
                        notifyOperation = function.getOperation().get(1);
                        service.createJobProcessDef(this.getProcessName(ctx, entryId, new Date()), function, notifyOperation, jobContext, SendCenterFacadeControllerBean.getScheduleXML(new Date(), ScheduleType.EVERYWEEK, entryInfo, -1), ctx.getLocale());
                        continue block7;
                    }
                    case 2: {
                        notifyOperation = function.getOperation().get(2);
                        service.createJobProcessDef(this.getProcessName(ctx, entryId, new Date()), function, notifyOperation, jobContext, SendCenterFacadeControllerBean.getScheduleXML(new Date(), ScheduleType.EVERYMONTH, entryInfo, -1), ctx.getLocale());
                        continue block7;
                    }
                    case 3: {
                        notifyOperation = function.getOperation().get(3);
                        for (int k = 0; k < 4; ++k) {
                            service.createJobProcessDef(this.getProcessName(ctx, entryId + k, new Date()), function, notifyOperation, jobContext, SendCenterFacadeControllerBean.getScheduleXML(new Date(), ScheduleType.EVERYMONTH, entryInfo, k), ctx.getLocale());
                        }
                        continue block7;
                    }
                    case 4: {
                        notifyOperation = function.getOperation().get(4);
                        service.createJobProcessDef(this.getProcessName(ctx, entryId, new Date()), function, notifyOperation, jobContext, SendCenterFacadeControllerBean.getScheduleXML(new Date(), ScheduleType.EVERYMONTH, entryInfo, -1), ctx.getLocale());
                    }
                }
            }
        }
    }

    private String getProcessName(Context ctx, String baseId, Date jobDate) {
        return SendCenterFacadeControllerBean.getProcessNamePrefix(baseId) + "_" + SendCenterFacadeControllerBean.getDateStr(jobDate, "yyyy.MM.dd HH:mm");
    }

    private static String getDateStr(Date date, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        return format.format(date);
    }

    private static String getScheduleXML(Date date, ScheduleType type, BaseSettingEntryInfo entryInfo, int quarterly) {
        Date dt = DateTimeUtils.addMinute((Date)date, (long)1L);
        ScheduleDef define = new ScheduleDef(null);
        define.setType(type);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setDefine(SendCenterFacadeControllerBean.getScheduleDateDesc(dt, entryInfo, quarterly));
        define.setRetryTime(0);
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    private static String getScheduleDateDesc(Date date, BaseSettingEntryInfo entryInfo, int quarterly) {
        StringBuffer value = new StringBuffer();
        value.append("0");
        value.append(" ");
        value.append(entryInfo.getMinute());
        value.append(" ");
        value.append(entryInfo.getHour());
        value.append(" ");
        block0 : switch (entryInfo.getSendCycle().getValue()) {
            case 0: {
                value.append("* * ?");
                break;
            }
            case 1: {
                value.append("? * ");
                value.append(entryInfo.getSendDay() % 7 + 1);
                break;
            }
            case 2: {
                value.append(entryInfo.getSendDay());
                value.append(" ");
                value.append("1,2,3,4,5,6,7,8,9,10,11,12 ?");
                break;
            }
            case 3: {
                int sendDay = entryInfo.getSendDay();
                block7 : switch (quarterly) {
                    case 0: {
                        if (sendDay >= 90) {
                            value.append("L 3 ?");
                            break;
                        }
                        for (int i = 0; i < 3; ++i) {
                            if (sendDay > monthDays[i]) {
                                sendDay -= monthDays[i];
                                continue;
                            }
                            value.append(sendDay);
                            value.append(" ");
                            value.append(i + 1);
                            value.append(" ?");
                            break block7;
                        }
                        break block0;
                    }
                    case 1: {
                        if (sendDay >= 91) {
                            value.append("L 6 ?");
                            break;
                        }
                        for (int i = 3; i < 6; ++i) {
                            if (sendDay > monthDays[i]) {
                                sendDay -= monthDays[i];
                                continue;
                            }
                            value.append(sendDay);
                            value.append(" ");
                            value.append(i + 1);
                            value.append(" ?");
                            break block7;
                        }
                        break block0;
                    }
                    case 2: {
                        if (sendDay >= 92) {
                            value.append("L 9 ?");
                            break;
                        }
                        for (int i = 6; i < 9; ++i) {
                            if (sendDay > monthDays[i]) {
                                sendDay -= monthDays[i];
                                continue;
                            }
                            value.append(sendDay);
                            value.append(" ");
                            value.append(i + 1);
                            value.append(" ?");
                            break block7;
                        }
                        break block0;
                    }
                    case 3: {
                        if (sendDay >= 92) {
                            value.append("L 12 ?");
                            break;
                        }
                        for (int i = 9; i < 12; ++i) {
                            if (sendDay > monthDays[i]) {
                                sendDay -= monthDays[i];
                                continue;
                            }
                            value.append(sendDay);
                            value.append(" ");
                            value.append(i + 1);
                            value.append(" ?");
                            break block7;
                        }
                    }
                }
                break;
            }
            case 4: {
                int sendDay = entryInfo.getSendDay();
                if (sendDay >= 365) {
                    value.append("L 12 ?");
                    break;
                }
                for (int i = 0; i < 12; ++i) {
                    if (sendDay > monthDays[i]) {
                        sendDay -= monthDays[i];
                        continue;
                    }
                    value.append(sendDay);
                    value.append(" ");
                    value.append(i + 1);
                    value.append(" ?");
                    break block0;
                }
                break;
            }
        }
        return value.toString();
    }

    protected void _sendFormByDay(Context ctx, String baseID) throws BOSException, EASBizException {
        BaseSettingInfo baseInfo = this.getBaseSettingInfo(ctx, baseID);
        SendListCollection sendCol = this.getSendListCollection(ctx, SendCycleEnum.DAY);
        this.runSend(ctx, baseInfo, sendCol);
    }

    protected void _sendFormByMonth(Context ctx, String baseID) throws BOSException, EASBizException {
        BaseSettingInfo baseInfo = this.getBaseSettingInfo(ctx, baseID);
        SendListCollection sendCol = this.getSendListCollection(ctx, SendCycleEnum.MONTH);
        this.runSend(ctx, baseInfo, sendCol);
    }

    protected void _sendFormByQuarter(Context ctx, String baseID) throws BOSException, EASBizException {
        BaseSettingInfo baseInfo = this.getBaseSettingInfo(ctx, baseID);
        SendListCollection sendCol = this.getSendListCollection(ctx, SendCycleEnum.QUARTER);
        this.runSend(ctx, baseInfo, sendCol);
    }

    protected void _sendFormByWeek(Context ctx, String baseID) throws BOSException, EASBizException {
        BaseSettingInfo baseInfo = this.getBaseSettingInfo(ctx, baseID);
        SendListCollection sendCol = this.getSendListCollection(ctx, SendCycleEnum.WEEK);
        this.runSend(ctx, baseInfo, sendCol);
    }

    protected void _sendFormByYear(Context ctx, String baseID) throws BOSException, EASBizException {
        BaseSettingInfo baseInfo = this.getBaseSettingInfo(ctx, baseID);
        SendListCollection sendCol = this.getSendListCollection(ctx, SendCycleEnum.YEAR);
        this.runSend(ctx, baseInfo, sendCol);
    }

    private void runSend(Context ctx, BaseSettingInfo baseInfo, SendListCollection sendCol) {
        if (!baseInfo.isIsEnable()) {
            return;
        }
        if (sendCol == null || sendCol.size() == 0) {
            return;
        }
        if (baseInfo.isIsSendEmail()) {
            this.sendEmail(ctx, sendCol);
        }
        if (baseInfo.isIsPortlet()) {
            this.sendPortlet(ctx, sendCol);
        }
    }

    private BaseSettingInfo getBaseSettingInfo(Context ctx, String baseID) throws EASBizException, BOSException {
        BaseSettingInfo baseInfo = null;
        if (baseID != null) {
            baseInfo = BaseSettingFactory.getLocalInstance(ctx).getBaseSettingInfo((IObjectPK)new ObjectUuidPK(baseID));
        }
        return baseInfo;
    }

    private SendListCollection getSendListCollection(Context ctx, SendCycleEnum sendCycle) throws BOSException {
        SendListCollection sendCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("sendCycle", (Object)sendCycle));
        filterInfo.getFilterItems().add(new FilterItemInfo("isEnable", (Object)new Boolean(true)));
        view.setSelector(this.getSelectors());
        view.setFilter(filterInfo);
        sendCol = SendListFactory.getLocalInstance(ctx).getSendListCollection(view);
        return sendCol;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("person.id");
        selectors.add("person.name");
        selectors.add("formConfig.*");
        selectors.add("formConfig.admin.id");
        selectors.add("formConfig.admin.name");
        selectors.add("formConfig.admin.number");
        selectors.add("formConfig.admin.level");
        selectors.add("formConfig.admin.longNumber");
        selectors.add("formConfig.admin.cu.id");
        selectors.add("formConfig.admin.cu.longNumber");
        selectors.add("formConfig.person.id");
        selectors.add("formConfig.person.name");
        selectors.add("formConfig.person.number");
        selectors.add("formConfig.CU.id");
        selectors.add("formConfig.entry.*");
        selectors.add("formConfig.entry.id");
        selectors.add("formConfig.entry.collectItemId");
        selectors.add("entry.id");
        selectors.add("entry.person.id");
        selectors.add("entry.person.name");
        selectors.add("entry.person.email");
        return selectors;
    }

    private void setLogs(Context ctx, SendListInfo sendListInfo, StatusEnum statusEnum) {
        if (sendListInfo == null || sendListInfo.getEntry() == null || sendListInfo.getFormConfig() == null) {
            return;
        }
        String formConfigName = sendListInfo.getFormConfig().getName();
        ReceiverCollection receiverCol = sendListInfo.getEntry();
        ReceiverInfo receiverInfo = null;
        CoreBaseCollection coreCol = new CoreBaseCollection();
        SendLogInfo logInfo = null;
        PersonInfo creator = sendListInfo.getPerson();
        int size = receiverCol.size();
        for (int i = 0; i < size; ++i) {
            receiverInfo = receiverCol.get(i);
            logInfo = new SendLogInfo();
            logInfo.setForm(formConfigName);
            logInfo.setStatus(statusEnum);
            logInfo.setReceiver(receiverInfo.getPerson());
            logInfo.setPerson(creator);
            coreCol.add((CoreBaseInfo)logInfo);
        }
        try {
            SendLogFactory.getLocalInstance(ctx).addnew(coreCol);
        }
        catch (EASBizException e) {
            logger.info((Object)("EASBizException:setLogs for portal" + e.getMessage()));
        }
        catch (BOSException e) {
            logger.info((Object)("BOSException:setLogs for portal" + e.getMessage()));
        }
    }

    private void setLogs(Context ctx, SendListInfo sendListInfo, StatusEnum statusEnum, PersonInfo personInfo) {
        if (sendListInfo == null || sendListInfo.getFormConfig() == null) {
            return;
        }
        String formConfigName = sendListInfo.getFormConfig().getName();
        SendLogInfo logInfo = null;
        PersonInfo creator = sendListInfo.getPerson();
        logInfo = new SendLogInfo();
        logInfo.setForm(formConfigName);
        logInfo.setStatus(statusEnum);
        logInfo.setReceiver(personInfo);
        logInfo.setPerson(creator);
        try {
            SendLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)logInfo);
        }
        catch (EASBizException e) {
            logger.info((Object)("EASBizException:setLogs for email" + e.getMessage()));
        }
        catch (BOSException e) {
            logger.info((Object)("BOSException:setLogs for email" + e.getMessage()));
        }
    }

    private void sendPortlet(Context ctx, SendListCollection sendCol) {
        String ftpPathId = FtpUtils.getCurrentFtpSetting(ctx);
        if (!FtpUtils.checkFtpConn(ctx, ftpPathId)) {
            System.out.println("QueryPathID:" + ftpPathId + "\u8fde\u63a5\u51fa\u9519,PORTLET\u63a8\u9001\u5931\u8d25\uff01");
            return;
        }
        SendListInfo sendListInfo = null;
        ReceiverCollection receiverCol = null;
        ReceiverInfo receiverInfo = null;
        PortletInfo portletInfo = null;
        PortletEntryCollection portletEntryCol = null;
        PortletEntryInfo portletEntryInfo = null;
        FormConfigInfo formConfigInfo = null;
        Object entryCol = null;
        Object entryInfo = null;
        IFormConfig iFormConfig = null;
        Object pk = null;
        try {
            iFormConfig = FormConfigFactory.getLocalInstance(ctx);
        }
        catch (BOSException e1) {
            logger.info((Object)("BOSException:sendPortlet" + e1.getMessage()));
        }
        int size = sendCol.size();
        for (int i = 0; i < size; ++i) {
            sendListInfo = sendCol.get(i);
            if (sendListInfo.getFormConfig() == null || sendListInfo.getFormConfig().getName() == null || sendListInfo.getPerson() == null) continue;
            receiverCol = sendListInfo.getEntry();
            portletInfo = new PortletInfo();
            formConfigInfo = this.getNewDateForFormConfigInfo(ctx, sendListInfo.getFormConfig(), sendListInfo);
            portletInfo.setFormConfig(formConfigInfo);
            portletInfo.setName(this.getNameTheme(sendListInfo.getFormConfig(), sendListInfo.getPerson()));
            portletEntryCol = portletInfo.getEntry();
            int len = receiverCol.size();
            for (int k = 0; k < len; ++k) {
                receiverInfo = receiverCol.get(k);
                portletEntryInfo = new PortletEntryInfo();
                portletEntryInfo.setPerson(receiverInfo.getPerson());
                portletEntryCol.add(portletEntryInfo);
            }
            try {
                PortletFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)portletInfo);
                int _size = portletEntryCol.size();
                for (int j = 0; j < _size; ++j) {
                    logger.info((Object)("\u6d41\u7a0b\u7edf\u8ba1\u62a5\u8868\u63a8\u9001\u5230porlet\nportletEntryId\uff1a" + portletEntryCol.get(j).getId().toString() + "\npersonId:" + portletEntryCol.get(j).getPerson().getId().toString() + "\nftpPathId:" + ftpPathId));
                    FtpUtils.pushToFtp(ctx, portletEntryCol.get(j).getId().toString(), portletEntryCol.get(j).getPerson().getId().toString(), ftpPathId, formConfigInfo);
                }
                this.setLogs(ctx, sendListInfo, StatusEnum.NORMAL);
                continue;
            }
            catch (Exception e) {
                this.setLogs(ctx, sendListInfo, StatusEnum.EXCEPTION);
                logger.info((Object)("BOSException:sendPortlet" + e.getMessage()));
            }
        }
    }

    private void sendEmail(Context ctx, SendListCollection sendListCol) {
        SendListInfo sendListInfo = null;
        ReceiverCollection receiverCol = null;
        ReceiverInfo receiverInfo = null;
        FormConfigInfo formConfigInfo = null;
        String bodyStr = null;
        PersonInfo personInfo = null;
        KDMessageAttachment[] attachment = null;
        HSSFWorkbook[] workBook = null;
        String eMail = null;
        boolean success = false;
        int size = sendListCol.size();
        for (int i = 0; i < size; ++i) {
            sendListInfo = sendListCol.get(i);
            formConfigInfo = sendListInfo.getFormConfig();
            if (formConfigInfo == null || formConfigInfo.getName() == null) continue;
            bodyStr = this.getNameTheme(formConfigInfo, sendListInfo.getPerson());
            receiverCol = sendListInfo.getEntry();
            int len = receiverCol.size();
            for (int k = 0; k < len; ++k) {
                receiverInfo = receiverCol.get(k);
                personInfo = receiverInfo.getPerson();
                eMail = personInfo.getEmail();
                if (eMail == null || eMail.trim().length() == 0) {
                    this.setLogs(ctx, sendListInfo, StatusEnum.EXCEPTION, personInfo);
                    continue;
                }
                workBook = this.getReport(ctx, formConfigInfo = this.getNewDateForFormConfigInfo(ctx, formConfigInfo, sendListInfo), personInfo);
                if (workBook != null && workBook.length > 0) {
                    attachment = new KDMessageAttachment[workBook.length];
                    int workBookLen = workBook.length;
                    for (int n = 0; n < workBookLen; ++n) {
                        try {
                            if (workBook[n] == null) continue;
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            workBook[n].write((OutputStream)bos);
                            attachment[n] = new KDMemAttachment();
                            attachment[n].setData(bos.toByteArray());
                            attachment[n].setSize(bos.toByteArray().length);
                            attachment[n].setName(formConfigInfo.getName() + ".xls");
                            continue;
                        }
                        catch (IOException e) {
                            logger.info((Object)("attachment.setData Error" + e.getMessage()));
                        }
                    }
                }
                try {
                    success = MsgUtil.msgMailDerect((Context)ctx, (String)bodyStr, (String)bodyStr, (String)eMail, null, null, (KDMessageAttachment[])attachment);
                    if (success) {
                        this.setLogs(ctx, sendListInfo, StatusEnum.NORMAL, personInfo);
                        continue;
                    }
                    this.setLogs(ctx, sendListInfo, StatusEnum.EXCEPTION, personInfo);
                    continue;
                }
                catch (EASBizException e) {
                    this.setLogs(ctx, sendListInfo, StatusEnum.EXCEPTION, personInfo);
                    logger.info((Object)("EASBizException:setEmail" + e.getMessage()));
                    continue;
                }
                catch (BOSException e) {
                    this.setLogs(ctx, sendListInfo, StatusEnum.EXCEPTION, personInfo);
                    logger.info((Object)("EASBizException:setEmail" + e.getMessage()));
                    continue;
                }
                catch (Exception e) {
                    this.setLogs(ctx, sendListInfo, StatusEnum.EXCEPTION, personInfo);
                    logger.info((Object)("EASBizException:setEmail" + e.getMessage()));
                }
            }
        }
    }

    private String getNameTheme(FormConfigInfo formConfigInfo, PersonInfo personInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append(formConfigInfo.getName());
        sb.append("(");
        sb.append(SendCenterFacadeControllerBean.getDateStr(new Date(), "yyyy-MM-dd"));
        sb.append(",");
        sb.append(personInfo.getName());
        sb.append(")");
        return sb.toString();
    }

    private HSSFWorkbook[] getReport(Context ctx, FormConfigInfo formConfigInfo, PersonInfo personInfo) {
        HSSFWorkbook[] workBook = null;
        if (personInfo != null && personInfo.getId() != null) {
            UserCollection coll = null;
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("person", (Object)personInfo.getId().toString(), CompareType.EQUALS));
            try {
                coll = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
            }
            catch (BOSException e) {
                logger.info((Object)("getReport Error" + e.getMessage()));
            }
            if (coll != null && coll.size() > 0) {
                ExcelExportHandler handler = null;
                handler = new ExcelExportHandler(ctx, formConfigInfo);
                if (handler != null) {
                    workBook = new HSSFWorkbook[coll.size()];
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        try {
                            workBook[i] = handler.getReportDatas(coll.get(i));
                            continue;
                        }
                        catch (Exception e) {
                            logger.info((Object)("getReport Error" + e.getMessage()));
                        }
                    }
                }
            }
        }
        return workBook;
    }

    private FormConfigInfo getNewDateForFormConfigInfo(Context ctx, FormConfigInfo formConfigInfo, SendListInfo sendListInfo) {
        Calendar time = Calendar.getInstance();
        Calendar startTime = null;
        Calendar endTime = null;
        switch (sendListInfo.getSendCycle().getValue()) {
            case 0: {
                time.add(5, -1);
                startTime = time;
                endTime = time;
                break;
            }
            case 1: {
                startTime = Calendar.getInstance();
                endTime = Calendar.getInstance();
                startTime.clear();
                endTime.clear();
                time.setFirstDayOfWeek(2);
                time.add(3, -1);
                time.set(7, time.getFirstDayOfWeek());
                startTime.setTime(time.getTime());
                endTime.setTime(time.getTime());
                endTime.add(5, 6);
                break;
            }
            case 2: {
                startTime = Calendar.getInstance();
                endTime = Calendar.getInstance();
                startTime.clear();
                endTime.clear();
                time.add(2, -1);
                startTime.set(1, time.get(1));
                endTime.set(1, time.get(1));
                startTime.set(2, time.get(2));
                endTime.set(2, time.get(2));
                startTime.set(5, 1);
                endTime.add(5, time.getActualMaximum(5));
                break;
            }
            case 3: {
                startTime = Calendar.getInstance();
                endTime = Calendar.getInstance();
                startTime.clear();
                endTime.clear();
                switch (time.get(1)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        time.add(1, -1);
                        startTime.set(1, time.get(1));
                        endTime.set(1, time.get(1));
                        startTime.set(2, 9);
                        endTime.set(2, 11);
                        startTime.set(5, 1);
                        endTime.set(5, 31);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        startTime.set(1, time.get(1));
                        endTime.set(1, time.get(1));
                        startTime.set(2, 0);
                        endTime.set(2, 2);
                        startTime.set(5, 1);
                        endTime.set(5, 31);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        startTime.set(1, time.get(1));
                        endTime.set(1, time.get(1));
                        startTime.set(2, 3);
                        endTime.set(2, 5);
                        startTime.set(5, 1);
                        endTime.set(5, 30);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        startTime.set(1, time.get(1));
                        endTime.set(1, time.get(1));
                        startTime.set(2, 6);
                        endTime.set(2, 8);
                        startTime.set(5, 1);
                        endTime.set(5, 30);
                    }
                }
                break;
            }
            case 4: {
                startTime = Calendar.getInstance();
                endTime = Calendar.getInstance();
                startTime.clear();
                endTime.clear();
                time.add(1, -1);
                startTime.set(1, time.get(1));
                endTime.set(1, time.get(1));
                startTime.set(2, 0);
                endTime.set(2, 11);
                startTime.set(5, 1);
                endTime.set(5, 31);
            }
        }
        formConfigInfo.setStartDate(DateTimeUtils.truncateDate((Date)startTime.getTime()));
        formConfigInfo.setEndDate(DateTimeUtils.truncateDate((Date)endTime.getTime()));
        return formConfigInfo;
    }
}

