/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Clock {
    private int itemIdx = 0;
    private List startItemList = null;
    private List stopItemList = null;

    public void reset(int idx) {
        this.startItemList.add(idx, null);
        this.stopItemList.add(idx, null);
    }

    public void resetAll() {
        this.startItemList = new ArrayList();
        this.stopItemList = new ArrayList();
        this.itemIdx = 0;
    }

    public Clock() {
        this.resetAll();
    }

    public Date getStartTime(int idx) {
        return (Date)this.startItemList.get(idx);
    }

    public Date getStopTime(int idx) {
        return (Date)this.stopItemList.get(idx);
    }

    public long getCostTimeInMilli(int idx) {
        Date startTime = this.getStartTime(idx);
        Date stopTime = this.getStopTime(idx);
        if (startTime == null || stopTime == null) {
            return 0L;
        }
        return stopTime.getTime() - startTime.getTime();
    }

    public double getCostTimeInSecond(int idx) {
        Date startTime = this.getStartTime(idx);
        Date stopTime = this.getStopTime(idx);
        if (startTime == null || stopTime == null) {
            return 0.0;
        }
        return (double)(stopTime.getTime() - startTime.getTime()) / 1000.0;
    }

    public int start() {
        this.startItemList.add(new Date());
        this.stopItemList.add(null);
        this.itemIdx = this.startItemList.size() - 1;
        return this.itemIdx;
    }

    public boolean start(int idx) {
        return this.start(idx, false);
    }

    public boolean start(int idx, boolean isStepClock) {
        if (this.startItemList.size() >= idx && this.startItemList.get(idx) != null) {
            if (isStepClock) {
                this.stopItemList.add(idx, null);
            } else {
                this.reset(idx);
                this.startItemList.add(idx, new Date());
            }
            return true;
        }
        return false;
    }

    public boolean stop(int idx) {
        if (this.startItemList.size() >= idx && this.startItemList.get(idx) != null) {
            this.stopItemList.add(idx, new Date());
            return true;
        }
        return false;
    }
}

