/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.eas.cp.wfs.utils.Clock;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DataUtil {
    public static final int DB_TYPE_SQLSERVER = 0;
    public static final int DB_TYPE_ORACLE = 1;
    public static final int DB_TYPE_DB2 = 2;
    public static final int MAX_DATAROW_COUNT = 50000;
    public static final String[] RESET_QUERY_CONTEXT_STATEMENTS = new String[]{"DELETE FROM T_WFS_QueryCollectEntry", "DELETE FROM T_WFS_QueryContext", "DELETE FROM T_WFS_QueryData", "DELETE FROM T_WFS_QueryResult"};
    public static final String[] DROP_IDX_STATEMENTS = new String[]{"DROP INDEX T_WFS_ActInst.IX_WFS_STEPINPIID", "DROP INDEX T_WFS_ActInst.IX_WFS_STEPINSIID", "DROP INDEX T_WFS_ActInst.IX_WFS_STEPINSDID", "DROP INDEX T_WFS_ActInst.IX_WFS_STEPINPDID", "DROP INDEX T_WFS_ActInst.IX_WFS_STEPINCTIME", "DROP INDEX T_WFS_ActInst.IX_WFS_STEPINSTAT", "DROP INDEX T_WFS_ActInst.IX_WFS_STEPINVER", "DROP INDEX T_WFS_Assign.IX_WFS_ASSIGNID", "DROP INDEX T_WFS_Assign.IX_WFS_ASSIGNSIID", "DROP INDEX T_WFS_Assign.IX_WFS_ASSIGNPDID", "DROP INDEX T_WFS_Assign.IX_WFS_ASSIGNPIID", "DROP INDEX T_WFS_Assign.IX_WFS_ASSIGNSDID", "DROP INDEX T_WFS_Assign.IX_WFS_ASSIGNSTAT", "DROP INDEX T_WFS_Assign.IX_WFS_ASSIGNCTIME", "DROP INDEX T_WFS_FlowTemplate.IX_WFS_FLOWTEMLNO", "DROP INDEX T_WFS_FlowType.IX_WFS_FLOWTYPENO", "DROP INDEX T_WFS_FormConfigEntry.IX_WFS_CONFENTRBD", "DROP INDEX T_WFS_FormConfigEntry.IX_WFS_CONFENTCID", "DROP INDEX T_WFS_ProcDef.IX_WFS_PROCDEPDID", "DROP INDEX T_WFS_ProcDef.IX_WFS_PROCDEFTYPE", "DROP INDEX T_WFS_ProcDef.IX_WFS_PROCDETEML", "DROP INDEX T_WFS_ProcDef.IX_WFS_PROCDEVER", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINPIID", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINPDID", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINORGID", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINCTIME", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINSTAT", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINVER", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINCRTOR", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINCU", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINORGL", "DROP INDEX T_WFS_ProcInst.IX_WFS_PROCINCULO", "DROP INDEX T_WFS_StepDef.IX_WFS_STEPDEPDID", "DROP INDEX T_WFS_StepDef.IX_WFS_STEPDESDID", "DROP INDEX T_WFS_StepDef.IX_WFS_STEPDEVER"};
    public static final String[] CREATE_IDX_STATEMENTS = new String[]{"CREATE INDEX IX_WFS_STEPINPIID ON T_WFS_ActInst(FProcInstID ASC)", "CREATE INDEX IX_WFS_STEPINSIID ON T_WFS_ActInst(FActInstID ASC)", "CREATE INDEX IX_WFS_STEPINSDID ON T_WFS_ActInst(FActDefID ASC)", "CREATE INDEX IX_WFS_STEPINPDID ON T_WFS_ActInst(FProcDefID ASC)", "CREATE INDEX IX_WFS_STEPINCTIME ON T_WFS_ActInst(FCreateTime ASC)", "CREATE INDEX IX_WFS_STEPINSTAT ON T_WFS_ActInst(FState ASC)", "CREATE INDEX IX_WFS_STEPINVER ON T_WFS_ActInst(FVersion ASC)", "CREATE INDEX IX_WFS_ASSIGNID ON T_WFS_Assign(FAssignID ASC)", "CREATE INDEX IX_WFS_ASSIGNSIID ON T_WFS_Assign(FActInstID ASC)", "CREATE INDEX IX_WFS_ASSIGNPDID ON T_WFS_Assign(FProcDefID ASC)", "CREATE INDEX IX_WFS_ASSIGNPIID ON T_WFS_Assign(FProcInstID ASC)", "CREATE INDEX IX_WFS_ASSIGNSDID ON T_WFS_Assign(FActDefID ASC)", "CREATE INDEX IX_WFS_ASSIGNSTAT ON T_WFS_Assign(FState ASC)", "CREATE INDEX IX_WFS_ASSIGNCTIME ON T_WFS_Assign(FCreateTime ASC)", "CREATE INDEX IX_WFS_FLOWTEMLNO ON T_WFS_FlowTemplate(FNumber ASC)", "CREATE INDEX IX_WFS_FLOWTYPENO ON T_WFS_FlowType(FNumber ASC)", "CREATE INDEX IX_WFS_CONFENTRBD ON T_WFS_FormConfigEntry(FBillID ASC)", "CREATE INDEX IX_WFS_CONFENTCID ON T_WFS_FormConfigEntry(FCollectItemId ASC)", "CREATE INDEX IX_WFS_PROCDEPDID ON T_WFS_ProcDef(FProcDefID ASC)", "CREATE INDEX IX_WFS_PROCDEFTYPE ON T_WFS_ProcDef(FFlowType ASC)", "CREATE INDEX IX_WFS_PROCDETEML ON T_WFS_ProcDef(FFlowTemplate ASC)", "CREATE INDEX IX_WFS_PROCDEVER ON T_WFS_ProcDef(FVersion ASC)", "CREATE INDEX IX_WFS_PROCINPIID ON T_WFS_ProcInst(FProcInstID ASC)", "CREATE INDEX IX_WFS_PROCINPDID ON T_WFS_ProcInst(FProcDefID ASC)", "CREATE INDEX IX_WFS_PROCINORGID ON T_WFS_ProcInst(FOrgID ASC)", "CREATE INDEX IX_WFS_PROCINCTIME ON T_WFS_ProcInst(FCreateTime ASC)", "CREATE INDEX IX_WFS_PROCINSTAT ON T_WFS_ProcInst(FState ASC)", "CREATE INDEX IX_WFS_PROCINVER ON T_WFS_ProcInst(FVersion ASC)", "CREATE INDEX IX_WFS_PROCINCRTOR ON T_WFS_ProcInst(FCreatorID ASC)", "CREATE INDEX IX_WFS_PROCINCU ON T_WFS_ProcInst(FControlUnitID ASC)", "CREATE INDEX IX_WFS_PROCINORGL ON T_WFS_ProcInst(FOrgLongNumber ASC)", "CREATE INDEX IX_WFS_PROCINCULO ON T_WFS_ProcInst(FCuLongNumber ASC)", "CREATE INDEX IX_WFS_STEPDEPDID ON T_WFS_StepDef(FProcDefID ASC)", "CREATE INDEX IX_WFS_STEPDESDID ON T_WFS_StepDef(FActDefID ASC)", "CREATE INDEX IX_WFS_STEPDEVER ON T_WFS_StepDef(FVersion ASC)"};

    public static IRowSet query(Context ctx, String metaQueryPath, EntityViewInfo view) throws BOSException {
        return DataUtil.query(ctx, metaQueryPath, view, -1);
    }

    public static IRowSet query(Context ctx, String metaQueryPath, EntityViewInfo view, Logger logger, Clock clock) throws BOSException {
        return DataUtil.query(ctx, metaQueryPath, view, -1, logger, clock);
    }

    public static IRowSet query(Context ctx, String metaQueryPath, EntityViewInfo view, int limited) throws BOSException {
        return DataUtil.query(ctx, metaQueryPath, view, limited, null, null);
    }

    public static IRowSet query(Context ctx, String metaQueryPath, EntityViewInfo view, int limited, Logger logger, Clock clock) throws BOSException {
        IQueryExecutor iqe;
        IRowSet dataRows = null;
        if (ctx != null && metaQueryPath != null && !metaQueryPath.trim().equals("") && (iqe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(metaQueryPath))) != null) {
            if (view != null) {
                iqe.setObjectView(view);
            }
            if (limited > 0 || limited == 0) {
                if (logger != null) {
                    logger.info((Object)("\n=========================================================\n\n\u67e5\u8be2\u8c03\u7528\u8005\uff1a" + logger.getName() + "\n" + "SQL\u6570\u636e\u67e5\u8be2(\u9650\u5236\u8fd4\u56de\u884c\u6570\uff1a" + limited + ")\uff1a\n" + iqe.getSQL() + "\n"));
                }
                int clockId = -1;
                if (clock != null) {
                    clockId = clock.start();
                }
                dataRows = iqe.executeQuery(0, limited);
                if (clock != null) {
                    clock.stop(clockId);
                    logger.info((Object)("\n\u67e5\u8be2\u8017\u65f6\uff1a" + clock.getCostTimeInSecond(clockId) + "\n"));
                }
            } else {
                if (logger != null) {
                    logger.info((Object)("\n=========================================================\n\n\u67e5\u8be2\u8c03\u7528\u8005\uff1a" + logger.getName() + "\n" + iqe.getSQL() + "\n"));
                }
                int clockId = -1;
                if (clock != null) {
                    clockId = clock.start();
                }
                dataRows = iqe.executeQuery();
                if (clock != null) {
                    clock.stop(clockId);
                    logger.info((Object)("\n\u67e5\u8be2\u8017\u65f6\uff1a" + clock.getCostTimeInSecond(clockId) + "\n"));
                }
            }
        }
        return dataRows;
    }

    public static String getSQL(Context ctx, String metaQueryPath, EntityViewInfo view) throws BOSException {
        IQueryExecutor iqe;
        String sql = null;
        if (ctx != null && metaQueryPath != null && !metaQueryPath.trim().equals("") && (iqe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(metaQueryPath))) != null) {
            if (view != null) {
                iqe.setObjectView(view);
            }
            sql = iqe.getSQL();
        }
        return sql;
    }

    public static IRowSet query(Context ctx, String sql) throws BOSException {
        return DataUtil.query(ctx, sql, null, null);
    }

    public static IRowSet query(Context ctx, String sql, Logger logger, Clock clock) throws BOSException {
        IRowSet dataRows = null;
        if (logger != null) {
            logger.info((Object)("\n=========================================================\n\n\u67e5\u8be2\u8c03\u7528\u8005\uff1a" + logger.getName() + "\n" + sql + "\n"));
        }
        int clockId = -1;
        if (clock != null) {
            clockId = clock.start();
        }
        dataRows = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql).executeSQL();
        if (clock != null) {
            clock.stop(clockId);
            logger.info((Object)("\n\u67e5\u8be2\u8017\u65f6\uff1a" + clock.getCostTimeInSecond(clockId) + "\n"));
        }
        return dataRows;
    }

    public static String getStdevNativeFunctionName(Context ctx) {
        String funcName = "Stddev";
        if (ctx != null) {
            switch (DataUtil.getDbType(ctx)) {
                case 0: {
                    funcName = "Stdev";
                    break;
                }
                case 1: {
                    funcName = "Stddev";
                    break;
                }
                case 2: {
                    funcName = "Stddev";
                }
            }
        }
        return funcName;
    }

    public static int calculExceedQueryTimes(int itemCount) {
        int m = itemCount % 50000;
        return (itemCount - m) / 50000 + (m == 0 ? 0 : 1);
    }

    public static int getDbType(Context ctx) {
        int dbType = -1;
        if (ctx != null) {
            DataCenterManager dc = new DataCenterManager(ctx);
            ArrayList dcInfos = dc.getDCList();
            String dcNumber = ctx.getAIS();
            int size = dcInfos.size();
            for (int i = 0; i < size; ++i) {
                if (!((DCInfo)dcInfos.get(i)).getNumber().equals(dcNumber)) continue;
                switch (((DCInfo)dcInfos.get(i)).getDBType()) {
                    case 0: {
                        dbType = 0;
                        break;
                    }
                    case 1: {
                        dbType = 1;
                        break;
                    }
                    case 2: {
                        dbType = 2;
                    }
                }
                break;
            }
        }
        return dbType;
    }

    public static boolean[] dropIdx(Context ctx) {
        boolean[] ret = new boolean[DROP_IDX_STATEMENTS.length];
        Clock clock = new Clock();
        System.out.print("\u9500\u6bc1\u7d22\u5f15\u6570\uff1a" + DROP_IDX_STATEMENTS.length);
        int id = clock.start();
        int len = DROP_IDX_STATEMENTS.length;
        for (int i = 0; i < len; ++i) {
            try {
                DbUtil.execute((Context)ctx, (String)DROP_IDX_STATEMENTS[i]);
                System.out.print("\u9500\u6bc1\u7d22\u5f15(" + i + ")\u6210\u529f(" + DROP_IDX_STATEMENTS[i] + ")");
                ret[i] = true;
                continue;
            }
            catch (Exception e) {
                ret[i] = false;
                System.out.print("\u9500\u6bc1\u7d22\u5f15(" + i + ")\u5931\u8d25(" + DROP_IDX_STATEMENTS[i] + ")\n\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790 drop idx exception:" + e.getMessage());
            }
        }
        clock.stop(id);
        System.out.print("\u9500\u6bc1\u7d22\u5f15\u8017\u65f6\uff1a" + clock.getCostTimeInSecond(id));
        return ret;
    }

    public static boolean[] createIdx(Context ctx) {
        boolean[] ret = new boolean[CREATE_IDX_STATEMENTS.length];
        Clock clock = new Clock();
        System.out.print("\u5efa\u7acb\u7d22\u5f15\u6570\uff1a" + CREATE_IDX_STATEMENTS.length);
        int id = clock.start();
        int len = CREATE_IDX_STATEMENTS.length;
        for (int i = 0; i < len; ++i) {
            try {
                DbUtil.execute((Context)ctx, (String)CREATE_IDX_STATEMENTS[i]);
                ret[i] = true;
                System.out.print("\u5efa\u7acb\u7d22\u5f15\u6210\u529f(" + CREATE_IDX_STATEMENTS[i] + ")");
                continue;
            }
            catch (Exception e) {
                ret[i] = false;
                System.out.print("\u5efa\u7acb\u7d22\u5f15\u5931\u8d25(" + CREATE_IDX_STATEMENTS[i] + ")\n\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790 create idx exception:" + e.getMessage());
            }
        }
        clock.stop(id);
        System.out.print("\u5efa\u7acb\u7d22\u5f15\u8017\u65f6\uff1a" + clock.getCostTimeInSecond(id));
        return ret;
    }

    public static boolean[] resetQueryContext(Context ctx) {
        boolean[] ret = new boolean[RESET_QUERY_CONTEXT_STATEMENTS.length];
        Clock clock = new Clock();
        int id = clock.start();
        int len = RESET_QUERY_CONTEXT_STATEMENTS.length;
        for (int i = 0; i < len; ++i) {
            try {
                DbUtil.execute((Context)ctx, (String)RESET_QUERY_CONTEXT_STATEMENTS[i]);
                ret[i] = true;
                continue;
            }
            catch (Exception e) {
                ret[i] = false;
            }
        }
        clock.stop(id);
        return ret;
    }
}

