/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.ResourceUtils;
import com.kingdee.eas.cp.wfs.utils.AbstractExcelReportBiz;
import com.kingdee.eas.cp.wfs.utils.DataUtil;
import com.kingdee.eas.cp.wfs.utils.DateUtils;
import com.kingdee.eas.cp.wfs.utils.NumericUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.json.JSONException;

public class ExcelExportGeneralViewReportBiz
extends AbstractExcelReportBiz {
    private static final String TEXT_ITEM = ResourceUtils.getString("ITEM");
    public static final String LABEL_SYS_CURRENT_USER_COUNT = "syc";
    public static final String LABEL_PROCESSING_USER_COUNT = "puc";
    public static final String LABEL_AVERAGE_USED_FREQUENCY_BY_USER = "aufbu";
    public static final String LABEL_PROC_SUM = "ps";
    public static final String LABEL_PROC_EXCU_COUNT = "pec";
    public static final String LABEL_STEP_SUM = "ss";
    public static final String LABEL_PROC_AVERAGE_EXCU_TIME_COST = "peatc";
    public static final String LABEL_STEP_AVERAGE_EXCU_TIME_COST = "seatc";
    public static final String LABEL_AUDIT_BY_SMS_PERCENT = "absp";
    public static final String SYS_CURRENT_USER_DATA_QUERY = "com.kingdee.eas.cp.wfs.app.GetReportDataGeneralViewSysCurrentUserDataQuery";
    public static final String PROCESSING_USER_COUNT_QUERY = "com.kingdee.eas.cp.wfs.app.GetReportDataGeneralViewProcessingUserCountDataQuery";
    public static final String PROCESSING_CREATOR_COUNT_QUERY = "com.kingdee.eas.cp.wfs.app.GetReportDataGeneralViewProcessingCreatorCountDataQuery";
    public static final String PROC_DEF_COUNT_QUERY = "com.kingdee.eas.cp.wfs.app.GetReportDataGeneralViewProcDefCountDataQuery";
    public static final String PROC_INST_EXCU_COUNT_QUERY = "com.kingdee.eas.cp.wfs.app.GetReportDataGeneralViewProcInstExcuCountDataQuery";
    public static final String STEP_INST_COUNT_QUERY = "com.kingdee.eas.cp.wfs.app.GetReportDataGeneralViewStepInstCountDataQuery";
    public static final String PROC_AVERAGE_EXCU_TIME_COST_QUERY = "com.kingdee.eas.cp.wfs.app.GetReportDataGeneralViewProcAverageExcuTimeCostDataQuery";
    public static final String STEP_AVERAGE_EXCU_TIME_COST_QUERY = "com.kingdee.eas.cp.wfs.app.GetReportDataGeneralViewStepAverageExcuTimeCostDataQuery";
    private String[] items_text = new String[]{ResourceUtils.getString("SYS_USER_COUNT"), ResourceUtils.getString("PROCESSING_USER_COUNT"), ResourceUtils.getString("AVERAGE_USED_FREQUENCY_BY_USER"), ResourceUtils.getString("PROC_SUM"), ResourceUtils.getString("PROC_EXCU_COUNT"), ResourceUtils.getString("STEP_SUM"), ResourceUtils.getString("PROC_EXCU_AVERAGE_TIME_COST"), ResourceUtils.getString("STEP_EXCU_AVERAGE_TIME_COST")};
    private String[] items_id = new String[]{"syc", "puc", "aufbu", "ps", "pec", "ss", "peatc", "seatc"};

    private String createDateCASESQL(List periodDatas, String dateField, Date startDate) {
        StringBuffer sql = new StringBuffer();
        sql.append("\n (CASE \n WHEN " + dateField + " < {TS'" + DateUtils.formatDate(startDate, null) + "'} THEN '" + "dateGroup" + "_0' \n");
        Map itemData = null;
        int size = periodDatas.size();
        for (int i = 0; i < size; ++i) {
            itemData = (Map)periodDatas.get(i);
            sql.append("WHEN " + dateField + " BETWEEN {TS'" + DateUtils.formatDate((Date)itemData.get("startDate"), null) + "'} AND {TS'" + DateUtils.formatDate(DateUtils.addOneDay((Date)itemData.get("endDate")), null) + "'} THEN '" + "dateGroup" + i + "' \n");
        }
        sql.append("END)\n");
        return sql.toString();
    }

    private String createUserDateCASESQL(List periodDatas) {
        StringBuffer sql = new StringBuffer();
        sql.append("\n (CASE \n");
        Map itemData = null;
        int size = periodDatas.size();
        for (int i = 0; i < size; ++i) {
            itemData = (Map)periodDatas.get(i);
            sql.append("WHEN \"USER\".FEffectiveDate < {TS'" + DateUtils.formatDate(DateUtils.addOneDay((Date)itemData.get("endDate")), null) + "'} THEN '" + "dateGroup" + i + "' \n");
        }
        sql.append("END)\n");
        return sql.toString();
    }

    public void buildBodyData(Context ctx, FormConfigInfo config) throws JSONException, EASBizException, BOSException, UuidException, SQLException {
        int len = this.items_text.length;
        for (int i = 0; i < len; ++i) {
            this.appendCellData(i + 1, 0, this.createCellData(this.items_text[i]), this.getDiffLineCellStyle(i + 1));
            this.registRowIdx(this.items_id[i], i + 1);
        }
        this.buildBizGridData(ctx, config);
        this.fillUpEmptyGridCell();
    }

    public void buildHeadData(Context ctx, FormConfigInfo config) throws JSONException {
        HSSFCellStyle style = this.styleKit.getCommonHeadStyle();
        this.appendCellData(0, 0, this.createCellData(TEXT_ITEM), style);
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        if (periodDatas != null) {
            int size = periodDatas.size();
            for (int i = 0; i < size; ++i) {
                this.appendCellData(0, i + 1, this.createCellData(DateUtils.getPeriodText((Map)periodDatas.get(i), null)), style);
                this.registColIdx("dateGroup" + i, i + 1);
            }
            this.setDataColCount(periodDatas.size());
            this.setDataColStartIdx(1);
        }
    }

    private void buildBizGridData(Context ctx, FormConfigInfo config) throws BOSException, SQLException, JSONException, EASBizException, UuidException {
        Map processingUserCountMap;
        this.setDataRowStartIdx(1);
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        IRowSet dataRows = this.querySysCurrentUserCountData(ctx, periodDatas, config);
        if (dataRows != null) {
            boolean countData = false;
            HashMap<String, Integer> periodMap = new HashMap<String, Integer>();
            while (dataRows.next()) {
                if (dataRows.getString("PERIOD") == null) continue;
                periodMap.put(dataRows.getString("PERIOD"), new Integer(dataRows.getInt("COUNTDATA")));
            }
            int value = 0;
            int size = periodDatas.size();
            for (int i = 0; i < size; ++i) {
                value = !periodMap.containsKey("dateGroup" + i) ? (i == 0 ? 0 : (Integer)periodMap.get("dateGroup" + (i - 1))) : (i != 0 ? (Integer)periodMap.get("dateGroup" + (i - 1)) + (Integer)periodMap.get("dateGroup" + i) : (Integer)periodMap.get("dateGroup" + i));
                this.appendBizCellData(LABEL_SYS_CURRENT_USER_COUNT, "dateGroup" + i, new Integer(value), null);
                periodMap.put("dateGroup" + i, new Integer(value));
            }
        }
        if ((processingUserCountMap = this.buildProcessingUserCountMap(ctx, periodDatas, config)) != null) {
            Iterator it = processingUserCountMap.keySet().iterator();
            String periodId = null;
            while (it.hasNext()) {
                periodId = (String)it.next();
                this.appendBizCellData(LABEL_PROCESSING_USER_COUNT, periodId, (Integer)processingUserCountMap.get(periodId), null);
            }
        }
        if ((dataRows = this.queryProcDefCountData(ctx, periodDatas, config)) != null) {
            boolean countData = false;
            HashMap<String, Integer> periodMap = new HashMap<String, Integer>();
            while (dataRows.next()) {
                if (dataRows.getString("PERIOD") == null) continue;
                periodMap.put(dataRows.getString("PERIOD"), new Integer(dataRows.getInt("COUNTINST")));
            }
            int value = 0;
            int size = periodDatas.size();
            for (int i = 0; i < size; ++i) {
                value = !periodMap.containsKey("dateGroup" + i) ? (i == 0 ? (periodMap.get("dateGroup_0") == null ? 0 : (Integer)periodMap.get("dateGroup_0")) : (Integer)periodMap.get("dateGroup" + (i - 1))) : (i != 0 ? (Integer)periodMap.get("dateGroup" + (i - 1)) + (Integer)periodMap.get("dateGroup" + i) : (Integer)periodMap.get("dateGroup" + i));
                this.appendBizCellData(LABEL_PROC_SUM, "dateGroup" + i, new Integer(value), null);
                periodMap.put("dateGroup" + i, new Integer(value));
            }
        }
        if ((dataRows = this.queryProcInstExcuCountData(ctx, periodDatas, config)) != null) {
            String periodId = null;
            Integer result = null;
            while (dataRows.next()) {
                periodId = dataRows.getString("PERIOD");
                result = new Integer(dataRows.getInt("COUNTDATA"));
                if (periodId == null) continue;
                this.appendBizCellData(LABEL_PROC_EXCU_COUNT, periodId, result, null);
                if (processingUserCountMap == null) continue;
                this.appendBizCellData(LABEL_AVERAGE_USED_FREQUENCY_BY_USER, periodId, NumericUtils.divide((Object)result, NumericUtils.avoidNullNumber((Integer)processingUserCountMap.get(periodId), 0), 2), this.styleKit.getDifferLineDecimalStyle(this.getRowIdx(LABEL_AVERAGE_USED_FREQUENCY_BY_USER)));
            }
        }
        if ((dataRows = this.queryStepInstCountData(ctx, periodDatas, config)) != null) {
            while (dataRows.next()) {
                this.appendBizCellData(LABEL_STEP_SUM, dataRows.getString("PERIOD"), new Integer(dataRows.getInt("COUNTDATA")), null);
            }
        }
        if ((dataRows = this.queryProcAverageExcuTimeCostData(ctx, periodDatas, config)) != null) {
            while (dataRows.next()) {
                this.appendBizCellData(LABEL_PROC_AVERAGE_EXCU_TIME_COST, dataRows.getString("PERIOD"), DateUtils.calculateWorkTime(dataRows.getString("AVGDATA")), null);
            }
        }
        if ((dataRows = this.queryStepAverageExcuTimeCostData(ctx, periodDatas, config)) != null) {
            while (dataRows.next()) {
                this.appendBizCellData(LABEL_STEP_AVERAGE_EXCU_TIME_COST, dataRows.getString("PERIOD"), DateUtils.calculateWorkTime(dataRows.getString("AVGDATA")), null);
            }
        }
        this.setDataRowCount(this.items_id.length);
    }

    public String createSysCurrentUserCountSQL(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("invalidationDate", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS));
        String sql = DataUtil.getSQL(ctx, SYS_CURRENT_USER_DATA_QUERY, view);
        String caseSQL = this.createUserDateCASESQL(periodDatas);
        String replace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        return sql.replaceAll(replace, caseSQL + " AS \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", caseSQL) + "ORDER BY \"PERIOD\"";
    }

    public IRowSet querySysCurrentUserCountData(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException, EASBizException, UuidException, SQLException {
        return this.query(ctx, this.createSysCurrentUserCountSQL(ctx, periodDatas, config));
    }

    public String createProcessingUserCountSQL(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        String sql = DataUtil.getSQL(ctx, PROCESSING_USER_COUNT_QUERY, view);
        String caseSQL = this.createDateCASESQL(periodDatas, "\"ASSIGN\".FCREATETIME");
        String replace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        sql = sql.replaceAll(replace, caseSQL + " AS \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", caseSQL);
        sql = sql.replaceAll("(?u)SELECT", "SELECT \"ASSIGN\".FUSERID AS \"ASSIGN.USERID\",");
        sql = this.insertGroupByItem(sql, "\"ASSIGN\".FUSERID");
        sql = "SELECT COUNT(T.\"ASSIGN.USERID\") AS \"COUNTDATA\",T.PERIOD FROM(\n" + sql + "\n) AS T GROUP BY T.PERIOD";
        return sql;
    }

    public String createProcessingCreatorCountSQL(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        String sql = DataUtil.getSQL(ctx, PROCESSING_CREATOR_COUNT_QUERY, view);
        String caseSQL = this.createDateCASESQL(periodDatas, "\"PROCINST\".FCREATETIME");
        String replace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        sql = sql.replaceAll(replace, caseSQL + " AS \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", caseSQL);
        sql = sql.replaceAll("(?u)SELECT", "SELECT \"PROCINST\".FCREATORID AS \"CREATOR\",");
        sql = this.insertGroupByItem(sql, "\"PROCINST\".FCREATORID");
        sql = "SELECT COUNT(T.\"CREATOR\") AS \"COUNTDATA\",T.PERIOD FROM(\n" + sql + "\n) AS T GROUP BY T.PERIOD";
        return sql;
    }

    public IRowSet queryProcessingUserCountData(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        return this.query(ctx, this.createProcessingUserCountSQL(ctx, periodDatas, config));
    }

    public IRowSet queryProcessingCreatorCountData(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        return this.query(ctx, this.createProcessingCreatorCountSQL(ctx, periodDatas, config));
    }

    public Map buildProcessingUserCountMap(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException, SQLException {
        HashMap<String, Integer> calculMap = new HashMap<String, Integer>();
        IRowSet dataRows = this.queryProcessingUserCountData(ctx, periodDatas, config);
        String periodId = null;
        if (dataRows != null) {
            while (dataRows.next()) {
                calculMap.put(dataRows.getString("PERIOD"), new Integer(dataRows.getInt("COUNTDATA")));
            }
        }
        if ((dataRows = this.queryProcessingCreatorCountData(ctx, periodDatas, config)) != null) {
            while (dataRows.next()) {
                periodId = dataRows.getString("PERIOD");
                calculMap.put(periodId, new Integer(NumericUtils.avoidNullNumber((Integer)calculMap.get(periodId), 0).intValue() + NumericUtils.avoidNullNumber(new Integer(dataRows.getInt("COUNTDATA")), 0).intValue()));
            }
        }
        return calculMap;
    }

    public String createProcDefCountSQL(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        String sql = DataUtil.getSQL(ctx, PROC_DEF_COUNT_QUERY, null);
        String caseSQL = this.createDateCASESQL(periodDatas, "FCreateTime", config.getStartDate());
        String replace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        sql = sql.replaceAll(replace, caseSQL + " AS \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", caseSQL) + "ORDER BY \"PERIOD\"";
        return sql;
    }

    public IRowSet queryProcDefCountData(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        return this.query(ctx, this.createProcDefCountSQL(ctx, periodDatas, config));
    }

    public String createProcInstExcuCountSQL(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        String sql = DataUtil.getSQL(ctx, PROC_INST_EXCU_COUNT_QUERY, view);
        String caseSQL = this.createDateCASESQL(periodDatas, "\"PROCINST\".FCREATETIME");
        String replace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        return sql.replaceAll(replace, caseSQL + " AS \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", caseSQL);
    }

    public IRowSet queryProcInstExcuCountData(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        return this.query(ctx, this.createProcInstExcuCountSQL(ctx, periodDatas, config));
    }

    public String createStepInstCountSQL(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("procInst.orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        String sql = DataUtil.getSQL(ctx, STEP_INST_COUNT_QUERY, view);
        String caseSQL = this.createDateCASESQL(periodDatas, "\"STEPINST\".FCREATETIME");
        String replace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        sql = sql.replaceAll(replace, caseSQL + " AS \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", caseSQL);
        return sql;
    }

    public IRowSet queryStepInstCountData(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        return this.query(ctx, this.createStepInstCountSQL(ctx, periodDatas, config));
    }

    public String createProcAverageExcuTimeCostSQL(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        String sql = DataUtil.getSQL(ctx, PROC_AVERAGE_EXCU_TIME_COST_QUERY, view);
        String caseSQL = this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime");
        String replace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        return sql.replaceAll(replace, caseSQL + " AS \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", caseSQL);
    }

    public IRowSet queryProcAverageExcuTimeCostData(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        return this.query(ctx, this.createProcAverageExcuTimeCostSQL(ctx, periodDatas, config));
    }

    public String createStepAverageExcuTimeCostSQL(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("procInst.orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        String sql = DataUtil.getSQL(ctx, STEP_AVERAGE_EXCU_TIME_COST_QUERY, view);
        String caseSQL = this.createDateCASESQL(periodDatas, "\"STEPINST\".FCreateTime");
        String replace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        sql = sql.replaceAll(replace, caseSQL + " AS \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", caseSQL);
        sql = "SELECT T.PERIOD,AVG(T.COSTWORKTIME) AS AVGDATA FROM (\n" + sql + ") AS T GROUP BY T.PERIOD";
        return sql;
    }

    public IRowSet queryStepAverageExcuTimeCostData(Context ctx, List periodDatas, FormConfigInfo config) throws BOSException {
        return this.query(ctx, this.createStepAverageExcuTimeCostSQL(ctx, periodDatas, config));
    }
}

