/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wp.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.common.web.util.WebContext;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.wp.DictateOrderCollection;
import com.kingdee.eas.cp.wp.DictateOrderFactory;
import com.kingdee.eas.cp.wp.DictateOrderInfo;
import com.kingdee.eas.cp.wp.IDictateOrder;
import com.kingdee.eas.cp.wp.IJobPlan;
import com.kingdee.eas.cp.wp.JobPlanCollection;
import com.kingdee.eas.cp.wp.JobPlanFactory;
import com.kingdee.eas.cp.wp.JobPlanInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class WPPortletListAction
extends Action {
    private String resultMsg = "";
    private static final String PLAN = "plan";
    private static final String DICTATE = "dictate";
    private static final String MEETING = "meeting";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.resultMsg = "";
        String method = request.getParameter("method");
        if (PLAN.equalsIgnoreCase(method)) {
            this.resultMsg = this.getPlanListData(mapping, form, request, response).toString();
        } else if (DICTATE.equalsIgnoreCase(method)) {
            this.resultMsg = this.getDictateListData(mapping, form, request, response).toString();
        } else if (MEETING.equalsIgnoreCase(method)) {
            this.resultMsg = this.getMeetingListData(mapping, form, request, response).toString();
        }
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(this.resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONObject getMeetingListData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JSONObject data = new JSONObject();
        JSONArray rows = new JSONArray();
        WebContext ctx = WebContextUtil.getWebContext((HttpServletRequest)request);
        String limit = request.getParameter("limit");
        String start = request.getParameter("start");
        String sortField = request.getParameter("sort");
        String dir = request.getParameter("dir");
        String d = request.getParameter("d");
        Context context = null;
        if (ctx != null) {
            context = ctx.getEasContext();
        }
        try {
            SorterItemInfo sort;
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
            PersonInfo person = userInfo.getPerson();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            boolean containDate = false;
            if (d != null && !"".equals(d)) {
                try {
                    Date startDate = DateTimeUtils.parseDate((String)d, (String)"yyyy-MM-dd");
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(startDate);
                    cal.add(5, 7);
                    Date endDate = cal.getTime();
                    filter.getFilterItems().add(new FilterItemInfo("convokeTime", (Object)startDate, CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("convokeTime", (Object)endDate, CompareType.LESS));
                    containDate = true;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)userInfo.getId()));
            if (person != null) {
                filter.getFilterItems().add(new FilterItemInfo("joinPeople", (Object)("%" + person.getNumber() + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("entrys.responsibility.id", (Object)person.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("entrys.trackPeople.id", (Object)person.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("BIMUDF0001", (Object)Integer.valueOf(String.valueOf(10)), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)userInfo.getId()));
                filter.getFilterItems().add(new FilterItemInfo("BIMUDF0001", (Object)Integer.valueOf(String.valueOf(10))));
                if (containDate) {
                    filter.setMaskString("#0 and #1 and (((#2 or #3 or #4 or #5) and #6) or (#7 and #8))");
                } else {
                    filter.setMaskString("((#0 or #1 or #2 or #3) and #4) or (#5 and #6)");
                }
            }
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("title"));
            sic.add(new SelectorItemInfo("entrys.id"));
            sic.add(new SelectorItemInfo("entrys.project"));
            sic.add(new SelectorItemInfo("entrys.responsibility.name"));
            sic.add(new SelectorItemInfo("convokeTime"));
            sic.add(new SelectorItemInfo("entrys.requestTime"));
            sic.add(new SelectorItemInfo("entrys.decidePrjState"));
            sic.add(new SelectorItemInfo("joinPeople"));
            view.setSelector(sic);
            SorterItemCollection coll = new SorterItemCollection();
            if (sortField != null && !"".equals(sortField)) {
                if ("responsibility".equals(sortField)) {
                    sortField = "entrys.responsibility.name";
                }
                if ("convokeTime".equals(sortField)) {
                    sortField = "convokeTime";
                }
                sort = new SorterItemInfo(sortField);
                if ("desc".equalsIgnoreCase(dir)) {
                    sort.setSortType(SortType.DESCEND);
                } else {
                    sort.setSortType(SortType.ASCEND);
                }
                coll.add(sort);
                if (!"title".equals(sortField)) {
                    SorterItemInfo defaultSort = new SorterItemInfo("title");
                    defaultSort.setSortType(SortType.ASCEND);
                    coll.add(defaultSort);
                }
            } else {
                sort = new SorterItemInfo("convokeTime");
                sort.setSortType(SortType.ASCEND);
                coll.add(sort);
            }
            SorterItemInfo entrySort = new SorterItemInfo("entrys.seq");
            entrySort.setSortType(SortType.ASCEND);
            coll.add(entrySort);
            view.setSorter(coll);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.wp.app.MeetingDecideMMHQuery");
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            exec.setObjectView(view);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isIgnorePermissionCheck = false;
            IRowSet set = exec.executeQuery();
            int rowCount = set.size();
            data.put("totalCount", rowCount);
            data.put("rows", (Object)rows);
            if (set != null && set.size() > 0) {
                int i;
                int pageSize = Integer.parseInt(limit);
                int pageBegin = Integer.parseInt(start);
                set.beforeFirst();
                for (i = 0; i < pageBegin && i < rowCount; ++i) {
                    set.next();
                }
                for (i = 0; i < pageSize && set.next(); ++i) {
                    JSONObject row = new JSONObject();
                    row.put("id", (Object)(set.getString("id") + set.getString("entrys.id")));
                    row.put("title", (Object)set.getString("title"));
                    row.put("project", (Object)set.getString("entrys.project"));
                    row.put("responsibility", (Object)set.getString("entrys.responsibility.name"));
                    row.put("convokeTime", (Object)(set.getTime("convokeTime") == null ? "" : DateTimeUtils.format((Date)set.getTime("convokeTime"), (String)"yyyy-MM-dd")));
                    row.put("requestTime", (Object)set.getString("entrys.requestTime"));
                    row.put("decidePrjState", (Object)set.getString("entrys.decidePrjState"));
                    row.put("billID", (Object)set.getString("id"));
                    row.put("joinPeople", (Object)set.getString("joinPeople"));
                    rows.put((Object)row);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return data;
    }

    private JSONObject getDictateListData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JSONObject data = new JSONObject();
        JSONArray rows = new JSONArray();
        WebContext ctx = WebContextUtil.getWebContext((HttpServletRequest)request);
        String limit = request.getParameter("limit");
        String start = request.getParameter("start");
        String sortField = request.getParameter("sort");
        String dir = request.getParameter("dir");
        String d = request.getParameter("d");
        Context context = null;
        if (ctx != null) {
            context = ctx.getEasContext();
        }
        try {
            SorterItemInfo sort;
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
            PersonInfo person = userInfo.getPerson();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            boolean containDate = false;
            if (d != null && !"".equals(d)) {
                try {
                    Date startDate = DateTimeUtils.parseDate((String)d, (String)"yyyy-MM-dd");
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(startDate);
                    cal.add(5, 7);
                    Date endDate = cal.getTime();
                    filter.getFilterItems().add(new FilterItemInfo("finishDate", (Object)startDate, CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("finishDate", (Object)endDate, CompareType.LESS));
                    containDate = true;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)userInfo.getId().toString()));
            if (person != null) {
                filter.getFilterItems().add(new FilterItemInfo("directionLead.id", person.get("id")));
                filter.getFilterItems().add(new FilterItemInfo("scoutPerson", (Object)("%" + person.getName() + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("liabilityPerson.id", person.get("id")));
                filter.getFilterItems().add(new FilterItemInfo("sender", (Object)("%" + person.getName() + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("finishInfo", (Object)Integer.valueOf(String.valueOf(10)), CompareType.NOTEQUALS));
                if (containDate) {
                    filter.setMaskString("(#0 and #1) and (#2 or (#3 or #4 or #5 or #6) and (#7))");
                } else {
                    filter.setMaskString("#0 or (#1 or #2 or #3 or #4) and (#5)");
                }
            }
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("workTitle"));
            sic.add(new SelectorItemInfo("directionLead"));
            sic.add(new SelectorItemInfo("directionLead.id"));
            sic.add(new SelectorItemInfo("directionLead.name"));
            sic.add(new SelectorItemInfo("liabilityPerson"));
            sic.add(new SelectorItemInfo("liabilityPerson.id"));
            sic.add(new SelectorItemInfo("liabilityPerson.name"));
            sic.add(new SelectorItemInfo("finishDate"));
            sic.add(new SelectorItemInfo("directionDate"));
            sic.add(new SelectorItemInfo("workContent"));
            sic.add(new SelectorItemInfo("scoutPerson"));
            sic.add(new SelectorItemInfo("finishInfo"));
            sic.add(new SelectorItemInfo("finishExplain"));
            view.setSelector(sic);
            SorterItemCollection coll = new SorterItemCollection();
            if (sortField != null && !"".equals(sortField)) {
                if ("directionLead".equals(sortField)) {
                    sortField = "directionLead.name";
                }
                if ("liabilityPerson".equals(sortField)) {
                    sortField = "liabilityPerson.name";
                }
                sort = new SorterItemInfo(sortField);
                if ("desc".equalsIgnoreCase(dir)) {
                    sort.setSortType(SortType.DESCEND);
                } else {
                    sort.setSortType(SortType.ASCEND);
                }
                coll.add(sort);
            } else {
                sort = new SorterItemInfo("finishDate");
                sort.setSortType(SortType.ASCEND);
                coll.add(sort);
            }
            view.setSorter(coll);
            IDictateOrder order = DictateOrderFactory.getRemoteInstance();
            DictateOrderCollection orderCollection = order.getDictateOrderCollection(view);
            data.put("totalCount", orderCollection.size());
            data.put("rows", (Object)rows);
            if (orderCollection != null && orderCollection.size() > 0) {
                int pageBegin;
                int pageSize = Integer.parseInt(limit);
                int cnt = orderCollection.size();
                for (int n = pageBegin = Integer.parseInt(start); n < cnt && n < pageBegin + pageSize; ++n) {
                    DictateOrderInfo orderInfo = orderCollection.get(n);
                    JSONObject row = new JSONObject();
                    row.put("id", (Object)orderInfo.getId().toString());
                    row.put("workTitle", (Object)orderInfo.getWorkTitle());
                    row.put("directionLead", (Object)(orderInfo.getDirectionLead() == null ? "" : orderInfo.getDirectionLead().getName()));
                    row.put("liabilityPerson", (Object)(orderInfo.getLiabilityPerson() == null ? "" : orderInfo.getLiabilityPerson().getName()));
                    row.put("finishDate", (Object)(orderInfo.getFinishDate() == null ? "" : DateTimeUtils.format((Date)orderInfo.getFinishDate(), (String)"yyyy-MM-dd")));
                    row.put("directionDate", (Object)(orderInfo.getDirectionDate() == null ? "" : DateTimeUtils.format((Date)orderInfo.getDirectionDate(), (String)"yyyy-MM-dd")));
                    row.put("workContent", (Object)orderInfo.getWorkContent());
                    row.put("scoutPerson", (Object)(orderInfo.getScoutPerson() == null ? "" : orderInfo.getScoutPerson()));
                    row.put("finishInfo", (Object)orderInfo.getFinishInfo());
                    String tempFinishExplain = orderInfo.getFinishExplain();
                    if (tempFinishExplain != null && tempFinishExplain.indexOf("\r\n") > -1) {
                        tempFinishExplain = tempFinishExplain.replaceAll("\r\n", "<br/>");
                    }
                    if (tempFinishExplain != null && tempFinishExplain.indexOf("\n") > -1) {
                        tempFinishExplain = tempFinishExplain.replaceAll("\n", "<br/>");
                    }
                    row.put("finishExplain", (Object)tempFinishExplain);
                    rows.put((Object)row);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return data;
    }

    private JSONObject getPlanListData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JSONObject data = new JSONObject();
        JSONArray rows = new JSONArray();
        WebContext ctx = WebContextUtil.getWebContext((HttpServletRequest)request);
        String limit = request.getParameter("limit");
        String start = request.getParameter("start");
        String sortField = request.getParameter("sort");
        String dir = request.getParameter("dir");
        String d = request.getParameter("d");
        Context context = null;
        if (ctx != null) {
            context = ctx.getEasContext();
        }
        try {
            SorterItemInfo sort;
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
            PersonInfo person = userInfo.getPerson();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            boolean containDate = false;
            if (d != null && !"".equals(d)) {
                try {
                    Date startDate = DateTimeUtils.parseDate((String)d, (String)"yyyy-MM-dd");
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(startDate);
                    cal.add(5, 7);
                    Date endDate = cal.getTime();
                    fic.add(new FilterItemInfo("startTime", (Object)startDate, CompareType.GREATER_EQUALS));
                    fic.add(new FilterItemInfo("startTime", (Object)endDate, CompareType.LESS));
                    fic.add(new FilterItemInfo("endTime", (Object)startDate, CompareType.GREATER_EQUALS));
                    fic.add(new FilterItemInfo("endTime", (Object)endDate, CompareType.LESS));
                    fic.add(new FilterItemInfo("startTime", (Object)startDate, CompareType.LESS));
                    fic.add(new FilterItemInfo("endTime", (Object)endDate, CompareType.GREATER_EQUALS));
                    containDate = true;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            fic.add(new FilterItemInfo("creator.id", (Object)userInfo.getId().toString()));
            if (containDate) {
                filter.setMaskString("((#0 and #1) or (#2 and #3) or (#4 and #5)) and #6 ");
            }
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("title"));
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("burdenPerson"));
            sic.add(new SelectorItemInfo("burdenPerson.id"));
            sic.add(new SelectorItemInfo("burdenPerson.name"));
            sic.add(new SelectorItemInfo("startTime"));
            sic.add(new SelectorItemInfo("endTime"));
            sic.add(new SelectorItemInfo("trackPerson"));
            sic.add(new SelectorItemInfo("trackPerson.id"));
            sic.add(new SelectorItemInfo("trackPerson.name"));
            sic.add(new SelectorItemInfo("department"));
            sic.add(new SelectorItemInfo("department.id"));
            sic.add(new SelectorItemInfo("department.name"));
            sic.add(new SelectorItemInfo("planCyc"));
            view.setSelector(sic);
            SorterItemCollection coll = new SorterItemCollection();
            if (sortField != null && !"".equals(sortField)) {
                if ("burdenPerson".equals(sortField)) {
                    sortField = "burdenPerson.name";
                }
                sort = new SorterItemInfo(sortField);
                if ("desc".equalsIgnoreCase(dir)) {
                    sort.setSortType(SortType.DESCEND);
                } else {
                    sort.setSortType(SortType.ASCEND);
                }
                coll.add(sort);
            } else {
                sort = new SorterItemInfo("startTime");
                sort.setSortType(SortType.DESCEND);
                coll.add(sort);
            }
            view.setSorter(coll);
            IJobPlan jobPlan = JobPlanFactory.getRemoteInstance();
            JobPlanCollection jobCollection = jobPlan.getJobPlanCollection(view);
            data.put("totalCount", jobCollection.size());
            data.put("rows", (Object)rows);
            if (jobCollection != null && jobCollection.size() > 0) {
                int pageBegin;
                int pageSize = Integer.parseInt(limit);
                int cnt = jobCollection.size();
                for (int n = pageBegin = Integer.parseInt(start); n < cnt && n < pageBegin + pageSize; ++n) {
                    JobPlanInfo jobInfo = jobCollection.get(n);
                    JSONObject row = new JSONObject();
                    row.put("id", (Object)jobInfo.getId().toString());
                    row.put("title", (Object)jobInfo.getTitle());
                    row.put("state", (Object)jobInfo.getState());
                    row.put("burdenPerson", (Object)(jobInfo.getBurdenPerson() == null ? "" : jobInfo.getBurdenPerson().getName()));
                    row.put("startTime", (Object)(jobInfo.getStartTime() == null ? "" : DateTimeUtils.format((Date)jobInfo.getStartTime(), (String)"yyyy-MM-dd")));
                    row.put("endTime", (Object)(jobInfo.getEndTime() == null ? "" : DateTimeUtils.format((Date)jobInfo.getEndTime(), (String)"yyyy-MM-dd")));
                    row.put("trackPerson", (Object)(jobInfo.getTrackPerson() == null ? "" : jobInfo.getTrackPerson().getName()));
                    row.put("department", (Object)(jobInfo.getDepartment() == null ? "" : jobInfo.getDepartment().getName()));
                    row.put("planCyc", (Object)(jobInfo.getPlanCyc() == null ? "" : jobInfo.getPlanCyc().getAlias()));
                    rows.put((Object)row);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return data;
    }
}

