/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wp.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.wp.IWPPortletConfig;
import com.kingdee.eas.cp.wp.WPPortletConfigCollection;
import com.kingdee.eas.cp.wp.WPPortletConfigFactory;
import com.kingdee.eas.cp.wp.WPPortletConfigInfo;
import com.kingdee.eas.util.app.ContextUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONObject;

public class WPPortletSettingAction
extends Action {
    private String resultMsg = "";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.wp.web.WPPortletSettingAction");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.resultMsg = "";
        String method = request.getParameter("method");
        if ("save".equalsIgnoreCase(method)) {
            this.save(mapping, form, request, response);
        } else if ("show".equalsIgnoreCase(method)) {
            this.show(mapping, form, request, response);
        }
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(this.resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void show(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)userInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("isCMAdmin", (Object)new Integer(0)));
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("isCMAdmin");
        if (WPPortletSettingAction.isCMAdmin(ctx)) {
            filter.getFilterItems().add(new FilterItemInfo("isCMAdmin", (Object)new Integer(1)));
            filter.setMaskString("(#0 and #1) or #2 ");
            sort.setSortType(SortType.DESCEND);
        } else {
            sort.setSortType(SortType.ASCEND);
        }
        sortColl.add(sort);
        view.setSorter(sortColl);
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("initItem"));
        sic.add(new SelectorItemInfo("planPagesize"));
        sic.add(new SelectorItemInfo("dictatePagesize"));
        sic.add(new SelectorItemInfo("meetingPagesize"));
        view.setSelector(sic);
        IWPPortletConfig wpPortletConfig = WPPortletConfigFactory.getRemoteInstance();
        WPPortletConfigCollection coll = wpPortletConfig.getWPPortletConfigCollection(view);
        if (coll != null && coll.size() > 0) {
            WPPortletConfigInfo wpConfigInfo = coll.get(0);
            JSONObject info = new JSONObject();
            info.put("id", (Object)wpConfigInfo.getId().toString());
            info.put("initItem", (Object)wpConfigInfo.getInitItem());
            info.put("planPagesize", wpConfigInfo.getPlanPagesize());
            info.put("dictatePagesize", wpConfigInfo.getDictatePagesize());
            info.put("meetingPagesize", wpConfigInfo.getMeetingPagesize());
            this.resultMsg = info.toString();
        }
    }

    protected void save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WPPortletConfigInfo model = this.initParams(request);
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IWPPortletConfig wpPortletConfig = WPPortletConfigFactory.getRemoteInstance();
        if (null != model.getId() && !"".equals(model.getId())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("initItem"));
            selector.add(new SelectorItemInfo("planPagesize"));
            selector.add(new SelectorItemInfo("dictatePagesize"));
            selector.add(new SelectorItemInfo("meetingPagesize"));
            selector.add(new SelectorItemInfo("isCMAdmin"));
            wpPortletConfig.updatePartial(model, selector);
        } else {
            wpPortletConfig.addnew(model);
        }
        JSONObject info = new JSONObject();
        info.put("id", (Object)model.getId().toString());
        info.put("initItem", (Object)model.getInitItem());
        info.put("planPagesize", model.getPlanPagesize());
        info.put("dictatePagesize", model.getDictatePagesize());
        info.put("meetingPagesize", model.getMeetingPagesize());
        info.put("success", (Object)Boolean.TRUE);
        this.resultMsg = info.toString();
    }

    private WPPortletConfigInfo initParams(HttpServletRequest request) throws BOSException {
        Context ctx;
        String initItem = request.getParameter("initType");
        int planCnt = 10;
        int dictateCnt = 10;
        int meetingCnt = 10;
        try {
            planCnt = Integer.parseInt(request.getParameter("planCount"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            dictateCnt = Integer.parseInt(request.getParameter("dictateCount"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            meetingCnt = Integer.parseInt(request.getParameter("meetingCount"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        WPPortletConfigInfo wpConfigInfo = new WPPortletConfigInfo();
        String id = null;
        if (null != request.getParameter("id") && !"".equals(request.getParameter("id"))) {
            id = request.getParameter("id");
            wpConfigInfo.setId(BOSUuid.read((String)id));
        }
        if (WPPortletSettingAction.isCMAdmin(ctx = WebContextUtil.getEasContext((HttpServletRequest)request))) {
            wpConfigInfo.setId(this.getCMAdminID(ctx));
            wpConfigInfo.setIsCMAdmin(1);
        } else {
            wpConfigInfo.setIsCMAdmin(0);
        }
        wpConfigInfo.setInitItem(initItem);
        wpConfigInfo.setPlanPagesize(planCnt);
        wpConfigInfo.setDictatePagesize(dictateCnt);
        wpConfigInfo.setMeetingPagesize(meetingCnt);
        return wpConfigInfo;
    }

    public static boolean isCMAdmin(Context ctx) {
        boolean isCMAdmin = false;
        try {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            try {
                isCMAdmin = iPermission.hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "portal_manage");
            }
            catch (Exception e) {
                logger.info((Object)(ctx.getUserName() + "\u4e0d\u662f\u95e8\u6237\u7ba1\u7406\u5458"));
            }
        }
        catch (BOSException e) {
            logger.info((Object)"MenuBaseAction:\u83b7\u53d6\u6743\u9650\u5931\u8d25");
        }
        return isCMAdmin;
    }

    private BOSUuid getCMAdminID(Context ctx) throws BOSException {
        BOSUuid adminBosID = null;
        IWPPortletConfig wpPortletConfig = WPPortletConfigFactory.getRemoteInstance();
        WPPortletConfigCollection pcColl = wpPortletConfig.getWPPortletConfigCollection("where isCMAdmin = 1");
        if (pcColl != null && pcColl.size() > 0) {
            adminBosID = pcColl.get(0).getId();
        }
        return adminBosID;
    }
}

