/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.formularengine;

import com.kingdee.bos.bi.model.common.formularengine.exception.StackPushingException;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringConstException;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.CompositeExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.ConstantExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.FuncExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.StringExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.VarExpr;
import com.kingdee.bos.bi.model.common.formularengine.oper.AbstractOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.DualisticOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.IDualisticOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.IOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.UnitaryOper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class FormularParser {
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char MULTIPLY = '*';
    private static final char DIVIDE = '/';
    private static final char L_BRACKET = '(';
    private static final char R_BRACKET = ')';
    private static final char RETURN = '\n';
    private static final char BLANK = ' ';
    private static final char COMMA = ',';
    private static final char DQM = '\"';
    private static final char BACKLASH = '\\';
    private CustomStack _stack = new CustomStack();
    private boolean _isFuncSupported;
    private boolean _isStringSupported;

    public void setFuncSupported(boolean isSupported) {
        this._isFuncSupported = isSupported;
    }

    public void setStringSupported(boolean isSupported) {
        this._isStringSupported = isSupported;
    }

    public AbstractExpr parse(String str) throws StringParsingException {
        int idx;
        this._stack.clear();
        if (str == null) {
            str = "";
        }
        str = str + '\n';
        ParserAux aux = new ParserAux();
        char chr = ' ';
        try {
            int c = str.length();
            for (idx = 0; idx < c; ++idx) {
                chr = str.charAt(idx);
                if (this._isStringSupported && this.spellString(chr, aux)) continue;
                if (this._isFuncSupported && chr == ',') {
                    aux.tryAcceptWord(this._stack);
                    this._stack.pushComma();
                    continue;
                }
                this.spellNormal(chr, aux);
            }
            aux.spellEnd();
            this._stack.pushEnd();
        }
        catch (StackPushingException ex) {
            throw new StringParsingException(ex, str, idx);
        }
        catch (StringConstException ex) {
            throw new StringParsingException(ex, str, idx);
        }
        return this._stack.pop();
    }

    private void spellNormal(char chr, ParserAux aux) throws StackPushingException {
        if (chr == ' ' || chr == '\n') {
            aux.tryAcceptWord(this._stack);
        } else if (chr == '(') {
            aux.tryAcceptWord(this._stack);
            this._stack.pushLeftBracket(this._isFuncSupported);
        } else if (chr == ')') {
            aux.tryAcceptWord(this._stack);
            this._stack.pushRightBracket();
        } else {
            DualisticOper oper = FormularParser.getOper(chr);
            if (oper != null) {
                aux.tryAcceptWord(this._stack);
                if (this._stack.askNeedDelay(oper)) {
                    aux.delayOper(oper);
                } else {
                    this._stack.pushOper(oper);
                }
            } else {
                aux.continueSpelling(chr);
            }
        }
    }

    private boolean spellString(char chr, ParserAux aux) throws StackPushingException, StringConstException {
        if (aux.isInsideString()) {
            aux.continueSpelling(chr);
            if (!aux.isInsideString()) {
                aux.acceptString(this._stack);
            }
            return true;
        }
        if (chr == '\"') {
            aux.stringStart();
            return true;
        }
        return false;
    }

    private static DualisticOper getOper(char chr) {
        switch (chr) {
            case '+': {
                return DualisticOper.PLUS;
            }
            case '-': {
                return DualisticOper.MINUS;
            }
            case '*': {
                return DualisticOper.MULTIPLY;
            }
            case '/': {
                return DualisticOper.DIVIDE;
            }
        }
        return null;
    }

    private static class CustomStack {
        private static final Object LBRACKET = "(";
        private Stack _stack = new Stack();

        private CustomStack() {
        }

        private Object peek() {
            if (this._stack.isEmpty()) {
                return null;
            }
            return this._stack.peek();
        }

        public void pushExpr(AbstractExpr expr) throws StackPushingException {
            Object last = this.peek();
            if (last instanceof AbstractExpr) {
                AbstractExpr lastExpr = (AbstractExpr)last;
                throw new StackPushingException("\u4e0d\u5141\u8bb8\u8fde\u7eed\u7684\u8868\u8fbe\u5f0f\uff1a" + lastExpr.getExprString() + "  " + expr.getExprString());
            }
            this._stack.push(expr);
        }

        public boolean askNeedDelay(IOper oper) {
            Object last = this.peek();
            return oper == DualisticOper.MINUS && (last == Comma.INST || last == LBRACKET || last == null);
        }

        public void pushOper(IOper oper) throws StackPushingException {
            Object last = this.peek();
            if (last == Comma.INST) {
                throw new StackPushingException("\u9519\u8bef\u7684\u8fd0\u7b97\u7b26\u6216\u9017\u53f7\uff0c\u6216\u8005\u7f3a\u5c11\u8868\u8fbe\u5f0f\uff1a, " + oper);
            }
            if (last instanceof IOper) {
                throw new StackPushingException("\u4e0d\u5141\u8bb8\u8fde\u7eed\u7684\u8fd0\u7b97\u7b26\uff1a" + last + "  " + oper);
            }
            if (last == LBRACKET) {
                throw new StackPushingException("\u7f3a\u5c11\u8868\u8fbe\u5f0f\uff1a" + last + "  " + oper);
            }
            if (last == null) {
                throw new StackPushingException("\u4e0d\u80fd\u4ee5\u8fd0\u7b97\u7b26\u5f00\u5934");
            }
            this.composeExpr(new Aux(oper));
            this._stack.push(oper);
        }

        public void pushLeftBracket(boolean isFuncSupported) throws StackPushingException {
            Object last = this.peek();
            if (isFuncSupported && last instanceof VarExpr) {
                FuncExpr func = new FuncExpr(((VarExpr)last).getVarName());
                this._stack.pop();
                this._stack.push(func);
            } else if (last instanceof AbstractExpr) {
                AbstractExpr expr = (AbstractExpr)last;
                throw new StackPushingException("\u7f3a\u5c11\u8fd0\u7b97\u7b26\uff1a" + expr.getExprString() + "  (");
            }
            this._stack.push(LBRACKET);
        }

        public void pushRightBracket() throws StackPushingException {
            Object last = this.peek();
            if (last == Comma.INST) {
                this._stack.push(FuncExpr.PARAM_VALUE_DEFAULT);
            } else if (last instanceof IOper) {
                throw new StackPushingException("\u7f3a\u5c11\u8868\u8fbe\u5f0f\uff1a" + last + "  )");
            }
            this.composeExpr(new Aux(SpecialOper.RIGHT_BRACKET));
        }

        public void pushComma() throws StackPushingException {
            Object last = this.peek();
            if (last == null) {
                throw new StackPushingException("\u4e0d\u80fd\u4ee5\u9017\u53f7\u5f00\u5934");
            }
            if (last == Comma.INST || last == LBRACKET) {
                this._stack.push(FuncExpr.PARAM_VALUE_DEFAULT);
            } else if (last instanceof IOper) {
                throw new StackPushingException("\u9519\u8bef\u7684\u8fd0\u7b97\u7b26\u6216\u9017\u53f7\uff0c\u6216\u8005\u7f3a\u5c11\u8868\u8fbe\u5f0f\uff1a" + last + " , ");
            }
            if (!this.isCommaValid()) {
                throw new StackPushingException("\u9017\u53f7\u53ea\u80fd\u4f5c\u4e3a\u51fd\u6570\u53c2\u6570\u7684\u95f4\u9694\u7b26\u51fa\u73b0");
            }
            this.composeExpr(new Aux(Comma.INST));
            this._stack.push(Comma.INST);
        }

        private boolean isCommaValid() {
            for (int i = this._stack.size() - 1; i >= 0; --i) {
                if (this._stack.get(i) != LBRACKET || i <= 0 || !(this._stack.get(i - 1) instanceof FuncExpr)) continue;
                return true;
            }
            return false;
        }

        public void pushEnd() throws StackPushingException {
            Object last = this.peek();
            if (last == Comma.INST) {
                throw new StackPushingException("\u4e0d\u80fd\u4ee5\u9017\u53f7\u7ed3\u5c3e");
            }
            if (last instanceof IOper) {
                throw new StackPushingException("\u4e0d\u80fd\u4ee5\u8fd0\u7b97\u7b26\u7ed3\u5c3e");
            }
            this.composeExpr(new Aux(SpecialOper.END));
            if (this._stack.size() > 1) {
                throw new StackPushingException("\u5de6\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u591a\u4f59\u7684\u5de6\u62ec\u53f7\uff0c\u6216\u7f3a\u5c11\u53f3\u62ec\u53f7");
            }
        }

        public AbstractExpr pop() {
            if (this._stack.isEmpty()) {
                return null;
            }
            return (AbstractExpr)this._stack.pop();
        }

        public void clear() {
            this._stack.clear();
        }

        private void composeExpr(Aux aux) throws StackPushingException {
            if (aux.getOperPriority() >= 0) {
                this.popPopPushStack(aux);
            } else {
                boolean isLeftBracketMatched = false;
                while (this._stack.size() > 1) {
                    if (!this.popPopPushStack(aux)) {
                        return;
                    }
                    boolean bl = isLeftBracketMatched = isLeftBracketMatched || aux.isTakeOffLeftBracket();
                    if (!aux.isRightBracket() || !aux.isTakeOffLeftBracket()) continue;
                    return;
                }
                if (aux.isRightBracket() && !isLeftBracketMatched) {
                    throw new StackPushingException("\u5de6\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u591a\u4f59\u7684\u53f3\u62ec\u53f7");
                }
            }
        }

        private boolean popPopPushStack(Aux aux) {
            AbstractExpr leftExpr = null;
            AbstractExpr rightExpr = null;
            IDualisticOper oper = null;
            boolean cancel = true;
            while (!this._stack.isEmpty()) {
                Object pop = this._stack.pop();
                if (pop instanceof AbstractExpr) {
                    if (rightExpr == null) {
                        rightExpr = (AbstractExpr)pop;
                    } else {
                        leftExpr = (AbstractExpr)pop;
                    }
                } else if (pop instanceof IDualisticOper) {
                    oper = (IDualisticOper)pop;
                    if (aux.getOperPriority() > ((IDualisticOper)pop).getPriority()) {
                        cancel = true;
                        break;
                    }
                } else if (pop == LBRACKET) {
                    cancel = true;
                    if (aux.isRightBracket()) break;
                    this._stack.push(pop);
                    break;
                }
                if (leftExpr == null || oper == null || rightExpr == null) continue;
                if (!this._stack.isEmpty() && aux.isRightBracket() && this._stack.peek() == LBRACKET) {
                    this._stack.pop();
                    aux.takeOffLeftBracket();
                }
                cancel = false;
                break;
            }
            if (aux.getOperPriority() < 0 && this.peek() instanceof FuncExpr) {
                if (cancel) {
                    FuncExpr func = (FuncExpr)this.peek();
                    if (rightExpr != null) {
                        func.addParam(rightExpr);
                    }
                    if (aux.isRightBracket()) {
                        aux.takeOffLeftBracket();
                    }
                    return false;
                }
                CompositeExpr ce = new CompositeExpr(leftExpr, oper, rightExpr);
                FuncExpr func = (FuncExpr)this.peek();
                ArrayList plainParams = new ArrayList();
                this.translatePlainParams(ce, plainParams);
                for (int i = 0; i < plainParams.size(); ++i) {
                    func.addParam((AbstractExpr)plainParams.get(i));
                }
                return true;
            }
            if (cancel) {
                if (oper != null) {
                    this._stack.push(oper);
                }
                if (rightExpr != null) {
                    this._stack.push(rightExpr);
                }
                return false;
            }
            this._stack.push(new CompositeExpr(leftExpr, oper, rightExpr));
            return true;
        }

        private boolean translatePlainParams(CompositeExpr ce, List result) {
            AbstractExpr right;
            if (ce.getOper() != Comma.INST) {
                return false;
            }
            AbstractExpr left = ce.getLeftExpr();
            if (left instanceof CompositeExpr) {
                if (!this.translatePlainParams((CompositeExpr)left, result)) {
                    result.add(left);
                }
            } else {
                result.add(left);
            }
            if ((right = ce.getRightExpr()) instanceof CompositeExpr) {
                if (!this.translatePlainParams((CompositeExpr)right, result)) {
                    result.add(right);
                }
            } else {
                result.add(right);
            }
            return true;
        }

        private static class Aux {
            private IOper _currentOper;
            private boolean _isTakeOffLeftBracket = false;

            public Aux(IOper currentOper) {
                this._currentOper = currentOper;
            }

            public int getOperPriority() {
                return this._currentOper.getPriority();
            }

            public boolean isRightBracket() {
                return this._currentOper == SpecialOper.RIGHT_BRACKET;
            }

            public boolean isTakeOffLeftBracket() {
                return this._isTakeOffLeftBracket;
            }

            public void takeOffLeftBracket() {
                this._isTakeOffLeftBracket = true;
            }
        }
    }

    private static class Comma
    extends DualisticOper {
        public static final IOper INST = new Comma(",", 0);

        protected Comma(String key, int priority) {
            super(key, priority, null);
        }
    }

    private static class SpecialOper
    extends AbstractOper {
        public static final IOper RIGHT_BRACKET = new SpecialOper(")", -1);
        public static final IOper END = new SpecialOper("End", -1);

        protected SpecialOper(String key, int priority) {
            super(key, priority, null);
        }
    }

    private static class ParserAux {
        private boolean _isWordSpelling;
        private StringBuffer _word;
        private boolean _isInsideString;
        private boolean _isTranslation;
        private IOper _delayOper;

        public ParserAux() {
            this.newWord();
        }

        public boolean isInsideString() {
            return this._isInsideString;
        }

        public void stringStart() throws StringConstException {
            if (this._isWordSpelling) {
                throw new StringConstException("\u5b57\u7b26\u4e32\u8d77\u6b62\u6807\u8bc6\u7b26\u53cc\u5f15\u53f7\u4f4d\u7f6e\u4e0d\u6b63\u786e");
            }
            this._isInsideString = true;
        }

        public void continueSpelling(char chr) {
            if (this._isInsideString) {
                if (this._isTranslation) {
                    this._isTranslation = false;
                    this._word.append('\\');
                } else {
                    if (chr == '\\') {
                        this._isTranslation = true;
                        return;
                    }
                    if (chr == '\"') {
                        this._isInsideString = false;
                        return;
                    }
                }
            }
            this._word.append(chr);
            this._isWordSpelling = true;
        }

        public void spellEnd() throws StringConstException {
            if (this._isInsideString) {
                throw new StringConstException("\u7f3a\u5c11\u53cc\u5f15\u53f7--\u5b57\u7b26\u4e32\u7ed3\u675f\u7b26");
            }
        }

        public void acceptString(CustomStack stack) throws StackPushingException {
            this.tryAcceptDelayOper(stack);
            StringExpr expr = new StringExpr(this._word.toString());
            stack.pushExpr(expr);
            this.newWord();
        }

        public void tryAcceptWord(CustomStack stack) throws StackPushingException {
            if (this._isWordSpelling) {
                AbstractExpr expr;
                block8: {
                    boolean isNegative = false;
                    if (this._delayOper != null) {
                        if (this._delayOper == DualisticOper.MINUS) {
                            isNegative = true;
                            this._delayOper = null;
                        } else {
                            this.tryAcceptDelayOper(stack);
                        }
                    }
                    String word = this._word.toString();
                    expr = null;
                    try {
                        String forNum = word;
                        if (isNegative) {
                            forNum = "-" + forNum;
                        }
                        BigDecimal num = new BigDecimal(forNum);
                        expr = new ConstantExpr(num);
                    }
                    catch (NumberFormatException ex) {
                        expr = new VarExpr(word);
                        if (!isNegative) break block8;
                        expr = new CompositeExpr(UnitaryOper.NEGATIVE, expr);
                    }
                }
                stack.pushExpr(expr);
                this.newWord();
            } else {
                this.tryAcceptDelayOper(stack);
            }
        }

        private void newWord() {
            this._isWordSpelling = false;
            this._word = new StringBuffer();
        }

        public void delayOper(IOper oper) {
            this._delayOper = oper;
        }

        private void tryAcceptDelayOper(CustomStack stack) throws StackPushingException {
            if (this._delayOper != null) {
                stack.pushOper(this._delayOper);
                this._delayOper = null;
            }
        }
    }
}

