/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.bizcenter.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.bizframework.billconfig.UseStatusEnum;
import com.kingdee.eas.bizframework.bizcenter.BillFilterCollection;
import com.kingdee.eas.bizframework.bizcenter.BillFilterFactory;
import com.kingdee.eas.bizframework.bizcenter.BillFilterInfo;
import com.kingdee.eas.bizframework.bizcenter.BillTypeInfo;
import com.kingdee.eas.bizframework.bizcenter.BizFrameworkException;
import com.kingdee.eas.bizframework.bizcenter.JobConfigCollection;
import com.kingdee.eas.bizframework.bizcenter.JobConfigInfo;
import com.kingdee.eas.bizframework.bizcenter.JobFactory;
import com.kingdee.eas.bizframework.bizcenter.JobInfo;
import com.kingdee.eas.bizframework.bizcenter.app.AbstractJobConfigControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class JobConfigControllerBean
extends AbstractJobConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bizframework.bizcenter.app.JobConfigControllerBean");

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        JobConfigInfo info = (JobConfigInfo)this.getValue(ctx, pk);
        if (2 == info.getState().getValue()) {
            throw new BizFrameworkException(BizFrameworkException.HAS_ENADBLE_DATA, new Object[]{info.getNumber()});
        }
        this.deleteFilter(ctx, pk.toString());
        super._delete(ctx, pk);
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        JobConfigInfo info = (JobConfigInfo)super.getValue(ctx, pk, selector);
        String id = info.getId().toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("jobConfigID", (Object)id);
        filter.appendFilterItem("user.id", (Object)ctx.getCaller().toString());
        ev.setFilter(filter);
        BillFilterCollection billfilter = BillFilterFactory.getLocalInstance(ctx).getBillFilterCollection(ev);
        if (billfilter.get(0) != null) {
            info.setFilter(billfilter.get(0).getFilter());
        }
        return info;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        JobConfigInfo jobConfig = (JobConfigInfo)model;
        if (jobConfig.getCU() == null) {
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            jobConfig.setCU(cu);
        }
        String number = jobConfig.getNumber();
        String cuid = jobConfig.getCU().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("number", (Object)number);
        filter.appendFilterItem("CU.id", (Object)cuid);
        if (jobConfig.getId() != null) {
            String id = jobConfig.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            throw new BizFrameworkException(BizFrameworkException.JOBCONFIG_IS_EXISTS);
        }
        try {
            this.checkSameBillType(ctx, jobConfig);
            String newFilter = jobConfig.getFilter();
            this.checkFilter(newFilter);
            String isFromMenu = jobConfig.getString("isFromMenu");
            if ("false".equals(isFromMenu) && jobConfig.getId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(jobConfig.getId());
                if (this.exists(ctx, (IObjectPK)pk)) {
                    JobConfigInfo tempInfo = this.getJobConfigInfo(ctx, (IObjectPK)pk);
                    jobConfig.setFilter(tempInfo.getFilter());
                } else {
                    jobConfig.setState(UseStatusEnum.SAVED);
                }
            } else {
                jobConfig.setState(UseStatusEnum.SAVED);
            }
            this.checkActionIsNull(ctx, jobConfig);
            IObjectPK id = super._save(ctx, (IObjectValue)jobConfig);
            jobConfig.setFilter(newFilter);
            this.doFilterSave(ctx, id.toString(), jobConfig);
            return id;
        }
        catch (PermissionServiceException e) {
            throw new BizFrameworkException(BizFrameworkException.NULL_EXCEPTION, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkFilter(String filterStr) throws BizFrameworkException {
        if (filterStr != null && !"".equals(filterStr)) {
            try {
                FilterInfo filterInfo = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                throw new BizFrameworkException(BizFrameworkException.FILTER_ERROR);
            }
        }
    }

    private void checkActionIsNull(Context ctx, JobConfigInfo jobConfig) throws EASBizException, BOSException {
        JobInfo jobInfo = jobConfig.getJob();
        ObjectUuidPK jobID = new ObjectUuidPK(jobInfo.getId());
        jobInfo = (JobInfo)JobFactory.getLocalInstance(ctx).getValue((IObjectPK)jobID);
        BillTypeInfo srcBillTypeInfo = jobConfig.getSrcBillType();
        BillTypeInfo destBillTypeInfo = jobInfo.getDestBillType();
        if (srcBillTypeInfo != null && srcBillTypeInfo.getId().equals((Object)destBillTypeInfo.getId()) && destBillTypeInfo != null && jobConfig.getAction() == null) {
            throw new BizFrameworkException(BizFrameworkException.ACTION_NOT_NULL);
        }
    }

    private void checkSameBillType(Context ctx, JobConfigInfo jobConfig) throws BOSException, BizFrameworkException, SQLException {
        IRowSet rs;
        StringBuffer sql = new StringBuffer();
        sql.append(" select t1.fdestbilltypeid,t2.fsrcbilltypeid  ");
        sql.append(" from  t_biz_job  t1   ");
        sql.append(" inner join  t_biz_jobconfig t2 on t1.fid = t2.fjobid ");
        sql.append(" inner join  t_biz_billtype t3 on t1.fdestbilltypeid = t3.fid ");
        sql.append(" where  t1.fdestbilltypeid = fsrcbilltypeid ");
        sql.append(" and t1.fid = '" + jobConfig.getJob().getId() + "' ");
        if (jobConfig.getId() != null) {
            sql.append(" and t2.fid <> '" + jobConfig.getId() + "' ");
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString())).next()) {
            throw new BizFrameworkException(BizFrameworkException.HAS_SAME_DATA);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.doFilterSave(ctx, pk.toString(), (JobConfigInfo)model);
        super._update(ctx, pk, model);
    }

    private void doFilterSave(Context ctx, String id, JobConfigInfo jobConfig) throws EASBizException, BOSException {
        String isFromMenu = jobConfig.getString("isFromMenu");
        if ("false".equals(isFromMenu)) {
            this.deleteFilter(ctx, id);
            if (jobConfig.getFilter() == null || "".equals(jobConfig.getFilter())) {
                return;
            }
            BillFilterInfo filterInfo = new BillFilterInfo();
            filterInfo.setFilter(jobConfig.getFilter());
            filterInfo.setJobConfigID(id);
            filterInfo.setUser(jobConfig.getLastUpdateUser());
            BillFilterFactory.getLocalInstance(ctx).save(filterInfo);
        }
    }

    private void deleteFilter(Context ctx, String configID) throws EASBizException, BOSException {
        String sql = "delete from T_BIZ_BillFilter where FJobConfigID  = '" + configID + "' and fuserid = '" + ctx.getCaller() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected boolean _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.updateState(ctx, ids, UseStatusEnum.INACTIVE);
        return true;
    }

    @Override
    protected boolean _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.updateState(ctx, ids, UseStatusEnum.ACTIVE);
        return true;
    }

    private void updateState(Context ctx, Set ids, UseStatusEnum state) throws BOSException {
        String idStr = this.getSqlIdsStrForColl(ids);
        String sql = "update T_BIZ_JobConfig set FState = " + state.getValue() + " where fid in (" + idStr + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private String getSqlIdsStrForColl(Collection coll) {
        StringBuffer str = new StringBuffer();
        Iterator it = coll.iterator();
        int i = 0;
        String id = null;
        while (it.hasNext()) {
            id = it.next().toString();
            if (null == id || id.trim().length() == 0) continue;
            if (i != 0) {
                str.append(",'" + id + "'");
            } else {
                str.append("'" + id + "'");
            }
            ++i;
        }
        return str.toString();
    }

    @Override
    protected IObjectCollection _getJobConfigColl(Context ctx, Set jobIdSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("job.id", (Object)jobIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("srcBillType.*"));
        selector.add(new SelectorItemInfo("action.*"));
        selector.add(new SelectorItemInfo("job.*"));
        selector.add(new SelectorItemInfo("job.destBillType.*"));
        selector.add(new SelectorItemInfo("job.destBillConfig.*"));
        selector.add(new SelectorItemInfo("srcBillConfig.*"));
        selector.add(new SelectorItemInfo("srcBillConfig.queryEntry.*"));
        view.setFilter(filter);
        view.setSelector(selector);
        JobConfigCollection coll = this.getJobConfigCollection(ctx, view);
        HashSet<String> jobConfigid = new HashSet<String>();
        JobConfigInfo configInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            configInfo = coll.get(i);
            jobConfigid.add(configInfo.getId().toString());
        }
        if (jobConfigid.size() == 0) {
            return coll;
        }
        String ids = this.getSqlIdsStrForColl(jobConfigid);
        String sql = "select * from T_BIZ_BillFilter where FJobConfigID in (" + ids + ") and fuserid = '" + ctx.getCaller() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> filterMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                filterMap.put(rs.getString("FJobConfigID"), rs.getString("Filter"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (filterMap.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                configInfo = coll.get(i);
                String id = configInfo.getId().toString();
                if (!filterMap.containsKey(id)) continue;
                configInfo.setFilter(filterMap.get(id).toString());
            }
        }
        return coll;
    }
}

