/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.bizplatform;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.bizframework.billconfig.BillConfigureFactory;
import com.kingdee.eas.bizframework.billconfig.BillConfigureInfo;
import com.kingdee.eas.bizframework.billconfig.BillConfigureQueryItemCollection;
import com.kingdee.eas.bizframework.billconfig.util.BillConfigureCache;
import com.kingdee.eas.bizframework.bizcenter.BillTypeInfo;
import com.kingdee.eas.bizframework.bizcenter.CountType;
import com.kingdee.eas.bizframework.bizcenter.JobConfigCollection;
import com.kingdee.eas.bizframework.bizcenter.JobConfigFactory;
import com.kingdee.eas.bizframework.bizcenter.JobConfigInfo;
import com.kingdee.eas.bizframework.bizcenter.JobInfo;
import com.kingdee.eas.bizframework.bizcenter.info.BizCenterDetailInfo;
import com.kingdee.eas.bizframework.bizcenter.info.BizCenterInfo;
import com.kingdee.eas.bizframework.bizplatform.PlatFormInfo;
import com.kingdee.eas.bizframework.bizplatform.PlatFormJobEntryCollection;
import com.kingdee.eas.bizframework.bizplatform.app.takedata.PlatFormTakeData;
import com.kingdee.eas.bizframework.bizplatform.util.BizPlatFormUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlatFormCenterHelper {
    public List<Map<String, Object>> getQueryExecutorData(Context ctx, String queryPk, EntityViewInfo view, String oql) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> list = null;
        MetaDataPK queryPK = null;
        IQueryExecutor queryExcu = null;
        if (queryPk == null) {
            return null;
        }
        queryPK = MetaDataPK.create((String)queryPk);
        queryExcu = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        if (view != null) {
            queryExcu.setObjectView(view);
        } else if (oql != null) {
            queryExcu.setObjectView(view);
        }
        IRowSet rs = queryExcu.executeQuery();
        int[] colTypes = null;
        list = new ArrayList<Map<String, Object>>();
        try {
            IRowSetMetaData rsmd = rs.getRowSetMetaData();
            int size = rsmd.getColumnCount();
            colTypes = new int[size];
            String[] fields = new String[size];
            for (int i = 0; i < size; ++i) {
                fields[i] = rsmd.getColumnName(i + 1);
                colTypes[i] = rsmd.getColumnType(i + 1);
            }
            HashMap<String, Object> map = null;
            while (rs.next()) {
                map = new HashMap<String, Object>();
                for (int i = 0; i < size; ++i) {
                    map.put(fields[i], rs.getObject(fields[i]));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    public List getPlatFormJobExecutorData(Context ctx, PlatFormInfo platFormInfo, Map paramMap) throws BOSException, EASBizException {
        PlatFormJobEntryCollection coll = platFormInfo.getJobEntry();
        if (coll == null || coll.size() == 0) {
            return null;
        }
        HashSet<String> jobIdSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            jobIdSet.add(coll.get(i).getJob().getId().toString());
        }
        JobConfigCollection jobConfigColl = JobConfigFactory.getLocalInstance(ctx).getJobConfigColl(jobIdSet);
        if (jobConfigColl == null || jobConfigColl.size() == 0) {
            return null;
        }
        this.setPeriodFilter(ctx, paramMap);
        ArrayList<BizCenterInfo> bizCenterInfoList = new ArrayList<BizCenterInfo>();
        HashMap<String, BizCenterInfo> bizCenterInfoMap = new HashMap<String, BizCenterInfo>();
        JobConfigInfo jobConfigInfo = null;
        JobInfo jobInfo = null;
        int size = jobConfigColl.size();
        for (int i = 0; i < size; ++i) {
            jobConfigInfo = jobConfigColl.get(i);
            jobInfo = jobConfigInfo.getJob();
            this.executorUndoJob(ctx, bizCenterInfoList, bizCenterInfoMap, jobInfo, jobConfigInfo, paramMap);
        }
        BizCenterInfo bizCenterInfo = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        int size2 = bizCenterInfoList.size();
        for (int i = 0; i < size2; ++i) {
            bizCenterInfo = (BizCenterInfo)bizCenterInfoList.get(i);
            if (bizCenterInfo.getDetailInfo().size() <= 0 || !bizCenterInfo.getDetailInfo().get(0).getDestBillBosType().equals(bizCenterInfo.getDetailInfo().get(0).getDestBillBosType())) continue;
            this.executorDoneJob(ctx, paramMap, bizCenterInfo, userInfo);
        }
        return bizCenterInfoList;
    }

    private void executorDoneJob(Context ctx, Map paramMap, BizCenterInfo bizCenterInfo, UserInfo userInfo) throws EASBizException, BOSException {
        String periodFilter;
        String bizDateFilter;
        String destBosType = bizCenterInfo.getDetailInfo().get(0).getDestBillBosType();
        EntityObjectInfo destEntity = BillConfigureCache.getEntityObjectInfo(ctx, destBosType);
        String destTableName = destEntity.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM ").append(destTableName);
        sql.append(" WHERE ").append("FCREATORID = '").append(userInfo.getId().toString()).append("' ");
        String orgId = (String)paramMap.get("orgId");
        String mainOrgProperty = bizCenterInfo.getMainOrgProperty();
        if (!BizPlatFormUtil.isNull(orgId).booleanValue() && !BizPlatFormUtil.isNull(mainOrgProperty).booleanValue()) {
            sql.append(" AND ").append("F" + mainOrgProperty + "ID = '").append(orgId).append("' ");
        }
        if (!BizPlatFormUtil.isNull(bizDateFilter = (String)paramMap.get("bizDateFilter")).booleanValue()) {
            sql.append(" AND").append(bizDateFilter);
        }
        if (!BizPlatFormUtil.isNull(periodFilter = (String)paramMap.get("periodFilter")).booleanValue()) {
            sql.append(" AND ").append(periodFilter);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString().toUpperCase().replaceAll("BIZDATE", "FBIZDATE"));
        int count = 0;
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rs.next()) {
                idSet.add(rs.getString("FID"));
                ++count;
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            bizCenterInfo.setDoneCount(count);
            bizCenterInfo.setDoneFilter(URLEncoder.encode(filter.toString()));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setPeriodFilter(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String companyId = (String)paramMap.get("companyId");
        String periodNumber = (String)paramMap.get("periodNumber");
        if (!BizPlatFormUtil.isNull(companyId).booleanValue() && !BizPlatFormUtil.isNull(periodNumber).booleanValue()) {
            PeriodInfo period;
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select accountPeriodType.id where id = '" + companyId + "'");
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("beginDate"));
            selector.add(new SelectorItemInfo("endDate"));
            selector.add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyOrgUnitInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)periodNumber, CompareType.EQUALS));
            view.setSelector(selector);
            view.setFilter(filter);
            PeriodCollection periodCollection = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
            if (periodCollection.size() > 0 && (period = periodCollection.get(0)) != null && periodNumber != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                StringBuffer periodFilter = new StringBuffer();
                periodFilter.append(" bizDate >=");
                periodFilter.append(" {ts'").append(dateFormat.format(period.getBeginDate())).append("'}");
                periodFilter.append(" and  bizDate <");
                periodFilter.append(" {ts'").append(dateFormat.format(period.getEndDate())).append("'}");
                paramMap.put("periodFilter", periodFilter.toString());
            }
        }
    }

    private void executorUndoJob(Context ctx, List<BizCenterInfo> bizCenterInfoList, Map<String, BizCenterInfo> bizCenterInfoMap, JobInfo jobInfo, JobConfigInfo jobConfigInfo, Map paramMap) throws BOSException, EASBizException {
        BillConfigureInfo billConfigInfo;
        BizCenterInfo bizCenterInfo = bizCenterInfoMap.get(jobInfo.getId().toString());
        if (bizCenterInfo == null) {
            bizCenterInfo = new BizCenterInfo();
            bizCenterInfo.setJobId(jobInfo.getId().toString());
            bizCenterInfo.setJobName(jobInfo.getName());
            bizCenterInfo.setDetailInfo(new ArrayList<BizCenterDetailInfo>());
            bizCenterInfoList.add(bizCenterInfo);
            bizCenterInfoMap.put(jobInfo.getId().toString(), bizCenterInfo);
        }
        BizCenterDetailInfo bizCenterDetailInfo = new BizCenterDetailInfo();
        BillTypeInfo srcBillTypeInfo = jobConfigInfo.getSrcBillType();
        BillTypeInfo destBillTypeInfo = jobInfo.getDestBillType();
        String srcQueryPk = srcBillTypeInfo.getQueryPK();
        String srcBosType = srcBillTypeInfo.getBillBosType();
        String destBosType = destBillTypeInfo.getBillBosType();
        String takeDataImplClass = jobConfigInfo.getString("takeDataImplClass");
        String methodName = "getSQL";
        String tableSQL = null;
        PlatFormTakeData takeData = null;
        if (takeDataImplClass != null) {
            try {
                Class<?> c = Class.forName(takeDataImplClass);
                Object instance = c.newInstance();
                Method method = instance.getClass().getMethod(methodName, Context.class, JobInfo.class, JobConfigInfo.class, Map.class);
                Object ret = method.invoke(instance, ctx, jobInfo, jobConfigInfo, paramMap);
                tableSQL = (String)ret;
            }
            catch (Exception e) {
                takeData = new PlatFormTakeData();
                tableSQL = takeData.getSQL(ctx, jobInfo, jobConfigInfo, paramMap);
            }
        } else {
            takeData = new PlatFormTakeData();
            tableSQL = takeData.getSQL(ctx, jobInfo, jobConfigInfo, paramMap);
        }
        if ((billConfigInfo = jobConfigInfo.getSrcBillConfig()) == null) {
            billConfigInfo = (BillConfigureInfo)BillConfigureFactory.getLocalInstance(ctx).getBillConfigureData(srcBosType);
        }
        if (billConfigInfo == null || tableSQL == null) {
            return;
        }
        Map keyMap = BillConfigureCache.getJoinQueryKey(ctx, srcQueryPk);
        StringBuffer fieldSQL = new StringBuffer();
        BillConfigureQueryItemCollection coll = billConfigInfo.getQueryEntry();
        if (coll == null || coll.size() == 0) {
            return;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.get(i).isIsVisible() && keyMap.get(coll.get(i).getFieldName()) == null) continue;
            fieldSQL.append("\"").append(this.getSelectorAlias(ctx, coll.get(i).getFieldName(), srcQueryPk)).append("\",");
        }
        String tempTableName = this.createTempTable(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append(fieldSQL.substring(0, fieldSQL.length() - 1));
        sql.append(" into ").append(tempTableName);
        sql.append(" from (").append(this.getOptimizeSql(tableSQL, fieldSQL.substring(0, fieldSQL.length() - 1))).append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        if (jobConfigInfo.getCountType().equals((Object)CountType.ENTRY)) {
            sql.append(" select count(1) as Count from ").append(tempTableName);
        } else {
            sql.append(" select count(distinct \"ID\") as Count from ").append(tempTableName);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int count = 0;
        try {
            while (rs.next()) {
                count = rs.getInt("Count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        bizCenterDetailInfo.setUndoCount(count);
        bizCenterDetailInfo.setJobConfigId(jobConfigInfo.getId().toString());
        bizCenterDetailInfo.setJobConfigName(jobConfigInfo.getName());
        bizCenterDetailInfo.setTempTableName(tempTableName);
        bizCenterDetailInfo.setSrcBillBosType(jobConfigInfo.getSrcBillType().getBillBosType());
        bizCenterDetailInfo.setSrcBillQueryPK(jobConfigInfo.getSrcBillType().getQueryPK());
        bizCenterDetailInfo.setSrcWebEditUIPK(jobConfigInfo.getSrcBillType().getWebEditUIPK());
        bizCenterDetailInfo.setSrcWebListUIPK(jobConfigInfo.getSrcBillType().getWebUIPK());
        bizCenterDetailInfo.setSrcBillTypeName(jobConfigInfo.getSrcBillType().getName());
        if (jobConfigInfo.getAction() != null) {
            bizCenterDetailInfo.setActionName(jobConfigInfo.getAction().getBizAction());
        }
        bizCenterDetailInfo.setDestWebEditUIPK(jobInfo.getDestBillType().getWebEditUIPK());
        bizCenterDetailInfo.setDestWebListUIPK(jobInfo.getDestBillType().getWebUIPK());
        bizCenterDetailInfo.setDestBillTypeName(jobInfo.getDestBillType().getName());
        bizCenterDetailInfo.setDestBillQueryPK(jobInfo.getDestBillType().getQueryPK());
        bizCenterDetailInfo.setDestBillBosType(jobInfo.getDestBillType().getBillBosType());
        if (jobInfo.getDestBillConfig() != null) {
            bizCenterInfo.setDestBillConfigID(jobInfo.getDestBillConfig().getId().toString());
        }
        bizCenterInfo.setUndoCount(bizCenterInfo.getUndoCount() + bizCenterDetailInfo.getUndoCount());
        bizCenterInfo.getDetailInfo().add(bizCenterDetailInfo);
    }

    private String getSelectorAlias(Context ctx, String fieldName, String queryPK) throws EASBizException {
        JoinQueryInfo queryInfo = BillConfigureCache.getQueryInfo(ctx, queryPK);
        String alias = fieldName;
        if (alias.length() >= 30) {
            ArrayList queryFields = queryInfo.getSelector().getFields();
            QueryFieldInfo queryFieldInfo = null;
            int size = queryFields.size();
            for (int i = 0; i < size; ++i) {
                queryFieldInfo = (QueryFieldInfo)queryFields.get(i);
                if (!queryFieldInfo.getName().equals(fieldName)) continue;
                alias = alias.substring(0, alias.length() - (alias.length() - 30 + String.valueOf(i).length())) + i;
                break;
            }
        }
        return alias;
    }

    private String getOptimizeSql(String sql, String fieldSQL) {
        Pattern from = Pattern.compile("FROM[^\"]+\"[^\"]+\"", 2);
        Pattern join = Pattern.compile("(LEFT|INNER|RIGHT).+JOIN[^\"]+\"[^\"]+\"", 2);
        Pattern on = Pattern.compile("ON\\s\"[^\"]+\"\\..+[^(LEFT|INNER|RIGHT|WHERE)]", 2);
        Matcher fromMatcher = from.matcher(sql);
        Matcher joinMatcher = join.matcher(sql);
        Matcher onMatcher = on.matcher(sql);
        ArrayList<String> joinList = new ArrayList<String>();
        String[] selectArr = null;
        while (joinMatcher.find()) {
            joinList.add(joinMatcher.group());
        }
        ArrayList<String> onList = new ArrayList<String>();
        while (onMatcher.find()) {
            onList.add(onMatcher.group());
        }
        if (fromMatcher.find() && joinList.size() > 0 && joinList.size() == onList.size()) {
            String selectSql = sql.substring(0, sql.indexOf("FROM"));
            String fromSql = fromMatcher.group();
            String whereSql = "";
            String orderSql = "";
            if (sql.indexOf("ORDER BY") != -1) {
                whereSql = sql.substring(sql.indexOf("WHERE"), sql.indexOf("ORDER BY"));
                orderSql = sql.substring(sql.indexOf("ORDER BY"));
            } else {
                whereSql = sql.substring(sql.indexOf("WHERE"));
            }
            selectSql = selectSql.substring(selectSql.indexOf("\"")).toUpperCase();
            selectArr = selectSql.split(",");
            StringBuilder sb = new StringBuilder("SELECT \n");
            for (int i = 0; i < selectArr.length; ++i) {
                String selectorItem = selectArr[i].substring(selectArr[i].indexOf("AS ") + 3);
                if (fieldSQL.toUpperCase().indexOf(selectorItem) == -1) continue;
                sb.append(selectArr[i]).append(",");
            }
            selectSql = sb.substring(0, sb.length() - 1);
            sb = new StringBuilder(selectSql).append("\n");
            String tableName = null;
            sb.append(fromSql).append("\n");
            int size = joinList.size();
            for (int i = 0; i < size; ++i) {
                tableName = ((String)joinList.get(i)).substring(((String)joinList.get(i)).indexOf("\""));
                if (selectSql.indexOf(tableName = tableName.substring(1, tableName.length() - 1)) == -1 && whereSql.toUpperCase().indexOf(tableName) == -1 && orderSql.toUpperCase().indexOf(tableName) == -1) continue;
                sb.append((String)joinList.get(i)).append("\n").append((String)onList.get(i));
            }
            sb.append(whereSql).append(orderSql);
            sql = sb.toString();
        }
        return sql;
    }

    protected String createTempTable(Context ctx) throws BOSException, EASBizException {
        try {
            return TableManager.getTableManager((Context)ctx).getTableName("");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public List getFavPageList(Context ctx) throws BOSException, EASBizException {
        ArrayList pageList = new ArrayList();
        StringBuilder permSql = new StringBuilder();
        try {
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            permSql.append("SELECT t.* FROM T_JP_Page t,T_BAS_ComFunction f ").append("where f.FUserID='").append(user.getId().toString()).append("' and f.FISLEAF=1 and ").append("(t.FId=f.FMenuFunctionID or ").append("  CHARINDEX(f.FMenuFunctionID,t.FNodeExt)>0 )").append("  and f.fpageType = '").append("EXTERNAL_LINK").append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSql.toString());
            if (rs != null) {
                while (rs.next()) {
                    HashMap<String, String> page = new HashMap<String, String>();
                    page.put("id", rs.getString("FId"));
                    page.put("name_l1", BizPlatFormUtil.getJsonAttribute(rs.getString("FDisplayName"), "en"));
                    page.put("name_l2", BizPlatFormUtil.getJsonAttribute(rs.getString("FDisplayName"), "zh_CN"));
                    page.put("name_l3", BizPlatFormUtil.getJsonAttribute(rs.getString("FDisplayName"), "zh_TW"));
                    page.put("url", BizPlatFormUtil.getJsonAttribute(rs.getString("FNodeExt"), "url"));
                    pageList.add(page);
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return pageList;
    }

    public List getMenuPageList(Context ctx) throws BOSException, EASBizException {
        ArrayList menuList = new ArrayList();
        StringBuilder menuSql = new StringBuilder();
        menuSql.append(" SELECT FId,fparentnodeid,fnodelevel,FDisplayName,FNodeExt,fnodepath,fnodetype FROM T_JP_Page ");
        menuSql.append(" where");
        menuSql.append(" (fnodetype = 'EXTERNAL_LINK' or fnodetype = 'EXTERNAL_LINK_G')");
        menuSql.append(" and fstatus = 'ENABLE' and fhidden  = 0  order by fnodelevel,fnodeorder");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)menuSql.toString());
            if (rs != null) {
                while (rs.next()) {
                    HashMap<String, Object> menu = new HashMap<String, Object>();
                    menu.put("id", rs.getString("FId"));
                    menu.put("parentid", rs.getString("fparentnodeid"));
                    menu.put("type", rs.getString("fnodetype"));
                    menu.put("level", rs.getInt("fnodelevel"));
                    menu.put("name_l1", BizPlatFormUtil.getJsonAttribute(rs.getString("FDisplayName"), "en"));
                    menu.put("name_l2", BizPlatFormUtil.getJsonAttribute(rs.getString("FDisplayName"), "zh_CN"));
                    menu.put("name_l3", BizPlatFormUtil.getJsonAttribute(rs.getString("FDisplayName"), "zh_TW"));
                    menu.put("url", BizPlatFormUtil.getJsonAttribute(rs.getString("FNodeExt"), "url"));
                    menu.put("path", rs.getString("fnodepath"));
                    menuList.add(menu);
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return menuList;
    }
}

