/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.bizplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.bizframework.bizplatform.PlatFormBizException;
import com.kingdee.eas.bizframework.bizplatform.PlatFormCollection;
import com.kingdee.eas.bizframework.bizplatform.PlatFormFactory;
import com.kingdee.eas.bizframework.bizplatform.PlatFormInfo;
import com.kingdee.eas.bizframework.bizplatform.PlatFormStatusEnum;
import com.kingdee.eas.bizframework.bizplatform.PlatFormTypeEnum;
import com.kingdee.eas.bizframework.bizplatform.app.AbstractPlatFormControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlatFormControllerBean
extends AbstractPlatFormControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bizframework.bizplatform.app.PlatFormControllerBean");

    @Override
    protected void _active(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.beforeActive(ctx, pks);
        IObjectPK pk2 = null;
        StringBuffer idsb = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (IObjectPK pk2 : pks) {
            idsb.append("'" + pk2.toString() + "',");
        }
        String idStr = idsb.substring(0, idsb.length() - 1);
        String cuId = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
        sb.append("update T_BIZ_PlatForm set FStatus = 2 where FID in (").append(idStr).append(")");
        sb.append(" and FStatus in (1,3) and FControlunitid = '").append(cuId).append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.beforeDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    private void beforeDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PlatFormInfo info = (PlatFormInfo)super.getValue(ctx, pk);
        if (info.isIsScheduled()) {
            throw new PlatFormBizException(PlatFormBizException.ISSCHEDULED_NOT_DELETE);
        }
        this.checkRight(ctx, (IObjectValue)info);
    }

    private void beforeActive(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        block7: {
            PlatFormInfo info = (PlatFormInfo)super.getValue(ctx, pks[0]);
            this.checkRight(ctx, (IObjectValue)info);
            StringBuffer sb = new StringBuffer();
            if (info.getPlatFormType().getValue() == 2) {
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                sb.append("select w.fid from T_BIZ_PlatForm w");
                sb.append(" where w.FPlatFormType = ").append(2);
                sb.append(" and w.fPlatUserId = '").append(user.getId().toString()).append("'");
                sb.append(" and w.FsubSystem = '").append(info.getSubSystem().getValue()).append("'");
                sb.append(" and w.Fcontrolunitid = '").append(info.getCU().getId().toString()).append("'");
                sb.append(" and w.Fstatus = ").append(2);
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                    if (rs != null && rs.size() > 0 && rs.next()) {
                        throw new PlatFormBizException(PlatFormBizException.ONLYONECUSTOM);
                    }
                    break block7;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            sb.setLength(0);
            sb.append(" select w.fid from T_BIZ_PlatForm w");
            sb.append(" where w.FPlatFormType = ").append(1);
            sb.append(" and w.FsubSystem = '").append(info.getSubSystem().getValue()).append("'");
            sb.append(" and w.Fcontrolunitid = '").append(info.getCU().getId().toString()).append("'");
            sb.append(" and w.Fstatus = ").append(2);
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rs != null && rs.size() > 0 && rs.next()) {
                    throw new PlatFormBizException(PlatFormBizException.ONLYONETEMPLE);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void beforeInActive(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        PlatFormInfo info = (PlatFormInfo)super.getValue(ctx, pks[0]);
        this.checkRight(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("jobEntry.seq"));
        sorter.add(new SorterItemInfo("comFunction.seq"));
        return super._getValue(ctx, pk, selector, sorter);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, model);
        this.checkNameDup(ctx, model);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        PlatFormInfo info = (PlatFormInfo)model;
        info.setStatus(PlatFormStatusEnum.SAVED);
        if (PlatFormTypeEnum.CUSTOM.equals((Object)info.getPlatFormType())) {
            info.setPlatUser(user);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    private void checkRight(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlatFormInfo info = (PlatFormInfo)model;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (PlatFormTypeEnum.CUSTOM.equals((Object)info.getPlatFormType()) && !user.getId().toString().equals(info.getPlatUser().getId().toString())) {
            throw new PlatFormBizException(PlatFormBizException.CREATE_RIGHT_PESSION);
        }
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlatFormInfo info = (PlatFormInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PlatFormCollection coll = PlatFormFactory.getLocalInstance(ctx).getPlatFormCollection(view);
        if (coll != null && coll.size() > 0) {
            throw new PlatFormBizException(PlatFormBizException.NUMBER_DUMP);
        }
    }

    protected void checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlatFormInfo info = (PlatFormInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PlatFormCollection coll = PlatFormFactory.getLocalInstance(ctx).getPlatFormCollection(view);
        if (coll != null && coll.size() > 0) {
            throw new PlatFormBizException(PlatFormBizException.NAME_DUMP);
        }
    }

    @Override
    protected void _inActive(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.beforeInActive(ctx, pks);
        IObjectPK pk2 = null;
        StringBuffer idsb = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (IObjectPK pk2 : pks) {
            idsb.append("'" + pk2.toString() + "',");
        }
        String idStr = idsb.substring(0, idsb.length() - 1);
        String cuId = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
        sb.append("update T_BIZ_PlatForm set FStatus = 3 where FID in (").append(idStr).append(")");
        sb.append(" and FStatus=2 and FControlunitid= '").append(cuId).append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected Map _handleBillByOprtState(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, PlatFormInfo> map = new HashMap<String, PlatFormInfo>();
        Object id = paramMap.get("id");
        if (id == null) {
            return this.createBill(ctx);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", id, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("jobEntry.*"));
        selector.add(new SelectorItemInfo("alarmEntry.*"));
        view.setFilter(filter);
        view.setSelector(selector);
        PlatFormCollection coll = PlatFormFactory.getLocalInstance(ctx).getPlatFormCollection(view);
        map.put("bill", coll.get(0));
        return map;
    }

    private Map createBill(Context ctx) throws BOSException, EASBizException {
        HashMap<String, PlatFormInfo> map = new HashMap<String, PlatFormInfo>();
        PlatFormInfo billInfo = new PlatFormInfo();
        CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        billInfo.setStatus(PlatFormStatusEnum.NEW);
        billInfo.setCU(cu);
        map.put("bill", billInfo);
        return map;
    }

    @Override
    protected void _checkFunctionPermission(Context ctx, String orgId, String permItemName, boolean isFromMenu) throws BOSException, EASBizException {
        if (isFromMenu) {
            if (orgId == null || orgId.equals("null")) {
                orgId = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
            }
            PermissionFactory.getRemoteInstance().checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgId.toString()), permItemName);
        }
    }
}

