/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.bizplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.bizframework.bizplatform.IPlatForm;
import com.kingdee.eas.bizframework.bizplatform.PlatFormAlarmEntryInfo;
import com.kingdee.eas.bizframework.bizplatform.PlatFormCollection;
import com.kingdee.eas.bizframework.bizplatform.PlatFormFactory;
import com.kingdee.eas.bizframework.bizplatform.PlatFormInfo;
import com.kingdee.eas.bizframework.bizplatform.PlatFormJobEntryInfo;
import com.kingdee.eas.bizframework.bizplatform.PlatFormStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class PlatFormImport
extends AbstractDataTransmission {
    PlatFormInfo platFormInfo = null;
    private static String resources = "com.kingdee.eas.bizframework.bizplatform.PlatFormResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PlatFormFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    private static String getString(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return ResourceBase.getString((String)resources, (String)strKey, (Locale)ctx.getLocale());
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.platFormInfo = null;
        super.getMainField();
        int keyCursor = 0;
        for (int i = 0; i < hsData.size(); ++i) {
            PlatFormAlarmEntryInfo alarmEntry;
            PlatFormJobEntryInfo jobEntry;
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (keyCursor == 0) {
                this.platFormInfo = this.transmitHead(lineData, ctx);
                if (this.platFormInfo == null) {
                    return null;
                }
            }
            if ((jobEntry = this.transmitJobEntry(lineData, ctx)) != null) {
                jobEntry.setPlatForm(this.platFormInfo);
                this.platFormInfo.getJobEntry().add(jobEntry);
            }
            if ((alarmEntry = this.transmitAlarmEntry(lineData, ctx)) != null) {
                alarmEntry.setPlatForm(this.platFormInfo);
                this.platFormInfo.getAlarmEntry().add(alarmEntry);
            }
            ++keyCursor;
        }
        return this.platFormInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof SaleIssueBillInfo)) {
            return;
        }
        try {
            PlatFormInfo bill = (PlatFormInfo)coreBaseInfo;
            IObjectPK userPK = ctx.getCaller();
            String id = this.getIdFromNumber(bill.getNumber(), ctx);
            ObjectUuidPK orgPK = new ObjectUuidPK(bill.getCU().getId());
            SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)userPK, (IObjectPK)orgPK, (String)"platform_import");
            if (StringUtil.isEmptyString((String)id)) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).delete((IObjectPK)new ObjectUuidPK(id));
                this.getController(ctx).addnew(coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "bizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("bizDate")));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FBizType_name_l2", rs.getString("bizType.name"));
            this.putTable(result, "transactionType", rs.getString("transactionType.number"));
            this.putTable(result, "transactionTypeName", rs.getString("transactionType.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private PlatFormInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        PlatFormInfo platFormInfo = new PlatFormInfo();
        Object number = ((DataToken)lineData.get((Object)"FNumber")).data;
        if (number != null && number.toString().trim().length() > 0) {
            platFormInfo.setNumber(number.toString().trim());
            String existId = this.getIdFromNumber(number.toString().trim(), ctx);
            if (!this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                throw new TaskExternalException(number.toString().trim() + PlatFormImport.getString(ctx, "EXISTS"));
            }
            if (this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                PlatFormInfo existInfo = null;
                try {
                    existInfo = ((IPlatForm)this.getController(ctx)).getPlatFormInfo((IObjectPK)new ObjectUuidPK(existId));
                }
                catch (Exception e) {
                    throw new TaskExternalException("", (Throwable)e);
                }
                if (!PlatFormStatusEnum.ACTIVE.equals((Object)existInfo.getStatus())) {
                    throw new TaskExternalException(number.toString().trim() + PlatFormImport.getString(ctx, "ACTIVED_SAVEERROE"));
                }
            }
        }
        platFormInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return null;
    }

    private PlatFormJobEntryInfo transmitJobEntry(Hashtable lineData, Context ctx) throws TaskExternalException {
        return null;
    }

    private PlatFormAlarmEntryInfo transmitAlarmEntry(Hashtable lineData, Context ctx) throws TaskExternalException {
        return null;
    }

    private String getIdFromNumber(String number, Context ctx) throws TaskExternalException {
        PlatFormCollection collection;
        try {
            collection = PlatFormFactory.getLocalInstance(ctx).getPlatFormCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }
}

