/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.bizplatform.app.takedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.bizframework.bizcenter.JobConfigInfo;
import com.kingdee.eas.bizframework.bizcenter.JobInfo;
import com.kingdee.eas.bizframework.bizplatform.app.takedata.IPlatFormTakeData;
import com.kingdee.eas.bizframework.bizplatform.util.BizPlatFormUtil;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbstractPlatFormTakeData
implements IPlatFormTakeData {
    public static final String WHERE = " where ";
    public static final String AND = " and ";
    public static final String NEWLINE = " \n ";
    public static final String OR = " or ";
    public static final String SPACE = " ";
    private String selectSql = null;
    private String oqlSql = null;
    private String fromSql = null;
    private String joinSql = null;
    private String whereSql = null;
    private String orderSql = null;
    protected JobInfo jobInfo = null;
    protected JobConfigInfo jobConfigInfo = null;
    protected Map paramMap = null;
    protected Context ctx = null;

    @Override
    public String getSQL(Context ctx, JobInfo jobInfo, JobConfigInfo jobConfigInfo, Map paramMap) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.jobInfo = jobInfo;
        this.jobConfigInfo = jobConfigInfo;
        this.paramMap = paramMap;
        this.analyzeTableSQL();
        return this.getTableSQL();
    }

    private void analyzeTableSQL() throws BOSException, EASBizException {
        String queryPk = this.jobConfigInfo.getSrcBillType().getQueryPK();
        MetaDataPK queryPK = MetaDataPK.create((String)queryPk);
        this.ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
        String oql = this.getOqlSql();
        if (!BizPlatFormUtil.isNull(oql).booleanValue()) {
            exec.setObjectView(oql);
        }
        String sql = exec.getSQL();
        Pattern from = Pattern.compile("FROM[^\"]+\"[^\"]+\"", 2);
        Pattern join = Pattern.compile("(LEFT|INNER|RIGHT).+JOIN[^\"]+\"[^\"]+\"", 2);
        Pattern on = Pattern.compile("ON\\s\"[^\"]+\"\\..+[^(LEFT|INNER|RIGHT|WHERE)]", 2);
        Matcher fromMatcher = from.matcher(sql);
        Matcher joinMatcher = join.matcher(sql);
        Matcher onMatcher = on.matcher(sql);
        ArrayList<String> joinList = new ArrayList<String>();
        while (joinMatcher.find()) {
            joinList.add(joinMatcher.group());
        }
        ArrayList<String> onList = new ArrayList<String>();
        while (onMatcher.find()) {
            onList.add(onMatcher.group());
        }
        if (fromMatcher.find() && joinList.size() > 0 && joinList.size() == onList.size()) {
            this.selectSql = sql.substring(0, sql.indexOf("FROM"));
            this.fromSql = fromMatcher.group();
            this.joinSql = sql.substring(sql.indexOf("FROM"), sql.indexOf("WHERE"));
            if (sql.indexOf("ORDER BY") != -1) {
                this.whereSql = sql.substring(sql.indexOf("WHERE"), sql.indexOf("ORDER BY"));
                this.orderSql = sql.substring(sql.indexOf("ORDER BY"));
            } else {
                this.whereSql = sql.substring(sql.indexOf("WHERE"));
            }
        }
    }

    private String getTableSQL() throws BOSException, EASBizException {
        StringBuffer sb = null;
        if (!BizPlatFormUtil.isNull(this.getSelectSql()).booleanValue() && !BizPlatFormUtil.isNull(this.getFromSql()).booleanValue()) {
            sb = new StringBuffer();
            sb.append(this.getSelectSql()).append(SPACE);
            sb.append(this.getFromSql()).append(SPACE);
            if (!BizPlatFormUtil.isNull(this.getJoinSql()).booleanValue()) {
                sb.append(this.getJoinSql()).append(SPACE);
            }
            if (!BizPlatFormUtil.isNull(this.getWhereSql()).booleanValue()) {
                sb.append(NEWLINE).append(this.getWhereSql()).append(SPACE);
            }
            if (!BizPlatFormUtil.isNull(this.getOrderSql()).booleanValue()) {
                sb.append(this.getOrderSql()).append(SPACE);
            }
            return sb.toString();
        }
        return null;
    }

    protected String getSelectSql() throws BOSException, EASBizException {
        return this.selectSql;
    }

    protected String getFromSql() throws BOSException, EASBizException {
        return this.fromSql;
    }

    protected String getJoinSql() throws BOSException, EASBizException {
        return this.joinSql;
    }

    protected String getOqlSql() throws BOSException, EASBizException {
        return this.oqlSql;
    }

    protected String getWhereSql() throws BOSException, EASBizException {
        return this.whereSql;
    }

    protected String getOrderSql() throws BOSException, EASBizException {
        return this.orderSql;
    }
}

