/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class BaseClassConstants {
    private static final HashMap bosToJava = new HashMap();

    public static String getJavaClassName(String bosClassName) {
        return (String)bosToJava.get(bosClassName);
    }

    public static boolean isNumberBOSClass(String bosClassName) {
        String[] numberBosClass = new String[]{"Short", "Integer", "Long", "Float", "Double", "BigDecimal"};
        for (int i = 0; i < numberBosClass.length; ++i) {
            if (!numberBosClass[i].equalsIgnoreCase(bosClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateBOSClass(String bosClassName) {
        String[] numberBosClass = new String[]{"Date", "Time", "TimeStamp"};
        for (int i = 0; i < numberBosClass.length; ++i) {
            if (!numberBosClass[i].equalsIgnoreCase(bosClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringBOSClass(String bosClassName) {
        String[] numberBosClass = new String[]{"String", "Char", "BosUuid", "Uuid", "BOSUuid"};
        for (int i = 0; i < numberBosClass.length; ++i) {
            if (!numberBosClass[i].equalsIgnoreCase(bosClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBooleanBOSClass(String bosClassName) {
        return "Boolean".equalsIgnoreCase(bosClassName);
    }

    public static boolean isEnumBOSClass(String bosClassName) {
        return "Enum".equalsIgnoreCase(bosClassName);
    }

    static {
        bosToJava.put("Short", Short.class.getName());
        bosToJava.put("Integer", Integer.class.getName());
        bosToJava.put("Long", Long.class.getName());
        bosToJava.put("Float", Float.class.getName());
        bosToJava.put("Double", Double.class.getName());
        bosToJava.put("BigDecimal", BigDecimal.class.getName());
        bosToJava.put("Date", Date.class.getName());
        bosToJava.put("Time", Time.class.getName());
        bosToJava.put("TimeStamp", Timestamp.class.getName());
        bosToJava.put("String", String.class.getName());
        bosToJava.put("Boolean", Boolean.class.getName());
        bosToJava.put("BosUuid", BOSUuid.class.getName());
        bosToJava.put("Uuid", Uuid.class.getName());
        bosToJava.put("BOSUuid", BOSUuid.class.getName());
        bosToJava.put("Enum", Enum.class.getName());
    }
}

