/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.tools.datatask.DEBotpInfo;
import com.kingdee.eas.tools.datatask.DEDataExportImplHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DEBotpQueryCondition {
    private Map whereMap = new HashMap();

    public String getWhere(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return "";
        }
        String retStr = "";
        if (this.whereMap.containsKey(tableName.toLowerCase())) {
            retStr = " where " + (String)this.whereMap.get(tableName.toLowerCase());
        }
        return retStr;
    }

    private void init(String fid, Connection con) throws BOSException {
        DEBotpInfo itemInfo = DEBotpQueryCondition.getInfo(fid, con);
        if (itemInfo == null) {
            this.whereMap.clear();
            return;
        }
        this.whereMap.put("T_BOT_Mapping".toLowerCase(), " fid  in (" + fid + ")");
        this.whereMap.put("T_BOT_BOTAggregateInfo".toLowerCase(), " FMAPPINGID  in (" + fid + ")");
        this.whereMap.put("T_BOT_Rule".toLowerCase(), " FMAPPINGID  in (" + fid + ")");
        this.whereMap.put("T_BOT_DelRevRule".toLowerCase(), "  fid   in (" + DEDataExportImplHelper.aryToStr(itemInfo.getDelRevRuleList()) + ")");
        this.whereMap.put("T_BOT_RevRule".toLowerCase(), " fid  in (" + DEDataExportImplHelper.aryToStr(itemInfo.getRevRuleList()) + ")");
        this.whereMap.put("T_BOT_ExtMapping".toLowerCase(), " fid  in (" + DEDataExportImplHelper.aryToStr(itemInfo.getExtMappingList()) + ")");
        this.whereMap.put("T_BOT_DelRevRuleSegment".toLowerCase(), " fid  in (" + DEDataExportImplHelper.aryToStr(itemInfo.getDelRevRuleSegmentList()) + ")");
        this.whereMap.put("T_BOT_RevRuleSegment".toLowerCase(), " fid  in (" + DEDataExportImplHelper.aryToStr(itemInfo.getRevRuleSegmentList()) + ")");
        this.whereMap.put("T_BOT_RuleSegment".toLowerCase(), " fid  in (" + DEDataExportImplHelper.aryToStr(itemInfo.getRuleSegmentList()) + ")");
        this.whereMap.put("T_BOT_Grouping".toLowerCase(), " fid  in (" + DEDataExportImplHelper.aryToStr(itemInfo.getGroupingList()) + ")");
    }

    public static DEBotpInfo getInfo(String fid, Connection con) throws BOSException {
        if (StringUtils.isEmpty((String)fid)) {
            return null;
        }
        DEBotpInfo itemInfo = new DEBotpInfo();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "select * from T_BOT_Mapping where fid in (" + fid + ");";
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemInfo.addExtMappingId(rs.getString("FEXTMAPPINGID"));
                itemInfo.addRevRuleId(rs.getString("FREVRULEID"));
                itemInfo.addDelRevRuleId(rs.getString("FDELREVRULEID"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            ArrayList revRuleList = (ArrayList)itemInfo.getRevRuleList();
            String revRuleId = DEDataExportImplHelper.aryToStr(revRuleList);
            sql = "select FID from T_BOT_RevRuleSegment where FREVRULEID in (" + revRuleId + ");";
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemInfo.addRevRuleSegmentId(rs.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            ArrayList delRevRuleList = (ArrayList)itemInfo.getDelRevRuleList();
            String delRevRuleId = DEDataExportImplHelper.aryToStr(delRevRuleList);
            sql = "select FID from T_BOT_DelRevRuleSegment where FDELREVRULEID in (" + delRevRuleId + ");";
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemInfo.addDelRevRuleSegmentId(rs.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select FID from T_BOT_Rule where FMAPPINGID in (" + fid + ");";
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemInfo.addRuleId(rs.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            ArrayList ruleList = (ArrayList)itemInfo.getRuleList();
            String ruleId = DEDataExportImplHelper.aryToStr(ruleList);
            sql = "select FID from T_BOT_RuleSegment where FRULEID in (" + ruleId + ");";
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemInfo.addRuleSegmentId(rs.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            sql = "select FID from T_BOT_Grouping where FRULEID in (" + ruleId + ");";
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemInfo.addGroupingId(rs.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        catch (SQLException se) {
            try {
                throw new BOSException((Throwable)se);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return itemInfo;
    }

    private DEBotpQueryCondition(String fidStr, Connection con) throws BOSException {
        this.init(fidStr, con);
    }

    public static DEBotpQueryCondition getInstance(Connection con, String fidStr) throws BOSException {
        DEBotpQueryCondition botpQueryCondition = new DEBotpQueryCondition(fidStr, con);
        return botpQueryCondition;
    }
}

