/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask;

import com.kingdee.eas.tools.datatask.DEDataExportImplHelper;
import com.kingdee.eas.tools.datatask.DEForewarnItemInfo;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DEForewarnQueryCondition {
    private static Map whereMap = new HashMap();
    private static DEForewarnQueryCondition forewarnQueryCondition;

    public String getWhere(String tableName) {
        if (tableName == null || tableName.trim().length() == 0) {
            return "";
        }
        String retStr = "";
        if (whereMap.containsKey(tableName.toLowerCase())) {
            retStr = " where " + (String)whereMap.get(tableName.toLowerCase());
        }
        if ("T_FW_ForewarnItem".equalsIgnoreCase(tableName)) {
            retStr = retStr + " order by ftype desc ";
        }
        return retStr;
    }

    private static void init(String fid, Connection con) {
        DEForewarnItemInfo itemInfo = DEForewarnQueryCondition.getInfo(fid, con);
        if (itemInfo == null) {
            whereMap.clear();
            return;
        }
        whereMap.put("T_FW_ForewarnObject".toLowerCase(), " fitemid  in (" + fid + ")");
        whereMap.put("T_FW_Receiver".toLowerCase(), " fitemid  in (" + fid + ")");
        whereMap.put("T_FW_ForewarnItem".toLowerCase(), " fid  in (" + fid + ")");
        whereMap.put("T_FW_schedule".toLowerCase(), "  fid   in (" + DEDataExportImplHelper.aryToStr(itemInfo.getScheduleMap()) + ")");
        whereMap.put("T_FW_Threshold".toLowerCase(), " fconditionid  in (" + DEDataExportImplHelper.aryToStr(itemInfo.getThresholdMap()) + ")");
        whereMap.put("T_FW_Condition".toLowerCase(), " fid  in (" + DEDataExportImplHelper.aryToStr(itemInfo.getConditionMap()) + ")");
        whereMap.put("T_FW_ForewarnMsg".toLowerCase(), " fid  in(" + DEDataExportImplHelper.aryToStr(itemInfo.getMsgMap()) + ")");
        whereMap.put("T_FW_RightnowAction".toLowerCase(), " fforewarntemplateid in(" + fid + ")");
        whereMap.put("T_FW_DynReceivers".toLowerCase(), " ffwitemid in(" + fid + ")");
    }

    public static DEForewarnItemInfo getInfo(String fid, Connection con) {
        if (StringUtils.isEmpty((String)fid)) {
            return null;
        }
        DEForewarnItemInfo itemInfo = new DEForewarnItemInfo();
        try {
            String sql = "select * from t_fw_forewarnitem";
            sql = sql + " where fid in (" + fid + ");";
            PreparedStatement ps = con.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            itemInfo = new DEForewarnItemInfo();
            while (rs.next()) {
                itemInfo.addConditionId(rs.getString("FconditionId"));
                itemInfo.addMsgId(rs.getString("Fmessageid"));
                itemInfo.addScheduleId(rs.getString("FscheduleId"));
            }
            sql = "select fid from T_FW_Condition where fid  in (select fconditionid from t_fw_forewarnitem where fid   in (" + fid + "))";
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemInfo.addThresholdId(rs.getString("fid"));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return itemInfo;
    }

    private DEForewarnQueryCondition() {
    }

    public static DEForewarnQueryCondition getInstance(Connection con, String fidStr) {
        if (forewarnQueryCondition == null) {
            forewarnQueryCondition = new DEForewarnQueryCondition();
        }
        DEForewarnQueryCondition.init(fidStr, con);
        return forewarnQueryCondition;
    }

    public static void reset() {
        if (whereMap != null) {
            whereMap.clear();
        }
    }
}

