/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.util.PermBizHelper;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.runtime.SqlInfo;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RoleDataSqlTransmission
extends BlockDataTransmission {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private HashMap cuMap = new HashMap(2);
    private static Logger logger = Logger.getLogger((String)RoleDataSqlTransmission.class.getName());

    @Override
    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.SQL;
    }

    @Override
    protected SqlInfo toSQL(Context ctx, IRecord rec) throws TaskExternalException {
        SqlInfo s = new SqlInfo();
        StringBuffer sbInsert = new StringBuffer("insert into T_PM_Role (Fid,FNumber,FName_L2,FDescription_L2,").append("FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FType)  values(");
        StringBuffer sbUpdate = new StringBuffer("update T_PM_Role set ");
        String roleNumber = (String)rec.get((String)"FRoleNumber").data;
        String name2 = StringUtils.cnulls((String)((String)rec.get((String)"FName").data));
        String FDescription2 = StringUtils.cnulls((String)((String)rec.get((String)"FDescription").data));
        String type = StringUtils.cnulls((String)((String)rec.get((String)"FType").data));
        String FControlUnitNumber = StringUtils.cnulls((String)((String)rec.get((String)"FControlUnitNumber").data));
        if (StringUtils.isEmpty((String)roleNumber)) {
            String objectName = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(new RoleInfo().getBOSType()).getAlias();
            Object[] params = new Object[]{objectName, roleNumber};
            String msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"numberNotFound"), params);
            throw new TaskExternalException(msg);
        }
        try {
            IRole iRole = RoleFactory.getLocalInstance((Context)ctx);
            String cuid = null;
            if (this.cuMap.containsKey(FControlUnitNumber)) {
                cuid = (String)this.cuMap.get(FControlUnitNumber);
            } else {
                FullOrgUnitInfo ctrlUnitOrgInfo = PermBizHelper.findFullOrgUnfoByNumber((Context)ctx, (String)FControlUnitNumber);
                if (ctrlUnitOrgInfo == null) {
                    throw new TaskExternalException(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "55_RoleDataSqlTransmission", new Object[]{FControlUnitNumber}));
                }
                cuid = ctrlUnitOrgInfo.getId().toString();
                this.cuMap.put(FControlUnitNumber, cuid);
            }
            RoleInfo alreadyRoleInfo = null;
            try {
                RoleCollection coll = iRole.getRoleCollection("where number = '" + roleNumber + "'");
                if (coll != null && coll.size() > 0) {
                    alreadyRoleInfo = coll.get(0);
                }
            }
            catch (ObjectNotFoundException e) {
                alreadyRoleInfo = null;
            }
            if (this.isSltImportUpdate() && alreadyRoleInfo != null) {
                sbUpdate.append("FNumber='").append(roleNumber).append("',");
                sbUpdate.append("FName_L2='").append(name2).append("',");
                sbUpdate.append("FDescription_L2='").append(FDescription2).append("',");
                sbUpdate.append("FLastUpdateUserID='").append(ctx.getCaller().toString()).append("',");
                sbUpdate.append("FLastUpdateTime=getdate()").append(",");
                sbUpdate.append("FControlUnitID='").append(cuid).append("',");
                sbUpdate.append("FType='").append(type).append("' where ");
                sbUpdate.append("FID = '").append(alreadyRoleInfo.getId()).append("'");
                s.setSql(sbUpdate.toString());
                return s;
            }
            if (!this.isSltImportUpdate() && alreadyRoleInfo != null) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"57_RoleDataSqlTransmission"));
            }
            sbInsert.append("newbosid('13B6732A'),");
            sbInsert.append("'").append(roleNumber).append("',");
            sbInsert.append("'").append(name2).append("',");
            sbInsert.append("'").append(FDescription2).append("',");
            sbInsert.append("'").append(ctx.getCaller().toString()).append("',");
            sbInsert.append("getdate(),");
            sbInsert.append("'").append(ctx.getCaller().toString()).append("',");
            sbInsert.append("getdate(),");
            sbInsert.append("'").append(cuid).append("',");
            sbInsert.append("").append(type).append(")");
            s.setSql(sbInsert.toString());
            return s;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"58_RoleDataSqlTransmission"), (Throwable)e);
        }
    }

    protected void beforeSubmitSql(Context ctx, String[] sql) throws TaskExternalException {
    }

    @Override
    protected int[] submitSql(Context ctx, SqlInfo[] batchSql) throws SQLException {
        return super.submitSql(ctx, batchSql);
    }

    @Override
    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            result.put("FRoleNumber", rs.getString("number"));
            result.put("FType", new Integer(rs.getInt("type")));
            result.put("FName", StringUtils.cnulls((String)rs.getString("name")));
            result.put("FDescription", StringUtils.cnulls((String)rs.getString("description")));
            result.put("FSimpleName", StringUtils.cnulls((String)rs.getString("simpleName")));
            String cuId = rs.getString("CU.id");
            ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
            CtrlUnitInfo ctrlUnitInfo = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cuId));
            result.put("FControlUnitNumber", ctrlUnitInfo.getNumber());
        }
        catch (SQLException e) {
            logger.error((Object)"eccor!", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    @Override
    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.base.permission.app.RoleQuery";
    }
}

