/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SqlFileSelector
implements KDPromptSelector {
    private KDFileChooser fc;
    private int retVal;
    private File retFile;
    private Component parentComp;
    private String lastSelectPath = System.getProperty("user.home");
    private String type = "";
    private String defFileName = null;

    public SqlFileSelector(Component parentComp, String chooserType) {
        this.type = chooserType;
        this.fc = new KDFileChooser(this.lastSelectPath);
        SimpleFileFilter ff = null;
        if ("OPEN".equals(chooserType)) {
            ff = new SimpleFileFilter(new String[]{"sql"});
            this.fc.setFileFilter((FileFilter)ff);
        } else {
            SimpleFileFilter ff1 = new SimpleFileFilter(new String[]{"sql"});
            ff1.setDescription("sql");
            this.fc.addChoosableFileFilter((FileFilter)ff1);
        }
        this.fc.setFileSelectionMode(0);
        this.fc.setMultiSelectionEnabled(false);
        this.parentComp = parentComp;
    }

    public void show() {
        boolean isFileValid = false;
        while (!isFileValid) {
            if ("OPEN".equals(this.type)) {
                this.retVal = this.fc.showOpenDialog(this.parentComp);
                if (this.retVal == 1) break;
                this.retFile = this.fc.getSelectedFile();
                if (this.retFile.exists()) {
                    isFileValid = true;
                    this.lastSelectPath = this.retFile.getPath();
                    continue;
                }
                MsgBox.showInfo((Component)this.parentComp, (String)Resrcs.getString((String)"FileNotExisted"));
                this.retFile = null;
                continue;
            }
            this.retVal = this.fc.showSaveDialog(this.parentComp);
            if (this.retVal == 1) break;
            this.retFile = this.fc.getSelectedFile();
            String fileName = this.retFile.getAbsolutePath();
            if (!fileName.endsWith(".sql")) {
                String extendName = "sql";
                fileName = new StringBuffer(fileName).append(".").append(extendName).toString();
            }
            this.retFile = new File(fileName);
            if (this.retFile.exists()) {
                int result = MsgBox.showConfirm2((Component)this.parentComp, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileHasExisted"));
                if (result == 0) {
                    isFileValid = true;
                    this.lastSelectPath = this.retFile.getPath();
                    continue;
                }
                isFileValid = false;
                continue;
            }
            isFileValid = true;
            this.lastSelectPath = this.retFile.getPath();
        }
    }

    public boolean isCanceled() {
        boolean hasBeenCanceled = true;
        if (this.retVal == 0) {
            hasBeenCanceled = false;
        }
        return hasBeenCanceled;
    }

    public Object getData() {
        return this.retFile;
    }

    public String getDefFileName() {
        return this.defFileName;
    }

    public void setDefFileName(String defFileName) {
        this.defFileName = defFileName;
        if (defFileName != null) {
            this.fc.setSelectedFile(new File(defFileName));
        }
    }
}

