/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tools.datatask.AccoutDataException;
import com.kingdee.eas.tools.datatask.app.AbstractAccountingDataInterfaceFacadeControllerBean;
import com.kingdee.eas.tools.datatask.task.util.IAccountingDataInterface;
import com.kingdee.eas.tools.datatask.task.util.XMLGenerator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class AccountingDataInterfaceFacadeControllerBean
extends AbstractAccountingDataInterfaceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tools.datatask.app.AccountingDataInterfaceFacadeControllerBean");

    @Override
    protected Map _exportData(Context ctx, List companyList, int year, int periodNumber, int toYear, int toNumber, IObjectPK pk) throws BOSException, EASBizException {
        ExportedFileManager.checkExpired();
        if (companyList == null || companyList.size() == 0) {
            throw new AccoutDataException(AccoutDataException.EXCEPTION0);
        }
        HashMap returnVal = new HashMap();
        List<PeriodInfo> periodinfo = this.getPeriod(year, periodNumber, toYear, toNumber, pk, ctx);
        Map accountDataImps = AccountingDataInterfaceFacadeControllerBean.getAccountDataImps(ctx);
        if (accountDataImps == null || accountDataImps.size() == 0) {
            return returnVal;
        }
        String accountDataImpStr = null;
        ArrayList exceptionList = new ArrayList();
        for (int i = 0; i < companyList.size(); ++i) {
            if (!(companyList.get(i) instanceof CompanyOrgUnitInfo)) {
                throw new AccoutDataException(AccoutDataException.EXCEPTION1);
            }
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)companyList.get(i);
            Set keyset = accountDataImps.keySet();
            Iterator iterator = keyset.iterator();
            while (iterator.hasNext()) {
                accountDataImpStr = iterator.next().toString();
                try {
                    Class<?> accountDataImpClass = Class.forName(accountDataImpStr);
                    Object accountDataImp = accountDataImpClass.newInstance();
                    if (accountDataImp != null && accountDataImp instanceof IAccountingDataInterface) {
                        this.addDocument(returnVal, (IAccountingDataInterface)accountDataImp, ctx, companyInfo, periodinfo);
                    }
                    if (accountDataImp == null || !(accountDataImp instanceof XMLGenerator)) continue;
                    List templist = ((XMLGenerator)accountDataImp).getException();
                    exceptionList.addAll(templist);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (InstantiationException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Exception e) {
                    String name = accountDataImps.get(accountDataImpStr).toString();
                    logger.error((Object)e.getStackTrace(), (Throwable)e);
                    throw new AccoutDataException(AccoutDataException.EXCEPTION2, new Object[]{" '" + name + "' "});
                }
            }
        }
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < exceptionList.size(); ++i) {
            Exception e = (Exception)exceptionList.get(i);
            logger.error((Object)e.getStackTrace(), (Throwable)e);
            if (e.getMessage() == null) continue;
            msg.append("--" + e.getMessage() + "-- ");
        }
        if (msg.length() > 0) {
            throw new AccoutDataException(AccoutDataException.EXCEPTION3, new Object[]{msg});
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Map returnVal, IAccountingDataInterface accountingData, Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> periodinfo) throws IOException {
        File file;
        if (accountingData instanceof XMLGenerator) {
            file = ((XMLGenerator)((Object)accountingData)).generate(ctx, companyInfo, periodinfo);
        } else {
            OutputStream out = null;
            Writer writer = null;
            try {
                Document document = accountingData.generateXML(ctx, companyInfo, periodinfo);
                OutputFormat format = OutputFormat.createPrettyPrint();
                format.setEncoding("GB18030");
                format.setTrimText(false);
                file = File.createTempFile("generatedXml", ".xml");
                file.deleteOnExit();
                out = new FileOutputStream(file);
                writer = new OutputStreamWriter(out, "GB18030");
                XMLWriter xmlWriter = new XMLWriter(writer, format);
                xmlWriter.write(document);
                xmlWriter.close();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String ais = null;
        try {
            DCRegister dcr = new DCRegister();
            ArrayList dcList = dcr.getDCList();
            DCInfo dci = null;
            int n = dcList.size();
            for (int i = 0; i < n; ++i) {
                dci = (DCInfo)dcList.get(i);
                if (!dci.getNumber().equals(ctx.getAIS())) continue;
                ais = dci.getName("L2");
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        String fileName = ais + "_" + companyInfo.getName() + "_" + accountingData.getTypeName(ctx) + ".xml";
        FileInputStream fis = new FileInputStream(file);
        String exportFileId = UUID.randomUUID().toString();
        ExportedFileManager.addExportedFile(exportFileId, file, fis);
        returnVal.put(fileName, exportFileId);
    }

    public PeriodInfo getPeriod(int year, int periodNumber, IObjectPK pk, Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select where periodYear=");
        sql.append(year);
        sql.append(" and periodNumber= ");
        sql.append(periodNumber);
        sql.append(" and periodType.id='");
        sql.append(pk.toString() + "'");
        CoreBaseCollection pinfoc = PeriodFactory.getLocalInstance((Context)ctx).getCollection(sql.toString());
        PeriodInfo pinfo = (PeriodInfo)pinfoc.get(0);
        return pinfo;
    }

    public List<PeriodInfo> getPeriod(int year, int periodNumber, int toyear, int periodToNumber, IObjectPK pk, Context ctx) throws BOSException, EASBizException {
        String sql = " SELECT FID FROM T_BD_Period  WHERE (FPeriodYear * 100 + FPeriodNumber BETWEEN ? AND ?)  AND (FTypeID ='" + pk.toString() + "') order by FPeriodYear, FPeriodNumber ";
        IRowSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{year * 100 + periodNumber, toyear * 100 + periodToNumber});
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        ArrayList<PeriodInfo> periodc = new ArrayList<PeriodInfo>();
        for (int i = 0; i < list.size(); ++i) {
            periodc.add(iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(list.get(i).toString())));
        }
        return periodc;
    }

    public static Map getAccountDataImps(Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String lan = ctx.getLocale().toString();
        String sql = "select FImplementClass,FTypeName_" + lan + " name from T_BD_AccountDataImp;";
        String accountDataImp = null;
        String name = null;
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowset == null || rowset.size() <= 0) {
                return null;
            }
            while (rowset.next()) {
                accountDataImp = rowset.getString("FImplementClass");
                name = rowset.getString("name");
                map.put(accountDataImp, name);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected byte[] _readExportedFile(Context ctx, String exportFileId) throws BOSException {
        int read;
        byte[] buffer;
        block8: {
            int length;
            block7: {
                InputStream is = null;
                is = ExportedFileManager.getExportedFile(exportFileId);
                if (is == null) {
                    throw new RuntimeException("The file does not exist or had been expired!");
                }
                length = 0x100000;
                buffer = new byte[length];
                read = is.read(buffer);
                if (read != -1) break block7;
                ExportedFileManager.closeExportedFile(exportFileId);
                byte[] byArray = null;
                return byArray;
            }
            if (read != length) break block8;
            byte[] byArray = buffer;
            return byArray;
        }
        try {
            byte[] bytes = new byte[read];
            System.arraycopy(buffer, 0, bytes, 0, read);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _closeExportedFile(Context ctx, String exportFileId) throws BOSException {
        ExportedFileManager.closeExportedFile(exportFileId);
    }

    private static void closeIfNotNull(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void deleteIfNotNull(File file) {
        if (file == null) {
            return;
        }
        file.delete();
    }

    private File getTempDir() {
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        return new File(tmpDirPath);
    }

    private static class ExportedFileManager {
        private static final int EXPIRE_IN_MILLIS = 30000;
        private static final Map<String, ExportedFileItem> exportedFiles = new HashMap<String, ExportedFileItem>();

        private ExportedFileManager() {
        }

        public static synchronized void checkExpired() {
            for (String key : new ArrayList<String>(exportedFiles.keySet())) {
                ExportedFileItem item = exportedFiles.get(key);
                long lastAccess = item.getLastAccessTime();
                long now = Calendar.getInstance().getTimeInMillis();
                if (now - lastAccess <= 30000L) continue;
                exportedFiles.remove(key);
                InputStream is = item.getInputStream();
                File file = item.getFile();
                AccountingDataInterfaceFacadeControllerBean.closeIfNotNull(is);
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }

        public static synchronized void closeExportedFile(String exportedSessionId) {
            ExportedFileItem item = exportedFiles.get(exportedSessionId);
            if (item == null) {
                return;
            }
            AccountingDataInterfaceFacadeControllerBean.closeIfNotNull(item.getInputStream());
            File file = item.getFile();
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }

        public static synchronized void addExportedFile(String exportFileId, File file, InputStream is) {
            ExportedFileItem item = new ExportedFileItem(file, is, ExportedFileManager.now());
            exportedFiles.put(exportFileId, item);
        }

        public static synchronized InputStream getExportedFile(String exportFileId) {
            ExportedFileItem item = exportedFiles.get(exportFileId);
            if (item == null) {
                return null;
            }
            item.setLastAccessTime(ExportedFileManager.now());
            return item.getInputStream();
        }

        private static long now() {
            return System.currentTimeMillis();
        }

        private static class ExportedFileItem {
            private File file;
            private InputStream inputStream;
            private long lastAccessTime;

            public ExportedFileItem(File file, InputStream inputStream, long lastAccessTime) {
                this.file = file;
                this.inputStream = inputStream;
                this.lastAccessTime = lastAccessTime;
            }

            public File getFile() {
                return this.file;
            }

            public void setFile(File file) {
                this.file = file;
            }

            public InputStream getInputStream() {
                return this.inputStream;
            }

            public void setInputStream(InputStream inputStream) {
                this.inputStream = inputStream;
            }

            public long getLastAccessTime() {
                return this.lastAccessTime;
            }

            public void setLastAccessTime(long lastAccessTime) {
                this.lastAccessTime = lastAccessTime;
            }
        }
    }
}

