/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskException;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.IDataTransmission;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.ReturnInfo;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.app.AbstractExternalDataExchangeFacadeControllerBean;
import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogManager;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskExternalCodeRunner;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.ZipUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Uuid;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ExternalDataExchangeFacadeControllerBean
extends AbstractExternalDataExchangeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tools.datatask.app.ExternalDataExchangeFacadeControllerBean");
    private static final String MAIN_QUERY_PK = "mainQueryPK";
    private static final String MAIN_QUERY = "mainQuery";
    private static final String FILE_ENCODING = "UTF-8";

    @Override
    protected String _test(Context ctx, String param) throws BOSException {
        return null;
    }

    @Override
    protected String[][] _importData(Context ctx, String easTemplateNumber, String[] key, String[] data, boolean isUpdate) throws BOSException, DatataskException {
        HashMap<String, DataToken> hsdata = new HashMap<String, DataToken>();
        for (int i = 0; i < key.length; ++i) {
            DataToken dt = new DataToken();
            dt.data = data[i];
            dt.name = key[i];
            hsdata.put(key[i], dt);
        }
        String[][] result = new String[1][2];
        try {
            IDataTransmission trans = this.getTransObject(ctx, easTemplateNumber);
            trans.setContextParameter(new HashMap());
            trans.getContextParameter().put("DATATASKMODE", new Integer(isUpdate ? 16 : 8));
            CoreBaseInfo info = trans.transmit(hsdata, ctx);
            trans.submit(info, ctx);
            result[0][0] = "0000";
            result[0][1] = "import success";
        }
        catch (TaskRunnerException e) {
            logger.error((Object)("easTemplaeNum is " + easTemplateNumber + "," + e.getMessage()), (Throwable)((Object)e));
            result[0][0] = "0001";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    @Override
    protected String[][] _importBizData(Context ctx, String easTemplaeNum, String xmlData, boolean isUpdate) throws BOSException {
        String[][] result = null;
        try {
            IDataTransmission trans = this.getTransObject(ctx, easTemplaeNum);
            int mode = isUpdate ? 16 : 8;
            trans.setContextParameter(new HashMap());
            trans.getContextParameter().put("DATATASKMODE", new Integer(mode));
            String uuid = Uuid.create().toString();
            TaskExternalCode task = this.getTaskExternalCode(ctx, easTemplaeNum);
            DatataskParameter dp = new DatataskParameter();
            dp.solutionName = easTemplaeNum;
            dp.datataskMode = mode;
            dp.setFileType("xml");
            dp.getContextParam().put("errorHandleMode", ErrorHandleModeEnum.ReturnWhenFinish);
            String fileName = this.getTempFileName(dp.getFileType());
            this.writeFile(xmlData, fileName);
            dp.setOpenFileName(fileName);
            task.setTaskUuID(uuid);
            task.setTaskParameter(dp);
            TaskExternalCodeRunner runner = new TaskExternalCodeRunner(task, ctx);
            runner.run();
            TaskLog log = this.getTaskLog(uuid);
            if (TaskStateEnum.SUCCESSEND.equals((Object)log.getTaskState())) {
                result = new String[1][2];
                result[0][0] = "0000";
                result[0][1] = "import success";
            } else {
                int logCount = log.getErrorDetailCount();
                result = new String[logCount][2];
                for (int i = 0; i < logCount; ++i) {
                    result[i][0] = log.getErrorSubject(i);
                    result[i][1] = log.getErrorDetail(i);
                }
            }
        }
        catch (TaskRunnerException e) {
            logger.error((Object)("easTemplaeNum is " + easTemplaeNum + "," + e.getMessage()), (Throwable)((Object)e));
            result = new String[1][2];
            result[0][0] = "0001";
            result[0][1] = e.getMessage();
        }
        catch (Exception e) {
            result = new String[1][2];
            result[0][0] = "0001";
            result[0][1] = e.getMessage();
        }
        return result;
    }

    private TaskLog getTaskLog(String uuid) {
        TaskLogManager lm = TaskLogManager.instance;
        ILog log = lm.getLog(uuid);
        if (log == null) {
            return null;
        }
        return (TaskLog)log;
    }

    private String getTempFileName(String fileType) {
        return String.valueOf(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String content, String fileName) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            fos.write(content.getBytes("utf-8"));
        }
        catch (IOException e) {
            logger.error((Object)("write file error:" + e));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private TaskExternalCode getTaskExternalCode(Context ctx, String solutionName) throws BOSException {
        Locale l = ctx.getLocale();
        IDIETemplate dt = DIETemplateFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        String[] tmp = solutionName.split("\\.");
        String number = tmp[tmp.length - 1];
        FilterItemInfo itemInfo = new FilterItemInfo("number", (Object)number);
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.getFilter().getFilterItems().add(itemInfo);
        DIETemplateInfo templateInfo = dt.getDIETemplateCollection(viewInfo).get(0);
        if (templateInfo == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"2_DatataskRunServerControllerBean", (Locale)l) + number + ResourceBase.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"3_DatataskRunServerControllerBean", (Locale)l));
        }
        return TaskTemplateAdapter.getTaskExternalCode(templateInfo, l);
    }

    private IDataTransmission getTransObject(Context ctx, String templateNumber) throws BOSException, TaskRunnerException {
        IDIETemplate iTemplate = DIETemplateFactory.getLocalInstance(ctx);
        DIETemplateCollection coll = iTemplate.getDIETemplateCollection("where number = '" + templateNumber + "'");
        IDataTransmission iObject = null;
        if (coll != null && coll.size() > 0) {
            DIETemplateInfo info = coll.get(0);
            String impleName = info.getImplementClassName();
            try {
                Class<?> classDefinition = Class.forName(impleName);
                iObject = (IDataTransmission)classDefinition.newInstance();
            }
            catch (Exception e) {
                throw new TaskRunnerException(4, (Throwable)e);
            }
        }
        return iObject;
    }

    @Override
    protected String _exportData(Context ctx, String easTemplateNumber, String mainQueryPK, String mainQuery) throws BOSException, DatataskException {
        if (easTemplateNumber == null || easTemplateNumber.trim().length() == 0) {
            StringBuffer returnMessage = new StringBuffer();
            returnMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<root>").append("<errorCood>0001</errorCood>").append("<errorMessage>Template Number is null.</errorMessage>").append("</root>");
            return returnMessage.toString();
        }
        String uuid = Uuid.create().toString();
        DatataskParameter dp = new DatataskParameter();
        dp.solutionName = easTemplateNumber;
        dp.datataskMode = 1;
        dp.setFileType("xml");
        dp.setLogUuID(uuid);
        String fileName = this.getTempFileName(dp.getFileType());
        dp.setOpenFileName(fileName);
        MetaDataPK queryPK = null;
        if (mainQueryPK != null && mainQueryPK.trim().length() > 0) {
            queryPK = new MetaDataPK(mainQueryPK);
        }
        if (queryPK != null) {
            dp.putContextParam(MAIN_QUERY_PK, queryPK);
        }
        EntityViewInfo query = null;
        try {
            if (mainQuery != null && mainQuery.trim().length() > 0) {
                query = new EntityViewInfo(mainQuery);
            }
        }
        catch (ParserException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        if (query != null) {
            dp.putContextParam(MAIN_QUERY, query);
        }
        dp.getContextParam().put("errorHandleMode", ErrorHandleModeEnum.ReturnWhenFinish);
        IDatataskRunServer iDatatask = DatataskRunServerFactory.getLocalInstance(ctx);
        ReturnInfo res = iDatatask.runSingleTask(dp);
        String openFileName = dp.getOpenFileName();
        String outPutFilePath = GlobalFunction.getFilePathForServer() + openFileName;
        List fileList = (List)res.getData();
        ZipUtil zip = new ZipUtil();
        byte[] fileByte = null;
        for (String file : fileList) {
            fileByte = iDatatask.getExportFile(file);
            if (fileByte == null) continue;
            try {
                zip.unGzipFile(fileByte, outPutFilePath);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        zip.close();
        fileByte = iDatatask.getExportFile(openFileName);
        TaskLog taskLog = iDatatask.getTaskLog(uuid);
        if (taskLog.getTaskState().equals((Object)TaskStateEnum.FAILEND)) {
            StringBuffer returnMessage = new StringBuffer();
            returnMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<root>").append("<errorCood>0002</errorCood>").append("<errorMessage>Export Error.</errorMessage>").append("</root>");
            return returnMessage.toString();
        }
        String dataXML = null;
        try {
            dataXML = new String(fileByte, FILE_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return dataXML;
    }
}

