/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.databind;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.tools.datatask.BaseClassConstants;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.databind.DataBindUtil;
import com.kingdee.eas.tools.datatask.databind.SimplePropertyField;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class SimpleClassValueProvider {
    private static Logger logger = Logger.getLogger(SimpleClassValueProvider.class);
    public static final int CODE = 345368;
    public static final String MASSAGE = "Not Simple Type";

    public static Object getValueObject(SimplePropertyField propField) throws TaskExternalException {
        return SimpleClassValueProvider.getValueObject1(propField, null, null);
    }

    public static Object getValueObject(SimplePropertyField propField, String propClass) throws TaskExternalException {
        return SimpleClassValueProvider.getValueObject1(propField, propClass, null);
    }

    public static Object getValueObject(SimplePropertyField propField, EntityObjectInfo eoInfo) throws TaskExternalException {
        return SimpleClassValueProvider.getValueObject1(propField, null, eoInfo);
    }

    public static Object getValueObject(SimplePropertyField propField, String propClass, EntityObjectInfo eoInfo) throws TaskExternalException {
        return SimpleClassValueProvider.getValueObject1(propField, propClass, eoInfo);
    }

    private static Object getValueObject1(SimplePropertyField propField, String propClass, EntityObjectInfo eoInfo) throws TaskExternalException {
        String propName = propField.getPropName();
        String propClassName = propField.getPropClass();
        String value = propField.getPropValue();
        if (!propField.isNecessary() && (value == null || value.equals(""))) {
            return null;
        }
        try {
            String tmp = BaseClassConstants.getJavaClassName(propClassName);
            try {
                Object val = SimpleClassValueProvider.dealWithSimpleType(tmp, value);
                return val;
            }
            catch (TaskRunnerException e) {
                if (e.getExceptionCode() != 345368) {
                    throw e;
                }
                if (Enum.class.getName().equals(tmp)) {
                    String parentClassName = propField.getParentPropertyField().getPropClass();
                    Class<?> returnType = (Class<?>)DataBindUtil.getReadValueOfObject(parentClassName, propName);
                    if (returnType == null && eoInfo != null && eoInfo.getPropertyByName(propName) == null) {
                        EntityObjectInfo eoi;
                        eoInfo = eoi = SimpleClassValueProvider.getDEPEntityObjectInfo(eoInfo, propField.getLongNumber());
                    }
                    if (returnType == null && eoInfo != null && eoInfo.getPropertyByName(propName) != null && eoInfo.getPropertyByName(propName) instanceof OwnPropertyInfo) {
                        String ref;
                        List list;
                        OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)eoInfo.getPropertyByName(propName);
                        if (ownPropertyInfo.getEnumType() != null) {
                            String className = ownPropertyInfo.getEnumType().getClassName();
                            if (className != null && className.trim().length() > 0) {
                                returnType = Class.forName(className);
                            }
                        } else if (ownPropertyInfo.getMetaDataRef() != null && ownPropertyInfo.isConfigured() && (list = DynamicEnum.getEnumList((String)(ref = ownPropertyInfo.getMetaDataRef()))) != null && !list.isEmpty()) {
                            logger.info((Object)("DEP\u6269\u5c55\u679a\u4e3e\u5b57\u6bb5, value : " + value + " ;\u679a\u4e3e\u7c7b\u578b : " + ref));
                            return DynamicEnum.getEnum((String)ref, (Object)value).getValue();
                        }
                    }
                    logger.info((Object)("returnType:" + returnType));
                    String methodName = "getEnum";
                    Object tmpEnum = null;
                    if (returnType != null && StringEnum.class.isAssignableFrom(returnType) || propClass != null && propClass.trim().equalsIgnoreCase("Enum")) {
                        if (IntEnum.class.isAssignableFrom(returnType)) {
                            tmpEnum = new Integer(value);
                        } else if (StringEnum.class.isAssignableFrom(returnType)) {
                            tmpEnum = new String(value);
                        } else if (LongEnum.class.isAssignableFrom(returnType)) {
                            tmpEnum = new Long(value);
                        } else if (FloatEnum.class.isAssignableFrom(returnType)) {
                            tmpEnum = new Float(value);
                        } else if (DoubleEnum.class.isAssignableFrom(returnType)) {
                            tmpEnum = new Double(value);
                        }
                    } else if (IntEnum.class.isAssignableFrom(returnType)) {
                        tmpEnum = DataBindUtil.getIntegerEnum(returnType, methodName, Integer.parseInt(value));
                    } else if (StringEnum.class.isAssignableFrom(returnType)) {
                        tmpEnum = DataBindUtil.getStringEnum(returnType, methodName, value);
                    } else if (LongEnum.class.isAssignableFrom(returnType)) {
                        tmpEnum = DataBindUtil.getLongEnum(returnType, methodName, Long.parseLong(value));
                    } else if (FloatEnum.class.isAssignableFrom(returnType)) {
                        tmpEnum = DataBindUtil.getFloatEnum(returnType, methodName, Float.parseFloat(value));
                    } else if (DoubleEnum.class.isAssignableFrom(returnType)) {
                        tmpEnum = DataBindUtil.getDoubleEnum(returnType, methodName, Double.parseDouble(value));
                    }
                    if (tmpEnum == null) {
                        logger.error((Object)("returnType:" + returnType));
                        throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"41_SimpleClassValueProvider"));
                    }
                    return tmpEnum;
                }
                Class<?> c = Class.forName(propClassName);
                Constructor<?> cst = c.getConstructor(null);
                return cst.newInstance(null);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "42_SimpleClassValueProvider", new Object[]{propField.getFileField(), propField.getPropClass(), propField.getPropValue()}), (Throwable)e);
        }
    }

    private static Object dealWithSimpleType(String tmp, String value) throws TaskExternalException, ParseException, TaskRunnerException {
        if (String.class.getName().equalsIgnoreCase(tmp)) {
            return value;
        }
        if (Short.class.getName().equalsIgnoreCase(tmp)) {
            return Short.valueOf(value);
        }
        if (Integer.class.getName().equalsIgnoreCase(tmp)) {
            return Integer.valueOf(value);
        }
        if (Long.class.getName().equalsIgnoreCase(tmp)) {
            return Long.valueOf(value);
        }
        if (Float.class.getName().equalsIgnoreCase(tmp)) {
            return Float.valueOf(value);
        }
        if (Double.class.getName().equalsIgnoreCase(tmp)) {
            return Double.valueOf(value);
        }
        if (BigDecimal.class.getName().equalsIgnoreCase(tmp)) {
            return new BigDecimal(value);
        }
        if (Date.class.getName().equalsIgnoreCase(tmp)) {
            if (value == null || value.equals("")) {
                return null;
            }
            SimpleDateFormat df = null;
            if (value.length() == "yyyy-MM-dd".length()) {
                df = new SimpleDateFormat("yyyy-MM-dd");
            } else if (value.length() == "yyyy-MM-dd HH:mm".length()) {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            } else if (value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            } else if (value.length() > 19 && value.length() < 24) {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            } else {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"40_SimpleClassValueProvider"));
            }
            Date d = df.parse(value);
            return d;
        }
        if (Time.class.getName().equalsIgnoreCase(tmp)) {
            return Time.valueOf(value);
        }
        if (Timestamp.class.getName().equalsIgnoreCase(tmp)) {
            if (value == null || value.equals("")) {
                return null;
            }
            SimpleDateFormat df = null;
            if (value.length() == "yyyy-MM-dd".length()) {
                df = new SimpleDateFormat("yyyy-MM-dd");
            } else if (value.length() == "yyyy-MM-dd HH:mm".length()) {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            } else if (value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            } else {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"40_SimpleClassValueProvider"));
            }
            Date d = df.parse(value);
            return new Timestamp(d.getTime());
        }
        if (Boolean.class.getName().equalsIgnoreCase(tmp)) {
            return new Boolean(value);
        }
        if (BOSUuid.class.getName().equalsIgnoreCase(tmp)) {
            return BOSUuid.read((String)value);
        }
        if (Uuid.class.getName().equalsIgnoreCase(tmp)) {
            return Uuid.read((String)value);
        }
        throw new TaskRunnerException(345368, MASSAGE);
    }

    private static EntityObjectInfo getDEPEntityObjectInfo(EntityObjectInfo templateEOI, String longNumber) throws BOSException {
        EntityObjectInfo eoi = templateEOI;
        String[] numbers = longNumber.split("\\.");
        if (numbers.length > 1) {
            try {
                for (int i = 0; i < numbers.length - 1; ++i) {
                    EntityObjectInfo nextEOI;
                    LinkPropertyInfo nextPropInfo = (LinkPropertyInfo)eoi.getPropertyByNameRuntime(numbers[i]);
                    eoi = nextEOI = nextPropInfo.getRelationship().getSupplierObject();
                }
            }
            catch (Exception e) {
                logger.info((Object)"DEP\u6269\u5c55\u679a\u4e3e\u5b57\u6bb5\u5176\u6240\u5728\u7684\u8fde\u63a5\u5c5e\u6027\u7684\u5b9e\u4f53\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
                throw new BOSException();
            }
        }
        return eoi;
    }
}

