/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.export.Excel2007SheetErrorWriter;
import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.export.IExternalExcelDataWriter;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.util.ExcelParam;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Excel2007SheetErrorManager {
    private Map<String, ExcelParam> expMap;
    private Excel2007Writer errExcelWriter;
    private IExternalExcelDataWriter errSheetWriter;
    private Set<String> sheets = new HashSet<String>();
    private Set<String> excels = new HashSet<String>();

    public Excel2007SheetErrorManager(Map<String, ExcelParam> expMap) {
        this.expMap = expMap;
    }

    public Excel2007SheetErrorManager(ExcelParam exp) {
        this.expMap = new HashMap<String, ExcelParam>(1);
        this.expMap.put(exp.getTaskParam().getFileUuId(), exp);
    }

    public void writeErrSheet(RecordCollection coll) throws TaskRunnerException {
        for (IRecord rec : coll) {
            this.writeErrSheet(rec);
        }
    }

    public void writeErrSheet(IRecord rec) throws TaskRunnerException {
        String errMsg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"notImport");
        this.writeErrSheet(errMsg, rec);
    }

    public void writeErrSheet(String errMsg, IRecord rec) throws TaskRunnerException {
        String errFieldDesc;
        ExcelParam exp;
        String fileUuId = rec.getFileUuId();
        int sheetId = rec.getSheetId();
        String _sheet_flag = fileUuId + "_" + sheetId;
        if (!this.excels.contains(fileUuId)) {
            exp = this.expMap.get(fileUuId);
            this.errExcelWriter = exp.getExcelWriter();
            this.errExcelWriter.initWb();
            this.excels.add(fileUuId);
            this.closeSheet();
        }
        if (!this.sheets.contains(_sheet_flag)) {
            this.closeSheet();
            exp = this.expMap.get(fileUuId);
            DatataskParameter taskParam = exp.getTaskParam();
            String sheetName = taskParam.getSheetIdAndName().get(sheetId);
            this.errSheetWriter = new Excel2007SheetErrorWriter(this.errExcelWriter);
            this.errExcelWriter.addErrSheet(sheetId);
            this.errSheetWriter.setSheetName(sheetName);
            this.errSheetWriter.openWriter();
            this.errSheetWriter.setDimension(5, exp.getStructMap().get(sheetId).getFieldCollection().size());
            this.errSheetWriter.writeStruct(exp.getStructMap().get(sheetId));
            this.sheets.add(_sheet_flag);
        }
        DataToken value = new DataToken();
        value.name = "ErrorReason";
        value.desc = errFieldDesc = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason");
        value.data = errMsg;
        rec.put(value.name, value);
        this.errSheetWriter.writeLine(rec.getMap());
    }

    public void closeSheet() throws TaskRunnerException {
        if (this.errSheetWriter != null) {
            this.errSheetWriter.closeWriter();
        }
    }

    public void setNotImportSheets(String fileUuId, Set<Integer> sheetIds) {
        ExcelParam exp = this.expMap.get(fileUuId);
        Excel2007Writer errExcelWriter = exp.getExcelWriter();
        errExcelWriter.setNotImportSheets(sheetIds);
    }

    private boolean hasNotImportSheets(String fileUuId) {
        ExcelParam exp = this.expMap.get(fileUuId);
        Excel2007Writer errExcelWriter = exp.getExcelWriter();
        return errExcelWriter.getNotImportSheets().size() > 0;
    }

    public void setIsImported(String fileUuId) {
        ExcelParam exp = this.expMap.get(fileUuId);
        Excel2007Writer errExcelWriter = exp.getExcelWriter();
        errExcelWriter.setImported();
    }

    public static void main(String[] args) {
    }
}

