/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2007Writer {
    private static final Logger logger = Logger.getLogger(Excel2007Writer.class);
    private String produceFileName;
    private final AtomicReference<XSSFWorkbook> atomicWb = new AtomicReference<Object>(null);
    private ConcurrentHashMap<String, File> sheet_file = new ConcurrentHashMap();
    private Set<Integer> errSheets = new HashSet<Integer>();
    private Set<Integer> notImportSheets = new HashSet<Integer>();
    private AtomicBoolean isImported = new AtomicBoolean(false);

    public Excel2007Writer(String produceFileName) {
        this.produceFileName = produceFileName;
    }

    public void initWb() {
        if (this.atomicWb.get() == null) {
            this.atomicWb.compareAndSet(this.atomicWb.get(), new XSSFWorkbook());
        }
    }

    public boolean hasErrSheets() {
        return this.isImported.get();
    }

    public void setImported() {
        this.isImported.compareAndSet(false, true);
    }

    public synchronized Set<Integer> getErrSheets() {
        return this.errSheets;
    }

    public synchronized void addErrSheet(int errSheetId) {
        this.errSheets.add(errSheetId);
    }

    public synchronized Set<Integer> getNotImportSheets() {
        return this.notImportSheets;
    }

    public synchronized void setNotImportSheets(Set<Integer> notImportSheets) {
        notImportSheets.removeAll(this.errSheets);
        this.notImportSheets.addAll(notImportSheets);
    }

    protected String getProduceFileName() {
        return this.produceFileName;
    }

    protected void setProduceFileName(String produceFileName) {
        this.produceFileName = produceFileName;
    }

    public XSSFWorkbook getWb() {
        return this.atomicWb.get();
    }

    protected void putSheetFile(String sheetRef, File sheetXml) {
        this.sheet_file.putIfAbsent(sheetRef, sheetXml);
    }

    public void processFile() throws Exception {
        FileOutputStream os = null;
        FileOutputStream out = null;
        try {
            String defalutTempleteName = GlobalFunction.getUuID() + ".xlsx";
            os = new FileOutputStream(defalutTempleteName);
            this.atomicWb.get().write((OutputStream)os);
            File templateFile = new File(defalutTempleteName);
            out = new FileOutputStream(this.produceFileName);
            Excel2007Writer.substitute(templateFile, this.sheet_file, out);
            if (templateFile.isFile() && templateFile.exists()) {
                templateFile.delete();
            }
            Iterator it = ((ConcurrentHashMap.KeySetView)this.sheet_file.keySet()).iterator();
            logger.info((Object)("sheet_file\u6587\u4ef6\u4e2a\u6570\uff1a" + this.sheet_file.size() + ",hasNext\uff1a" + it.hasNext()));
            while (it.hasNext()) {
                File file = this.sheet_file.get(it.next());
                if (file != null && file.exists() && file.isFile()) {
                    logger.info((Object)("\u5f15\u51fa\u4efb\u52a1\u670d\u52a1\u5668\u7aef\u751f\u6210\u7684\u4e34\u65f6\u6587\u4ef6\u5927\u5c0f\uff1a" + file.length()));
                    file.delete();
                    continue;
                }
                logger.error((Object)("\u5f15\u51fa\u4efb\u52a1\u670d\u52a1\u5668\u7aef\u751f\u6210\u7684\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff1a" + file.getPath() + "," + file.getName()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u751f\u6210\u670d\u52a1\u7aef\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static void substitute(File zipfile, Map map, OutputStream out) throws IOException {
        ZipOutputStream zos = null;
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipfile);
            zos = new ZipOutputStream(out);
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                InputStream is;
                ZipEntry ze = en.nextElement();
                if (!map.containsKey(ze.getName())) {
                    zos.putNextEntry(new ZipEntry(ze.getName()));
                    is = zip.getInputStream(ze);
                    Excel2007Writer.copyStream(is, zos);
                    continue;
                }
                zos.putNextEntry(new ZipEntry(ze.getName()));
                is = new FileInputStream((File)map.get(ze.getName()));
                Excel2007Writer.copyStream(is, zos);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int count;
            byte[] chunk = new byte[1024];
            while ((count = in.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            out.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            in.close();
        }
    }
}

